/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.email.system;

import com.aspose.email.internal.b.zax;
import com.aspose.email.internal.b.zg;
import com.aspose.email.internal.b.zo;
import com.aspose.email.internal.ky.zb;
import com.aspose.email.internal.m.zd;
import com.aspose.email.internal.m.ze;
import com.aspose.email.internal.m.zv;
import com.aspose.email.system.Array;
import com.aspose.email.system.DateTimeOffset;
import com.aspose.email.system.IFormatProvider;
import com.aspose.email.system.IFormattable;
import com.aspose.email.system.Struct;
import com.aspose.email.system.TimeSpan;
import com.aspose.email.system.collections.ArrayList;
import com.aspose.email.system.exceptions.ArgumentException;
import com.aspose.email.system.exceptions.ArgumentNullException;
import com.aspose.email.system.exceptions.ArgumentOutOfRangeException;
import com.aspose.email.system.exceptions.Exception;
import com.aspose.email.system.exceptions.FormatException;
import com.aspose.email.system.exceptions.InvalidOperationException;
import com.aspose.email.system.exceptions.NullReferenceException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public final class DateTime
extends Struct<DateTime>
implements IFormattable,
Comparable<DateTime> {
    char[] a = new char[]{'d', 'D', 'f', 'F', 'g', 'G', 'm', 'M', 'o', 'O', 'r', 'R', 's', 't', 'T', 'u', 'U', 'y', 'Y'};
    private static final int[] c = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static final int[] d = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};
    public static final DateTime MinValue = new DateTime(0L, true);
    public static final DateTime MaxValue = new DateTime(3155378975999999999L, true);
    public static final long MinValueToUnixTicks = -62135769599766L - (long)TimeZone.getDefault().getOffset(MinValueToUnixTicks);
    private long e;
    private Locale f = Locale.getDefault();
    private final boolean g;
    public static final long UnixToFileTimeOffset = 11644473600000L;
    public static final long WindowsTicksInUnixOne = 10000L;
    public static final long UnixToDateTimeOffset = 62135596800000L;
    private static String[] h = new String[]{"yyyy/M/dT", "yyyy/M/d", "M/yyyy/dT", "M/yyyy/d", "yyyy'\u5e74'M'\u6708'd'\u65e5", "yyyy'-'M'-'dT", "yyyy'-'M'-'d"};
    private static String[] i = new String[]{"yyyy/M/dT", "M/yyyy/dT", "yyyy'\u5e74'M'\u6708'd'\u65e5", "yyyy/MMMM/d", "yyyy/d/MMM", "MMMM/d/yyyy", "d/MMM/yyyy", "MMMM/yyyy/d", "d/yyyy/MMM", "yy/MMMM/d", "yy/d/MMM", "MMM/yy/d"};
    private static String[] j = new String[]{"yyyy/M/dT", "M/yyyy/dT", "yyyy'\u5e74'M'\u6708'd'\u65e5", "yyyy/d/MMMM", "yyyy/MMM/d", "d/MMMM/yyyy", "dd/MMM/yy", "MMM/d/yyyy", "d/yyyy/MMMM", "MMM/yyyy/d", "yy/d/M"};
    private static String[] k = new String[]{"yyyy/M/dT", "M/yyyy/dT", "yyyy'\u5e74'M'\u6708'd'\u65e5", "yyyy/MMMM/d", "yyyy/d/MMM", "d/MMMM/yyyy", "MMM/d/yyyy", "MMMM/yyyy/d", "d/yyyy/MMM", "d/MMMM/yy", "yy/MMM/d", "d/yy/MMM", "yy/d/MMM", "MMM/d/yy", "MMM/yy/d"};
    private static String[] l = new String[]{"yyyy/M/dT", "M/yyyy/dT", "yyyy'\u5e74'M'\u6708'd'\u65e5", "yyyy/MMMM/d", "yyyy/d/MMM", "MMMM/d/yyyy", "d/MMM/yyyy", "MMMM/yyyy/d", "d/yyyy/MMM", "MMMM/d/yy", "MMM/yy/d", "d/MMM/yy", "dd/MMM/yy", "yy/MMM/d", "d/yy/MMM", "yy/d/MMM"};
    private static String[] m = new String[]{"H:m:s.fff zzz", "H:m:s.fffffffzzz", "H:m:s.fffffff", "H:m:s.ffffff", "H:m:s.ffffffzzz", "H:m:s.fffff", "H:m:s.ffff", "H:m:s.fff", "H:m:s.ff", "H:m:s.f", "H:m:s tt zzz", "H:m:szzz", "H:m:s", "H:mzzz", "H:m", "H tt", "H'\u6642'm'\u5206's'\u79d2'"};
    private static String[] n = new String[]{"MMMM/d", "d/MMM", "yyyy/MMMM"};
    private static String[] o = new String[]{"d/MMMM", "MMM/yy", "yyyy/MMMM"};

    public Locale getLocale() {
        return this.f;
    }

    public void setLocale(Locale locale) {
        this.f = locale;
    }

    public DateTime() {
        this.e = 0L;
        this.g = false;
    }

    public DateTime(long ticks) {
        this(ticks, false);
    }

    private DateTime(long ticks, boolean readonly) {
        if (ticks < 0L || ticks > 3155378975999999999L) {
            throw new ArgumentOutOfRangeException("ticks", "Ticks must be between DateTime.MinValue.Ticks and DateTime.MaxValue.Ticks.");
        }
        this.e = ticks;
        this.g = readonly;
    }

    private static DateTime a(long l) {
        DateTime dateTime = new DateTime();
        dateTime.e = l;
        return dateTime;
    }

    public DateTime(long ticks, long kind) {
        if (ticks < 0L || ticks > 3155378975999999999L) {
            throw new ArgumentOutOfRangeException("ticks", "Ticks must be between DateTime.MinValue.Ticks and DateTime.MaxValue.Ticks.");
        }
        if (kind < 0L || kind > 2L) {
            throw new ArgumentException("Invalid DateTimeKind value.");
        }
        this.e = ticks | kind << 62;
        this.g = false;
    }

    public DateTime(int year, int month, int day) {
        this.e = DateTime.a(year, month, day);
        this.g = false;
    }

    public DateTime(int year, int month, int day, zv calendar) {
        if (calendar == null) {
            throw new ArgumentNullException("calendar");
        }
        long l = calendar.a(year, month, day, 0, 0, 0, 0).getTicks();
        if (l < 0L || l > 3155378975999999999L) {
            throw new ArgumentException("Arg_DateTimeRange");
        }
        this.e = l;
        this.g = false;
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second) {
        this.e = DateTime.a(year, month, day) + DateTime.b(hour, minute, second);
        this.g = false;
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second, long kind) {
        long l = DateTime.a(year, month, day) + DateTime.b(hour, minute, second);
        if (kind < 0L || kind > 2L) {
            throw new ArgumentException("Invalid DateTimeKind value.");
        }
        this.e = l | kind << 62;
        this.g = false;
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second, zv calendar) {
        if (calendar == null) {
            throw new ArgumentNullException("calendar");
        }
        long l = calendar.a(year, month, day, hour, minute, second, 0).getTicks();
        if (l < 0L || l > 3155378975999999999L) {
            throw new ArgumentException("Arg_DateTimeRange");
        }
        this.e = l;
        this.g = false;
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        long l = DateTime.a(year, month, day) + DateTime.b(hour, minute, second);
        if (millisecond < 0 || millisecond >= 1000) {
            throw new ArgumentOutOfRangeException("millisecond");
        }
        if ((l += (long)millisecond * 10000L) < 0L || l > 3155378975999999999L) {
            throw new ArgumentException("Arg_DateTimeRange");
        }
        this.e = l;
        this.g = false;
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, long kind) {
        long l = DateTime.a(year, month, day) + DateTime.b(hour, minute, second);
        if (millisecond < 0 || millisecond >= 1000) {
            throw new ArgumentOutOfRangeException("millisecond");
        }
        if ((l += (long)millisecond * 10000L) < 0L || l > 3155378975999999999L) {
            throw new ArgumentException("Arg_DateTimeRange");
        }
        if (kind < 0L || kind > 2L) {
            throw new ArgumentException("Invalid DateTimeKind value.");
        }
        this.e = l | kind << 62;
        this.g = false;
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, zv calendar) {
        if (calendar == null) {
            throw new ArgumentNullException("calendar");
        }
        long l = calendar.a(year, month, day, hour, minute, second, 0).getTicks();
        if (millisecond < 0 || millisecond >= 1000) {
            throw new ArgumentOutOfRangeException("millisecond");
        }
        if ((l += (long)millisecond * 10000L) < 0L || l > 3155378975999999999L) {
            throw new ArgumentException("Arg_DateTimeRange");
        }
        this.e = l;
        this.g = false;
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, zv calendar, long kind) {
        if (calendar == null) {
            throw new ArgumentNullException("calendar");
        }
        long l = calendar.a(year, month, day, hour, minute, second, 0).getTicks();
        if (millisecond < 0 || millisecond >= 1000) {
            throw new ArgumentOutOfRangeException("millisecond");
        }
        if ((l += (long)millisecond * 10000L) < 0L || l > 3155378975999999999L) {
            throw new ArgumentException("Arg_DateTimeRange");
        }
        if (kind < 0L || kind > 2L) {
            throw new ArgumentException("kind");
        }
        this.e = l | kind << 62;
        this.g = false;
    }

    private long a() {
        return this.e & 0x3FFFFFFFFFFFFFFFL;
    }

    private long b() {
        return this.e & 0xC000000000000000L;
    }

    public DateTime add(TimeSpan value) {
        return this.addTicks(value.getTicks());
    }

    public static DateTime op_Addition(DateTime d, TimeSpan t) {
        return d.add(t);
    }

    private DateTime a(double d, int n) {
        long l = (long)(d * (double)n);
        if (l <= -315537897600000L || l >= 315537897600000L) {
            throw new ArgumentOutOfRangeException("value");
        }
        return this.addTicks((long)(d * (double)n * 10000.0));
    }

    public DateTime addDays(double value) {
        return this.a(value, 86400000);
    }

    public DateTime addHours(double value) {
        return this.a(value, 3600000);
    }

    public DateTime addMilliseconds(double value) {
        return this.a(value, 1);
    }

    public DateTime addMinutes(double value) {
        return this.a(value, 60000);
    }

    public DateTime addMonths(int months) {
        if (months < -120000 || months > 120000) {
            throw new ArgumentOutOfRangeException("months");
        }
        int n = this.a(0);
        int n2 = this.a(2);
        int n3 = this.a(3);
        int n4 = n2 - 1 + months;
        if (n4 >= 0) {
            n2 = n4 % 12 + 1;
            n += n4 / 12;
        } else {
            n2 = 12 + (n4 + 1) % 12;
            n += (n4 - 11) / 12;
        }
        if (n < 1 || n > 9999) {
            throw new IndexOutOfBoundsException("months");
        }
        int n5 = DateTime.daysInMonth(n, n2);
        if (n3 > n5) {
            n3 = n5;
        }
        return DateTime.a(DateTime.a(n, n2, n3) + this.a() % 864000000000L | this.b());
    }

    public DateTime addSeconds(double value) {
        return this.a(value, 1000);
    }

    public DateTime addTicks(long value) {
        long l = this.a();
        if (value > 3155378975999999999L - l || value < 0L - l) {
            throw new ArgumentOutOfRangeException("value");
        }
        return DateTime.a(l + value | this.b());
    }

    public DateTime addYears(int value) {
        if (value < -10000 || value > 10000) {
            throw new ArgumentOutOfRangeException("years");
        }
        return this.addMonths(value * 12);
    }

    public static boolean op_GreaterThan(DateTime t1, DateTime t2) {
        return t1 != null && (t2 == null || t1.a() > t2.a());
    }

    public static boolean op_GreaterThanOrEqual(DateTime t1, DateTime t2) {
        return t1 != null && (t2 == null || t1.a() >= t2.a());
    }

    public static boolean op_LessThan(DateTime t1, DateTime t2) {
        return t1 == null || t2 != null && t1.a() < t2.a();
    }

    public static boolean op_LessThanOrEqual(DateTime t1, DateTime t2) {
        return t1 == null || t2 != null && t1.a() <= t2.a();
    }

    public static int compare(DateTime t1, DateTime t2) {
        long l;
        long l2;
        if (t1 == t2) {
            return 0;
        }
        if (t1 == null) {
            t1 = MinValue.Clone();
        }
        if (t2 == null) {
            t2 = MinValue.Clone();
        }
        if ((l2 = t1.a()) > (l = t2.a())) {
            return 1;
        }
        if (l2 < l) {
            return -1;
        }
        return 0;
    }

    @Override
    public int compareTo(DateTime value) {
        if (value == null) {
            return 1;
        }
        long l = value.a();
        long l2 = this.a();
        if (l2 > l) {
            return 1;
        }
        if (l2 < l) {
            return -1;
        }
        return 0;
    }

    private static long a(int n, int n2, int n3) {
        if (n >= 1 && n <= 9999 && n2 >= 1 && n2 <= 12) {
            int[] nArray;
            int[] nArray2 = nArray = DateTime.isLeapYear(n) ? d : c;
            if (n3 >= 1 && n3 <= nArray[n2] - nArray[n2 - 1]) {
                int n4 = n - 1;
                int n5 = n4 * 365 + n4 / 4 - n4 / 100 + n4 / 400 + nArray[n2 - 1] + n3 - 1;
                return (long)n5 * 864000000000L;
            }
        }
        throw new ArgumentOutOfRangeException("Year, Month, and Day parameters describe an un-representable DateTime.");
    }

    private static long b(int n, int n2, int n3) {
        if (n >= 0 && n < 24 && n2 >= 0 && n2 < 60 && n3 >= 0 && n3 < 60) {
            return new TimeSpan(n, n2, n3).getTicks();
        }
        throw new ArgumentOutOfRangeException("Hour, Minute, and Second parameters describe an un-representable DateTime.");
    }

    public static int daysInMonth(int year, int month) {
        if (month < 1 || month > 12) {
            throw new ArgumentOutOfRangeException("month", "Month must be between one and twelve.");
        }
        int[] nArray = DateTime.isLeapYear(year) ? d : c;
        return nArray[month] - nArray[month - 1];
    }

    static long a(double d) {
        if (d >= 2958466.0 || d <= -657435.0) {
            throw new ArgumentException("Not a legal OleAut date.");
        }
        long l = (long)(d * 8.64E7 + (d >= 0.0 ? 0.5 : -0.5));
        if (l < 0L) {
            l -= l % 86400000L * 2L;
        }
        if ((l += 59926435200000L) < 0L || l >= 315537897600000L) {
            throw new ArgumentException("OleAut date did not convert to a DateTime correctly.");
        }
        return l * 10000L;
    }

    public int hashCode() {
        long l = this.a();
        return (int)l ^ (int)(l >> 32);
    }

    public int getHashCode() {
        return this.hashCode();
    }

    public boolean equals(Object value) {
        return value instanceof DateTime && DateTime.equals(this, (DateTime)value);
    }

    public static boolean equals(DateTime a, DateTime b) {
        return DateTime.op_Equality(a, b);
    }

    public static boolean op_Equality(DateTime a, DateTime b) {
        return DateTime.compare(a, b) == 0;
    }

    public static boolean op_Inequality(DateTime a, DateTime b) {
        return !DateTime.op_Equality(a, b);
    }

    public static DateTime fromFileTime(long fileTime) {
        return DateTime.fromFileTimeUtc(fileTime).toLocalTime();
    }

    public static DateTime fromFileTimeUtc(long fileTime) {
        if (fileTime < 0L || fileTime > 2650467743999999999L) {
            throw new ArgumentOutOfRangeException("fileTime");
        }
        long l = fileTime + 504911232000000000L;
        return new DateTime(l, 1L);
    }

    public static DateTime fromOADate(double d) {
        return new DateTime(DateTime.a(d), 0L);
    }

    public boolean isDaylightSavingTime() {
        return TimeZone.getDefault().inDaylightTime(DateTime.toJava(this));
    }

    public static DateTime specifyKind(DateTime value, long kind) {
        return new DateTime(value.a(), kind);
    }

    public long toBinaryRaw() {
        return this.e;
    }

    public DateTime getDate() {
        long l = this.a();
        return DateTime.a(l - l % 864000000000L | this.b());
    }

    private int a(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        long l = this.a();
        int n6 = (int)(l / 864000000000L);
        if ((n5 = (n6 -= (n4 = n6 / 146097) * 146097) / 36524) == 4) {
            n5 = 3;
        }
        n6 -= n5 * 36524;
        if ((n3 = (n6 -= (n2 = n6 / 1461) * 1461) / 365) == 4) {
            n3 = 3;
        }
        if (n == 0) {
            return n4 * 400 + n5 * 100 + n2 * 4 + n3 + 1;
        }
        n6 -= n3 * 365;
        if (n == 1) {
            return n6 + 1;
        }
        boolean bl = n3 == 3 && (n2 != 24 || n5 == 3);
        int[] nArray = bl ? d : c;
        int n7 = n6 >> 6;
        while (n6 >= nArray[n7]) {
            ++n7;
        }
        if (n == 2) {
            return n7;
        }
        return n6 - nArray[n7 - 1] + 1;
    }

    public int getDay() {
        return this.a(3);
    }

    public int getDayOfWeek() {
        return (int)((this.a() / 864000000000L + 1L) % 7L);
    }

    public int getDayOfYear() {
        return this.a(1);
    }

    public int getHour() {
        return (int)(this.a() / 36000000000L % 24L);
    }

    public long getKind() {
        long l = this.b();
        if (l == 0L) {
            return 0L;
        }
        if (l == 0x4000000000000000L) {
            return 1L;
        }
        return 2L;
    }

    public int getMillisecond() {
        return (int)(this.a() / 10000L % 1000L);
    }

    public int getMinute() {
        return (int)(this.a() / 600000000L % 60L);
    }

    public int getMonth() {
        return this.a(2);
    }

    public static DateTime getUtcNow() {
        return DateTime.a(DateTime.fromJavaTicks(System.currentTimeMillis()) | 0x4000000000000000L);
    }

    public static DateTime getNow() {
        return DateTime.getUtcNow().toLocalTime();
    }

    public int getSecond() {
        return (int)(this.a() / 10000000L % 60L);
    }

    public long getTicks() {
        return this.a();
    }

    public static long getTicks(DateTime dt) {
        return dt == null ? 0L : dt.getTicks();
    }

    public TimeSpan getTimeOfDay() {
        return new TimeSpan(this.a() % 864000000000L);
    }

    public static DateTime getToday() {
        return DateTime.getNow().getDate();
    }

    public int getYear() {
        return this.a(0);
    }

    public static boolean isLeapYear(int year) {
        if (year < 1 || year > 9999) {
            throw new ArgumentOutOfRangeException("year");
        }
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static TimeSpan op_Subtraction(DateTime d1, DateTime d2) {
        return new TimeSpan(d1.a() - d2.a());
    }

    public DateTime subtract(TimeSpan t) {
        return DateTime.op_Subtraction(this, t);
    }

    public TimeSpan subtract(DateTime dt) {
        return DateTime.op_Subtraction(this, dt);
    }

    public static DateTime op_Subtraction(DateTime d, TimeSpan t) {
        long l;
        long l2 = d.a();
        if (l2 - 0L < (l = t.getTicks()) || l2 - 3155378975999999999L > l) {
            throw new ArgumentOutOfRangeException("t");
        }
        return DateTime.a(l2 - l | d.b());
    }

    private static double b(long l) {
        long l2;
        if (l == 0L) {
            return 0.0;
        }
        if (l < 864000000000L) {
            l += 599264352000000000L;
        }
        if (l < 31241376000000000L) {
            throw new IllegalStateException("Arg_OleAutDateInvalid");
        }
        long l3 = (l - 599264352000000000L) / 10000L;
        if (l3 < 0L && (l2 = l3 % 86400000L) != 0L) {
            l3 -= (86400000L + l2) * 2L;
        }
        return (double)l3 / 8.64E7;
    }

    public double toOADate() {
        return DateTime.b(this.a());
    }

    public long toFileTime() {
        return this.toUniversalTime().toFileTimeUtc();
    }

    public long toFileTimeUtc() {
        long l;
        long l2 = l = (this.b() & Long.MIN_VALUE) != 0L ? this.toUniversalTime().a() : this.a();
        if ((l -= 504911232000000000L) < 0L) {
            throw new ArgumentOutOfRangeException("Not a valid Win32 FileTime.");
        }
        return l;
    }

    public DateTime toLocalTime() {
        if (this.getKind() == 2L) {
            return this;
        }
        long l = this.c();
        if (l > 3155378975999999999L) {
            return new DateTime(3155378975999999999L, 2L);
        }
        if (l < 0L) {
            return new DateTime(0L, 2L);
        }
        return new DateTime(l, 2L);
    }

    private long c() {
        double d;
        double d2 = (double)this.a() / 10000.0 - 6.21355968E13;
        double d3 = 6.21355968E13 + d2 + (d = (double)TimeZone.getDefault().getOffset((long)d2));
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        double d4 = d3 * 10000.0;
        return (long)d4;
    }

    private long d() {
        double d;
        double d2 = (double)this.a() / 10000.0 - 6.21355968E13;
        double d3 = 6.21355968E13 + d2 - (d = (double)TimeZone.getDefault().getOffset((long)d2));
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        double d4 = d3 * 10000.0;
        return (long)d4;
    }

    public long toJavaTicks() {
        return this.a() / 10000L - 62135596800000L;
    }

    public static Date toJava(DateTime dt) {
        if (dt == null) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(dt.getYear(), dt.getMonth() - 1, dt.getDay(), dt.getHour(), dt.getMinute(), dt.getSecond());
        gregorianCalendar.set(14, dt.getMillisecond());
        return gregorianCalendar.getTime();
    }

    public static String toJavaPattern(String csharpPattern) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = csharpPattern.split("\"");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i % 2 == 0) {
                String[] stringArray2 = stringArray[i].split("'");
                StringBuffer stringBuffer2 = new StringBuffer();
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (j % 2 == 0) {
                        stringBuffer2.append(stringArray2[j].replaceAll("dddd", "EEEE").replaceAll("ddd", "EEE").replaceAll("f", "S").replaceAll("g", "G").replaceAll("t", "a").replaceAll("h", "K").replaceAll("z", "Z").replaceAll("ZZZ", "z"));
                        if (j >= stringArray2.length - 1) continue;
                        stringBuffer2.append("'");
                        continue;
                    }
                    stringBuffer2.append(stringArray2[j]);
                    stringBuffer2.append("'");
                }
                stringBuffer.append(stringBuffer2);
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append("\"");
                continue;
            }
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    public static long fromJavaTicks(long unixTicks) {
        long l = 62135596800000L + unixTicks;
        if (l < 0L) {
            l = 0L;
        }
        return l * 10000L;
    }

    public static DateTime fromJava(Date javaDate) {
        if (javaDate == null) {
            return new DateTime();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(javaDate);
        return new DateTime(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5), gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13), gregorianCalendar.get(14));
    }

    public String toString() {
        return this.toString("G", null);
    }

    public String toLongDateString() {
        return this.toString("D");
    }

    public String toShortDateString() {
        return this.toString("d");
    }

    public String toLongTimeString() {
        return this.toString("T");
    }

    public String toShortTimeString() {
        return this.toString("t");
    }

    public String toString(String format) {
        return this.toString(format, null);
    }

    @Override
    public String toString(String format, IFormatProvider provider) {
        boolean bl;
        ze ze2 = ze.a(provider);
        boolean bl2 = bl = provider == null;
        if (format == null || zax.e(format, "")) {
            format = "G";
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if (format.length() == 1) {
            bl = false;
            char c = format.charAt(0);
            boolean[] blArray = new boolean[]{bl3};
            boolean[] blArray2 = new boolean[]{bl4};
            format = zo.a(c, ze2, blArray, blArray2);
            bl3 = blArray[0];
            bl4 = blArray2[0];
            if (c == 'U') {
                return zo.a(this.toUniversalTime().Clone(), format, ze2, bl);
            }
            if (format == null) {
                throw new FormatException("format is not one of the format specifier characters defined for DateTimeFormatInfo");
            }
        }
        return zo.a(this.Clone(), format, ze2, bl);
    }

    public DateTime toUniversalTime() {
        if (this.getKind() == 1L) {
            return this;
        }
        long l = this.d();
        if (l > 3155378975999999999L) {
            return new DateTime(3155378975999999999L, 1L);
        }
        if (l < 0L) {
            return new DateTime(0L, 1L);
        }
        return new DateTime(l, 1L);
    }

    public String[] getDateTimeFormats() {
        return this.getDateTimeFormats(zd.d());
    }

    public String[] getDateTimeFormats(IFormatProvider provider) {
        return this.a(ze.a(provider));
    }

    public String[] getDateTimeFormats(char format) {
        return this.getDateTimeFormats(format, zd.d());
    }

    public String[] getDateTimeFormats(char format, IFormatProvider provider) {
        return this.a(format, ze.a(provider));
    }

    private String[] a(char c, ze ze2) {
        String[] stringArray = null;
        String[] stringArray2 = null;
        switch (c) {
            case 'D': 
            case 'F': 
            case 'G': 
            case 'M': 
            case 'T': 
            case 'Y': 
            case 'd': 
            case 'f': 
            case 'g': 
            case 'm': 
            case 't': 
            case 'y': {
                stringArray = ze2.a(c);
                stringArray2 = new String[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray2[i] = this.toString(stringArray[i], ze2);
                }
                return stringArray2;
            }
            case 'R': 
            case 'r': {
                return new String[]{this.toString(new String(new char[]{c}), ze.y())};
            }
            case 'O': 
            case 'o': 
            case 's': 
            case 'u': {
                return new String[]{this.toString(new String(new char[]{c}), ze2)};
            }
            case 'U': {
                DateTime dateTime = this.toUniversalTime();
                stringArray = ze2.a(c);
                stringArray2 = new String[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray2[i] = dateTime.toString(stringArray[i], ze2);
                }
                return stringArray2;
            }
        }
        throw new FormatException();
    }

    private String[] a(ze ze2) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.a.length; ++i) {
            String[] stringArray = this.a(this.a[i], ze2);
            for (int j = 0; j < stringArray.length; ++j) {
                arrayList.addItem(stringArray[j]);
            }
        }
        return (String[])Array.unboxing(arrayList.toArray(zb.a(String.class)));
    }

    public int getTypeCode() {
        return 16;
    }

    public static String toString(DateTime dateTime) {
        if (dateTime == null) {
            throw new NullReferenceException();
        }
        return dateTime.toString();
    }

    public static String toString(DateTime dateTime, String pattern) {
        if (dateTime == null) {
            throw new NullReferenceException();
        }
        return dateTime.toString(pattern);
    }

    public static String toString(DateTime dateTime, zd cultureInfo) {
        if (dateTime == null) {
            throw new NullReferenceException();
        }
        return dateTime.toString(cultureInfo);
    }

    public static String toString(DateTime dateTime, String pattern, zd cultureInfo) {
        if (dateTime == null) {
            throw new NullReferenceException();
        }
        return dateTime.toString(pattern, cultureInfo);
    }

    public static String toString(DateTime dateTime, String pattern, ze dateTimeFormatInfo) {
        if (dateTime == null) {
            throw new NullReferenceException();
        }
        return dateTime.toString(pattern, dateTimeFormatInfo);
    }

    private static String[] b(ze ze2) {
        int n = ze2.r().indexOf(100);
        int n2 = ze2.r().indexOf(77);
        int n3 = ze2.r().indexOf(121);
        if (n == -1 || n2 == -1 || n3 == -1) {
            return h;
        }
        if (n3 < n2) {
            if (n2 < n) {
                return i;
            }
            if (n3 < n) {
                return j;
            }
            return h;
        }
        if (n < n2) {
            return k;
        }
        if (n < n3) {
            return l;
        }
        return h;
    }

    static boolean a(String string, IFormatProvider iFormatProvider, int n, DateTime[] dateTimeArray, DateTimeOffset[] dateTimeOffsetArray, boolean bl, RuntimeException[] runtimeExceptionArray) {
        int n2;
        boolean bl2;
        Object[] objectArray;
        boolean bl3;
        int n3;
        ze ze2;
        String[] stringArray;
        dateTimeOffsetArray[0] = new DateTimeOffset(0L, TimeSpan.Zero.Clone());
        if (string == null || string.length() == 0) {
            if (bl) {
                runtimeExceptionArray[0] = new FormatException("String was not recognized as a valid DateTime.");
            }
            MinValue.CloneTo(dateTimeArray[0]);
            return false;
        }
        if (iFormatProvider == null) {
            iFormatProvider = zd.d();
        }
        if ((stringArray = DateTime.b(ze2 = ze.a(iFormatProvider))) == null) {
            MinValue.CloneTo(dateTimeArray[0]);
            return false;
        }
        boolean bl4 = false;
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            String string2 = stringArray[n3];
            bl3 = false;
            objectArray = new boolean[]{bl3};
            boolean[] blArray = new boolean[]{bl4};
            bl2 = DateTime.a(string, string2, "", false, dateTimeArray, dateTimeOffsetArray, ze2, n, true, objectArray, blArray);
            bl3 = objectArray[0];
            bl4 = blArray[0];
            if (bl2) {
                return true;
            }
            if (!bl3) continue;
            for (int i = 0; i < m.length; ++i) {
                objectArray[0] = bl3;
                blArray[0] = bl4;
                boolean bl5 = DateTime.a(string, string2, m[i], false, dateTimeArray, dateTimeOffsetArray, ze2, n, true, objectArray, blArray);
                bl3 = objectArray[0];
                bl4 = blArray[0];
                if (!bl5) continue;
                return true;
            }
        }
        n3 = ze2.u().indexOf(100);
        int n4 = ze2.u().indexOf(77);
        if (n3 == -1 || n4 == -1) {
            MinValue.CloneTo(dateTimeArray[0]);
            if (bl) {
                runtimeExceptionArray[0] = new FormatException(zax.a("Order of month and date is not defined by {0}", new Object[]{ze2.u()}));
            }
            return false;
        }
        bl3 = n3 < n4;
        objectArray = bl3 ? o : DateTime.n;
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            bl2 = false;
            boolean[] blArray = new boolean[]{bl2};
            boolean[] blArray2 = new boolean[]{bl4};
            boolean bl6 = DateTime.a(string, (String)objectArray[n2], "", false, dateTimeArray, dateTimeOffsetArray, ze2, n, true, blArray, blArray2);
            bl2 = blArray[0];
            bl4 = blArray2[0];
            if (!bl6) continue;
            return true;
        }
        for (n2 = 0; n2 < m.length; ++n2) {
            int n5;
            String string3 = m[n2];
            boolean bl7 = false;
            boolean[] blArray = new boolean[]{bl7};
            boolean[] blArray3 = new boolean[]{bl4};
            boolean bl8 = DateTime.a(string, string3, "", false, dateTimeArray, dateTimeOffsetArray, ze2, n, false, blArray, blArray3);
            bl7 = blArray[0];
            bl4 = blArray3[0];
            if (bl8) {
                return true;
            }
            if (!bl7) continue;
            for (n5 = 0; n5 < objectArray.length; ++n5) {
                blArray[0] = bl7;
                blArray3[0] = bl4;
                boolean bl9 = DateTime.a(string, string3, (String)objectArray[n5], false, dateTimeArray, dateTimeOffsetArray, ze2, n, false, blArray, blArray3);
                bl7 = blArray[0];
                bl4 = blArray3[0];
                if (!bl9) continue;
                return true;
            }
            for (n5 = 0; n5 < stringArray.length; ++n5) {
                String string4 = stringArray[n5];
                if (string4.charAt(string4.length() - 1) == 'T') continue;
                blArray[0] = bl7;
                blArray3[0] = bl4;
                boolean bl10 = DateTime.a(string, string3, string4, false, dateTimeArray, dateTimeOffsetArray, ze2, n, false, blArray, blArray3);
                bl7 = blArray[0];
                bl4 = blArray3[0];
                if (!bl10) continue;
                return true;
            }
        }
        boolean[] blArray = new boolean[]{bl4};
        boolean bl11 = DateTime.a(string, ze2.G(), ze2, n, dateTimeArray, false, blArray, bl, runtimeExceptionArray);
        bl4 = blArray[0];
        if (bl11) {
            return true;
        }
        if (!bl) {
            return false;
        }
        runtimeExceptionArray[0] = new FormatException("String was not recognized as a valid DateTime.");
        return false;
    }

    private static boolean a(String string, int n) {
        return n < string.length() && Character.isLetter(string.charAt(n));
    }

    private static int a(String string, int n, int n2, int n3, boolean bl, boolean bl2, int[] nArray) {
        int n4;
        char c;
        int n5 = 0;
        if (bl2) {
            bl = false;
        }
        if (!bl) {
            c = '\u0000';
            for (n4 = n; n4 < string.length() && n4 < n3 + n && Character.isDigit(string.charAt(n4)); ++n4) {
                ++c;
            }
            n3 = c;
        }
        if (n3 < n2) {
            nArray[0] = -1;
            return 0;
        }
        if (string.length() - n < n3) {
            nArray[0] = -1;
            return 0;
        }
        for (n4 = n; n4 < n3 + n; ++n4) {
            c = string.charAt(n4);
            if (!Character.isDigit(c)) {
                nArray[0] = -1;
                return 0;
            }
            n5 = n5 * 10 + ((byte)(c - 48) & 0xFF);
        }
        nArray[0] = n3;
        return n5;
    }

    private static int a(String string, int n, String[] stringArray, String[] stringArray2, boolean bl, int[] nArray) {
        for (int i = stringArray.length - 1; i >= 0; --i) {
            if (!bl && stringArray2[i].length() > stringArray[i].length()) {
                if (stringArray2[i].length() > 0 && DateTime.a(string, n, 0, stringArray2[i], nArray)) {
                    return i;
                }
                if (stringArray[i].length() <= 0 || !DateTime.a(string, n, 0, stringArray[i], nArray)) continue;
                return i;
            }
            if (stringArray[i].length() > 0 && DateTime.a(string, n, 0, stringArray[i], nArray)) {
                return i;
            }
            if (bl || stringArray2[i].length() <= 0 || !DateTime.a(string, n, 0, stringArray2[i], nArray)) continue;
            return i;
        }
        nArray[0] = -1;
        return -1;
    }

    private static boolean a(String string, int n, int n2, String string2, int[] nArray) {
        if (n2 <= 0) {
            n2 = string2.length();
        }
        if (n + n2 <= string.length() && zax.a(string, n, string2, 0, n2, true, zd.c()) == 0) {
            nArray[0] = n2;
            return true;
        }
        nArray[0] = -1;
        return false;
    }

    private static boolean a(String string, int n, int n2, ze ze2, boolean bl, int[] nArray, int[] nArray2) {
        nArray[0] = -1;
        if (nArray2[0] != -1) {
            return false;
        }
        if (!DateTime.a(string, n)) {
            if (!"".equals(ze2.m())) {
                return false;
            }
            if (bl) {
                nArray2[0] = 0;
            }
            nArray[0] = 0;
            return true;
        }
        ze ze3 = ze.y();
        if (!bl && DateTime.a(string, n, n2, ze3.n(), nArray) || !"".equals(ze2.n()) && DateTime.a(string, n, n2, ze2.n(), nArray)) {
            nArray2[0] = 1;
        } else if (!bl && DateTime.a(string, n, n2, ze3.m(), nArray) || DateTime.a(string, n, n2, ze2.m(), nArray)) {
            if (bl || nArray[0] != 0) {
                nArray2[0] = 0;
            }
        } else {
            return false;
        }
        return true;
    }

    private static boolean a(String string, int n, ze ze2, boolean bl, int[] nArray) {
        return DateTime.a(string, n, 0, ze2.p(), nArray) || !bl && DateTime.a(string, n, 0, ":", nArray);
    }

    private static boolean b(String string, int n, ze ze2, boolean bl, int[] nArray) {
        nArray[0] = -1;
        if (bl && string.charAt(n) != '/') {
            return false;
        }
        if (DateTime.a(string, n, ze2, bl, nArray) || Character.isDigit(string.charAt(n)) || Character.isLetter(string.charAt(n))) {
            return false;
        }
        nArray[0] = 1;
        return true;
    }

    private static boolean a(String string, String[] stringArray, ze ze2, int n, DateTime[] dateTimeArray, boolean bl, boolean[] blArray, boolean bl2, RuntimeException[] runtimeExceptionArray) {
        boolean bl3 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            DateTime dateTime = new DateTime();
            String string2 = stringArray[i];
            if (string2 == null || zax.e(string2, "")) break;
            DateTimeOffset dateTimeOffset = new DateTimeOffset();
            DateTime[] dateTimeArray2 = new DateTime[]{dateTime};
            DateTimeOffset[] dateTimeOffsetArray = new DateTimeOffset[]{dateTimeOffset};
            boolean[] blArray2 = new boolean[]{bl3};
            boolean bl4 = DateTime.a(string, stringArray[i], null, bl, dateTimeArray2, dateTimeOffsetArray, ze2, n, false, blArray2, blArray);
            dateTimeArray2[0].CloneTo(dateTime);
            dateTimeOffsetArray[0].CloneTo(dateTimeOffset);
            bl3 = blArray2[0];
            if (!bl4) continue;
            dateTime.CloneTo(dateTimeArray[0]);
            return true;
        }
        if (bl2) {
            runtimeExceptionArray[0] = new FormatException("Invalid format string");
        }
        MinValue.CloneTo(dateTimeArray[0]);
        return false;
    }

    private static boolean a(String string, String string2, String string3, boolean bl, DateTime[] dateTimeArray, DateTimeOffset[] dateTimeOffsetArray, ze ze2, int n, boolean bl2, boolean[] blArray, boolean[] blArray2) {
        boolean bl3;
        boolean bl4;
        Object object;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        dateTimeOffsetArray[0] = new DateTimeOffset(0L, TimeSpan.Zero.Clone());
        boolean bl8 = !bl && string3 != null;
        blArray[0] = false;
        int n2 = 0;
        String string4 = string2;
        boolean bl9 = false;
        ze ze3 = ze.y();
        if (string4.length() == 1) {
            object = new boolean[]{bl5};
            boolean[] blArray3 = new boolean[]{bl6};
            string4 = zo.a(string4.charAt(0), ze2, (boolean[])object, blArray3);
            bl5 = object[0];
            bl6 = blArray3[0];
        }
        dateTimeArray[0] = new DateTime(0L);
        if (string4 == null) {
            return false;
        }
        if (string == null) {
            return false;
        }
        if ((n & 1) != 0) {
            string4 = zax.d(string4, null);
            string = zax.d(string, null);
        }
        if ((n & 2) != 0) {
            string4 = zax.e(string4, null);
            string = zax.e(string, null);
        }
        if (bl6) {
            ze2 = ze3;
        }
        if ((n & 4) != 0) {
            bl7 = true;
        }
        object = string4;
        int n3 = string4.length();
        int n4 = 0;
        int n5 = 0;
        if (n3 == 0) {
            return false;
        }
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        double d = -1.0;
        int n13 = -1;
        int n14 = -1;
        int n15 = -1;
        int n16 = -1;
        boolean bl10 = true;
        boolean bl11 = false;
        while (n2 != string.length()) {
            char c;
            int[] nArray;
            int[] nArray2;
            int n17 = 0;
            if (bl8 && n4 + n5 == 0) {
                bl4 = DateTime.a(string, n2);
                if (bl4) {
                    if (string.charAt(n2) == 'Z') {
                        n17 = 1;
                    } else {
                        nArray2 = new int[]{n17};
                        DateTime.a(string, n2, 0, "GMT", nArray2);
                        n17 = nArray2[0];
                    }
                    if (n17 > 0 && !DateTime.a(string, n2 + n17)) {
                        n2 += n17;
                        bl5 = true;
                        continue;
                    }
                }
                nArray2 = new int[]{n17};
                nArray = new int[]{n13};
                c = !bl9 && DateTime.a(string, n2, 0, ze2, bl, nArray2, nArray) ? (char)'\u0001' : '\u0000';
                n17 = nArray2[0];
                n13 = nArray[0];
                if (c != '\u0000') {
                    if (DateTime.a(string, n2 + n17)) {
                        n13 = -1;
                    } else if (n17 > 0) {
                        n2 += n17;
                        continue;
                    }
                }
                if (!bl9 && n7 == -1 && bl4) {
                    nArray2[0] = n17;
                    n7 = DateTime.a(string, n2, ze2.g(), ze3.g(), bl, nArray2);
                    n17 = nArray2[0];
                    if (n7 == -1) {
                        nArray2[0] = n17;
                        n7 = DateTime.a(string, n2, ze2.c(), ze3.c(), bl, nArray2);
                        n17 = nArray2[0];
                    }
                    if (n7 != -1 && !DateTime.a(string, n2 + n17)) {
                        n2 += n17;
                        continue;
                    }
                    n7 = -1;
                }
                if (zg.l(string.charAt(n2)) || string.charAt(n2) == ',') {
                    ++n2;
                    continue;
                }
                n17 = 0;
            }
            if (n4 + n5 >= n3) {
                if (!bl8 || n5 != 0) break;
                boolean bl12 = bl9 = bl10 && string2.charAt(string2.length() - 1) == 'T';
                if (!bl10 && "".equals(string4)) break;
                n4 = 0;
                string4 = bl10 ? string3 : "";
                object = string4;
                n3 = ((String)object).length();
                bl10 = false;
                continue;
            }
            bl4 = true;
            if (((String)object).charAt(n4) == '\'') {
                n5 = 1;
                while (n4 + n5 < n3 && ((String)object).charAt(n4 + n5) != '\'') {
                    if (n2 == string.length() || string.charAt(n2) != ((String)object).charAt(n4 + n5)) {
                        return false;
                    }
                    ++n2;
                    ++n5;
                }
                n4 += n5 + 1;
                n5 = 0;
                continue;
            }
            if (((String)object).charAt(n4) == '\"') {
                n5 = 1;
                while (n4 + n5 < n3 && ((String)object).charAt(n4 + n5) != '\"') {
                    if (n2 == string.length() || string.charAt(n2) != ((String)object).charAt(n4 + n5)) {
                        return false;
                    }
                    ++n2;
                    ++n5;
                }
                n4 += n5 + 1;
                n5 = 0;
                continue;
            }
            if (((String)object).charAt(n4) == '\\') {
                n5 = 0;
                if ((n4 += n5 + 1) >= n3) {
                    return false;
                }
                if (string.charAt(n2) != ((String)object).charAt(n4)) {
                    return false;
                }
                ++n2;
                ++n4;
                continue;
            }
            if (((String)object).charAt(n4) == '%') {
                ++n4;
                continue;
            }
            if (zg.l(string.charAt(n2)) || string.charAt(n2) == ',' && (!bl && ((String)object).charAt(n4) == '/' || zg.l(((String)object).charAt(n4)))) {
                int n18;
                ++n2;
                n5 = 0;
                if (bl && (n & 4) == 0) {
                    if (!zg.l(((String)object).charAt(n4))) {
                        return false;
                    }
                    ++n4;
                    continue;
                }
                for (n18 = n2; n18 < string.length() && (zg.l(string.charAt(n18)) || string.charAt(n18) == ','); ++n18) {
                }
                n2 = n18;
                for (n18 = n4; n18 < ((String)object).length() && (zg.l(((String)object).charAt(n18)) || ((String)object).charAt(n18) == ','); ++n18) {
                }
                n4 = n18;
                if (bl || n4 >= ((String)object).length() || ((String)object).charAt(n4) != '/') continue;
                nArray = new int[]{n17};
                c = !DateTime.b(string, n2, ze2, bl, nArray) ? (char)'\u0001' : '\u0000';
                n17 = nArray[0];
                if (c == '\u0000') continue;
                ++n4;
                continue;
            }
            if (n4 + n5 + 1 < n3 && ((String)object).charAt(n4 + n5 + 1) == ((String)object).charAt(n4 + n5)) {
                ++n5;
                continue;
            }
            switch (((String)object).charAt(n4)) {
                case 'd': {
                    if (n5 < 2 && n6 != -1 || n5 >= 2 && n7 != -1) {
                        return false;
                    }
                    if (n5 == 0) {
                        nArray2 = new int[]{n17};
                        n6 = DateTime.a(string, n2, 1, 2, false, bl7, nArray2);
                        n17 = nArray2[0];
                        break;
                    }
                    if (n5 == 1) {
                        nArray2 = new int[]{n17};
                        n6 = DateTime.a(string, n2, 1, 2, true, bl7, nArray2);
                        n17 = nArray2[0];
                        break;
                    }
                    if (n5 == 2) {
                        nArray2 = new int[]{n17};
                        n7 = DateTime.a(string, n2, ze2.c(), ze3.c(), bl, nArray2);
                        n17 = nArray2[0];
                        break;
                    }
                    nArray2 = new int[]{n17};
                    n7 = DateTime.a(string, n2, ze2.g(), ze3.g(), bl, nArray2);
                    n17 = nArray2[0];
                    break;
                }
                case 'M': {
                    if (n8 != -1) {
                        return false;
                    }
                    if (bl8) {
                        n17 = -1;
                        if (n5 == 0 || n5 == 3) {
                            nArray2 = new int[]{n17};
                            n8 = DateTime.a(string, n2, 1, 2, false, bl7, nArray2);
                            n17 = nArray2[0];
                        }
                        if (n5 > 1 && n17 == -1) {
                            nArray2 = new int[]{n17};
                            n8 = DateTime.a(string, n2, ze2.i(), ze3.i(), bl, nArray2) + 1;
                            n17 = nArray2[0];
                        }
                        if (n5 <= 1 || n17 != -1) break;
                        nArray2 = new int[]{n17};
                        n8 = DateTime.a(string, n2, ze2.e(), ze3.e(), bl, nArray2) + 1;
                        n17 = nArray2[0];
                        break;
                    }
                    if (n5 == 0) {
                        nArray2 = new int[]{n17};
                        n8 = DateTime.a(string, n2, 1, 2, false, bl7, nArray2);
                        n17 = nArray2[0];
                        break;
                    }
                    if (n5 == 1) {
                        nArray2 = new int[]{n17};
                        n8 = DateTime.a(string, n2, 1, 2, true, bl7, nArray2);
                        n17 = nArray2[0];
                        break;
                    }
                    if (n5 == 2) {
                        nArray2 = new int[]{n17};
                        n8 = DateTime.a(string, n2, ze2.e(), ze3.e(), bl, nArray2) + 1;
                        n17 = nArray2[0];
                        break;
                    }
                    nArray2 = new int[]{n17};
                    n8 = DateTime.a(string, n2, ze2.i(), ze3.i(), bl, nArray2) + 1;
                    n17 = nArray2[0];
                    break;
                }
                case 'E': {
                    if (n7 != -1) {
                        return false;
                    }
                    if (n5 == 2) {
                        nArray2 = new int[]{n17};
                        n7 = DateTime.a(string, n2, ze2.c(), ze3.c(), bl, nArray2);
                        n17 = nArray2[0];
                        break;
                    }
                    nArray2 = new int[]{n17};
                    n7 = DateTime.a(string, n2, ze2.g(), ze3.g(), bl, nArray2);
                    n17 = nArray2[0];
                    break;
                }
                case 'y': {
                    if (n9 != -1) {
                        return false;
                    }
                    if (n5 == 0) {
                        nArray2 = new int[]{n17};
                        n9 = DateTime.a(string, n2, 1, 2, false, bl7, nArray2);
                        n17 = nArray2[0];
                    } else if (n5 < 3) {
                        nArray2 = new int[]{n17};
                        n9 = DateTime.a(string, n2, 1, 2, true, bl7, nArray2);
                        n17 = nArray2[0];
                    } else {
                        nArray2 = new int[]{n17};
                        n9 = DateTime.a(string, n2, bl ? 4 : 3, 4, false, bl7, nArray2);
                        n17 = nArray2[0];
                        if (n9 >= 1000 && n17 == 4 && !blArray2[0] && string.length() > 4 + n2) {
                            int n19 = 0;
                            int[] nArray3 = new int[]{n19};
                            int n20 = DateTime.a(string, n2, 5, 5, false, bl7, nArray3);
                            n19 = nArray3[0];
                            blArray2[0] = n20 > 9999;
                        }
                        n5 = 3;
                    }
                    if (n17 > 2) break;
                    n9 += n9 < 30 ? 2000 : 1900;
                    break;
                }
                case 'h': {
                    if (n10 != -1) {
                        return false;
                    }
                    if (n5 == 0) {
                        nArray2 = new int[]{n17};
                        n10 = DateTime.a(string, n2, 1, 2, false, bl7, nArray2);
                        n17 = nArray2[0];
                    } else {
                        nArray2 = new int[]{n17};
                        n10 = DateTime.a(string, n2, 1, 2, true, bl7, nArray2);
                        n17 = nArray2[0];
                    }
                    if (n10 > 12) {
                        return false;
                    }
                    if (n10 != 12) break;
                    n10 = 0;
                    break;
                }
                case 'H': {
                    if (n10 != -1 || !bl8 && n13 >= 0) {
                        return false;
                    }
                    if (n5 == 0) {
                        nArray2 = new int[]{n17};
                        n10 = DateTime.a(string, n2, 1, 2, false, bl7, nArray2);
                        n17 = nArray2[0];
                    } else {
                        nArray2 = new int[]{n17};
                        n10 = DateTime.a(string, n2, 1, 2, true, bl7, nArray2);
                        n17 = nArray2[0];
                    }
                    if (n10 >= 24) {
                        return false;
                    }
                    bl11 = true;
                    break;
                }
                case 'm': {
                    if (n11 != -1) {
                        return false;
                    }
                    if (n5 == 0) {
                        nArray2 = new int[]{n17};
                        n11 = DateTime.a(string, n2, 1, 2, false, bl7, nArray2);
                        n17 = nArray2[0];
                    } else {
                        nArray2 = new int[]{n17};
                        n11 = DateTime.a(string, n2, 1, 2, true, bl7, nArray2);
                        n17 = nArray2[0];
                    }
                    if (n11 < 60) break;
                    return false;
                }
                case 's': {
                    if (n12 != -1) {
                        return false;
                    }
                    if (n5 == 0) {
                        nArray2 = new int[]{n17};
                        n12 = DateTime.a(string, n2, 1, 2, false, bl7, nArray2);
                        n17 = nArray2[0];
                    } else {
                        nArray2 = new int[]{n17};
                        n12 = DateTime.a(string, n2, 1, 2, true, bl7, nArray2);
                        n17 = nArray2[0];
                    }
                    if (n12 < 60) break;
                    return false;
                }
                case 'F': 
                case 'f': {
                    if (((String)object).charAt(n4) == 'F') {
                        bl4 = false;
                    }
                    if (n5 > 6 || d != -1.0) {
                        return false;
                    }
                    int n21 = 0;
                    if (!bl) {
                        for (int i = n2; i < string.length() && Character.isDigit(c = string.charAt(i)); ++i) {
                            ++n21;
                        }
                    } else {
                        n21 = n5 + 1;
                    }
                    int[] nArray4 = new int[]{n17};
                    double d2 = DateTime.a(string, n2, 0, n21, bl4, bl7, nArray4);
                    n17 = nArray4[0];
                    if (n17 == -1) {
                        return false;
                    }
                    d = d2 / Math.pow(10.0, n17);
                    break;
                }
                case 't': {
                    nArray2 = new int[]{n17};
                    nArray = new int[]{n13};
                    c = !DateTime.a(string, n2, n5 > 0 ? 0 : 1, ze2, bl, nArray2, nArray) ? (char)'\u0001' : '\u0000';
                    n17 = nArray2[0];
                    n13 = nArray[0];
                    if (c == '\u0000') break;
                    return false;
                }
                case 'z': {
                    if (n14 != -1) {
                        return false;
                    }
                    if (string.charAt(n2) == '+') {
                        n14 = 0;
                    } else if (string.charAt(n2) == '-') {
                        n14 = 1;
                    } else {
                        return false;
                    }
                    ++n2;
                    if (n5 == 0) {
                        nArray2 = new int[]{n17};
                        n15 = DateTime.a(string, n2, 1, 2, false, bl7, nArray2);
                        n17 = nArray2[0];
                        break;
                    }
                    if (n5 == 1) {
                        nArray2 = new int[]{n17};
                        n15 = DateTime.a(string, n2, 1, 2, true, bl7, nArray2);
                        n17 = nArray2[0];
                        break;
                    }
                    nArray2 = new int[]{n17};
                    n15 = DateTime.a(string, n2, 1, 2, true, true, nArray2);
                    n17 = nArray2[0];
                    n2 += n17;
                    if (n17 < 0) {
                        return false;
                    }
                    nArray2[0] = n17 = 0;
                    boolean bl13 = n2 < string.length() && Character.isDigit(string.charAt(n2)) || DateTime.a(string, n2, ze2, bl, nArray2);
                    n17 = nArray2[0];
                    if (bl13) {
                        nArray2[0] = n17;
                        n16 = DateTime.a(string, n2 += n17, 1, 2, true, bl7, nArray2);
                        n17 = nArray2[0];
                        if (n17 >= 0) break;
                        return false;
                    }
                    if (!bl8) {
                        return false;
                    }
                    n17 = 0;
                    break;
                }
                case 'K': {
                    if (string.charAt(n2) == 'Z') {
                        ++n2;
                        bl5 = true;
                        break;
                    }
                    if (string.charAt(n2) != '+' && string.charAt(n2) != '-') break;
                    if (n14 != -1) {
                        return false;
                    }
                    if (string.charAt(n2) == '+') {
                        n14 = 0;
                    } else if (string.charAt(n2) == '-') {
                        n14 = 1;
                    }
                    nArray2 = new int[]{n17};
                    n15 = DateTime.a(string, ++n2, 0, 2, true, bl7, nArray2);
                    n17 = nArray2[0];
                    n2 += n17;
                    if (n17 < 0) {
                        return false;
                    }
                    if (Character.isDigit(string.charAt(n2))) {
                        n17 = 0;
                    } else {
                        nArray2[0] = n17;
                        boolean bl14 = !DateTime.a(string, n2, 0, ze2.p(), nArray2);
                        n17 = nArray2[0];
                        if (bl14) {
                            return false;
                        }
                    }
                    nArray2[0] = n17;
                    n16 = DateTime.a(string, n2 += n17, 0, 2, true, bl7, nArray2);
                    n17 = nArray2[0];
                    n5 = 2;
                    if (n17 >= 0) break;
                    return false;
                }
                case 'Z': {
                    if (string.charAt(n2) != 'Z') {
                        return false;
                    }
                    n5 = 0;
                    n17 = 1;
                    bl5 = true;
                    break;
                }
                case 'G': {
                    if (string.charAt(n2) != 'G') {
                        return false;
                    }
                    if (n4 + 2 < n3 && n2 + 2 < string.length() && ((String)object).charAt(n4 + 1) == 'M' && string.charAt(n2 + 1) == 'M' && ((String)object).charAt(n4 + 2) == 'T' && string.charAt(n2 + 2) == 'T') {
                        bl5 = true;
                        n5 = 2;
                        n17 = 3;
                        break;
                    }
                    n5 = 0;
                    n17 = 1;
                    break;
                }
                case ':': {
                    nArray2 = new int[]{n17};
                    boolean bl15 = !DateTime.a(string, n2, ze2, bl, nArray2);
                    n17 = nArray2[0];
                    if (!bl15) break;
                    return false;
                }
                case '/': {
                    nArray2 = new int[]{n17};
                    boolean bl16 = !DateTime.b(string, n2, ze2, bl, nArray2);
                    n17 = nArray2[0];
                    if (bl16) {
                        return false;
                    }
                    n5 = 0;
                    break;
                }
                case '.': {
                    if (string.charAt(n2) == '.') {
                        n5 = 0;
                        n17 = 1;
                        break;
                    }
                    if (n4 + 1 < n3 && ((String)object).charAt(n4 + 1) == 'F') {
                        ++n4;
                        while (n4 + 1 < n3 && ((String)object).charAt(n4 + 1) == 'F') {
                            ++n4;
                        }
                        n5 = 0;
                        n17 = 0;
                        break;
                    }
                    return false;
                }
                default: {
                    if (string.charAt(n2) != ((String)object).charAt(n4)) {
                        return false;
                    }
                    n5 = 0;
                    n17 = 1;
                }
            }
            if (n17 < 0) {
                return false;
            }
            n2 += n17;
            if (!bl && !bl8) {
                switch (((String)object).charAt(n4)) {
                    case 'F': 
                    case 'f': 
                    case 'm': 
                    case 's': 
                    case 'z': {
                        if (string.length() <= n2 || string.charAt(n2) != 'Z' || n4 + 1 != ((String)object).length() && ((String)object).charAt(n4 + 1) == 'Z') break;
                        bl5 = true;
                        ++n2;
                    }
                }
            }
            n4 = n4 + n5 + 1;
            n5 = 0;
        }
        if (n4 + 1 < n3 && ((String)object).charAt(n4) == '.' && ((String)object).charAt(n4 + 1) == 'F') {
            ++n4;
            while (n4 < n3 && ((String)object).charAt(n4) == 'F') {
                ++n4;
            }
        }
        while (n4 < n3 && ((String)object).charAt(n4) == 'K') {
            ++n4;
        }
        if (n4 < n3) {
            return false;
        }
        if (string.length() > n2) {
            if (n2 == 0) {
                return false;
            }
            if (Character.isDigit(string.charAt(n2)) && Character.isDigit(string.charAt(n2 - 1))) {
                return false;
            }
            if (Character.isLetter(string.charAt(n2)) && Character.isLetter(string.charAt(n2 - 1))) {
                return false;
            }
            blArray[0] = true;
            return false;
        }
        if (n10 == -1) {
            n10 = 0;
        }
        if (n11 == -1) {
            n11 = 0;
        }
        if (n12 == -1) {
            n12 = 0;
        }
        if (d == -1.0) {
            d = 0.0;
        }
        if (n6 == -1 && n8 == -1 && n9 == -1) {
            if ((n & 8) != 0) {
                n6 = 1;
                n8 = 1;
                n9 = 1;
            } else {
                n6 = DateTime.getToday().getDay();
                n8 = DateTime.getToday().getMonth();
                n9 = DateTime.getToday().getYear();
            }
        }
        if (n6 == -1) {
            n6 = 1;
        }
        if (n8 == -1) {
            n8 = 1;
        }
        if (n9 == -1) {
            n9 = (n & 8) != 0 ? 1 : DateTime.getToday().getYear();
        }
        if (n13 == 0) {
            if (n10 >= 12 && bl11 && bl) {
                return false;
            }
            if (n10 == 12) {
                n10 = 0;
            }
        } else if (n13 == 1 && n10 < 12) {
            if (bl11 && bl) {
                return false;
            }
            n10 += 12;
        }
        if (n9 < 1 || n9 > 9999 || n8 < 1 || n8 > 12 || n6 < 1 || n6 > DateTime.daysInMonth(n9, n8) || n10 < 0 || n10 > 23 || n11 < 0 || n11 > 59 || n12 < 0 || n12 > 59) {
            return false;
        }
        dateTimeArray[0] = new DateTime(n9, n8, n6, n10, n11, n12, 0);
        dateTimeArray[0].addSeconds(d).CloneTo(dateTimeArray[0]);
        if (n7 != -1 && n7 != dateTimeArray[0].getDayOfWeek()) {
            return false;
        }
        if (n14 == -1) {
            if (!DateTime.equals(dateTimeArray[0], MinValue)) {
                try {
                    dateTimeOffsetArray[0] = new DateTimeOffset(dateTimeArray[0].Clone());
                }
                catch (Exception exception) {}
            }
        } else {
            if (n16 == -1) {
                n16 = 0;
            }
            if (n15 == -1) {
                n15 = 0;
            }
            if (n14 == 1) {
                n15 = -n15;
                n16 = -n16;
            }
            try {
                dateTimeOffsetArray[0] = new DateTimeOffset(dateTimeArray[0].Clone(), new TimeSpan(n15, n16, 0));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean bl17 = bl3 = (n & 0x10) != 0;
        if (n14 != -1) {
            long l = DateTime.op_Subtraction(dateTimeArray[0], dateTimeOffsetArray[0].getOffset()).getTicks();
            if (l < 0L) {
                l += 864000000000L;
            }
            dateTimeArray[0] = new DateTime(l, 1L);
            if ((n & 0x80) != 0) {
                dateTimeArray[0].toLocalTime().CloneTo(dateTimeArray[0]);
            }
        } else if (bl5 || (n & 0x40) != 0) {
            dateTimeArray[0].e |= 0x4000000000000000L;
        } else if ((n & 0x20) != 0) {
            dateTimeArray[0].e |= Long.MIN_VALUE;
        }
        boolean bl18 = bl4 = !bl3 && (n & 0x80) == 0;
        if ((long)((int)(dateTimeArray[0].e >> 62)) != 0L) {
            if (bl3) {
                dateTimeArray[0].toUniversalTime().CloneTo(dateTimeArray[0]);
            } else if (bl4) {
                dateTimeArray[0].toLocalTime().CloneTo(dateTimeArray[0]);
            }
        }
        return true;
    }

    public static DateTime parse(String s) {
        return DateTime.parse(s, null);
    }

    public static DateTime parse(String s, IFormatProvider provider) {
        return DateTime.parse(s, provider, 7);
    }

    public static DateTime parse(String s, IFormatProvider provider, int styles) {
        if (s == null) {
            throw new ArgumentNullException("s");
        }
        DateTime dateTime = new DateTime();
        DateTimeOffset dateTimeOffset = new DateTimeOffset();
        RuntimeException runtimeException = null;
        DateTime[] dateTimeArray = new DateTime[]{dateTime};
        DateTimeOffset[] dateTimeOffsetArray = new DateTimeOffset[]{dateTimeOffset};
        RuntimeException[] runtimeExceptionArray = new RuntimeException[]{runtimeException};
        boolean bl = !DateTime.a(s, provider, styles, dateTimeArray, dateTimeOffsetArray, true, runtimeExceptionArray);
        dateTimeArray[0].CloneTo(dateTime);
        dateTimeOffsetArray[0].CloneTo(dateTimeOffset);
        runtimeException = runtimeExceptionArray[0];
        if (bl) {
            throw runtimeException;
        }
        return dateTime;
    }

    public static boolean tryParse(String value, DateTime[] referenceToDateTime) {
        return DateTime.tryParse(value, ze.x(), 0, referenceToDateTime);
    }

    public static boolean tryParse(String s, IFormatProvider provider, int styles, DateTime[] result) {
        if (s != null) {
            try {
                Object var4_4 = null;
                DateTimeOffset dateTimeOffset = new DateTimeOffset();
                DateTimeOffset[] dateTimeOffsetArray = new DateTimeOffset[]{dateTimeOffset};
                RuntimeException[] runtimeExceptionArray = new RuntimeException[]{var4_4};
                return DateTime.a(s, provider, styles, result, dateTimeOffsetArray, false, runtimeExceptionArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MinValue.CloneTo(result[0]);
        return false;
    }

    public static boolean tryParseExact(String s, String format, IFormatProvider provider, int style, DateTime[] result) {
        String[] stringArray = new String[]{format};
        return DateTime.tryParseExact(s, stringArray, provider, style, result);
    }

    public static boolean tryParseExact(String s, String[] formats, IFormatProvider provider, int style, DateTime[] result) {
        try {
            ze ze2 = ze.a(provider);
            boolean[] blArray = new boolean[]{false};
            RuntimeException[] runtimeExceptionArray = new Exception[]{null};
            return DateTime.a(s, formats, ze2, style, result, true, blArray, false, runtimeExceptionArray);
        }
        catch (RuntimeException runtimeException) {
            result[0] = MinValue.Clone();
            return false;
        }
    }

    @Override
    public void CloneTo(DateTime that) {
        if (that.g) {
            throw new InvalidOperationException("Cannot clone into read-only value");
        }
        that.e = this.e;
        that.f = this.f;
    }

    public Object clone() {
        return this.Clone();
    }

    @Override
    public DateTime Clone() {
        DateTime dateTime = new DateTime();
        dateTime.e = this.e;
        dateTime.f = this.f;
        return dateTime;
    }

    public String toString(IFormatProvider provider) {
        return this.toString(null, provider);
    }

    public static DateTime parseExact(String dateString, String format, IFormatProvider formatProvider) {
        return DateTime.parseExact(dateString, format, formatProvider, 0);
    }

    public static DateTime parseExact(String dateString, String format, IFormatProvider formatProvider, int style) {
        if (format == null) {
            throw new ArgumentNullException("format");
        }
        String[] stringArray = new String[]{format};
        return DateTime.parseExact(dateString, stringArray, formatProvider, style);
    }

    public static DateTime parseExact(String dateString, String[] formats, IFormatProvider formatProvider, int style) {
        ze ze2 = ze.a(formatProvider);
        DateTime.b(style);
        if (dateString == null) {
            throw new ArgumentNullException("s");
        }
        if (formats == null) {
            throw new ArgumentNullException("formats");
        }
        if (formats.length == 0) {
            throw new FormatException("Format specifier was invalid.");
        }
        DateTime dateTime = new DateTime();
        boolean bl = false;
        RuntimeException runtimeException = null;
        DateTime[] dateTimeArray = new DateTime[]{dateTime};
        boolean[] blArray = new boolean[]{bl};
        RuntimeException[] runtimeExceptionArray = new RuntimeException[]{runtimeException};
        boolean bl2 = !DateTime.a(dateString, formats, ze2, style, dateTimeArray, true, blArray, true, runtimeExceptionArray);
        dateTimeArray[0].CloneTo(dateTime);
        bl = blArray[0];
        runtimeException = runtimeExceptionArray[0];
        if (bl2) {
            throw runtimeException;
        }
        return dateTime;
    }

    private static void b(int n) {
        if ((n & 0x80) != 0 && ((n & 0x10) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0)) {
            throw new ArgumentException("The DateTimeStyles value RoundtripKind cannot be used with the values AssumeLocal, Asersal or AdjustToUniversal.", "style");
        }
        if ((n & 0x40) != 0 && (n & 0x20) != 0) {
            throw new ArgumentException("The DateTimeStyles values AssumeLocal and AssumeUniversal cannot be used together.", "style");
        }
    }

    public static DateTime fromBinary(long dateData) {
        switch ((int)(dateData >> 62)) {
            case 1: {
                return new DateTime(dateData & 0x3FFFFFFFFFFFFFFFL, 1L);
            }
            case 0: {
                return new DateTime(dateData, 0L);
            }
        }
        return new DateTime(dateData & 0x3FFFFFFFFFFFFFFFL, 1L).toLocalTime();
    }

    public long toBinary() {
        if ((this.e & Long.MIN_VALUE) != 0L) {
            return this.toUniversalTime().getTicks() | Long.MIN_VALUE;
        }
        return this.e;
    }
}

