/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.email.system.collections;

import com.aspose.email.internal.b.zau;
import com.aspose.email.internal.b.zaz;
import com.aspose.email.internal.b.zbj;
import com.aspose.email.internal.b.zz;
import com.aspose.email.system.Array;
import com.aspose.email.system.collections.ICollection;
import com.aspose.email.system.collections.IEnumerator;
import com.aspose.email.system.collections.IList;
import com.aspose.email.system.exceptions.ArgumentException;
import com.aspose.email.system.exceptions.ArgumentNullException;
import com.aspose.email.system.exceptions.ArgumentOutOfRangeException;
import com.aspose.email.system.exceptions.InvalidOperationException;
import com.aspose.email.system.exceptions.NotSupportedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@zau
public class ArrayList
implements IList,
List {
    private Object[] a;
    private int b;
    private int c;

    protected int getVersion() {
        return this.c;
    }

    public ArrayList() {
        this.a = new Object[4];
    }

    public ArrayList(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c", "collection is null");
        }
        this.a = new Object[c.size()];
        this.addRange(c);
    }

    public ArrayList(int capacity) {
        if (capacity < 0) {
            ArrayList.a("capacity", (Object)capacity, "The initial capacity can't be smaller than zero.");
        }
        if (capacity == 0) {
            capacity = 4;
        }
        this.a = new Object[capacity];
    }

    private ArrayList(int initialCapacity, boolean forceZeroSize) {
        if (!forceZeroSize) {
            throw new IllegalStateException("Use ArrayList(int)");
        }
        this.a = null;
    }

    private ArrayList(Array array, int index, int count) {
        this.a = count == 0 ? new Object[4] : new Object[count];
        Array.copy(array, index, Array.boxing(this.a), 0, count);
        this.b = count;
    }

    @Override
    public Object get_Item(int index) {
        if (index < 0 || index >= this.b) {
            ArrayList.a("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        return this.a[index];
    }

    @Override
    public void set_Item(int index, Object value) {
        if (index < 0 || index >= this.b) {
            ArrayList.a("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        this.a[index] = value;
        ++this.c;
    }

    @Override
    public int size() {
        return this.b;
    }

    public int getCapacity() {
        return this.a.length;
    }

    public void setCapacity(int value) {
        if (value < this.b) {
            ArrayList.a("Capacity", (Object)value, "Must be more than count.");
        }
        this.a = value > 0 ? Arrays.copyOf(this.a, value) : new Object[4];
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    private void a(int n) {
        int n2;
        if (n <= this.a.length) {
            return;
        }
        int n3 = n2 = this.a.length == 0 ? 4 : this.a.length * 2;
        if (n2 < n) {
            n2 = n;
        }
        this.setCapacity(n2);
    }

    private void a(int n, int n2) {
        if (n2 > 0) {
            if (this.b + n2 > this.a.length) {
                int n3;
                int n4 = n3 = this.a.length > 0 ? this.a.length << 1 : 1;
                while (n3 < this.b + n2) {
                    n3 <<= 1;
                }
                Object[] objectArray = new Object[n3];
                Array.copy(this.a, 0, objectArray, 0, n);
                Array.copy(this.a, n, objectArray, n + n2, this.b - n);
                this.a = objectArray;
            } else {
                Array.copy(this.a, n, this.a, n + n2, this.b - n);
            }
        } else if (n2 < 0) {
            int n5 = n - n2;
            Array.copy(this.a, n5, this.a, n, this.b - n5);
            Array.clear(this.a, this.b + n2, -n2);
        }
    }

    @Override
    public int addItem(Object value) {
        if (this.a.length <= this.b) {
            this.a(this.b + 1);
        }
        this.a[this.b] = value;
        ++this.c;
        return this.b++;
    }

    @Override
    public void clear() {
        Array.clear(this.a, 0, this.b);
        this.b = 0;
        ++this.c;
    }

    @Override
    public boolean contains(Object item) {
        return this.indexOf(item, 0, this.b) > -1;
    }

    boolean a(Object object, int n, int n2) {
        return this.indexOf(object, n, n2) > -1;
    }

    @Override
    public int indexOf(Object value) {
        return this.indexOf(value, 0);
    }

    public int indexOf(Object value, int startIndex) {
        return this.indexOf(value, startIndex, this.b - startIndex);
    }

    public int indexOf(Object value, int startIndex, int count) {
        if (startIndex < 0 || startIndex > this.b) {
            ArrayList.a("startIndex", (Object)startIndex, "Does not specify valid index.");
        }
        if (count < 0) {
            ArrayList.a("count", (Object)count, "Can't be less than 0.");
        }
        if (startIndex > this.b - count) {
            throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
        }
        return Array.indexOf(this.a, value, startIndex, count);
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.lastIndexOf(value, this.b - 1);
    }

    public int lastIndexOf(Object value, int startIndex) {
        return this.lastIndexOf(value, startIndex, startIndex + 1);
    }

    public int lastIndexOf(Object value, int startIndex, int count) {
        return zbj.a(this.a, value, startIndex, count);
    }

    @Override
    public void insertItem(int index, Object value) {
        if (index < 0 || index > this.b) {
            ArrayList.a("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        this.a(index, 1);
        this.a[index] = value;
        ++this.b;
        ++this.c;
    }

    public void insertRange(int index, ICollection c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.b) {
            ArrayList.a("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.size()) > 0) {
            if (this.a.length < this.b + n) {
                this.a(this.b + n);
            }
            if (index < this.b) {
                Array.copy(this.a, index, this.a, index + n, this.b - index);
            }
            if (this == c.getSyncRoot()) {
                Array.copy(this.a, 0, this.a, index, index);
                Array.copy(this.a, index + n, this.a, index << 1, this.b - index);
            } else {
                c.copyTo(Array.boxing(this.a), index);
            }
            this.b += c.size();
            ++this.c;
        }
    }

    public void insertRange(int index, Object[] c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.b) {
            ArrayList.a("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.length) > 0) {
            if (this.a.length < this.b + n) {
                this.a(this.b + n);
            }
            if (index < this.b) {
                Array.copy(this.a, index, this.a, index + n, this.b - index);
            }
            Array.copy(c, 0, this.a, index, c.length);
            this.b += c.length;
            ++this.c;
        }
    }

    @Override
    public void removeItem(Object obj) {
        int n = this.indexOf(obj);
        if (n > -1) {
            this.removeAt(n);
        }
        ++this.c;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || index >= this.b) {
            ArrayList.a("index", (Object)index, "Less than 0 or more than list count.");
        }
        this.a(index, -1);
        --this.b;
        ++this.c;
    }

    public void removeRange(int index, int count) {
        ArrayList.a(index, count, this.b);
        this.a(index, -count);
        this.b -= count;
        ++this.c;
    }

    public void reverse() {
        zbj.a(this.a, 0, this.b);
        ++this.c;
    }

    public void reverse(int index, int count) {
        ArrayList.a(index, count, this.b);
        zbj.a(this.a, index, count);
        ++this.c;
    }

    public void copyTo(Array array) {
        Array.copy(Array.boxing(this.a), 0, array, 0, this.b);
    }

    @Override
    public void copyTo(Array array, int arrayIndex) {
        this.copyTo(0, array, arrayIndex, this.b);
    }

    public void copyTo(int index, Array array, int arrayIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() != 1) {
            throw new ArgumentException("Must have only 1 dimensions.", "array");
        }
        Array.copy(Array.boxing(this.a), index, array, arrayIndex, count);
    }

    @Override
    public IEnumerator iterator() {
        return new zm(this);
    }

    public IEnumerator iterator(int index, int count) {
        ArrayList.a(index, count, this.b);
        return new zb(this, index, count);
    }

    public void addRange(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.b, c);
    }

    public void addRange(Object[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.b, collection);
    }

    public int binarySearch(Object value) {
        if (value == null) {
            return -1;
        }
        try {
            return zbj.a(this.a, 0, this.b, value);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(Object value, Comparator comparer) {
        try {
            return zbj.a(this.a, 0, this.b, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(int index, int count, Object value, Comparator comparer) {
        try {
            return zbj.a(this.a, index, count, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public ArrayList getRange(int index, int count) {
        ArrayList.a(index, count, this.b);
        if (this.isSynchronized()) {
            return ArrayList.sync(new zj(this, index, count));
        }
        return new zj(this, index, count);
    }

    public void setRange(int index, ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index + c.size() > this.b) {
            throw new ArgumentOutOfRangeException("index");
        }
        c.copyTo(Array.boxing(this.a), index);
        ++this.c;
    }

    public void trimToSize() {
        this.setCapacity(this.b);
    }

    public void sort() {
        Arrays.sort(this.a, 0, this.b, com.aspose.email.internal.c.ze.a);
        ++this.c;
    }

    public void sort(Comparator comparer) {
        Arrays.sort(this.a, 0, this.b, comparer);
    }

    public void sort(int index, int count, Comparator comparer) {
        ArrayList.a(index, count, this.b);
        Arrays.sort(this.a, index, index + count, comparer);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.b];
        this.copyTo(Array.boxing(objectArray));
        return objectArray;
    }

    public Array toArray(zaz type) {
        Array array = Array.createInstance(type, this.b);
        this.copyTo(array);
        return array;
    }

    public Object deepClone() {
        return new ArrayList(Array.boxing(this.a), 0, this.b);
    }

    static void a(int n, int n2, int n3) {
        if (n < 0) {
            ArrayList.a("index", (Object)n, "Can't be less than 0.");
        }
        if (n2 < 0) {
            ArrayList.a("count", (Object)n2, "Can't be less than 0.");
        }
        if (n > n3 - n2) {
            throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
        }
    }

    static void a(String string, Object object, String string2) {
        throw new ArgumentOutOfRangeException(string, object, string2);
    }

    public static ArrayList adapter(IList list) {
        ArrayList arrayList;
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        ArrayList arrayList2 = arrayList = list instanceof ArrayList ? (ArrayList)list : null;
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new za(list);
        if (list.isSynchronized()) {
            return ArrayList.sync(arrayList);
        }
        return arrayList;
    }

    public static ArrayList sync(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new zn(list);
    }

    public static IList sync(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new zo(list);
    }

    public static ArrayList readOnly(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new zk(list);
    }

    public static IList readOnly(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new zl(list);
    }

    public static ArrayList fixedSize(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new ze(list);
    }

    public static IList fixedSize(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new zf(list);
    }

    public static ArrayList repeat(Object value, int count) {
        ArrayList arrayList = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            arrayList.addItem(value);
        }
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length <= this.size()) {
            a = new Object[this.size()];
        }
        this.copyTo(Array.boxing(a));
        return a;
    }

    @Override
    public boolean add(Object o) {
        int n = this.size();
        this.addItem(o);
        return this.size() != n;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.size();
        this.removeItem(o);
        return this.size() != n;
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        return this.addAll(this.b, c);
    }

    public boolean addAll(int index, Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = index;
        int n2 = this.size();
        for (Object e : c) {
            this.insertItem(n++, e);
        }
        return n2 != this.size();
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object e : c) {
            this.removeItem(e);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection c) {
        Object[] objectArray;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    public Object get(int index) {
        return this.get_Item(index);
    }

    public Object set(int index, Object element) {
        Object object = this.get_Item(index);
        this.set_Item(index, element);
        return object;
    }

    public void add(int index, Object element) {
        this.insertItem(index, element);
    }

    public Object remove(int index) {
        Object object = this.get_Item(index);
        this.removeAt(index);
        return object;
    }

    public ListIterator listIterator() {
        return new zh(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new zh(index);
    }

    public List subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        ArrayList arrayList = this.getRange(fromIndex, n);
        return arrayList;
    }

    public static ArrayList fromJava(List list) {
        if (list == null) {
            return null;
        }
        return new zc(list);
    }

    public static List toJava(ArrayList list) {
        return list;
    }

    /* synthetic */ ArrayList(int x0, boolean x1, com.aspose.email.system.collections.za x2) {
        this(x0, x1);
    }

    private static class zc
    extends ArrayList {
        private final List a;
        private int b;

        @Override
        protected int getVersion() {
            return this.a instanceof ArrayList ? ((ArrayList)this.a).getVersion() : this.b;
        }

        public zc(List list) {
            this.a = list;
            if (list instanceof ArrayList) {
                this.b = ((ArrayList)list).getVersion();
            }
        }

        @Override
        public Object get_Item(int index) {
            return this.a.get(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.a.set(index, value);
            ++this.b;
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public int getCapacity() {
            return Math.max(super.getCapacity(), this.a.size());
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.a.size()) {
                throw new ArgumentOutOfRangeException("Capacity", value, "Must be more than count.");
            }
            int n = value - this.a.size();
            for (int i = 0; i < n; ++i) {
                this.a.add(null);
            }
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public int addItem(Object value) {
            int n = this.a.size();
            this.a.add(value);
            ++this.b;
            return n;
        }

        @Override
        public void clear() {
            this.a.clear();
            ++this.b;
        }

        @Override
        public boolean contains(Object item) {
            return this.a.contains(item);
        }

        @Override
        public int indexOf(Object value) {
            return this.a.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.a.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.a.size()) {
                throw new ArgumentOutOfRangeException("startIndex", startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (startIndex > this.a.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            return Array.indexOf(this.a.toArray(), value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.a.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return zbj.a(this.a.toArray(), value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            if (index < 0 || index > this.a.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.a.add(index, value);
            ++this.b;
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.a.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.a.add(index++, e);
            }
            ++this.b;
        }

        @Override
        public void insertRange(int index, Object[] c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.a.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object object : c) {
                this.a.add(index++, object);
            }
            ++this.b;
        }

        @Override
        public void removeItem(Object obj) {
            this.a.remove(obj);
            ++this.b;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || index > this.a.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.a.remove(index);
            ++this.b;
        }

        @Override
        public void removeRange(int index, int count) {
            if (index < 0 || index > this.a.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.a.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                this.a.remove(index);
            }
            ++this.b;
        }

        @Override
        public void reverse() {
            this.reverse(0, this.a.size());
        }

        @Override
        public void reverse(int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.a.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            int n = index;
            for (int i = index + this.a.size() - 1; n < i; ++n, --i) {
                Object e = this.a.get(n);
                this.a.set(n, this.a.get(i));
                this.a.set(i, e);
            }
            ++this.b;
        }

        @Override
        public void copyTo(Array array) {
            Array.copy(Array.boxing(this.a.toArray()), 0, array, 0, this.a.size());
        }

        @Override
        public void copyTo(Array array, int arrayIndex) {
            this.copyTo(0, array, arrayIndex, this.a.size());
        }

        @Override
        public void copyTo(int index, Array array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.getRank() != 1) {
                throw new ArgumentException("Must have only 1 dimensions.", "array");
            }
            Array.copy(Array.boxing(this.a.toArray()), index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return new zm(this);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayList.a(index, count, this.a.size());
            return new zb(this, index, count);
        }

        @Override
        public void addRange(ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.size(), c);
        }

        @Override
        public void addRange(Object[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.a.size(), collection);
        }

        @Override
        public int binarySearch(Object value) {
            if (value == null) {
                return -1;
            }
            try {
                return zbj.a(this.a.toArray(), 0, this.a.size(), value);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            try {
                return zbj.a(this.a.toArray(), 0, this.a.size(), value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            try {
                return zbj.a(this.a.toArray(), index, count, value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayList.a(index, count, this.a.size());
            if (this.isSynchronized()) {
                return ArrayList.sync(new zj(this, index, count));
            }
            return new zj(this, index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.a.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            for (Object e : c) {
                this.a.set(index++, e);
            }
            ++this.b;
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            Collections.sort(this.a, null);
            ++this.b;
        }

        @Override
        public void sort(Comparator comparer) {
            Collections.sort(this.a, comparer);
            ++this.b;
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.a.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            List list = this.a.subList(index, count);
            if (comparer == null) {
                Collections.sort(list);
            } else {
                Collections.sort(list, comparer);
            }
            for (int i = index; i < count; ++i) {
                this.a.set(i, list.get(i - index));
            }
            ++this.b;
        }

        @Override
        public Object[] toArray() {
            return this.a.toArray();
        }

        @Override
        public Array toArray(zaz type) {
            Array array = Array.createInstance(type, this.a.size());
            this.copyTo(array);
            return array;
        }

        @Override
        public Object deepClone() {
            Object[] objectArray = new Object[this.a.size()];
            Array.copy(this.a.toArray(), 0, objectArray, 0, this.a.size());
            java.util.ArrayList arrayList = new java.util.ArrayList();
            Collections.addAll(arrayList, objectArray);
            return new zc(arrayList);
        }

        @Override
        public boolean isEmpty() {
            return this.a.size() == 0;
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.a.toArray(a);
        }

        @Override
        public boolean add(Object o) {
            ++this.b;
            return this.a.add(o);
        }

        @Override
        public boolean remove(Object o) {
            ++this.b;
            return this.a.remove(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.a.containsAll(c);
        }

        @Override
        public boolean addAll(Collection c) {
            ++this.b;
            return this.a.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection c) {
            ++this.b;
            return this.a.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection c) {
            ++this.b;
            return this.a.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection c) {
            ++this.b;
            return this.a.retainAll(c);
        }

        @Override
        public Object get(int index) {
            return this.a.get(index);
        }

        @Override
        public Object set(int index, Object element) {
            ++this.b;
            return this.a.set(index, element);
        }

        @Override
        public void add(int index, Object element) {
            this.a.add(index, element);
            ++this.b;
        }

        @Override
        public Object remove(int index) {
            ++this.b;
            return this.a.remove(index);
        }

        @Override
        public ListIterator listIterator() {
            return this.a.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.a.listIterator(index);
        }

        @Override
        public List subList(int fromIndex, int toIndex) {
            return this.a.subList(fromIndex, toIndex);
        }
    }

    private class zh
    extends zg
    implements ListIterator {
        zh(int n) {
            super(null);
            this.a = n;
        }

        @Override
        public boolean hasPrevious() {
            return this.a != 0;
        }

        @Override
        public int nextIndex() {
            return this.a;
        }

        @Override
        public int previousIndex() {
            return this.a - 1;
        }

        public Object previous() {
            int n = this.a - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.a;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.a = n;
            this.b = n;
            return objectArray[this.b];
        }

        public void set(Object e) {
            if (this.b < 0) {
                throw new IllegalStateException();
            }
            try {
                ((ArrayList)ArrayList.this).a[this.b] = e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object e) {
            try {
                int n = this.a;
                ArrayList.this.add(n, e);
                this.a = n + 1;
                this.b = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class zg
    implements Iterator {
        int a;
        int b = -1;

        private zg() {
        }

        @Override
        public boolean hasNext() {
            return this.a != ArrayList.this.size();
        }

        public Object next() {
            int n = this.a;
            if (n >= ArrayList.this.size()) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.a;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.a = n + 1;
            this.b = n;
            return objectArray[this.b];
        }

        @Override
        public void remove() {
            if (this.b < 0) {
                throw new IllegalStateException();
            }
            try {
                ArrayList.this.remove(this.b);
                this.a = this.b;
                this.b = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        /* synthetic */ zg(com.aspose.email.system.collections.za za2) {
            this();
        }
    }

    @zau
    private static class zi
    implements IList {
        protected IList a;

        public zi(IList iList) {
            this.a = iList;
        }

        @Override
        public Object get_Item(int index) {
            return this.a.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.a.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.a.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.a.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.a.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.a.isReadOnly();
        }

        @Override
        public int addItem(Object value) {
            return this.a.addItem(value);
        }

        @Override
        public void clear() {
            this.a.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.a.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.a.indexOf(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.a.insertItem(index, value);
        }

        @Override
        public void removeItem(Object value) {
            this.a.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.a.removeAt(index);
        }

        @Override
        public void copyTo(Array array, int index) {
            this.a.copyTo(array, index);
        }

        @Override
        public IEnumerator iterator() {
            return this.a.iterator();
        }
    }

    @zau
    private static final class zl
    extends zf {
        @Override
        protected String a() {
            return "List is read-only.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public zl(IList iList) {
            super(iList);
        }

        @Override
        public Object get_Item(int index) {
            return this.a.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.a());
        }
    }

    @zau
    private static class zf
    extends zi {
        protected String a() {
            return "List is fixed-size.";
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        public zf(IList iList) {
            super(iList);
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.a());
        }
    }

    @zau
    private static final class zo
    extends zi {
        private final Object b;

        public zo(IList iList) {
            super(iList);
            this.b = iList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.b;
            synchronized (object) {
                return this.a.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getSyncRoot() {
            Object object = this.b;
            synchronized (object) {
                return this.a.getSyncRoot();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.b;
            synchronized (object) {
                return this.a.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.b;
            synchronized (object) {
                return this.a.isReadOnly();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.b;
            synchronized (object) {
                return this.a.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.b;
            synchronized (object) {
                this.a.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.b;
            synchronized (object) {
                return this.a.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.b;
            synchronized (object) {
                this.a.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.b;
            synchronized (object) {
                return this.a.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.b;
            synchronized (object) {
                return this.a.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.b;
            synchronized (object) {
                this.a.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.b;
            synchronized (object) {
                this.a.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.b;
            synchronized (object) {
                this.a.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(Array array, int index) {
            Object object = this.b;
            synchronized (object) {
                this.a.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.b;
            synchronized (object) {
                return this.a.iterator();
            }
        }
    }

    @zau
    private static final class zj
    extends zd {
        private final int b;
        private int c;
        private int d;

        public zj(ArrayList arrayList, int n, int n2) {
            super(arrayList);
            this.b = n;
            this.c = n2;
            this.d = arrayList.getVersion();
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object get_Item(int index) {
            if (index < 0 || index > this.c) {
                throw new ArgumentOutOfRangeException("index");
            }
            return this.a.get_Item(this.b + index);
        }

        @Override
        public void set_Item(int index, Object value) {
            if (index < 0 || index > this.c) {
                throw new ArgumentOutOfRangeException("index");
            }
            this.a.set_Item(this.b + index, value);
        }

        @Override
        public int size() {
            this.a();
            return this.c;
        }

        @Override
        public int getCapacity() {
            return this.a.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.c) {
                throw new ArgumentOutOfRangeException();
            }
        }

        private void a() {
            if (this.d != this.a.getVersion()) {
                throw new IllegalStateException("ArrayList view is invalid because the underlying ArrayList was modified.");
            }
        }

        @Override
        public int addItem(Object value) {
            this.a();
            this.a.insertItem(this.b + this.c, value);
            this.d = this.a.getVersion();
            return ++this.c;
        }

        @Override
        public void clear() {
            this.a();
            this.a.removeRange(this.b, this.c);
            this.c = 0;
            this.d = this.a.getVersion();
        }

        @Override
        public boolean contains(Object value) {
            return this.a.a(value, this.b, this.c);
        }

        @Override
        public int indexOf(Object value) {
            return this.indexOf(value, 0);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.c - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.c) {
                zj.a("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                zj.a("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.c - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            int n = this.a.indexOf(value, this.b + startIndex, count);
            if (n == -1) {
                return -1;
            }
            return n - this.b;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.c - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            int n;
            if (startIndex < 0) {
                zj.a("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                zj.a("count", (Object)count, "count is negative.");
            }
            if ((n = this.a.lastIndexOf(value, this.b + startIndex, count)) == -1) {
                return -1;
            }
            return n - this.b;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.a();
            if (index < 0 || index > this.c) {
                zj.a("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.a.insertItem(this.b + index, value);
            ++this.c;
            this.d = this.a.getVersion();
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.a();
            if (index < 0 || index > this.c) {
                zj.a("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.a.insertRange(this.b + index, c);
            this.c += c.size();
            this.d = this.a.getVersion();
        }

        @Override
        public void removeItem(Object value) {
            this.a();
            int n = this.indexOf(value);
            if (n > -1) {
                this.removeAt(n);
            }
            this.d = this.a.getVersion();
        }

        @Override
        public void removeAt(int index) {
            this.a();
            if (index < 0 || index > this.c) {
                zj.a("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.a.removeAt(this.b + index);
            --this.c;
            this.d = this.a.getVersion();
        }

        @Override
        public void removeRange(int index, int count) {
            this.a();
            zj.a(index, count, this.c);
            this.a.removeRange(this.b + index, count);
            this.c -= count;
            this.d = this.a.getVersion();
        }

        @Override
        public void reverse() {
            this.reverse(0, this.c);
        }

        @Override
        public void reverse(int index, int count) {
            this.a();
            zj.a(index, count, this.c);
            this.a.reverse(this.b + index, count);
            this.d = this.a.getVersion();
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.a();
            if (index < 0 || index > this.c) {
                zj.a("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.a.setRange(this.b + index, c);
            this.d = this.a.getVersion();
        }

        @Override
        public void copyTo(Array array) {
            this.copyTo(array, 0);
        }

        @Override
        public void copyTo(Array array, int index) {
            this.copyTo(0, array, index, this.c);
        }

        @Override
        public void copyTo(int index, Array array, int arrayIndex, int count) {
            zj.a(index, count, this.c);
            this.a.copyTo(this.b + index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.iterator(0, this.c);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            zj.a(index, count, this.c);
            return this.a.iterator(this.b + index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.a();
            this.a.insertRange(this.c, c);
            this.c += c.size();
            this.d = this.a.getVersion();
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(0, this.c, value, com.aspose.email.internal.c.ze.a);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.c, value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            zj.a(index, count, this.c);
            return this.a.binarySearch(this.b + index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return new zj((ArrayList)this.a.deepClone(), this.b, this.c);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            zj.a(index, count, this.c);
            return new zj(this, index, count);
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException();
        }

        @Override
        public void sort() {
            this.sort((Comparator)com.aspose.email.internal.c.ze.a);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.c, comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.a();
            zj.a(index, count, this.c);
            this.a.sort(this.b + index, count, comparer);
            this.d = this.a.getVersion();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.c];
            this.a.copyTo(this.b, Array.boxing(objectArray), 0, this.c);
            return objectArray;
        }

        @Override
        public Array toArray(zaz elementType) {
            Array array = Array.createInstance(elementType, this.c);
            this.a.copyTo(this.b, array, 0, this.c);
            return array;
        }
    }

    @zau
    private static final class zk
    extends ze {
        @Override
        protected String a() {
            return "Can't modify a readonly list.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public zk(ArrayList arrayList) {
            super(arrayList);
        }

        @Override
        public Object get_Item(int index) {
            return this.a.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void reverse() {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void reverse(int index, int count) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void setRange(int index, ICollection c) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void sort() {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void sort(Comparator comparer) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            throw new NotSupportedException(this.a());
        }
    }

    @zau
    private static class ze
    extends zd {
        public ze(ArrayList arrayList) {
            super(arrayList);
        }

        protected String a() {
            return "Can't add or remove from a fixed-size list.";
        }

        @Override
        public int getCapacity() {
            return super.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void addRange(ICollection c) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void insertRange(int index, ICollection c) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void insertRange(int index, Object[] c) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void removeRange(int index, int count) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException(this.a());
        }
    }

    @zau
    private static final class zn
    extends zd {
        private final Object b;

        zn(ArrayList arrayList) {
            super(arrayList);
            this.b = arrayList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.b;
            synchronized (object) {
                return this.a.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.b;
            synchronized (object) {
                this.a.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.b;
            synchronized (object) {
                return this.a.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.b;
            synchronized (object) {
                return this.a.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.b;
            synchronized (object) {
                this.a.setCapacity(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.b;
            synchronized (object) {
                return this.a.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.b;
            synchronized (object) {
                return this.a.isReadOnly();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.b;
            synchronized (object) {
                return this.a.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.b;
            synchronized (object) {
                this.a.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.b;
            synchronized (object) {
                return this.a.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.b;
            synchronized (object) {
                return this.a.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex) {
            Object object = this.b;
            synchronized (object) {
                return this.a.indexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex, int count) {
            Object object = this.b;
            synchronized (object) {
                return this.a.indexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value) {
            Object object = this.b;
            synchronized (object) {
                return this.a.lastIndexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex) {
            Object object = this.b;
            synchronized (object) {
                return this.a.lastIndexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            Object object = this.b;
            synchronized (object) {
                return this.a.lastIndexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.b;
            synchronized (object) {
                this.a.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertRange(int index, ICollection c) {
            Object object = this.b;
            synchronized (object) {
                this.a.insertRange(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.b;
            synchronized (object) {
                this.a.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.b;
            synchronized (object) {
                this.a.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeRange(int index, int count) {
            Object object = this.b;
            synchronized (object) {
                this.a.removeRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse() {
            Object object = this.b;
            synchronized (object) {
                this.a.reverse();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse(int index, int count) {
            Object object = this.b;
            synchronized (object) {
                this.a.reverse(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(Array array) {
            Object object = this.b;
            synchronized (object) {
                this.a.copyTo(array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(Array array, int index) {
            Object object = this.b;
            synchronized (object) {
                this.a.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(int index, Array array, int arrayIndex, int count) {
            Object object = this.b;
            synchronized (object) {
                this.a.copyTo(index, array, arrayIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.b;
            synchronized (object) {
                return this.a.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator(int index, int count) {
            Object object = this.b;
            synchronized (object) {
                return this.a.iterator(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addRange(ICollection c) {
            Object object = this.b;
            synchronized (object) {
                this.a.addRange(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value) {
            Object object = this.b;
            synchronized (object) {
                return this.a.binarySearch(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value, Comparator comparer) {
            Object object = this.b;
            synchronized (object) {
                return this.a.binarySearch(value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            Object object = this.b;
            synchronized (object) {
                return this.a.binarySearch(index, count, value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.b;
            synchronized (object) {
                return this.a.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList getRange(int index, int count) {
            Object object = this.b;
            synchronized (object) {
                return this.a.getRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.b;
            synchronized (object) {
                this.a.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort() {
            Object object = this.b;
            synchronized (object) {
                this.a.sort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator comparer) {
            Object object = this.b;
            synchronized (object) {
                this.a.sort(comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(int index, int count, Comparator comparer) {
            Object object = this.b;
            synchronized (object) {
                this.a.sort(index, count, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.b;
            synchronized (object) {
                return this.a.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Array toArray(zaz elementType) {
            Object object = this.b;
            synchronized (object) {
                return this.a.toArray(elementType);
            }
        }
    }

    @zau
    private static class zd
    extends ArrayList {
        protected ArrayList a;

        public zd(ArrayList arrayList) {
            this.a = arrayList;
        }

        @Override
        public Object get_Item(int index) {
            return this.a.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.a.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public int getCapacity() {
            return this.a.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            this.a.setCapacity(value);
        }

        @Override
        public boolean isFixedSize() {
            return this.a.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.a.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return this.a.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.a.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.a.addItem(value);
        }

        @Override
        public void clear() {
            this.a.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.a.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.a.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.a.indexOf(value, startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            return this.a.indexOf(value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.a.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.a.lastIndexOf(value, startIndex);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return this.a.lastIndexOf(value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.a.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.a.insertRange(index, c);
        }

        @Override
        public void removeItem(Object value) {
            this.a.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.a.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            this.a.removeRange(index, count);
        }

        @Override
        public void reverse() {
            this.a.reverse();
        }

        @Override
        public void reverse(int index, int count) {
            this.a.reverse(index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.a.setRange(index, c);
        }

        @Override
        public void copyTo(Array array) {
            this.a.copyTo(array);
        }

        @Override
        public void copyTo(Array array, int index) {
            this.a.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, Array array, int arrayIndex, int count) {
            this.a.copyTo(index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.a.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            return this.a.iterator(index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.a.addRange(c);
        }

        @Override
        public int binarySearch(Object value) {
            return this.a.binarySearch(value);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.a.binarySearch(value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            return this.a.binarySearch(index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return this.a.deepClone();
        }

        @Override
        public ArrayList getRange(int index, int count) {
            return this.a.getRange(index, count);
        }

        @Override
        public void trimToSize() {
            this.a.trimToSize();
        }

        @Override
        public void sort() {
            this.a.sort();
        }

        @Override
        public void sort(Comparator comparer) {
            this.a.sort(comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.a.sort(index, count, comparer);
        }

        @Override
        public Object[] toArray() {
            return this.a.toArray();
        }

        @Override
        public Array toArray(zaz elementType) {
            return this.a.toArray(elementType);
        }
    }

    @zau
    private static final class com.aspose.email.system.collections.ArrayList$za
    extends ArrayList {
        private IList a;

        public com.aspose.email.system.collections.ArrayList$za(IList iList) {
            super(0, true, null);
            this.a = iList;
        }

        @Override
        public Object get_Item(int index) {
            return this.a.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.a.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public int getCapacity() {
            return this.a.size();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.a.size()) {
                throw new ArgumentException("capacity");
            }
        }

        @Override
        public boolean isFixedSize() {
            return this.a.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.a.isReadOnly();
        }

        @Override
        public Object getSyncRoot() {
            return this.a.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.a.addItem(value);
        }

        @Override
        public void clear() {
            this.a.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.a.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.a.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.a.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.a.size()) {
                com.aspose.email.system.collections.ArrayList$za.a("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                com.aspose.email.system.collections.ArrayList$za.a("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.a.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            if (value == null) {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (this.a.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (!value.equals(this.a.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.a.size() - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            if (startIndex < 0) {
                com.aspose.email.system.collections.ArrayList$za.a("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                com.aspose.email.system.collections.ArrayList$za.a("count", (Object)count, "count is negative.");
            }
            if (startIndex - count + 1 < 0) {
                com.aspose.email.system.collections.ArrayList$za.a("count", (Object)count, "count is too large.");
            }
            if (value == null) {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (this.a.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (!value.equals(this.a.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.a.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index > this.a.size()) {
                com.aspose.email.system.collections.ArrayList$za.a("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.a.insertItem(index++, e);
            }
        }

        @Override
        public void removeItem(Object value) {
            this.a.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.a.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            com.aspose.email.system.collections.ArrayList$za.a(index, count, this.a.size());
            for (int i = 0; i < count; ++i) {
                this.a.removeAt(index);
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.a.size());
        }

        @Override
        public void reverse(int index, int count) {
            com.aspose.email.system.collections.ArrayList$za.a(index, count, this.a.size());
            for (int i = 0; i < count / 2; ++i) {
                Object object = this.a.get_Item(i + index);
                this.a.set_Item(i + index, this.a.get_Item(index + count - i + index - 1));
                this.a.set_Item(index + count - i + index - 1, object);
            }
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.a.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            int n = index;
            for (Object e : c) {
                this.a.set_Item(n++, e);
            }
        }

        @Override
        public void copyTo(Array array) {
            this.a.copyTo(array, 0);
        }

        @Override
        public void copyTo(Array array, int index) {
            this.a.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, Array array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (index < 0) {
                com.aspose.email.system.collections.ArrayList$za.a("index", (Object)index, "Can't be less than zero.");
            }
            if (arrayIndex < 0) {
                com.aspose.email.system.collections.ArrayList$za.a("arrayIndex", (Object)arrayIndex, "Can't be less than zero.");
            }
            if (count < 0) {
                com.aspose.email.system.collections.ArrayList$za.a("index", (Object)index, "Can't be less than zero.");
            }
            if (array.getRank() > 1) {
                throw new ArgumentException("Can't copy into multi-dimensional array.");
            }
            if (array.getLength() - arrayIndex < count) {
                throw new ArgumentException("Destination array is too small.");
            }
            if (index > this.a.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                array.setValue(this.a.get_Item(index + i), arrayIndex + i);
            }
        }

        @Override
        public boolean isSynchronized() {
            return this.a.isSynchronized();
        }

        @Override
        public IEnumerator iterator() {
            return this.a.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            com.aspose.email.system.collections.ArrayList$za.a(index, count, this.a.size());
            return new za(this.a.iterator(), index, count);
        }

        @Override
        public void addRange(ICollection c) {
            for (Object e : c) {
                this.a.addItem(e);
            }
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(value, null);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.a.size(), value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            com.aspose.email.system.collections.ArrayList$za.a(index, count, this.a.size());
            if (comparer == null) {
                comparer = com.aspose.email.internal.c.ze.a;
            }
            int n = index;
            int n2 = index + count - 1;
            while (n <= n2) {
                int n3;
                int n4 = n + (n2 - n) / 2;
                try {
                    n3 = comparer.compare(value, this.a.get_Item(n4));
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("value is not of the same type", exception);
                }
                if (n3 < 0) {
                    n2 = n4 - 1;
                    continue;
                }
                if (n3 > 0) {
                    n = n4 + 1;
                    continue;
                }
                return n4;
            }
            return ~n;
        }

        @Override
        public Object deepClone() {
            return new com.aspose.email.system.collections.ArrayList$za(this.a);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            com.aspose.email.system.collections.ArrayList$za.a(index, count, this.a.size());
            return new zj(this, index, count);
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            this.sort((Comparator)com.aspose.email.internal.c.ze.a);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.a.size(), comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            com.aspose.email.system.collections.ArrayList$za.a(index, count, this.a.size());
            if (comparer == null) {
                comparer = com.aspose.email.internal.c.ze.a;
            }
            com.aspose.email.system.collections.ArrayList$za.a(this.a, index, index + count - 1, comparer);
        }

        private static void a(IList iList, int n, int n2) {
            Object object = iList.get_Item(n);
            iList.set_Item(n, iList.get_Item(n2));
            iList.set_Item(n2, object);
        }

        static void a(IList iList, int n, int n2, Comparator comparator) {
            if (n >= n2) {
                return;
            }
            int n3 = n + (n2 - n) / 2;
            if (comparator.compare(iList.get_Item(n3), iList.get_Item(n)) < 0) {
                com.aspose.email.system.collections.ArrayList$za.a(iList, n3, n);
            }
            if (comparator.compare(iList.get_Item(n2), iList.get_Item(n)) < 0) {
                com.aspose.email.system.collections.ArrayList$za.a(iList, n2, n);
            }
            if (comparator.compare(iList.get_Item(n2), iList.get_Item(n3)) < 0) {
                com.aspose.email.system.collections.ArrayList$za.a(iList, n2, n3);
            }
            if (n2 - n + 1 <= 3) {
                return;
            }
            com.aspose.email.system.collections.ArrayList$za.a(iList, n2 - 1, n3);
            Object object = iList.get_Item(n2 - 1);
            int n4 = n;
            int n5 = n2 - 1;
            while (true) {
                if (comparator.compare(iList.get_Item(++n4), object) < 0) {
                    continue;
                }
                while (comparator.compare(iList.get_Item(--n5), object) > 0) {
                }
                if (n4 >= n5) break;
                com.aspose.email.system.collections.ArrayList$za.a(iList, n4, n5);
            }
            com.aspose.email.system.collections.ArrayList$za.a(iList, n2 - 1, n4);
            com.aspose.email.system.collections.ArrayList$za.a(iList, n, n4 - 1, comparator);
            com.aspose.email.system.collections.ArrayList$za.a(iList, n4 + 1, n2, comparator);
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.a.size()];
            this.a.copyTo(Array.boxing(objectArray), 0);
            return objectArray;
        }

        @Override
        public Array toArray(zaz elementType) {
            Array array = Array.createInstance(elementType, this.a.size());
            this.a.copyTo(array, 0);
            return array;
        }

        private static final class za
        implements zz,
        IEnumerator,
        Cloneable {
            private int a;
            private int b;
            private int c;
            private IEnumerator d;

            private za() {
            }

            public za(IEnumerator iEnumerator, int n, int n2) {
                this.b = 0;
                this.a = n;
                this.c = n2;
                this.d = iEnumerator;
                this.reset();
            }

            @Override
            public Object deepClone() {
                return this.a();
            }

            @Override
            public Object next() {
                return this.d.next();
            }

            @Override
            public boolean hasNext() {
                if (this.b >= this.c) {
                    return false;
                }
                ++this.b;
                return this.d.hasNext();
            }

            @Override
            public void reset() {
                this.b = 0;
                this.d.reset();
                for (int i = 0; i < this.a; ++i) {
                    this.d.hasNext();
                }
            }

            protected Object a() {
                try {
                    return this.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new IllegalStateException(cloneNotSupportedException);
                }
            }

            protected Object clone() throws CloneNotSupportedException {
                za za2 = new za();
                za2.a = this.a;
                za2.b = this.b;
                za2.c = this.c;
                za2.d = this.d;
                return za2;
            }

            @Override
            public void remove() {
                throw new NotSupportedException();
            }
        }
    }

    static final class zm
    implements zz,
    IEnumerator,
    Cloneable {
        private ArrayList b;
        private Object c;
        private int d;
        private int e;
        static Object a = new Object();

        private zm() {
        }

        public zm(ArrayList arrayList) {
            this.b = arrayList;
            this.d = -1;
            this.e = arrayList.getVersion();
            this.c = a;
        }

        @Override
        public Object deepClone() {
            return this.a();
        }

        @Override
        public boolean hasNext() {
            if (this.e != this.b.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            if (++this.d < this.b.size()) {
                this.c = this.b.get_Item(this.d);
                return true;
            }
            this.c = a;
            return false;
        }

        @Override
        public Object next() {
            if (this.c == a) {
                if (this.d == -1) {
                    throw new IllegalStateException("Enumerator not started");
                }
                throw new IllegalStateException("Enumerator ended");
            }
            return this.c;
        }

        @Override
        public void reset() {
            if (this.e != this.b.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            this.c = a;
            this.d = -1;
        }

        protected Object a() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            zm zm2 = new zm();
            zm2.b = this.b;
            zm2.c = this.c;
            zm2.d = this.d;
            zm2.e = this.e;
            return zm2;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class zb
    implements zz,
    IEnumerator,
    Cloneable {
        private Object a;
        private ArrayList b;
        private int c;
        private int d;
        private int e;
        private int f;

        private zb() {
        }

        @Override
        public Object deepClone() {
            return this.a();
        }

        public zb(ArrayList arrayList, int n, int n2) {
            this.b = arrayList;
            this.d = n;
            this.e = n2;
            this.c = this.d - 1;
            this.a = null;
            this.f = arrayList.getVersion();
        }

        @Override
        public Object next() {
            if (this.c == this.d - 1) {
                throw new IllegalStateException("Enumerator unusable (Reset pending, or past end of array.");
            }
            return this.a;
        }

        @Override
        public boolean hasNext() {
            if (this.b.getVersion() != this.f) {
                throw new IllegalStateException("List has changed.");
            }
            ++this.c;
            if (this.c - this.d < this.e) {
                this.a = this.b.get_Item(this.c);
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.a = null;
            this.c = this.d - 1;
        }

        protected Object a() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            zb zb2 = new zb();
            zb2.a = this.a;
            zb2.b = this.b;
            zb2.c = this.c;
            zb2.d = this.d;
            zb2.e = this.e;
            zb2.f = this.f;
            return zb2;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }
}

