/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.font.internal.l397;

import com.aspose.font.internal.l38I.I31;
import com.aspose.font.internal.l38I.I4l;
import com.aspose.font.internal.l397.I114;
import com.aspose.font.internal.l397.I151;
import com.aspose.font.internal.l397.I4I;
import com.aspose.font.internal.l397.I5I;
import com.aspose.font.internal.l397.I67;
import com.aspose.font.internal.l397.II;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class I15l
extends CertPathBuilderSpi {
    private final I114 lif;
    private final boolean ll;
    private Exception lI;

    public I15l(I4I i4I) {
        this(i4I, false);
    }

    I15l(I4I i4I, boolean bl) {
        this(new I114(i4I), bl);
    }

    I15l(I114 i114, boolean bl) {
        this.lif = i114;
        this.ll = bl;
    }

    @Override
    public CertPathBuilderResult engineBuild(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        I4l i4l = null;
        if (certPathParameters instanceof I4l) {
            i4l = (I4l)certPathParameters;
        } else if (certPathParameters instanceof PKIXBuilderParameters) {
            i4l = new I4l.I7((PKIXBuilderParameters)certPathParameters).lif();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + I4l.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        Collection collection = I5I.lif(i4l);
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.lif(x509Certificate, i4l, arrayList);
        }
        if (certPathBuilderResult == null && this.lI != null) {
            if (this.lI instanceof II) {
                throw new CertPathBuilderException(this.lI.getMessage(), this.lI.getCause());
            }
            throw new CertPathBuilderException("Possible certificate chain could not be validated.", this.lI);
        }
        if (certPathBuilderResult == null && this.lI == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    protected CertPathBuilderResult lif(X509Certificate x509Certificate, I4l i4l, List list) {
        I151 i151;
        I67 i67;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (i4l.ll().contains(x509Certificate)) {
            return null;
        }
        if (i4l.lI() != -1 && list.size() - 1 > i4l.lI()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            i67 = new I67(this.lif);
            i151 = new I151(this.lif, this.ll);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception creating support classes.");
        }
        try {
            if (I5I.ll(x509Certificate, i4l.lif().lf(), i4l.lif().l0l())) {
                CertPath certPath = null;
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult = null;
                try {
                    certPath = i67.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new II("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)i151.engineValidate(certPath, i4l);
                }
                catch (Exception exception) {
                    throw new II("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<I31> arrayList = new ArrayList<I31>();
            arrayList.addAll(i4l.lif().lif());
            try {
                arrayList.addAll(I5I.lif(x509Certificate.getExtensionValue(com.aspose.font.internal.l32I.I4l.llf.lI()), i4l.lif().ll()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new II("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(I5I.lif(x509Certificate, i4l.lif().l0iF(), arrayList));
            }
            catch (II iI) {
                throw new II("Cannot find issuer certificate for certificate in certification path.", iI);
            }
            if (hashSet.isEmpty()) {
                throw new II("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.lif(x509Certificate2, i4l, list);
            }
        }
        catch (II iI) {
            this.lI = iI;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

