/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.font.internal.l397;

import com.aspose.font.internal.l264.I14;
import com.aspose.font.internal.l264.I21;
import com.aspose.font.internal.l264.I24;
import com.aspose.font.internal.l264.I27;
import com.aspose.font.internal.l264.I31;
import com.aspose.font.internal.l327.I1;
import com.aspose.font.internal.l32I.I101;
import com.aspose.font.internal.l32I.I11;
import com.aspose.font.internal.l32I.I1I;
import com.aspose.font.internal.l32I.I2I;
import com.aspose.font.internal.l32I.I2l;
import com.aspose.font.internal.l32I.I4I;
import com.aspose.font.internal.l32I.I4l;
import com.aspose.font.internal.l32I.I57;
import com.aspose.font.internal.l32I.I6l;
import com.aspose.font.internal.l384.I07;
import com.aspose.font.internal.l397.I1837;
import com.aspose.font.internal.l397.I1841;
import com.aspose.font.internal.l39I.I4;
import com.aspose.font.internal.l411.I04;
import com.aspose.font.internal.l41I.I34;
import com.aspose.font.internal.l41I.I7;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

abstract class I183l
extends X509CRL {
    protected I4 lif;
    protected I2I ll;
    protected String lI;
    protected byte[] l1;
    protected boolean lIF;

    I183l(I4 i4, I2I i2I, String string, byte[] byArray, boolean bl) {
        this.lif = i4;
        this.ll = i2I;
        this.lI = string;
        this.l1 = byArray;
        this.lIF = bl;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        if (set == null) {
            return false;
        }
        set.remove(I4l.l01.lI());
        set.remove(I4l.l0I.lI());
        return !set.isEmpty();
    }

    private Set lif(boolean bl) {
        I4I i4I;
        if (this.getVersion() == 2 && (i4I = this.ll.lif().lf()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = i4I.lif();
            while (enumeration.hasMoreElements()) {
                I21 i21 = (I21)enumeration.nextElement();
                I4l i4l = i4I.lif(i21);
                if (bl != i4l.ll()) continue;
                hashSet.add(i21.lI());
            }
            return hashSet;
        }
        return null;
    }

    public Set getCriticalExtensionOIDs() {
        return this.lif(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.lif(false);
    }

    @Override
    public byte[] getExtensionValue(String string) {
        I24 i24 = I183l.ll(this.ll, string);
        if (null != i24) {
            try {
                return i24.l0I();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    @Override
    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        try {
            signature = this.lif.l0I(this.getSigAlgName());
        }
        catch (Exception exception) {
            signature = Signature.getInstance(this.getSigAlgName());
        }
        this.lif(publicKey, signature);
    }

    @Override
    public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = string != null ? Signature.getInstance(this.getSigAlgName(), string) : Signature.getInstance(this.getSigAlgName());
        this.lif(publicKey, signature);
    }

    @Override
    public void verify(PublicKey publicKey, Provider provider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = provider != null ? Signature.getInstance(this.getSigAlgName(), provider) : Signature.getInstance(this.getSigAlgName());
        this.lif(publicKey, signature);
    }

    private void lif(PublicKey publicKey, Signature signature) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!this.ll.l1().equals(this.ll.lif().lI())) {
            throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
        }
        if (this.l1 != null) {
            try {
                I1841.lif(signature, I31.lI(this.l1));
            }
            catch (IOException iOException) {
                throw new SignatureException("cannot decode signature parameters: " + iOException.getMessage());
            }
        }
        signature.initVerify(publicKey);
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(I07.lif(signature), 512);
            this.ll.lif().lif(bufferedOutputStream, "DER");
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
    }

    @Override
    public int getVersion() {
        return this.ll.llf();
    }

    @Override
    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        try {
            return new X500Principal(this.ll.liF().l0I());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public Date getThisUpdate() {
        return this.ll.lIf().ll();
    }

    @Override
    public Date getNextUpdate() {
        if (this.ll.lf() != null) {
            return this.ll.lf().ll();
        }
        return null;
    }

    private Set lif() {
        HashSet<I1837> hashSet = new HashSet<I1837>();
        Enumeration enumeration = this.ll.lI();
        I1 i1 = null;
        while (enumeration.hasMoreElements()) {
            I4l i4l;
            I101.I7 i7 = (I101.I7)enumeration.nextElement();
            I1837 i1837 = new I1837(i7, this.lIF, i1);
            hashSet.add(i1837);
            if (!this.lIF || !i7.l1() || (i4l = i7.lI().lif(I4l.l0IF)) == null) continue;
            i1 = I1.lif(I57.lif(i4l.l1()).lif()[0].ll());
        }
        return hashSet;
    }

    @Override
    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        Enumeration enumeration = this.ll.lI();
        I1 i1 = null;
        while (enumeration.hasMoreElements()) {
            I4l i4l;
            I101.I7 i7 = (I101.I7)enumeration.nextElement();
            if (i7.lif().lif(bigInteger)) {
                return new I1837(i7, this.lIF, i1);
            }
            if (!this.lIF || !i7.l1() || (i4l = i7.lI().lif(I4l.l0IF)) == null) continue;
            i1 = I1.lif(I57.lif(i4l.l1()).lif()[0].ll());
        }
        return null;
    }

    public Set getRevokedCertificates() {
        Set set = this.lif();
        if (!set.isEmpty()) {
            return Collections.unmodifiableSet(set);
        }
        return null;
    }

    @Override
    public byte[] getTBSCertList() throws CRLException {
        try {
            return this.ll.lif().lif("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    @Override
    public byte[] getSignature() {
        return this.ll.lIF().lIF();
    }

    @Override
    public String getSigAlgName() {
        return this.lI;
    }

    @Override
    public String getSigAlgOID() {
        return this.ll.l1().lif().lI();
    }

    @Override
    public byte[] getSigAlgParams() {
        return I7.ll(this.l1);
    }

    @Override
    public String toString() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = I34.ll();
        stringBuffer.append("              Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("          This update: ").append(this.getThisUpdate()).append(string);
        stringBuffer.append("          Next update: ").append(this.getNextUpdate()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(new String(I04.ll(byArray, 0, 20))).append(string);
        for (int i = 20; i < byArray.length; i += 20) {
            if (i < byArray.length - 20) {
                stringBuffer.append("                       ").append(new String(I04.ll(byArray, i, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(new String(I04.ll(byArray, i, byArray.length - i))).append(string);
        }
        I4I i4I = this.ll.lif().lf();
        if (i4I != null) {
            object2 = i4I.lif();
            if (object2.hasMoreElements()) {
                stringBuffer.append("           Extensions: ").append(string);
            }
            while (object2.hasMoreElements()) {
                object = (I21)object2.nextElement();
                I4l i4l = i4I.lif((I21)object);
                if (i4l.lI() != null) {
                    byte[] byArray2 = i4l.lI().lIF();
                    I14 i14 = new I14(byArray2);
                    stringBuffer.append("                       critical(").append(i4l.ll()).append(") ");
                    try {
                        if (((I31)object).ll(I4l.lIf)) {
                            stringBuffer.append(new I11(I27.lif(i14.lI()).lI())).append(string);
                            continue;
                        }
                        if (((I31)object).ll(I4l.l0I)) {
                            stringBuffer.append("Base CRL: " + new I11(I27.lif(i14.lI()).lI())).append(string);
                            continue;
                        }
                        if (((I31)object).ll(I4l.l01)) {
                            stringBuffer.append(I6l.lif(i14.lI())).append(string);
                            continue;
                        }
                        if (((I31)object).ll(I4l.l0iF)) {
                            stringBuffer.append(I1I.lif(i14.lI())).append(string);
                            continue;
                        }
                        if (((I31)object).ll(I4l.l11)) {
                            stringBuffer.append(I1I.lif(i14.lI())).append(string);
                            continue;
                        }
                        stringBuffer.append(((I21)object).lI());
                        stringBuffer.append(" value = ").append(com.aspose.font.internal.l314.I7.lif(i14.lI())).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(((I21)object).lI());
                        stringBuffer.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        if ((object2 = this.getRevokedCertificates()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                stringBuffer.append(object.next());
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isRevoked(Certificate certificate) {
        if (!certificate.getType().equals("X.509")) {
            throw new IllegalArgumentException("X.509 CRL used with non X.509 Cert");
        }
        Enumeration enumeration = this.ll.lI();
        I1 i1 = this.ll.liF();
        if (enumeration.hasMoreElements()) {
            BigInteger bigInteger = ((X509Certificate)certificate).getSerialNumber();
            while (enumeration.hasMoreElements()) {
                com.aspose.font.internal.l264.I2I i2I;
                I101.I7 i7 = I101.I7.lif(enumeration.nextElement());
                if (this.lIF && i7.l1() && (i2I = i7.lI().lif(I4l.l0IF)) != null) {
                    i1 = I1.lif(I57.lif(i2I.l1()).lif()[0].ll());
                }
                if (!i7.lif().lif(bigInteger)) continue;
                if (certificate instanceof X509Certificate) {
                    i2I = I1.lif(((X509Certificate)certificate).getIssuerX500Principal().getEncoded());
                } else {
                    try {
                        i2I = I2l.lif(certificate.getEncoded()).lIF();
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        throw new IllegalArgumentException("Cannot process certificate: " + certificateEncodingException.getMessage());
                    }
                }
                return i1.equals(i2I);
            }
        }
        return false;
    }

    protected static byte[] lif(I2I i2I, String string) {
        I24 i24 = I183l.ll(i2I, string);
        if (null != i24) {
            return i24.lIF();
        }
        return null;
    }

    protected static I24 ll(I2I i2I, String string) {
        I4l i4l;
        I4I i4I = i2I.lif().lf();
        if (null != i4I && null != (i4l = i4I.lif(new I21(string)))) {
            return i4l.lI();
        }
        return null;
    }
}

