/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html;

import com.aspose.html.Configuration;
import com.aspose.html.HTMLElement;
import com.aspose.html.IDisposable;
import com.aspose.html.Url;
import com.aspose.html.collections.HTMLCollection;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.IDocumentInit;
import com.aspose.html.dom.css.ICSSStyleDeclaration;
import com.aspose.html.dom.css.IDocumentCSS;
import com.aspose.html.dom.css.IViewCSS;
import com.aspose.html.dom.events.Event;
import com.aspose.html.io.IOutputStorage;
import com.aspose.html.net.RequestMessage;
import com.aspose.html.rendering.IDevice;
import com.aspose.html.saving.HTMLSaveOptions;
import com.aspose.html.saving.MHTMLSaveOptions;
import com.aspose.html.saving.MarkdownSaveOptions;
import com.aspose.html.saving.TextSaveOptions;
import com.aspose.html.serialization.manager.resources.Resource;
import com.aspose.html.serialization.manager.resources.handlers.MHTMLHandlerFactory;
import com.aspose.html.serialization.manager.resources.handlers.SingleDocumentHandlerFactory;
import com.aspose.html.utils.AN;
import com.aspose.html.utils.Bd;
import com.aspose.html.utils.CY;
import com.aspose.html.utils.KeyValuePair;
import com.aspose.html.utils.MN;
import com.aspose.html.utils.Stream;
import com.aspose.html.utils.UY;
import com.aspose.html.utils.UZ;
import com.aspose.html.utils.YI;
import com.aspose.html.utils.aaX;
import com.aspose.html.utils.afr;
import com.aspose.html.utils.apW;
import com.aspose.html.utils.arD;
import com.aspose.html.utils.arE;
import com.aspose.html.utils.arH;
import com.aspose.html.utils.arP;
import com.aspose.html.utils.arj;
import com.aspose.html.utils.ark;
import com.aspose.html.utils.atG;
import com.aspose.html.utils.bCM;
import com.aspose.html.utils.bDS;
import com.aspose.html.utils.collections.generic.List;
import com.aspose.html.utils.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.utils.ms.System.IO.Directory;
import com.aspose.html.utils.ms.System.IO.Path;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.pA;
import com.aspose.html.utils.pb;
import com.aspose.html.utils.pf;
import com.aspose.html.utils.tB;
import com.aspose.html.utils.xC;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public class HTMLDocument
extends Document
implements IDocumentCSS {
    private String bgn;
    private IViewCSS bgo;

    public HTMLDocument() {
        this("about:blank");
    }

    public HTMLDocument(InputStream inputStream, String string) {
        this(Stream.fromJava(inputStream), string, new Configuration());
    }

    public HTMLDocument(pb pb2) {
        super(HTMLDocument.e(pb2));
    }

    public HTMLDocument(Configuration configuration) {
        this("about:blank", configuration);
    }

    public HTMLDocument(RequestMessage requestMessage) {
        this(requestMessage, new Configuration());
    }

    public HTMLDocument(RequestMessage requestMessage, Configuration configuration) {
        this(requestMessage, configuration, 1);
    }

    private HTMLDocument(final RequestMessage requestMessage, Configuration configuration, final byte by2) {
        super(HTMLDocument.a(new pb(configuration), new Document.c(){
            {
                this.a(MN.eYg);
                this.a(requestMessage);
                this.D(by2);
            }
        }));
    }

    public HTMLDocument(Stream stream, Url url) {
        this(stream, url, new Configuration());
    }

    public HTMLDocument(Stream stream, Url url, Configuration configuration) {
        this(afr.a(stream, url), configuration, 3);
    }

    public HTMLDocument(Stream stream, String string) {
        this(stream, string, new Configuration());
    }

    public HTMLDocument(Stream stream, String string, Configuration configuration) {
        this(afr.f(stream, string), configuration, 3);
    }

    public HTMLDocument(Url url) {
        this(url, new Configuration());
    }

    public HTMLDocument(Url url, Configuration configuration) {
        this(afr.m(url), configuration, 3);
    }

    public HTMLDocument(String string) {
        this(new pf(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))));
    }

    public HTMLDocument(String string, Configuration configuration) {
        this(new pf(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), configuration);
    }

    public HTMLDocument(String string, Url url) {
        this(string, url, new Configuration());
    }

    public HTMLDocument(String string, Url url, Configuration configuration) {
        this(afr.a(string, url), configuration, 3);
    }

    public HTMLDocument(String string, String string2) {
        this(string, string2, new Configuration());
    }

    public HTMLDocument(String string, String string2, Configuration configuration) {
        this(afr.as(string, string2), configuration, 3);
    }

    private static IDocumentInit e(pb pb2) {
        return HTMLDocument.a(pb2, null);
    }

    private static IDocumentInit a(pb pb2, Document.c c2) {
        Bd bd2 = pb2.Ab().l(pb2);
        bd2.im(1);
        bd2.b(new bCM<Document, Event>(){

            public void a(Document document, Event event) {
                HTMLDocument hTMLDocument = (HTMLDocument)document;
                if (hTMLDocument.getBody() != null) {
                    hTMLDocument.getBody().dispatchEvent(event);
                } else {
                    hTMLDocument.dispatchEvent(event);
                }
            }

            @Override
            public /* synthetic */ void invoke(Object object, Object object2) {
                this.a((Document)object, (Event)object2);
            }
        });
        bd2.a(c2);
        return bd2;
    }

    public final HTMLCollection getAnchors() {
        return new tB(this, new UZ("A"));
    }

    public final HTMLCollection getApplets() {
        Dictionary dictionary = new Dictionary(2);
        dictionary.addItem("APPLET", null);
        List<KeyValuePair<String, String>> list = new List<KeyValuePair<String, String>>(2);
        list.addItem(new KeyValuePair<String, String>("classid", "clsid:CAFEEFAC-00"));
        list.addItem(new KeyValuePair<String, String>("classid", "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93"));
        dictionary.addItem("OBJECT", list);
        List<KeyValuePair<String, String>> list2 = new List<KeyValuePair<String, String>>(3);
        list2.addItem(new KeyValuePair<String, String>("type", "application/x-java-applet"));
        list2.addItem(new KeyValuePair<String, String>("type", "application/x-java-bean"));
        list2.addItem(new KeyValuePair<String, String>("type", "application/x-java-vm"));
        dictionary.addItem("EMBED", list2);
        return new tB(this, new UZ("APPLET", "OBJECT", "EMBED"));
    }

    public final HTMLElement getBody() {
        tB tB2 = new tB(this, new UZ("BODY", "FRAMESET"));
        return (HTMLElement)YI.c(tB2);
    }

    public final void setBody(HTMLElement hTMLElement) {
        xC.g(hTMLElement, "value");
        HTMLElement hTMLElement2 = this.getBody();
        if (hTMLElement2 != null) {
            this.getDocumentElement().replaceChild(hTMLElement2, hTMLElement);
        } else {
            this.getDocumentElement().appendChild(hTMLElement);
        }
    }

    public final String BV() {
        return this.bgn;
    }

    final void cJ(String string) {
        this.bgn = string;
    }

    public final String getDomain() {
        return this.getLocation().getHost();
    }

    public final HTMLCollection getForms() {
        return new tB(this, new UY("FORM"));
    }

    public final HTMLCollection getImages() {
        return this.getElementsByTagName("IMG");
    }

    public final HTMLCollection getLinks() {
        return new tB(this, new UZ("A", "AREA"));
    }

    public final String getReferrer() {
        return StringExtensions.Empty;
    }

    public final String getTitle() {
        Element element = YI.c(this.getElementsByTagName(AN.i.dtB.Dh()));
        if (element != null) {
            return element.getTextContent();
        }
        return StringExtensions.Empty;
    }

    public final void setTitle(String string) {
        if (this.getDocumentElement() != null && StringExtensions.equals(this.getDocumentElement().getNamespaceURI(), AN.g.dpG)) {
            Element element = YI.c(this.getElementsByTagName(pA.a(AN.i.dtB)));
            if (element != null) {
                element.setTextContent(string);
                return;
            }
            Element element2 = YI.c(this.getElementsByTagName(pA.a(AN.i.drL)));
            if (element2 == null) {
                return;
            }
            element = this.createElement(AN.i.dtB.Dh());
            element.setTextContent(string);
            element2.appendChild(element);
        }
    }

    @Override
    public final ICSSStyleDeclaration getOverrideStyle(Element element, String string) {
        pb pb2 = (pb)this.getContext();
        return ((CY)pb2.zZ()).getOverrideStyle(element, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderTo(IDevice iDevice) {
        atG atG2 = this.getContext().getService(atG.class);
        IDisposable iDisposable = atG2.aXN();
        try {
            atG2.a(iDisposable, iDevice, this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    public final void save(IOutputStorage iOutputStorage) {
        this.save(iOutputStorage, 0);
    }

    public final void save(IOutputStorage iOutputStorage, int n2) {
        switch (n2) {
            case 0: {
                this.save(iOutputStorage, new HTMLSaveOptions());
                break;
            }
            case 1: {
                this.save(iOutputStorage, MarkdownSaveOptions.getDefault());
                break;
            }
            case 10: {
                this.save(iOutputStorage, TextSaveOptions.getDefault());
                break;
            }
            case 2: {
                this.save(iOutputStorage, new MHTMLSaveOptions());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(IOutputStorage iOutputStorage, HTMLSaveOptions hTMLSaveOptions) {
        arE arE2 = new arE((pb)this.getContext());
        IDisposable iDisposable = arE2.a(Document.a.z(this), hTMLSaveOptions);
        try {
            arD arD2 = arE2.bau();
            arD2.b(new arj(arD2.bad(), hTMLSaveOptions));
            arD2.a(iOutputStorage);
            arD2.c(Document.a.z(this), ".htm");
            arE2.I(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(IOutputStorage iOutputStorage, MHTMLSaveOptions mHTMLSaveOptions) {
        arE arE2 = new arE((pb)this.getContext());
        IDisposable iDisposable = arE2.a((Url)this.getLocation(), mHTMLSaveOptions);
        try {
            arD arD2 = arE2.bau();
            arD2.ej(false);
            arD2.a(new MHTMLHandlerFactory());
            arD2.a(new arH());
            arD2.a(new aaX(iOutputStorage, arD2.getBoundary()));
            arD2.c(this.getLocation(), ".mht");
            arE2.I(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(IOutputStorage iOutputStorage, MarkdownSaveOptions markdownSaveOptions) {
        arE arE2 = new arE((pb)this.getContext());
        IDisposable iDisposable = arE2.a((Url)this.getLocation(), markdownSaveOptions);
        try {
            arD arD2 = arE2.bau();
            arD2.b(new arP(markdownSaveOptions));
            arD2.a(new SingleDocumentHandlerFactory());
            arD2.a(iOutputStorage);
            arD2.c(this.getLocation(), ".md");
            arE2.i(this.getBody(), this.getLocation().getHref());
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    public final void save(Url url) {
        this.save(url, 0);
    }

    public final void save(Url url, int n2) {
        switch (n2) {
            case 0: {
                this.save(url, new HTMLSaveOptions());
                break;
            }
            case 1: {
                this.save(url, MarkdownSaveOptions.getDefault());
                break;
            }
            case 10: {
                this.save(url, new MHTMLSaveOptions());
                break;
            }
            case 2: {
                this.save(url, new MHTMLSaveOptions());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(Url url, HTMLSaveOptions hTMLSaveOptions) {
        arE arE2 = new arE((pb)this.getContext());
        IDisposable iDisposable = arE2.a((Url)this.getLocation(), hTMLSaveOptions);
        try {
            arD arD2 = arE2.bau();
            arD2.r(url);
            arE2.I(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(Url url, MHTMLSaveOptions mHTMLSaveOptions) {
        arE arE2 = new arE((pb)this.getContext());
        IDisposable iDisposable = arE2.a((Url)this.getLocation(), mHTMLSaveOptions);
        try {
            arD arD2 = arE2.bau();
            arD2.ej(false);
            arD2.a(new MHTMLHandlerFactory());
            arD2.a(new arH());
            arD2.a(new aaX(arD2.bai(), arD2.getBoundary()));
            arD2.p(url);
            arD2.r(url);
            final HTMLDocument hTMLDocument = this;
            arE2.c(this.getLocation().getHref(), new bDS<Url, Resource>(){

                public Resource b(Url url) {
                    return new ark(url, hTMLDocument);
                }

                @Override
                public /* synthetic */ Object invoke(Object object) {
                    return this.b((Url)object);
                }
            });
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(Url url, MarkdownSaveOptions markdownSaveOptions) {
        arE arE2 = new arE((pb)this.getContext());
        IDisposable iDisposable = arE2.a((Url)this.getLocation(), markdownSaveOptions);
        try {
            arD arD2 = arE2.bau();
            arD2.b(new arP(markdownSaveOptions));
            arD2.a(new SingleDocumentHandlerFactory());
            arD2.r(url);
            arE2.i(this.getBody(), this.getLocation().getHref());
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    public final void save(String string) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))));
    }

    public final void save(String string, int n2) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), n2);
    }

    public final void save(String string, HTMLSaveOptions hTMLSaveOptions) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), hTMLSaveOptions);
    }

    public final void save(String string, MHTMLSaveOptions mHTMLSaveOptions) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), mHTMLSaveOptions);
    }

    public final void save(String string, MarkdownSaveOptions markdownSaveOptions) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), markdownSaveOptions);
    }

    public final void save(String string, TextSaveOptions textSaveOptions) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), textSaveOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Url url, TextSaveOptions textSaveOptions) {
        arE arE2 = new arE((pb)this.getContext());
        IDisposable iDisposable = arE2.a((Url)this.getLocation(), textSaveOptions);
        try {
            arD arD2 = arE2.bau();
            arD2.a(new SingleDocumentHandlerFactory());
            arD2.r(url);
            String string = apW.i(this);
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(arD2.bah(), new String[0]), new OpenOption[0]);){
                string = string.replace("\u00a0", " ");
                bufferedWriter.append(string);
                bufferedWriter.newLine();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    public void save(IOutputStorage iOutputStorage, TextSaveOptions textSaveOptions) {
        this.a(iOutputStorage, textSaveOptions);
    }

    private void a(Url url, TextSaveOptions textSaveOptions) {
        String string = apW.i(this);
        apW.save(url.toString(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IOutputStorage iOutputStorage, TextSaveOptions textSaveOptions) {
        arE arE2 = new arE((pb)this.getContext());
        IDisposable iDisposable = arE2.a((Url)this.getLocation(), textSaveOptions);
        try {
            arD arD2 = arE2.bau();
            arD2.a(new SingleDocumentHandlerFactory());
            arD2.a(iOutputStorage);
            arD2.c(this.getLocation(), ".txt");
            String string = apW.i(this);
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(URI.create(iOutputStorage.toString())), new OpenOption[0]);){
                string = string.replace("\u00a0", " ");
                bufferedWriter.append(string);
                bufferedWriter.newLine();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }
}

