/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.net.messagehandlers;

import com.aspose.html.IDisposable;
import com.aspose.html.net.ContentHeaders;
import com.aspose.html.net.HttpMethod;
import com.aspose.html.net.INetworkOperationContext;
import com.aspose.html.net.MessageHandler;
import com.aspose.html.net.RequestHeaders;
import com.aspose.html.net.ResponseMessage;
import com.aspose.html.net.StreamContent;
import com.aspose.html.net.messagefilters.ProtocolMessageFilter;
import com.aspose.html.utils.AN;
import com.aspose.html.utils.afb;
import com.aspose.html.utils.afn;
import com.aspose.html.utils.avQ;
import com.aspose.html.utils.ayI;
import com.aspose.html.utils.bEX;
import com.aspose.html.utils.ms.System.Collections.IEnumerator;
import com.aspose.html.utils.ms.System.Diagnostics.Stopwatch;
import com.aspose.html.utils.ms.System.Net.Cookie;
import com.aspose.html.utils.ms.System.Net.CookieCollection;
import com.aspose.html.utils.ms.System.Net.CookieContainer;
import com.aspose.html.utils.ms.System.Net.CredentialCache;
import com.aspose.html.utils.ms.System.Net.HttpWebRequest;
import com.aspose.html.utils.ms.System.Net.ICredentials;
import com.aspose.html.utils.ms.System.Net.WebHeaderCollection;
import com.aspose.html.utils.ms.System.Net.WebRequest;
import com.aspose.html.utils.ms.System.Net.WebResponse;
import com.aspose.html.utils.ms.lang.Operators;
import com.aspose.html.utils.ms.lang.StringSwitchMap;
import com.aspose.html.utils.tM;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class HttpProtocolMessageHandler
extends MessageHandler {
    private static final StringSwitchMap ica = new StringSwitchMap("Accept", "User-Agent", "Content-Type", "Expect", "Referer");

    public HttpProtocolMessageHandler() {
        this.getFilters().addItem(new ProtocolMessageFilter(avQ.a(AN.j.dxa), avQ.a(AN.j.dxb)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(WebHeaderCollection webHeaderCollection, WebRequest webRequest) {
        IEnumerator iEnumerator = webHeaderCollection.getKeys().iterator();
        try {
            while (iEnumerator.hasNext()) {
                String string = (String)iEnumerator.next();
                if (!WebHeaderCollection.isRestricted(string)) {
                    webRequest.getHeaders().set(string, webHeaderCollection.get_Item(string));
                    continue;
                }
                HttpWebRequest httpWebRequest = Operators.as(webRequest, HttpWebRequest.class);
                if (httpWebRequest == null) continue;
                switch (ica.of(string)) {
                    case 0: {
                        httpWebRequest.setAccept(webHeaderCollection.get_Item(string));
                        break;
                    }
                    case 1: {
                        httpWebRequest.setUserAgent(webHeaderCollection.get_Item(string));
                        break;
                    }
                    case 2: {
                        httpWebRequest.setContentType(webHeaderCollection.get_Item(string));
                        break;
                    }
                    case 3: {
                        httpWebRequest.setExpect(webHeaderCollection.get_Item(string));
                        break;
                    }
                    case 4: {
                        httpWebRequest.setReferer(webHeaderCollection.get_Item(string));
                    }
                }
            }
        }
        finally {
            if (Operators.is(iEnumerator, IDisposable.class)) {
                ((IDisposable)((Object)iEnumerator)).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(WebResponse webResponse, ResponseMessage responseMessage) {
        IEnumerator iEnumerator = webResponse.getHeaders().getKeys().iterator();
        try {
            while (iEnumerator.hasNext()) {
                String string = (String)iEnumerator.next();
                if (WebHeaderCollection.isRestricted(string, true)) continue;
                responseMessage.getHeaders().add(string, webResponse.getHeaders().get(string));
            }
        }
        finally {
            if (Operators.is(iEnumerator, IDisposable.class)) {
                ((IDisposable)((Object)iEnumerator)).dispose();
            }
        }
    }

    private static void a(RequestHeaders requestHeaders, HttpURLConnection httpURLConnection) {
    }

    private static void a(ContentHeaders contentHeaders, HttpURLConnection httpURLConnection) {
    }

    @Override
    public void invoke(INetworkOperationContext iNetworkOperationContext) {
        if (tM.Hn().getEnabled()) {
            tM.Hn().RO().RH();
        }
        Stopwatch stopwatch = null;
        try {
            HttpURLConnection httpURLConnection = HttpProtocolMessageHandler.c(iNetworkOperationContext);
            if (tM.Hn().getEnabled()) {
                stopwatch = Stopwatch.startNew();
            }
            HttpProtocolMessageHandler.a(iNetworkOperationContext, httpURLConnection, stopwatch);
        }
        catch (IOException iOException) {
            if (tM.Hn().getEnabled() && stopwatch != null) {
                stopwatch.stop();
                tM.Hn().RP().setValue(stopwatch.getElapsedMilliseconds());
            }
            iNetworkOperationContext.setResponse(new ResponseMessage(400));
            iNetworkOperationContext.getResponse().setContent(new afb(iOException));
        }
        this.next(iNetworkOperationContext);
    }

    private static void a(INetworkOperationContext iNetworkOperationContext, HttpURLConnection httpURLConnection, Stopwatch stopwatch) throws IOException {
        if (tM.Hn().getEnabled()) {
            stopwatch.stop();
            tM.Hn().RP().setValue(stopwatch.getElapsedMilliseconds());
        }
        iNetworkOperationContext.setResponse(new ResponseMessage(httpURLConnection.getResponseCode()));
        iNetworkOperationContext.getResponse().setRequest(iNetworkOperationContext.getRequest());
        iNetworkOperationContext.getResponse().setContent(new StreamContent(httpURLConnection.getInputStream()));
        iNetworkOperationContext.getResponse().setCookies(HttpProtocolMessageHandler.a(httpURLConnection));
        HttpProtocolMessageHandler.a(httpURLConnection, iNetworkOperationContext.getResponse());
    }

    private static HttpURLConnection c(INetworkOperationContext iNetworkOperationContext) throws IOException {
        String string;
        String string2 = iNetworkOperationContext.getRequest().getRequestUri().getHref();
        URL uRL = new URL(string2);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod(iNetworkOperationContext.getRequest().getMethod() != null ? iNetworkOperationContext.getRequest().getMethod().aHm() : HttpMethod.getGet().aHm());
        ICredentials iCredentials = iNetworkOperationContext.getRequest().getCredentials();
        if (iCredentials == null) {
            iCredentials = CredentialCache.getDefaultCredentials();
        }
        afn.a(httpURLConnection, iCredentials);
        afn.a(httpURLConnection, iNetworkOperationContext.getRequest().getPreAuthenticate());
        int n2 = new Double(iNetworkOperationContext.getRequest().getTimeout().getTotalMilliseconds()).intValue();
        httpURLConnection.setReadTimeout(n2);
        HttpProtocolMessageHandler.a(iNetworkOperationContext, httpURLConnection);
        httpURLConnection.setInstanceFollowRedirects(true);
        httpURLConnection.setAllowUserInteraction(false);
        if (bEX.isNullOrEmpty(HttpProtocolMessageHandler.b(httpURLConnection))) {
            HttpProtocolMessageHandler.a(httpURLConnection, "*/*");
        }
        if ((string = httpURLConnection.getRequestProperty("User-Agent")) == null) {
            httpURLConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36");
        }
        if ((HttpMethod.getPost().equals(iNetworkOperationContext.getRequest().getMethod()) || HttpMethod.getPut().equals(iNetworkOperationContext.getRequest().getMethod())) && iNetworkOperationContext.getRequest().getContent() != null) {
            HttpProtocolMessageHandler.a(iNetworkOperationContext.getRequest().getContent().getHeaders(), httpURLConnection);
        }
        HttpProtocolMessageHandler.a(iNetworkOperationContext.getRequest().getHeaders(), httpURLConnection);
        int n3 = httpURLConnection.getResponseCode();
        if (n3 == 302 || n3 == 301) {
            String string3 = httpURLConnection.getHeaderField("Location");
            URL uRL2 = new URL(string3);
            httpURLConnection = (HttpURLConnection)uRL2.openConnection();
        }
        return httpURLConnection;
    }

    private static void a(INetworkOperationContext iNetworkOperationContext, HttpURLConnection httpURLConnection) {
        CookieContainer cookieContainer = iNetworkOperationContext.getRequest().getCookieContainer();
        if (cookieContainer == null) {
            cookieContainer = new CookieContainer();
        }
        httpURLConnection.setRequestProperty("Cookie", HttpProtocolMessageHandler.a(cookieContainer));
    }

    private static String a(CookieContainer cookieContainer) {
        cookieContainer.getCount();
        Field[] fieldArray = cookieContainer.getClass().getDeclaredFields();
        String string = null;
        CookieCollection cookieCollection = null;
        for (Field field : fieldArray) {
            if (!field.getClass().isAssignableFrom(CookieCollection.class)) continue;
            string = field.getName();
            try {
                cookieCollection = (CookieCollection)field.get(cookieContainer);
            }
            catch (IllegalAccessException illegalAccessException) {}
            break;
        }
        if (cookieCollection != null) {
            // empty if block
        }
        return "";
    }

    public static void a(HttpURLConnection httpURLConnection, ResponseMessage responseMessage) {
        Map<String, List<String>> map = httpURLConnection.getHeaderFields();
        Set<String> set = map.keySet();
        for (String string : set) {
            List<String> list = map.get(string);
            if (string == null || WebHeaderCollection.isRestricted(string, true)) continue;
            for (String string2 : list) {
                responseMessage.getHeaders().add(string, string2);
            }
        }
    }

    private static CookieCollection a(HttpURLConnection httpURLConnection) {
        Map<String, List<String>> map = httpURLConnection.getHeaderFields();
        Set<String> set = map.keySet();
        Iterator<String> iterator = set.iterator();
        CookieCollection cookieCollection = new CookieCollection();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (!"Set-Cookie".equalsIgnoreCase(string)) continue;
            List<String> list = map.get(string);
            for (String string2 : list) {
                Cookie cookie = HttpProtocolMessageHandler.ar(httpURLConnection.getURL().getHost(), string2);
                if (cookie == null) continue;
                cookieCollection.add(cookie);
            }
        }
        return cookieCollection;
    }

    public static Cookie ar(String string, String string2) {
        Object object;
        if (string2 == null || string2.trim().isEmpty()) {
            return null;
        }
        String[] stringArray = string2.split(";");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = "";
        String string7 = null;
        boolean bl2 = false;
        Long l2 = null;
        for (String object2 : stringArray) {
            object = object2.trim();
            if (((String)object).isEmpty()) continue;
            int l4 = ((String)object).indexOf(61);
            if (l4 > 0) {
                String string8 = ((String)object).substring(0, l4).trim();
                String string9 = HttpProtocolMessageHandler.lN(((String)object).substring(l4 + 1).trim());
                if (string3 == null && HttpProtocolMessageHandler.lM(string8)) {
                    string3 = string8;
                    string4 = string9;
                    continue;
                }
                switch (string8.toLowerCase(Locale.ROOT)) {
                    case "expires": {
                        string5 = string9;
                        break;
                    }
                    case "max-age": {
                        try {
                            l2 = System.currentTimeMillis() + Long.parseLong(string9) * 1000L;
                        }
                        catch (NumberFormatException numberFormatException) {}
                        break;
                    }
                    case "path": {
                        string6 = string9;
                        break;
                    }
                    case "domain": {
                        string7 = string9;
                    }
                }
                continue;
            }
            if (!"secure".equalsIgnoreCase((String)object)) continue;
            bl2 = true;
        }
        if (string3 == null || string4 == null) {
            return null;
        }
        if (string7 == null || string7.isEmpty()) {
            string7 = string;
        }
        Cookie cookie = new Cookie();
        cookie.setName(string3);
        cookie.setValue(string4);
        cookie.setPath(string6);
        cookie.setDomain(string7);
        cookie.setSecure(bl2);
        long l3 = 0L;
        if (string5 != null) {
            try {
                DateTimeFormatter dateTimeParseException = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
                object = ZonedDateTime.parse(string5, dateTimeParseException);
                long l4 = ((ZonedDateTime)object).withZoneSameInstant(ZoneId.systemDefault()).toInstant().toEpochMilli();
                l3 = (l4 + 62135596800000L) * 10000L;
            }
            catch (DateTimeParseException dateTimeParseException) {}
        } else if (l2 != null) {
            l3 = (l2 + 62135596800000L) * 10000L;
        }
        cookie.setExpires(new ayI(l3));
        return cookie;
    }

    private static boolean lM(String string) {
        String string2 = string.toLowerCase(Locale.ROOT);
        return !string2.equals("secure") && !string2.equals("httponly") && !string2.equals("samesite") && !string2.equals("path") && !string2.equals("domain") && !string2.equals("expires") && !string2.equals("max-age");
    }

    private static String lN(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() >= 2) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private static void a(HttpURLConnection httpURLConnection, String string) {
        httpURLConnection.setRequestProperty("Accept", string);
    }

    private static String b(HttpURLConnection httpURLConnection) {
        return httpURLConnection.getRequestProperty("Accept");
    }
}

