/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.rendering;

import com.aspose.html.IDisposable;
import com.aspose.html.Url;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.io.ICreateOutputStreamProvider;
import com.aspose.html.io.OutputStream;
import com.aspose.html.rendering.DeviceConfiguration;
import com.aspose.html.rendering.GraphicContext;
import com.aspose.html.rendering.IDevice;
import com.aspose.html.rendering.RenderingOptions;
import com.aspose.html.utils.Stream;
import com.aspose.html.utils.abb;
import com.aspose.html.utils.afI;
import com.aspose.html.utils.ann;
import com.aspose.html.utils.anp;
import com.aspose.html.utils.collections.generic.List;
import com.aspose.html.utils.ms.System.Activator;
import com.aspose.html.utils.ms.System.Collections.Generic.Stack;
import com.aspose.html.utils.ms.System.Drawing.PointF;
import com.aspose.html.utils.ms.System.Drawing.RectangleF;
import com.aspose.html.utils.ms.System.Drawing.SizeF;
import com.aspose.html.utils.ms.System.GC;
import com.aspose.html.utils.ms.System.IO.Path;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.lang.Operators;

public abstract class Device<TGraphicContext extends GraphicContext, TRenderingOptions extends RenderingOptions>
extends afI
implements IDevice {
    private Class<TGraphicContext> ieR;
    private Stack<TGraphicContext> ieS;
    private Stream ieT;
    private final List<Document> ieU = new List();
    private boolean ieV;
    private Document ieW;
    private TRenderingOptions gaQ;
    private int ieX;
    private ICreateOutputStreamProvider ieY;

    protected DeviceConfiguration aHR() {
        DeviceConfiguration deviceConfiguration = new DeviceConfiguration();
        deviceConfiguration.setPageWritingStrategy(0);
        return deviceConfiguration;
    }

    public final Document aHS() {
        return this.ieW;
    }

    public final void F(Document document) {
        this.ieW = document;
    }

    public final TGraphicContext getGraphicContext() {
        return (TGraphicContext)((GraphicContext)this.ieS.peek());
    }

    public final TRenderingOptions getOptions() {
        return this.gaQ;
    }

    private void a(TRenderingOptions TRenderingOptions) {
        this.gaQ = TRenderingOptions;
    }

    public final Stream aHT() {
        ann ann2 = Operators.as(this.ieT, ann.class);
        if (ann2 != null) {
            return ann2.aSP();
        }
        return this.ieT;
    }

    protected final OutputStream aHU() {
        return OutputStream.fromStream(this.ieT);
    }

    private void a(OutputStream outputStream) {
        this.ieT = outputStream == null || outputStream.getStream() == null ? null : new ann(outputStream.getStream());
    }

    public final int getPageIndex() {
        return this.ieX;
    }

    public final void setPageIndex(int n2) {
        this.ieX = n2;
    }

    protected final ICreateOutputStreamProvider aHV() {
        return this.ieY;
    }

    private void a(ICreateOutputStreamProvider iCreateOutputStreamProvider) {
        this.ieY = iCreateOutputStreamProvider;
    }

    public Device(Class<TGraphicContext> clazz, TRenderingOptions TRenderingOptions, ICreateOutputStreamProvider iCreateOutputStreamProvider) {
        this.ieR = clazz;
        this.ieS = new Stack();
        this.a(RenderingOptions.a.c(TRenderingOptions));
        this.a(iCreateOutputStreamProvider);
    }

    public Device(Class<TGraphicContext> clazz, TRenderingOptions TRenderingOptions, OutputStream outputStream) {
        this(clazz, TRenderingOptions, new b(outputStream));
    }

    public Device(Class<TGraphicContext> clazz, TRenderingOptions TRenderingOptions, Stream stream) {
        this(clazz, TRenderingOptions, new b(stream));
    }

    public Device(Class<TGraphicContext> clazz, TRenderingOptions TRenderingOptions, String string) {
        this(clazz, TRenderingOptions, new abb(string));
    }

    @Override
    public abstract void addRect(RectangleF var1);

    @Override
    public void beginDocument(Document document) {
        this.initialize();
        this.F(document);
        this.ieU.addItem(this.aHS());
        if (this.aHR().getPageWritingStrategy() == 0 && !this.ieV) {
            this.a(this.aHV().getOutputStream(this.aHW(), this.getExtension()));
        }
        if (!this.ieV) {
            this.setPageIndex(0);
            this.ieV = true;
        }
    }

    @Override
    public abstract boolean beginElement(Element var1, RectangleF var2);

    @Override
    public void beginPage(SizeF sizeF) {
        this.setPageIndex(this.getPageIndex() + 1);
        if (this.aHR().getPageWritingStrategy() == 1) {
            this.a(this.aHV().getOutputStream(this.aHW(), this.getExtension(), this.getPageIndex()));
        }
    }

    @Override
    public abstract void clip(int var1);

    @Override
    public abstract void closePath();

    private String aHW() {
        if ("about:".equals(this.aHS().getLocation().getProtocol())) {
            return "document";
        }
        String string = Path.getFileNameWithoutExtension(Url.a.f(this.aHS().getLocation()));
        return StringExtensions.isNullOrEmpty(string) ? "document" : string;
    }

    @Override
    public abstract void cubicBezierTo(PointF var1, PointF var2, PointF var3);

    @Override
    public final void dispose() {
        this.dispose(true);
        GC.suppressFinalize(this);
    }

    public void dispose(boolean bl2) {
    }

    @Override
    public abstract void drawImage(byte[] var1, int var2, RectangleF var3);

    @Override
    public void endDocument() {
        this.F(null);
    }

    @Override
    public abstract void endElement(Element var1);

    @Override
    public void endPage() {
        if (this.aHR().getPageWritingStrategy() == 1) {
            IDisposable iDisposable = anp.b.c(this.aHS(), (Stream)Operators.as(this.aHU(), ann.class), (IDevice)this);
            if (iDisposable != null) {
                iDisposable.dispose();
            }
            this.aHV().releaseOutputStream(new OutputStream(this.aHT()));
            this.a((OutputStream)null);
        }
    }

    @Override
    public abstract void fill(int var1);

    @Override
    public abstract void fillText(String var1, PointF var2);

    @Override
    public void flush() {
        this.ieV = false;
        if (this.aHR().getPageWritingStrategy() == 0) {
            IDisposable iDisposable = anp.b.c(this.ieU, (Stream)Operators.as(this.aHU(), ann.class), (IDevice)this);
            if (iDisposable != null) {
                iDisposable.dispose();
            }
            this.aHV().releaseOutputStream(OutputStream.fromStream(this.aHT()));
            this.a((OutputStream)null);
        } else if (this.aHU() != null && this.aHR().getPageWritingStrategy() == 1) {
            IDisposable iDisposable;
            if (this.ieU != null && this.ieU.size() > 0 && (iDisposable = anp.b.c(this.ieU.get_Item(this.ieU.size() - 1), (Stream)Operators.as(this.aHU(), ann.class), (IDevice)this)) != null) {
                iDisposable.dispose();
            }
            this.aHV().releaseOutputStream(OutputStream.fromStream(this.aHT()));
            this.a((OutputStream)null);
        }
        this.ieU.clear();
    }

    protected abstract String getExtension();

    public void initialize() {
        this.ieS.clear();
        this.ieS.push((GraphicContext)Activator.createInstance(Operators.typeOf(this.ieR), new Object[0]));
    }

    @Override
    public abstract void lineTo(PointF var1);

    @Override
    public abstract void moveTo(PointF var1);

    @Override
    public void restoreGraphicContext() {
        if (this.ieS.size() > 1) {
            this.ieS.pop();
        }
    }

    @Override
    public void saveGraphicContext() {
        this.ieS.push(((GraphicContext)this.ieS.peek()).deepClone());
    }

    @Override
    public abstract void stroke();

    @Override
    public abstract void strokeAndFill(int var1);

    @Override
    public abstract void strokeText(String var1, PointF var2);

    public static class b
    implements ICreateOutputStreamProvider {
        private Stream ieZ;

        public b(Stream stream) {
            this.ieZ = stream;
        }

        public b(OutputStream outputStream) {
            this.ieZ = outputStream.getStream();
        }

        @Override
        public final void dispose() {
            if (this.ieZ != null) {
                this.ieZ.dispose();
            }
            this.ieZ = null;
        }

        @Override
        public final OutputStream getOutputStream(String string, String string2) {
            return OutputStream.fromStream(this.ieZ);
        }

        @Override
        public final OutputStream getOutputStream(String string, String string2, int n2) {
            return OutputStream.fromStream(this.ieZ);
        }

        @Override
        public final void releaseOutputStream(OutputStream outputStream) {
        }
    }

    public static class a {
        public static <TGraphicContext, TRenderingOptions> Document b(Device device) {
            return device.aHS();
        }

        public static <TGraphicContext, TRenderingOptions> boolean c(Device device) {
            return device.ieV;
        }

        public static <TGraphicContext, TRenderingOptions> int d(Device device) {
            return device.getPageIndex();
        }
    }
}

