/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.ayZ;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Char;
import com.aspose.html.utils.ms.System.DoubleExtensions;
import com.aspose.html.utils.ms.System.Enum;
import com.aspose.html.utils.ms.System.FormatException;
import com.aspose.html.utils.ms.System.Int32Extensions;
import com.aspose.html.utils.ms.System.Int64Extensions;
import com.aspose.html.utils.ms.System.OverflowException;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.System.ValueType;
import java.math.BigDecimal;
import java.math.BigInteger;

public class TimeSpan
extends ValueType<TimeSpan>
implements Comparable<TimeSpan> {
    public static TimeSpan MaxValue = new TimeSpan(Long.MAX_VALUE);
    public static TimeSpan MinValue = new TimeSpan(Long.MIN_VALUE);
    public static TimeSpan Zero = new TimeSpan(0L);
    public static final long TicksPerDay = 864000000000L;
    public static final long TicksPerHour = 36000000000L;
    public static final long TicksPerMillisecond = 10000L;
    public static final long TicksPerMinute = 600000000L;
    public static final long TicksPerSecond = 10000000L;
    private long a;

    public TimeSpan() {
    }

    public TimeSpan(long l2) {
        this.a = l2;
    }

    public TimeSpan(int n2, int n3, int n4) {
        long[] lArray = new long[]{this.a};
        TimeSpan.a(0, n2, n3, n4, 0, true, lArray);
        this.a = lArray[0];
    }

    public TimeSpan(int n2, int n3, int n4, int n5) {
        long[] lArray = new long[]{this.a};
        TimeSpan.a(n2, n3, n4, n5, 0, true, lArray);
        this.a = lArray[0];
    }

    public TimeSpan(int n2, int n3, int n4, int n5, int n6) {
        long[] lArray = new long[]{this.a};
        TimeSpan.a(n2, n3, n4, n5, n6, true, lArray);
        this.a = lArray[0];
    }

    static boolean a(int n2, int n3, int n4, int n5, int n6, boolean bl2, long[] lArray) {
        int n7 = n3 * 3600;
        int n8 = n4 * 60;
        long l2 = (long)(n7 + n8 + n5) * 1000L + (long)n6;
        l2 *= 10000L;
        lArray[0] = 0L;
        boolean bl3 = false;
        if (n2 > 0) {
            long l3;
            long l4 = 864000000000L * (long)n2;
            bl3 = l2 < 0L ? (l3 = l2) > (l2 += l4) : (l2 += l4) < 0L;
        } else if (n2 < 0) {
            long l5 = 864000000000L * (long)n2;
            if (l2 <= 0L) {
                bl3 = (l2 += l5) > 0L;
            } else {
                long l6;
                boolean bl4 = bl3 = (l2 += l5) > (l6 = l2);
            }
        }
        if (bl3) {
            if (bl2) {
                throw new ArgumentOutOfRangeException("The timespan is too big or too small.");
            }
            return false;
        }
        lArray[0] = l2;
        return true;
    }

    public int getDays() {
        return (int)(this.a / 864000000000L);
    }

    public int getHours() {
        return (int)(this.a % 864000000000L / 36000000000L);
    }

    public int getMilliseconds() {
        return (int)(this.a % 10000000L / 10000L);
    }

    public int getMinutes() {
        return (int)(this.a % 36000000000L / 600000000L);
    }

    public int getSeconds() {
        return (int)(this.a % 600000000L / 10000000L);
    }

    public long getTicks() {
        return this.a;
    }

    public double getTotalDays() {
        return (double)this.a / 8.64E11;
    }

    public double getTotalHours() {
        return (double)this.a / 3.6E10;
    }

    public double getTotalMilliseconds() {
        return (double)this.a / 10000.0;
    }

    public double getTotalMinutes() {
        return (double)this.a / 6.0E8;
    }

    public double getTotalSeconds() {
        return (double)this.a / 1.0E7;
    }

    public TimeSpan add(TimeSpan timeSpan) {
        BigInteger bigInteger = BigInteger.valueOf(timeSpan.getTicks());
        if ((bigInteger = bigInteger.add(BigInteger.valueOf(this.a))).compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            throw new OverflowException("Resulting timespan is too big.");
        }
        return new TimeSpan(bigInteger.longValue());
    }

    public static int compare(TimeSpan timeSpan, TimeSpan timeSpan2) {
        if (timeSpan.a < timeSpan2.a) {
            return -1;
        }
        if (timeSpan.a > timeSpan2.a) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(TimeSpan timeSpan) {
        if (timeSpan == null) {
            return 1;
        }
        return TimeSpan.compare(this.Clone(), timeSpan.Clone());
    }

    public boolean equals(TimeSpan timeSpan) {
        if (timeSpan == null) {
            return false;
        }
        return timeSpan.a == this.a;
    }

    public TimeSpan duration() {
        BigInteger bigInteger = BigInteger.valueOf(this.a);
        if ((bigInteger = bigInteger.abs()).compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 || bigInteger.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
            throw new OverflowException("This TimeSpan value is MinValue so you cannot get the duration.");
        }
        return new TimeSpan(bigInteger.longValue());
    }

    public boolean equals(Object object) {
        if (!(object instanceof TimeSpan)) {
            return false;
        }
        return this.a == ((TimeSpan)object).a;
    }

    public static boolean equals(TimeSpan timeSpan, TimeSpan timeSpan2) {
        return timeSpan.a == timeSpan2.a;
    }

    public static TimeSpan fromDays(double d2) {
        return TimeSpan.a(d2, 864000000000L);
    }

    public static TimeSpan fromHours(double d2) {
        return TimeSpan.a(d2, 36000000000L);
    }

    public static TimeSpan fromMinutes(double d2) {
        return TimeSpan.a(d2, 600000000L);
    }

    public static TimeSpan fromSeconds(double d2) {
        return TimeSpan.a(d2, 10000000L);
    }

    public static TimeSpan fromMilliseconds(double d2) {
        return TimeSpan.a(d2, 10000L);
    }

    private static TimeSpan a(double d2, long l2) {
        if (DoubleExtensions.isNaN(d2)) {
            throw new ArgumentException("Value cannot be NaN.", "value");
        }
        if (DoubleExtensions.isNegativeInfinity(d2) || DoubleExtensions.isPositiveInfinity(d2) || d2 < (double)MinValue.getTicks() || d2 > (double)MaxValue.getTicks()) {
            throw new OverflowException("Outside range [MinValue,MaxValue]");
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(d2 *= (double)(l2 / 10000L)).setScale(0, 4);
        if ((bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(10000L))).compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) > 0 || bigDecimal.compareTo(BigDecimal.valueOf(Long.MIN_VALUE)) < 0) {
            throw new OverflowException("Resulting timespan is too big.");
        }
        return new TimeSpan(bigDecimal.longValue());
    }

    public static TimeSpan fromTicks(long l2) {
        return new TimeSpan(l2);
    }

    public int hashCode() {
        return Int64Extensions.getHashCode(this.a);
    }

    public TimeSpan negate() {
        if (this.a == TimeSpan.MinValue.a) {
            throw new OverflowException("This TimeSpan value is MinValue and cannot be negated.");
        }
        return new TimeSpan(-this.a);
    }

    public static TimeSpan parse(String string) {
        if (string == null) {
            throw new ArgumentNullException("s");
        }
        TimeSpan timeSpan = new TimeSpan();
        b b2 = new b(string);
        TimeSpan[] timeSpanArray = new TimeSpan[]{timeSpan};
        b2.a(false, timeSpanArray);
        timeSpanArray[0].CloneTo(timeSpan);
        return timeSpan;
    }

    public static boolean tryParse(String string, TimeSpan[] timeSpanArray) {
        if (string == null) {
            Zero.CloneTo(timeSpanArray[0]);
            return false;
        }
        b b2 = new b(string);
        return b2.a(true, timeSpanArray);
    }

    public TimeSpan subtract(TimeSpan timeSpan) {
        BigInteger bigInteger = BigInteger.valueOf(this.a);
        if ((bigInteger = bigInteger.subtract(BigInteger.valueOf(timeSpan.getTicks()))).compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
            throw new OverflowException("Resulting timespan is too big.");
        }
        return new TimeSpan(bigInteger.longValue());
    }

    public String toString() {
        msStringBuilder msStringBuilder2 = new msStringBuilder(14);
        if (this.a < 0L) {
            msStringBuilder2.append('-');
        }
        if (this.getDays() != 0) {
            msStringBuilder2.append(Math.abs(this.getDays()));
            msStringBuilder2.append('.');
        }
        msStringBuilder2.append(Int32Extensions.toString(Math.abs(this.getHours()), "D2"));
        msStringBuilder2.append(':');
        msStringBuilder2.append(Int32Extensions.toString(Math.abs(this.getMinutes()), "D2"));
        msStringBuilder2.append(':');
        msStringBuilder2.append(Int32Extensions.toString(Math.abs(this.getSeconds()), "D2"));
        int n2 = (int)Math.abs(this.a % 10000000L);
        if (n2 != 0) {
            msStringBuilder2.append('.');
            msStringBuilder2.append(Int32Extensions.toString(n2, "D7"));
        }
        return msStringBuilder2.toString();
    }

    public static TimeSpan op_Addition(TimeSpan timeSpan, TimeSpan timeSpan2) {
        if (timeSpan == null || timeSpan2 == null) {
            return null;
        }
        return timeSpan.add(timeSpan2.Clone());
    }

    public static boolean op_Equality(TimeSpan timeSpan, TimeSpan timeSpan2) {
        return timeSpan.a == timeSpan2.a;
    }

    public static boolean op_GreaterThan(TimeSpan timeSpan, TimeSpan timeSpan2) {
        if (timeSpan == null || timeSpan2 == null) {
            return false;
        }
        return timeSpan.a > timeSpan2.a;
    }

    public static boolean op_GreaterThanOrEqual(TimeSpan timeSpan, TimeSpan timeSpan2) {
        if (timeSpan == null || timeSpan2 == null) {
            return false;
        }
        return timeSpan.a >= timeSpan2.a;
    }

    public static boolean op_Inequality(TimeSpan timeSpan, TimeSpan timeSpan2) {
        return timeSpan.a != timeSpan2.a;
    }

    public static boolean op_LessThan(TimeSpan timeSpan, TimeSpan timeSpan2) {
        if (timeSpan == null || timeSpan2 == null) {
            return false;
        }
        return timeSpan.a < timeSpan2.a;
    }

    public static boolean op_LessThanOrEqual(TimeSpan timeSpan, TimeSpan timeSpan2) {
        if (timeSpan == null || timeSpan2 == null) {
            return false;
        }
        return timeSpan.a <= timeSpan2.a;
    }

    public static TimeSpan op_Subtraction(TimeSpan timeSpan, TimeSpan timeSpan2) {
        if (timeSpan == null || timeSpan2 == null) {
            return null;
        }
        return timeSpan.subtract(timeSpan2.Clone());
    }

    public static TimeSpan op_UnaryNegation(TimeSpan timeSpan) {
        return timeSpan.negate();
    }

    public static TimeSpan op_UnaryPlus(TimeSpan timeSpan) {
        return timeSpan;
    }

    @Override
    public void CloneTo(TimeSpan timeSpan) {
        timeSpan.a = this.a;
    }

    @Override
    public TimeSpan Clone() {
        TimeSpan timeSpan = new TimeSpan();
        this.CloneTo(timeSpan);
        return timeSpan;
    }

    public Object clone() {
        return this.Clone();
    }

    private boolean a(TimeSpan timeSpan) {
        return timeSpan.a == this.a;
    }

    public static TimeSpan fromJava(long l2) {
        return new TimeSpan(l2);
    }

    public static long toJava(TimeSpan timeSpan) {
        if (timeSpan == null) {
            return 0L;
        }
        return timeSpan.a;
    }

    public static double toMilliseconds(TimeSpan timeSpan) {
        if (timeSpan == null) {
            return 0.0;
        }
        return timeSpan.getTotalMilliseconds();
    }

    static class b {
        private String a;
        private int b = 0;
        private int c;
        private int d;

        public b(String string) {
            this.a = string;
            this.c = this.a.length();
        }

        public boolean a() {
            return this.b >= this.c;
        }

        private void b() {
            while (!this.a() && Char.isWhiteSpace(this.a, this.b)) {
                ++this.b;
            }
        }

        private boolean c() {
            boolean bl2 = false;
            if (!this.a() && this.a.charAt(this.b) == '-') {
                bl2 = true;
                ++this.b;
            }
            return bl2;
        }

        private int a(boolean bl2) {
            if (bl2 && this.a()) {
                return 0;
            }
            long l2 = 0L;
            int n2 = 0;
            while (!this.a() && Char.isDigit(this.a, this.b)) {
                if ((l2 = l2 * 10L + (long)this.a.charAt(this.b) - 48L) > Integer.MAX_VALUE) {
                    this.a(2);
                    break;
                }
                ++this.b;
                ++n2;
            }
            if (!bl2 && n2 == 0) {
                this.a(1);
            }
            return (int)l2;
        }

        private boolean d() {
            if (this.a()) {
                return false;
            }
            if (this.a.charAt(this.b) == '.') {
                ++this.b;
                return true;
            }
            return false;
        }

        private void b(boolean bl2) {
            if (!this.a()) {
                if (this.a.charAt(this.b) == ':') {
                    ++this.b;
                } else if (!bl2) {
                    this.a(1);
                }
            }
        }

        private long bfg() {
            long l2 = 0L;
            boolean bl2 = false;
            for (long i2 = 1000000L; i2 > 0L && !this.a() && Char.isDigit(this.a, this.b); i2 /= 10L) {
                l2 += (long)(this.a.charAt(this.b) - 48) * i2;
                ++this.b;
                bl2 = true;
            }
            if (!bl2) {
                this.a(1);
            }
            return l2;
        }

        private void a(int n2) {
            if (this.d != 0) {
                return;
            }
            this.d = n2;
        }

        private boolean b(int n2, int n3, int n4, boolean bl2) {
            if (this.d == 2 || n2 > 23 || n3 > 59 || n4 > 59) {
                if (bl2) {
                    return false;
                }
                throw new OverflowException("Invalid time data.");
            }
            if (this.d == 1) {
                if (bl2) {
                    return false;
                }
                throw new FormatException("Invalid format for TimeSpan.Parse.");
            }
            return true;
        }

        public boolean a(boolean bl2, TimeSpan[] timeSpanArray) {
            int n2 = 0;
            Zero.CloneTo(timeSpanArray[0]);
            this.b();
            boolean bl3 = this.c();
            int n3 = this.a(false);
            if (this.d()) {
                n2 = this.a(true);
            } else if (!this.a()) {
                n2 = n3;
                n3 = 0;
            }
            this.b(false);
            int n4 = this.b;
            int n5 = this.a(true);
            int n6 = 0;
            if (n4 < this.b) {
                this.b(true);
                n6 = this.a(true);
            }
            long l2 = this.d() ? this.bfg() : 0L;
            this.b();
            if (!this.a()) {
                this.a(1);
            }
            if (!this.b(n2, n5, n6, bl2)) {
                return false;
            }
            long l3 = 0L;
            long[] lArray = new long[]{0L};
            boolean bl4 = !TimeSpan.a(n3, n2, n5, n6, 0, false, lArray);
            l3 = lArray[0];
            if (bl4) {
                return false;
            }
            BigInteger bigInteger = BigInteger.valueOf(l2);
            BigInteger bigInteger2 = BigInteger.valueOf(l3);
            bigInteger2 = bl3 ? bigInteger2.negate().subtract(bigInteger) : bigInteger2.add(bigInteger);
            if (bigInteger2.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 || bigInteger2.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
                if (bl2) {
                    return false;
                }
                throw new OverflowException();
            }
            l3 = bigInteger2.longValue();
            timeSpanArray[0] = new TimeSpan(l3);
            return true;
        }
    }

    static final class a
    extends Enum {
        public static final int a = 0;
        public static final int jDn = 1;
        public static final int jDo = 2;

        private a() {
        }

        static {
            Enum.register(new ayZ((Class)a.class, Integer.class));
        }
    }
}

