/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.bBK;
import com.aspose.html.utils.beL;

public class bhY {
    private final byte[] mMf;
    private final long mMg;
    private final int mMh;
    private long counterValue;
    private boolean counterExhausted;

    public bhY(byte[] byArray, int n2) {
        if (byArray == null) {
            throw new NullPointerException("'baseNonce' cannot be null");
        }
        if (byArray.length < 8) {
            throw new IllegalArgumentException("'baseNonce' must be at least 8 bytes");
        }
        if (n2 < 1 || n2 > 64) {
            throw new IllegalArgumentException("'counterBits' must be from 1 to 64 bits");
        }
        if (beL.isInApprovedOnlyMode()) {
            if (byArray.length < 12) {
                throw new IllegalArgumentException("Approved mode requires 'baseNonce' of at least 12 bytes");
            }
            if (n2 < 32) {
                throw new IllegalArgumentException("Approved mode requires 'counterBits' of at least 32 bits");
            }
        }
        this.mMf = bBK.clone(byArray);
        this.mMg = -1L >>> 64 - n2;
        this.mMh = (n2 + 7) / 8;
        this.counterValue = 0L;
        this.counterExhausted = false;
    }

    public void generateNonce(byte[] byArray) {
        if (this.mMf.length != byArray.length) {
            throw new IllegalArgumentException("'nonce' length must match the base nonce length (" + this.mMf.length + " bytes)");
        }
        if (this.counterExhausted) {
            throw new IllegalStateException("TLS nonce generator exhausted");
        }
        System.arraycopy(this.mMf, 0, byArray, 0, this.mMf.length);
        this.xorCounter(byArray, this.mMf.length - this.mMh);
        this.counterExhausted |= (++this.counterValue & this.mMg) == 0L;
    }

    private void xorCounter(byte[] byArray, int n2) {
        for (int i2 = 0; i2 < this.mMh; ++i2) {
            int n3 = n2 + i2;
            byArray[n3] = (byte)(byArray[n3] ^ (byte)(this.counterValue >>> (this.mMh - 1 - i2) * 8));
        }
    }
}

