/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.bmG;
import com.aspose.html.utils.bmm;
import com.aspose.html.utils.bmr;
import com.aspose.html.utils.bnJ;
import com.aspose.html.utils.bnp;

public class bnl
implements bmG {
    private byte[] mac;
    private byte[] buf;
    private int bufOff;
    private bnp nrj;
    private bnJ net = null;
    private int macSize;

    public bnl(bmm bmm2) {
        this(bmm2, 8, bmm2.getBlockSize() * 8 / 2, null);
    }

    public bnl(bmm bmm2, bnJ bnJ2) {
        this(bmm2, 8, bmm2.getBlockSize() * 8 / 2, bnJ2);
    }

    public bnl(bmm bmm2, int n2, int n3) {
        this(bmm2, n2, n3, null);
    }

    public bnl(bmm bmm2, int n2, int n3, bnJ bnJ2) {
        if (n3 % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        this.mac = new byte[bmm2.getBlockSize()];
        this.nrj = new bnp(bmm2, n2);
        this.net = bnJ2;
        this.macSize = n3 / 8;
        this.buf = new byte[this.nrj.getBlockSize()];
        this.bufOff = 0;
    }

    public String getAlgorithmName() {
        return this.nrj.getAlgorithmName();
    }

    public void a(bmr bmr2) {
        this.reset();
        this.nrj.a(bmr2);
    }

    public int getMacSize() {
        return this.macSize;
    }

    public void update(byte by2) {
        if (this.bufOff == this.buf.length) {
            this.nrj.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
        }
        this.buf[this.bufOff++] = by2;
    }

    public void update(byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n4 = this.nrj.getBlockSize();
        int n5 = 0;
        int n6 = n4 - this.bufOff;
        if (n3 > n6) {
            System.arraycopy(byArray, n2, this.buf, this.bufOff, n6);
            n5 += this.nrj.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
            n3 -= n6;
            n2 += n6;
            while (n3 > n4) {
                n5 += this.nrj.processBlock(byArray, n2, this.mac, 0);
                n3 -= n4;
                n2 += n4;
            }
        }
        System.arraycopy(byArray, n2, this.buf, this.bufOff, n3);
        this.bufOff += n3;
    }

    public int doFinal(byte[] byArray, int n2) {
        int n3 = this.nrj.getBlockSize();
        if (this.net == null) {
            while (this.bufOff < n3) {
                this.buf[this.bufOff] = 0;
                ++this.bufOff;
            }
        } else {
            this.net.addPadding(this.buf, this.bufOff);
        }
        this.nrj.processBlock(this.buf, 0, this.mac, 0);
        this.nrj.getMacBlock(this.mac);
        System.arraycopy(this.mac, 0, byArray, n2, this.macSize);
        this.reset();
        return this.macSize;
    }

    public void reset() {
        for (int i2 = 0; i2 < this.buf.length; ++i2) {
            this.buf[i2] = 0;
        }
        this.bufOff = 0;
        this.nrj.reset();
    }
}

