/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.bBK;
import com.aspose.html.utils.bmB;
import com.aspose.html.utils.bmG;
import com.aspose.html.utils.bmJ;
import com.aspose.html.utils.bmm;
import com.aspose.html.utils.bmr;
import com.aspose.html.utils.bmu;
import com.aspose.html.utils.bnD;
import com.aspose.html.utils.bnQ;
import com.aspose.html.utils.bnm;
import com.aspose.html.utils.bnr;
import com.aspose.html.utils.boz;

public class bnv
implements bnr {
    private static final byte nrv = 0;
    private static final byte nrw = 1;
    private static final byte nrx = 2;
    private bnD nry;
    private boolean forEncryption;
    private int blockSize;
    private bmG nqZ;
    private byte[] nonceMac;
    private byte[] associatedTextMac;
    private byte[] macBlock;
    private int macSize;
    private byte[] bufBlock;
    private int bufOff;
    private boolean cipherInitialized;
    private byte[] initialAssociatedText;

    public bnv(bmm bmm2) {
        this.blockSize = bmm2.getBlockSize();
        this.nqZ = new bnm(bmm2);
        this.macBlock = new byte[this.blockSize];
        this.associatedTextMac = new byte[this.nqZ.getMacSize()];
        this.nonceMac = new byte[this.nqZ.getMacSize()];
        this.nry = new bnD(bmm2);
    }

    public String getAlgorithmName() {
        return this.nry.caZ().getAlgorithmName() + "/EAX";
    }

    public bmm caZ() {
        return this.nry.caZ();
    }

    public int getBlockSize() {
        return this.nry.getBlockSize();
    }

    public void a(boolean bl2, bmr bmr2) throws IllegalArgumentException {
        bmr bmr3;
        byte[] byArray;
        Object object;
        this.forEncryption = bl2;
        if (bmr2 instanceof bnQ) {
            object = (bnQ)bmr2;
            byArray = ((bnQ)object).getNonce();
            this.initialAssociatedText = ((bnQ)object).getAssociatedText();
            this.macSize = ((bnQ)object).getMacSize() / 8;
            bmr3 = ((bnQ)object).cbd();
        } else if (bmr2 instanceof boz) {
            object = (boz)bmr2;
            byArray = ((boz)object).getIV();
            this.initialAssociatedText = null;
            this.macSize = this.nqZ.getMacSize() / 2;
            bmr3 = ((boz)object).cbs();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to EAX");
        }
        this.bufBlock = new byte[bl2 ? this.blockSize : this.blockSize + this.macSize];
        object = new byte[this.blockSize];
        this.nqZ.a(bmr3);
        object[this.blockSize - 1] = false;
        this.nqZ.update((byte[])object, 0, this.blockSize);
        this.nqZ.update(byArray, 0, byArray.length);
        this.nqZ.doFinal(this.nonceMac, 0);
        this.nry.a(true, new boz(null, this.nonceMac));
        this.reset();
    }

    private void initCipher() {
        if (this.cipherInitialized) {
            return;
        }
        this.cipherInitialized = true;
        this.nqZ.doFinal(this.associatedTextMac, 0);
        byte[] byArray = new byte[this.blockSize];
        byArray[this.blockSize - 1] = 2;
        this.nqZ.update(byArray, 0, this.blockSize);
    }

    private void calculateMac() {
        byte[] byArray = new byte[this.blockSize];
        this.nqZ.doFinal(byArray, 0);
        for (int i2 = 0; i2 < this.macBlock.length; ++i2) {
            this.macBlock[i2] = (byte)(this.nonceMac[i2] ^ this.associatedTextMac[i2] ^ byArray[i2]);
        }
    }

    public void reset() {
        this.reset(true);
    }

    private void reset(boolean bl2) {
        this.nry.reset();
        this.nqZ.reset();
        this.bufOff = 0;
        bBK.fill(this.bufBlock, (byte)0);
        if (bl2) {
            bBK.fill(this.macBlock, (byte)0);
        }
        byte[] byArray = new byte[this.blockSize];
        byArray[this.blockSize - 1] = 1;
        this.nqZ.update(byArray, 0, this.blockSize);
        this.cipherInitialized = false;
        if (this.initialAssociatedText != null) {
            this.processAADBytes(this.initialAssociatedText, 0, this.initialAssociatedText.length);
        }
    }

    public void processAADByte(byte by2) {
        if (this.cipherInitialized) {
            throw new IllegalStateException("AAD data cannot be added after encryption/decription processing has begun.");
        }
        this.nqZ.update(by2);
    }

    public void processAADBytes(byte[] byArray, int n2, int n3) {
        if (this.cipherInitialized) {
            throw new IllegalStateException("AAD data cannot be added after encryption/decryption processing has begun.");
        }
        this.nqZ.update(byArray, n2, n3);
    }

    public int processByte(byte by2, byte[] byArray, int n2) throws bmu {
        this.initCipher();
        return this.process(by2, byArray, n2);
    }

    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws bmu {
        this.initCipher();
        if (byArray.length < n2 + n3) {
            throw new bmu("Input buffer too short");
        }
        int n5 = 0;
        for (int i2 = 0; i2 != n3; ++i2) {
            n5 += this.process(byArray[n2 + i2], byArray2, n4 + n5);
        }
        return n5;
    }

    public int doFinal(byte[] byArray, int n2) throws IllegalStateException, bmB {
        this.initCipher();
        int n3 = this.bufOff;
        byte[] byArray2 = new byte[this.bufBlock.length];
        this.bufOff = 0;
        if (this.forEncryption) {
            if (byArray.length < n2 + n3 + this.macSize) {
                throw new bmJ("Output buffer too short");
            }
            this.nry.processBlock(this.bufBlock, 0, byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n2, n3);
            this.nqZ.update(byArray2, 0, n3);
            this.calculateMac();
            System.arraycopy(this.macBlock, 0, byArray, n2 + n3, this.macSize);
            this.reset(false);
            return n3 + this.macSize;
        }
        if (byArray.length < n2 + n3 - this.macSize) {
            throw new bmJ("Output buffer too short");
        }
        if (n3 < this.macSize) {
            throw new bmB("data too short");
        }
        if (n3 > this.macSize) {
            this.nqZ.update(this.bufBlock, 0, n3 - this.macSize);
            this.nry.processBlock(this.bufBlock, 0, byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n2, n3 - this.macSize);
        }
        this.calculateMac();
        if (!this.verifyMac(this.bufBlock, n3 - this.macSize)) {
            throw new bmB("mac check in EAX failed");
        }
        this.reset(false);
        return n3 - this.macSize;
    }

    public byte[] getMac() {
        byte[] byArray = new byte[this.macSize];
        System.arraycopy(this.macBlock, 0, byArray, 0, this.macSize);
        return byArray;
    }

    public int getUpdateOutputSize(int n2) {
        int n3 = n2 + this.bufOff;
        if (!this.forEncryption) {
            if (n3 < this.macSize) {
                return 0;
            }
            n3 -= this.macSize;
        }
        return n3 - n3 % this.blockSize;
    }

    public int getOutputSize(int n2) {
        int n3 = n2 + this.bufOff;
        if (this.forEncryption) {
            return n3 + this.macSize;
        }
        return n3 < this.macSize ? 0 : n3 - this.macSize;
    }

    private int process(byte by2, byte[] byArray, int n2) {
        this.bufBlock[this.bufOff++] = by2;
        if (this.bufOff == this.bufBlock.length) {
            int n3;
            if (byArray.length < n2 + this.blockSize) {
                throw new bmJ("Output buffer is too short");
            }
            if (this.forEncryption) {
                n3 = this.nry.processBlock(this.bufBlock, 0, byArray, n2);
                this.nqZ.update(byArray, n2, this.blockSize);
            } else {
                this.nqZ.update(this.bufBlock, 0, this.blockSize);
                n3 = this.nry.processBlock(this.bufBlock, 0, byArray, n2);
            }
            this.bufOff = 0;
            if (!this.forEncryption) {
                System.arraycopy(this.bufBlock, this.blockSize, this.bufBlock, 0, this.macSize);
                this.bufOff = this.macSize;
            }
            return n3;
        }
        return 0;
    }

    private boolean verifyMac(byte[] byArray, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.macSize; ++i2) {
            n3 |= this.macBlock[i2] ^ byArray[n2 + i2];
        }
        return n3 == 0;
    }
}

