/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.bBK;
import com.aspose.html.utils.bBV;
import com.aspose.html.utils.bmB;
import com.aspose.html.utils.bmJ;
import com.aspose.html.utils.bmm;
import com.aspose.html.utils.bmr;
import com.aspose.html.utils.bmu;
import com.aspose.html.utils.bnE;
import com.aspose.html.utils.bnF;
import com.aspose.html.utils.bnG;
import com.aspose.html.utils.bnH;
import com.aspose.html.utils.bnI;
import com.aspose.html.utils.bnQ;
import com.aspose.html.utils.bnr;
import com.aspose.html.utils.bov;
import com.aspose.html.utils.boz;

public class bnx
implements bnr {
    private static final int nrC = 16;
    private bmm ncy;
    private bnF nrD;
    private bnE nrE;
    private boolean forEncryption;
    private int macSize;
    private byte[] nonce;
    private byte[] initialAssociatedText;
    private byte[] H;
    private byte[] J0;
    private byte[] bufBlock;
    private byte[] macBlock;
    private byte[] S;
    private byte[] S_at;
    private byte[] S_atPre;
    private byte[] counter;
    private int blocksRemaining;
    private int bufOff;
    private long totalLength;
    private byte[] atBlock;
    private int atBlockPos;
    private long atLength;
    private long atLengthPre;

    public bnx(bmm bmm2) {
        this(bmm2, null);
    }

    public bnx(bmm bmm2, bnF bnF2) {
        if (bmm2.getBlockSize() != 16) {
            throw new IllegalArgumentException("cipher required with a block size of 16.");
        }
        if (bnF2 == null) {
            bnF2 = new bnI();
        }
        this.ncy = bmm2;
        this.nrD = bnF2;
    }

    public bmm caZ() {
        return this.ncy;
    }

    public String getAlgorithmName() {
        return this.ncy.getAlgorithmName() + "/GCM";
    }

    public void a(boolean bl2, bmr bmr2) throws IllegalArgumentException {
        bov bov2;
        bmr bmr3;
        this.forEncryption = bl2;
        this.macBlock = null;
        if (bmr2 instanceof bnQ) {
            bmr3 = (bnQ)bmr2;
            this.nonce = ((bnQ)bmr3).getNonce();
            this.initialAssociatedText = ((bnQ)bmr3).getAssociatedText();
            int n2 = ((bnQ)bmr3).getMacSize();
            if (n2 < 32 || n2 > 128 || n2 % 8 != 0) {
                throw new IllegalArgumentException("Invalid value for MAC size: " + n2);
            }
            this.macSize = n2 / 8;
            bov2 = ((bnQ)bmr3).cbd();
        } else if (bmr2 instanceof boz) {
            bmr3 = (boz)bmr2;
            this.nonce = ((boz)bmr3).getIV();
            this.initialAssociatedText = null;
            this.macSize = 16;
            bov2 = (bov)((boz)bmr3).cbs();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to GCM");
        }
        int n3 = bl2 ? 16 : 16 + this.macSize;
        this.bufBlock = new byte[n3];
        if (this.nonce == null || this.nonce.length < 1) {
            throw new IllegalArgumentException("IV must be at least 1 byte");
        }
        if (bov2 != null) {
            this.ncy.a(true, bov2);
            this.H = new byte[16];
            this.ncy.processBlock(this.H, 0, this.H, 0);
            this.nrD.init(this.H);
            this.nrE = null;
        } else if (this.H == null) {
            throw new IllegalArgumentException("Key must be specified in initial init");
        }
        this.J0 = new byte[16];
        if (this.nonce.length == 12) {
            System.arraycopy(this.nonce, 0, this.J0, 0, this.nonce.length);
            this.J0[15] = 1;
        } else {
            this.gHASH(this.J0, this.nonce, this.nonce.length);
            byte[] byArray = new byte[16];
            bBV.longToBigEndian((long)this.nonce.length * 8L, byArray, 8);
            this.gHASHBlock(this.J0, byArray);
        }
        this.S = new byte[16];
        this.S_at = new byte[16];
        this.S_atPre = new byte[16];
        this.atBlock = new byte[16];
        this.atBlockPos = 0;
        this.atLength = 0L;
        this.atLengthPre = 0L;
        this.counter = bBK.clone(this.J0);
        this.blocksRemaining = -2;
        this.bufOff = 0;
        this.totalLength = 0L;
        if (this.initialAssociatedText != null) {
            this.processAADBytes(this.initialAssociatedText, 0, this.initialAssociatedText.length);
        }
    }

    public byte[] getMac() {
        return bBK.clone(this.macBlock);
    }

    public int getOutputSize(int n2) {
        int n3 = n2 + this.bufOff;
        if (this.forEncryption) {
            return n3 + this.macSize;
        }
        return n3 < this.macSize ? 0 : n3 - this.macSize;
    }

    public int getUpdateOutputSize(int n2) {
        int n3 = n2 + this.bufOff;
        if (!this.forEncryption) {
            if (n3 < this.macSize) {
                return 0;
            }
            n3 -= this.macSize;
        }
        return n3 - n3 % 16;
    }

    public void processAADByte(byte by2) {
        this.atBlock[this.atBlockPos] = by2;
        if (++this.atBlockPos == 16) {
            this.gHASHBlock(this.S_at, this.atBlock);
            this.atBlockPos = 0;
            this.atLength += 16L;
        }
    }

    public void processAADBytes(byte[] byArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            this.atBlock[this.atBlockPos] = byArray[n2 + i2];
            if (++this.atBlockPos != 16) continue;
            this.gHASHBlock(this.S_at, this.atBlock);
            this.atBlockPos = 0;
            this.atLength += 16L;
        }
    }

    private void initCipher() {
        if (this.atLength > 0L) {
            System.arraycopy(this.S_at, 0, this.S_atPre, 0, 16);
            this.atLengthPre = this.atLength;
        }
        if (this.atBlockPos > 0) {
            this.gHASHPartial(this.S_atPre, this.atBlock, 0, this.atBlockPos);
            this.atLengthPre += (long)this.atBlockPos;
        }
        if (this.atLengthPre > 0L) {
            System.arraycopy(this.S_atPre, 0, this.S, 0, 16);
        }
    }

    public int processByte(byte by2, byte[] byArray, int n2) throws bmu {
        this.bufBlock[this.bufOff] = by2;
        if (++this.bufOff == this.bufBlock.length) {
            this.outputBlock(byArray, n2);
            return 16;
        }
        return 0;
    }

    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws bmu {
        if (byArray.length < n2 + n3) {
            throw new bmu("Input buffer too short");
        }
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.bufBlock[this.bufOff] = byArray[n2 + i2];
            if (++this.bufOff != this.bufBlock.length) continue;
            this.outputBlock(byArray2, n4 + n5);
            n5 += 16;
        }
        return n5;
    }

    private void outputBlock(byte[] byArray, int n2) {
        if (byArray.length < n2 + 16) {
            throw new bmJ("Output buffer too short");
        }
        if (this.totalLength == 0L) {
            this.initCipher();
        }
        this.gCTRBlock(this.bufBlock, byArray, n2);
        if (this.forEncryption) {
            this.bufOff = 0;
        } else {
            System.arraycopy(this.bufBlock, 16, this.bufBlock, 0, this.macSize);
            this.bufOff = this.macSize;
        }
    }

    public int doFinal(byte[] byArray, int n2) throws IllegalStateException, bmB {
        if (this.totalLength == 0L) {
            this.initCipher();
        }
        int n3 = this.bufOff;
        if (this.forEncryption) {
            if (byArray.length < n2 + n3 + this.macSize) {
                throw new bmJ("Output buffer too short");
            }
        } else {
            if (n3 < this.macSize) {
                throw new bmB("data too short");
            }
            if (byArray.length < n2 + (n3 -= this.macSize)) {
                throw new bmJ("Output buffer too short");
            }
        }
        if (n3 > 0) {
            this.gCTRPartial(this.bufBlock, 0, n3, byArray, n2);
        }
        this.atLength += (long)this.atBlockPos;
        if (this.atLength > this.atLengthPre) {
            if (this.atBlockPos > 0) {
                this.gHASHPartial(this.S_at, this.atBlock, 0, this.atBlockPos);
            }
            if (this.atLengthPre > 0L) {
                bnG.xor(this.S_at, this.S_atPre);
            }
            long l2 = this.totalLength * 8L + 127L >>> 7;
            byte[] byArray2 = new byte[16];
            if (this.nrE == null) {
                this.nrE = new bnH();
                this.nrE.init(this.H);
            }
            this.nrE.exponentiateX(l2, byArray2);
            bnG.multiply(this.S_at, byArray2);
            bnG.xor(this.S, this.S_at);
        }
        byte[] byArray3 = new byte[16];
        bBV.longToBigEndian(this.atLength * 8L, byArray3, 0);
        bBV.longToBigEndian(this.totalLength * 8L, byArray3, 8);
        this.gHASHBlock(this.S, byArray3);
        byte[] byArray4 = new byte[16];
        this.ncy.processBlock(this.J0, 0, byArray4, 0);
        bnG.xor(byArray4, this.S);
        int n4 = n3;
        this.macBlock = new byte[this.macSize];
        System.arraycopy(byArray4, 0, this.macBlock, 0, this.macSize);
        if (this.forEncryption) {
            System.arraycopy(this.macBlock, 0, byArray, n2 + this.bufOff, this.macSize);
            n4 += this.macSize;
        } else {
            byte[] byArray5 = new byte[this.macSize];
            System.arraycopy(this.bufBlock, n3, byArray5, 0, this.macSize);
            if (!bBK.constantTimeAreEqual(this.macBlock, byArray5)) {
                throw new bmB("mac check in GCM failed");
            }
        }
        this.reset(false);
        return n4;
    }

    public void reset() {
        this.reset(true);
    }

    private void reset(boolean bl2) {
        this.ncy.reset();
        this.S = new byte[16];
        this.S_at = new byte[16];
        this.S_atPre = new byte[16];
        this.atBlock = new byte[16];
        this.atBlockPos = 0;
        this.atLength = 0L;
        this.atLengthPre = 0L;
        this.counter = bBK.clone(this.J0);
        this.blocksRemaining = -2;
        this.bufOff = 0;
        this.totalLength = 0L;
        if (this.bufBlock != null) {
            bBK.fill(this.bufBlock, (byte)0);
        }
        if (bl2) {
            this.macBlock = null;
        }
        if (this.initialAssociatedText != null) {
            this.processAADBytes(this.initialAssociatedText, 0, this.initialAssociatedText.length);
        }
    }

    private void gCTRBlock(byte[] byArray, byte[] byArray2, int n2) {
        byte[] byArray3 = this.getNextCounterBlock();
        bnG.xor(byArray3, byArray);
        System.arraycopy(byArray3, 0, byArray2, n2, 16);
        this.gHASHBlock(this.S, this.forEncryption ? byArray3 : byArray);
        this.totalLength += 16L;
    }

    private void gCTRPartial(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        byte[] byArray3 = this.getNextCounterBlock();
        bnG.xor(byArray3, byArray, n2, n3);
        System.arraycopy(byArray3, 0, byArray2, n4, n3);
        this.gHASHPartial(this.S, this.forEncryption ? byArray3 : byArray, 0, n3);
        this.totalLength += (long)n3;
    }

    private void gHASH(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = 0; i2 < n2; i2 += 16) {
            int n3 = Math.min(n2 - i2, 16);
            this.gHASHPartial(byArray, byArray2, i2, n3);
        }
    }

    private void gHASHBlock(byte[] byArray, byte[] byArray2) {
        bnG.xor(byArray, byArray2);
        this.nrD.multiplyH(byArray);
    }

    private void gHASHPartial(byte[] byArray, byte[] byArray2, int n2, int n3) {
        bnG.xor(byArray, byArray2, n2, n3);
        this.nrD.multiplyH(byArray);
    }

    private byte[] getNextCounterBlock() {
        if (this.blocksRemaining == 0) {
            throw new IllegalStateException("Attempt to process too many blocks in GCM");
        }
        --this.blocksRemaining;
        int n2 = 1;
        this.counter[15] = (byte)(n2 += this.counter[15] & 0xFF);
        n2 >>>= 8;
        this.counter[14] = (byte)(n2 += this.counter[14] & 0xFF);
        n2 >>>= 8;
        this.counter[13] = (byte)(n2 += this.counter[13] & 0xFF);
        n2 >>>= 8;
        this.counter[12] = (byte)(n2 += this.counter[12] & 0xFF);
        byte[] byArray = new byte[16];
        this.ncy.processBlock(this.counter, 0, byArray, 0);
        return byArray;
    }
}

