/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.bBK;
import com.aspose.html.utils.bqS;
import com.aspose.html.utils.bqT;
import com.aspose.html.utils.bqU;
import com.aspose.html.utils.bqV;
import com.aspose.html.utils.bqW;
import com.aspose.html.utils.bqX;
import com.aspose.html.utils.bqY;
import com.aspose.html.utils.bqZ;
import com.aspose.html.utils.bra;
import com.aspose.html.utils.brb;
import com.aspose.html.utils.btU;
import com.aspose.html.utils.btX;
import com.aspose.html.utils.buf;
import com.aspose.html.utils.bug;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.interfaces.DHKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

public class bqB {
    private PrivateKey privateKey;
    private PublicKey publicKey;

    public bqB(final PublicKey publicKey, final PrivateKey privateKey) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                bqB.this.checkKeyPairForConsistency(publicKey, privateKey);
                return null;
            }
        });
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkKeyPairForConsistency(PublicKey publicKey, PrivateKey privateKey) {
        if (publicKey instanceof ECKey && privateKey instanceof ECKey) {
            ECPrivateKey eCPrivateKey = (ECPrivateKey)privateKey;
            ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
            if (!(eCPrivateKey.getParams().getCurve().equals(eCPublicKey.getParams().getCurve()) && eCPrivateKey.getParams().getGenerator().equals(eCPublicKey.getParams().getGenerator()) && eCPrivateKey.getParams().getOrder().equals(eCPublicKey.getParams().getOrder()) && eCPrivateKey.getParams().getCofactor() == eCPublicKey.getParams().getCofactor())) {
                throw new IllegalArgumentException("EC keys do not have the same domain parameters");
            }
            btX btX2 = new btX(eCPrivateKey.getParams());
            if (btX2.bWV().bUJ().i(eCPrivateKey.getS()).cem().h(btX2.bWV().bUI().l(eCPublicKey.getW().getAffineX(), eCPublicKey.getW().getAffineY()))) return;
            throw new IllegalArgumentException("EC public key not consistent with EC private key");
        }
        if (publicKey instanceof DHKey && privateKey instanceof DHKey) {
            DHPrivateKey dHPrivateKey = (DHPrivateKey)privateKey;
            DHPublicKey dHPublicKey = (DHPublicKey)publicKey;
            DHParameterSpec dHParameterSpec = dHPrivateKey.getParams();
            if (!dHParameterSpec.getG().equals(dHPublicKey.getParams().getG()) && !dHParameterSpec.getP().equals(dHPublicKey.getParams().getP())) {
                throw new IllegalArgumentException("DH keys do not have the same domain parameters");
            }
            if (dHParameterSpec.getG().modPow(dHPrivateKey.getX(), dHParameterSpec.getP()).equals(dHPublicKey.getY())) return;
            throw new IllegalArgumentException("DH public key not consistent with DH private key");
        }
        if (publicKey instanceof DSAKey && privateKey instanceof DSAKey) {
            DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
            DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
            DSAParams dSAParams = dSAPrivateKey.getParams();
            if (!(dSAParams.getG().equals(dSAPublicKey.getParams().getG()) || dSAParams.getP().equals(dSAPublicKey.getParams().getP()) || dSAParams.getQ().equals(dSAPublicKey.getParams().getQ()))) {
                throw new IllegalArgumentException("DSA keys do not have the same domain parameters");
            }
            if (dSAParams.getG().modPow(dSAPrivateKey.getX(), dSAParams.getP()).equals(dSAPublicKey.getY())) return;
            throw new IllegalArgumentException("DSA public key not consistent with DSA private key");
        }
        if (publicKey instanceof RSAKey && privateKey instanceof RSAKey) {
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)privateKey;
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            if (!rSAPrivateKey.getModulus().equals(rSAPublicKey.getModulus())) {
                throw new IllegalArgumentException("RSA keys do not have the same modulus");
            }
            BigInteger bigInteger = BigInteger.valueOf(2L);
            if (bigInteger.modPow(rSAPrivateKey.getPrivateExponent(), rSAPrivateKey.getModulus()).modPow(rSAPublicKey.getPublicExponent(), rSAPrivateKey.getModulus()).equals(bigInteger)) return;
            throw new IllegalArgumentException("RSA public key not consistent with RSA private key");
        }
        if (publicKey instanceof bqY && privateKey instanceof bqY) {
            if (!((bqY)((Object)publicKey)).ccz().equals(((bqY)((Object)privateKey)).ccz())) {
                throw new IllegalArgumentException("GOST3410 parameters mismatch");
            }
            if (publicKey instanceof bra && privateKey instanceof bqZ) {
                bqZ bqZ2 = (bqZ)privateKey;
                bra bra2 = (bra)publicKey;
                bug bug2 = bqZ2.ccz();
                buf buf2 = (buf)bug2.getDomainParametersSpec();
                if (buf2.getA().modPow(bqZ2.getX(), buf2.getP()).equals(bra2.getY())) return;
                throw new IllegalArgumentException("GOST3410 public key not consistent with GOST3410 private key");
            }
            if (!(publicKey instanceof bqW) || !(privateKey instanceof bqV)) throw new IllegalArgumentException("GOST3410 key pair inconsistent");
            bqV bqV2 = (bqV)privateKey;
            bqW bqW2 = (bqW)publicKey;
            bug bug3 = bqV2.ccz();
            btX btX3 = (btX)bug3.getDomainParametersSpec();
            btX btX4 = new btX(btX3);
            if (btX4.bWV().bUJ().i(bqV2.getS()).cem().h(btX4.bWV().bUI().l(bqW2.getW().getAffineX(), bqW2.getW().getAffineY()))) return;
            throw new IllegalArgumentException("ECGOST3410 public key not consistent with ECGOST3410 private key");
        }
        if (publicKey instanceof bqS && privateKey instanceof bqS) {
            bqT bqT2 = (bqT)privateKey;
            bqU bqU2 = (bqU)publicKey;
            if (!bqT2.ccy().equals(bqU2.ccy())) {
                throw new IllegalArgumentException("DSTU4145 keys do not have the same domain parameters");
            }
            btU btU2 = bqT2.ccy();
            btX btX5 = new btX(btU2);
            if (btX5.bWV().bUJ().i(bqT2.getS()).cen().cem().h(btX5.bWV().bUI().l(bqU2.getW().getAffineX(), bqU2.getW().getAffineY()))) return;
            throw new IllegalArgumentException("DSTU4145 public key not consistent with DSTU4145 private key");
        }
        if (publicKey instanceof bqX && privateKey instanceof bqX) {
            bqX bqX2 = (bqX)((Object)privateKey);
            bqX bqX3 = (bqX)((Object)publicKey);
            if (!bqX2.getAlgorithm().equals(bqX3.getAlgorithm())) {
                throw new IllegalArgumentException("EdDSA keys do not have the same domain parameters");
            }
            if (bBK.areEqual(bqX2.getPublicData(), bqX3.getPublicData())) return;
            throw new IllegalArgumentException("EdDSA public key not consistent with EdDSA private key");
        }
        if (!(publicKey instanceof brb) || !(privateKey instanceof brb)) throw new IllegalArgumentException("Key pair inconsistent");
        brb brb2 = (brb)((Object)privateKey);
        brb brb3 = (brb)((Object)publicKey);
        if (!brb2.getAlgorithm().equals(brb3.getAlgorithm())) {
            throw new IllegalArgumentException("XDH keys do not have the same domain parameters");
        }
        if (bBK.areEqual(brb2.getPublicData(), brb3.getPublicData())) return;
        throw new IllegalArgumentException("XDH public key not consistent with XDH private key");
    }

    public PublicKey getPublic() {
        return this.publicKey;
    }

    public PrivateKey getPrivate() {
        return this.privateKey;
    }
}

