/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.bCc;
import com.aspose.html.utils.bpQ;
import com.aspose.html.utils.bpR;
import com.aspose.html.utils.bpZ;
import com.aspose.html.utils.bqh;
import com.aspose.html.utils.bqi;
import com.aspose.html.utils.bqj;
import com.aspose.html.utils.bql;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;

public class bqb {
    private final bpZ nvR;
    private final bqh.a nvS;
    private final byte[] nvT;
    private final bqj nvU;
    private String HttpVersion;
    private int statusCode;
    private String statusMessage;
    private InputStream inputStream;
    private Long contentLength;
    private long read = 0L;
    private Long absoluteReadLimit;
    private static final Long nvV = 0L;

    public long getAbsoluteReadLimit() {
        return this.absoluteReadLimit == null ? Long.MAX_VALUE : this.absoluteReadLimit;
    }

    public bqb(bpZ bpZ2, bqj bqj2) throws IOException {
        Set<String> set;
        this.nvR = bpZ2;
        this.nvU = bqj2;
        if (bqj2 instanceof bqi) {
            this.absoluteReadLimit = ((bqi)((Object)bqj2)).getAbsoluteReadLimit();
        }
        this.inputStream = (set = bql.asKeySet("org.bouncycastle.debug.est")).contains("input") || set.contains("all") ? new a(bqj2.getInputStream()) : bqj2.getInputStream();
        this.nvS = new bqh.a();
        this.nvT = new byte[1024];
        this.process();
    }

    private void process() throws IOException {
        this.HttpVersion = this.readStringIncluding(' ');
        this.statusCode = Integer.parseInt(this.readStringIncluding(' '));
        this.statusMessage = this.readStringIncluding('\n');
        String string = this.readStringIncluding('\n');
        while (string.length() > 0) {
            int n2 = string.indexOf(58);
            if (n2 > -1) {
                String string2 = bCc.toLowerCase(string.substring(0, n2).trim());
                this.nvS.add(string2, string.substring(n2 + 1).trim());
            }
            string = this.readStringIncluding('\n');
        }
        boolean bl2 = this.nvS.getFirstValueOrEmpty("Transfer-Encoding").equalsIgnoreCase("chunked");
        this.contentLength = bl2 ? Long.valueOf(0L) : this.getContentLength();
        if (this.statusCode == 204 || this.statusCode == 202) {
            if (this.contentLength == null) {
                this.contentLength = 0L;
            } else if (this.statusCode == 204 && this.contentLength > 0L) {
                throw new IOException("Got HTTP status 204 but Content-length > 0.");
            }
        }
        if (this.contentLength == null) {
            throw new IOException("No Content-length header.");
        }
        if (this.contentLength.equals(nvV) && !bl2) {
            this.inputStream = new InputStream(){

                public int read() throws IOException {
                    return -1;
                }
            };
        }
        if (this.contentLength < 0L) {
            throw new IOException("Server returned negative content length: " + this.absoluteReadLimit);
        }
        if (this.absoluteReadLimit != null && this.contentLength >= this.absoluteReadLimit) {
            throw new IOException("Content length longer than absolute read limit: " + this.absoluteReadLimit + " Content-Length: " + this.contentLength);
        }
        this.inputStream = this.wrapWithCounter(this.inputStream, this.absoluteReadLimit);
        if (bl2) {
            this.inputStream = new bpR(this.inputStream);
        }
        if ("base64".equalsIgnoreCase(this.getHeader("content-transfer-encoding"))) {
            this.inputStream = new bpQ(this.inputStream, this.getContentLength());
        }
    }

    public String getHeader(String string) {
        return this.nvS.getFirstValue(string);
    }

    public String getHeaderOrEmpty(String string) {
        return this.nvS.getFirstValueOrEmpty(string);
    }

    protected InputStream wrapWithCounter(final InputStream inputStream, final Long l2) {
        return new InputStream(){

            public int read() throws IOException {
                int n2 = inputStream.read();
                if (n2 > -1) {
                    bqb.this.read++;
                    if (l2 != null && bqb.this.read >= l2) {
                        throw new IOException("Absolute Read Limit exceeded: " + l2);
                    }
                }
                return n2;
            }

            public void close() throws IOException {
                if (bqb.this.contentLength != null && bqb.this.contentLength - 1L > bqb.this.read) {
                    throw new IOException("Stream closed before limit fully read, Read: " + bqb.this.read + " ContentLength: " + bqb.this.contentLength);
                }
                if (inputStream.available() > 0) {
                    throw new IOException("Stream closed with extra content in pipe that exceeds content length.");
                }
                inputStream.close();
            }
        };
    }

    protected String readStringIncluding(char c2) throws IOException {
        int n2;
        int n3 = 0;
        do {
            n2 = this.inputStream.read();
            this.nvT[n3++] = (byte)n2;
            if (n3 < this.nvT.length) continue;
            throw new IOException("Server sent line > " + this.nvT.length);
        } while (n2 != c2 && n2 > -1);
        if (n2 == -1) {
            throw new EOFException();
        }
        return new String(this.nvT, 0, n3).trim();
    }

    public bpZ ccc() {
        return this.nvR;
    }

    public bqh.a ccd() {
        return this.nvS;
    }

    public String getHttpVersion() {
        return this.HttpVersion;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public bqj cbV() {
        return this.nvU;
    }

    public Long getContentLength() {
        String string = this.nvS.getFirstValue("Content-Length");
        if (string == null) {
            return null;
        }
        try {
            return Long.parseLong(string);
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Content Length: '" + string + "' invalid. " + runtimeException.getMessage());
        }
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        this.nvU.close();
    }

    class a
    extends InputStream {
        private final InputStream nwa;

        private a(InputStream inputStream) {
            this.nwa = inputStream;
        }

        public int read() throws IOException {
            int n2 = this.nwa.read();
            return n2;
        }

        public int available() throws IOException {
            return this.nwa.available();
        }

        public void close() throws IOException {
            this.nwa.close();
        }
    }
}

