/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aXr;
import com.aspose.html.utils.aXt;
import com.aspose.html.utils.aXu;
import com.aspose.html.utils.aXz;
import com.aspose.html.utils.bCc;
import com.aspose.html.utils.bCl;
import com.aspose.html.utils.bpX;
import com.aspose.html.utils.bqu;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class bqs
implements bqu {
    private static Logger LOG = Logger.getLogger(bqs.class.getName());
    private final Set<String> nxj;

    public bqs(Set<String> set) {
        this.nxj = set;
    }

    @Override
    public boolean verified(String string, SSLSession sSLSession) throws IOException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(sSLSession.getPeerCertificates()[0].getEncoded()));
            return this.verify(string, x509Certificate);
        }
        catch (Exception exception) {
            if (exception instanceof bpX) {
                throw (bpX)exception;
            }
            throw new bpX(exception.getMessage(), exception);
        }
    }

    public boolean verify(String string, X509Certificate x509Certificate) throws IOException {
        aXt[] aXtArray;
        try {
            aXtArray = x509Certificate.getSubjectAlternativeNames();
            if (aXtArray != null) {
                block6: for (List<?> list : aXtArray) {
                    int n2 = ((Number)list.get(0)).intValue();
                    switch (n2) {
                        case 2: {
                            if (!bqs.isValidNameMatch(string, list.get(1).toString(), this.nxj)) continue block6;
                            return true;
                        }
                        case 7: {
                            if (!InetAddress.getByName(string).equals(InetAddress.getByName(list.get(1).toString()))) continue block6;
                            return true;
                        }
                    }
                    if (!LOG.isLoggable(Level.INFO)) continue;
                    String string2 = list.get(1) instanceof byte[] ? bCl.toHexString((byte[])list.get(1)) : list.get(1).toString();
                    LOG.log(Level.INFO, "ignoring type " + n2 + " value = " + string2);
                }
                return false;
            }
        }
        catch (Exception exception) {
            throw new bpX(exception.getMessage(), exception);
        }
        if (x509Certificate.getSubjectX500Principal() == null) {
            return false;
        }
        aXtArray = aXu.hp(x509Certificate.getSubjectX500Principal().getEncoded()).bSJ();
        for (int i2 = aXtArray.length - 1; i2 >= 0; --i2) {
            aXt aXt2 = aXtArray[i2];
            aXr[] aXrArray = aXt2.bSI();
            for (int i3 = 0; i3 != aXrArray.length; ++i3) {
                aXr aXr2 = aXrArray[i3];
                if (!aXr2.bNz().equals(aXz.mfk)) continue;
                return bqs.isValidNameMatch(string, aXr2.bNA().toString(), this.nxj);
            }
        }
        return false;
    }

    public static boolean isValidNameMatch(String string, String string2, Set<String> set) throws IOException {
        if (string2.contains("*")) {
            int n2 = string2.indexOf(42);
            if (n2 == string2.lastIndexOf("*")) {
                if (string2.contains("..") || string2.charAt(string2.length() - 1) == '*') {
                    return false;
                }
                int n3 = string2.indexOf(46, n2);
                if (set != null && set.contains(bCc.toLowerCase(string2.substring(n3)))) {
                    throw new IOException("Wildcard `" + string2 + "` matches known public suffix.");
                }
                String string3 = bCc.toLowerCase(string2.substring(n2 + 1));
                String string4 = bCc.toLowerCase(string);
                if (string4.equals(string3)) {
                    return false;
                }
                if (string3.length() > string4.length()) {
                    return false;
                }
                if (n2 > 0) {
                    if (string4.startsWith(string2.substring(0, n2)) && string4.endsWith(string3)) {
                        return string4.substring(n2, string4.length() - string3.length()).indexOf(46) < 0;
                    }
                    return false;
                }
                String string5 = string4.substring(0, string4.length() - string3.length());
                if (string5.indexOf(46) > 0) {
                    return false;
                }
                return string4.endsWith(string3);
            }
            return false;
        }
        return string.equalsIgnoreCase(string2);
    }
}

