/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aPJ;
import com.aspose.html.utils.aPV;
import com.aspose.html.utils.aXE;
import com.aspose.html.utils.aYb;
import com.aspose.html.utils.aYu;
import com.aspose.html.utils.bqP;
import com.aspose.html.utils.bqQ;
import com.aspose.html.utils.brE;
import com.aspose.html.utils.brl;
import com.aspose.html.utils.bso;
import com.aspose.html.utils.btD;
import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class bsn
extends CertPathValidatorSpi {
    private final Provider nCN;

    bsn(Provider provider) {
        this.nCN = provider;
    }

    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        HashSet hashSet;
        PublicKey publicKey;
        X500Principal x500Principal;
        TrustAnchor trustAnchor;
        bqQ bqQ2;
        if (certPathParameters instanceof bqQ) {
            bqQ2 = (bqQ)certPathParameters;
        } else if (certPathParameters instanceof bqP) {
            bqQ2 = ((bqP)certPathParameters).ccu();
        } else if (certPathParameters instanceof PKIXParameters) {
            bqQ2 = new bqQ.a((PKIXParameters)certPathParameters).ccx();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be " + PKIXParameters.class.getName() + " or " + bqQ.class.getName() + " instance.");
        }
        if (bqQ2.getTrustAnchors() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for certification path validation.");
        }
        List<? extends Certificate> list = certPath.getCertificates();
        int n2 = list.size();
        if (list.isEmpty()) {
            throw new CertPathValidatorException("Certification path is empty.", null, certPath, -1);
        }
        Set set = bqQ2.getInitialPolicies();
        try {
            trustAnchor = brE.findTrustAnchor((X509Certificate)list.get(list.size() - 1), bqQ2.getTrustAnchors(), bqQ2.getSigProvider());
        }
        catch (brl brl2) {
            throw new CertPathValidatorException(brl2.getMessage(), (Throwable)brl2, certPath, list.size() - 1);
        }
        if (trustAnchor == null) {
            throw new CertPathValidatorException("Trust anchor for certification path not found.", null, certPath, -1);
        }
        bqQ2 = new bqQ.a(bqQ2).a(trustAnchor).ccx();
        int n3 = 0;
        List[] listArray = new ArrayList[n2 + 1];
        for (int i2 = 0; i2 < listArray.length; ++i2) {
            listArray[i2] = new ArrayList();
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("2.5.29.32.0");
        bso bso2 = new bso(new ArrayList(), 0, hashSet2, null, new HashSet(), "2.5.29.32.0", false);
        listArray[0].add(bso2);
        aYu aYu2 = new aYu();
        HashSet hashSet3 = new HashSet();
        int n4 = bqQ2.isExplicitPolicyRequired() ? 0 : n2 + 1;
        int n5 = bqQ2.isAnyPolicyInhibited() ? 0 : n2 + 1;
        int n6 = bqQ2.isPolicyMappingInhibited() ? 0 : n2 + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x500Principal = brE.getSubjectPrincipal(x509Certificate);
                publicKey = x509Certificate.getPublicKey();
            } else {
                x500Principal = new X500Principal(trustAnchor.getCAName());
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("Subject of trust anchor could not be (re)encoded.", (Throwable)illegalArgumentException, certPath, -1);
        }
        aXE aXE2 = null;
        try {
            aXE2 = brE.g(publicKey);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new CertPathValidatorException("Algorithm identifier of public key of trust anchor could not be read.", (Throwable)certPathValidatorException, certPath, -1);
        }
        aPV aPV2 = aXE2.bRW();
        aPJ aPJ2 = aXE2.bRX();
        int n7 = n2;
        if (bqQ2.ccw() != null && !bqQ2.ccw().match((X509Certificate)list.get(0))) {
            throw new CertPathValidatorException("Target certificate in certification path does not match targetConstraints.", null, certPath, 0);
        }
        List list2 = bqQ2.getCertPathCheckers();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            ((PKIXCertPathChecker)iterator.next()).init(false);
        }
        X509Certificate x509Certificate2 = null;
        for (n3 = list.size() - 1; n3 >= 0; --n3) {
            boolean bl2;
            int n8 = n2 - n3;
            x509Certificate2 = (X509Certificate)list.get(n3);
            boolean bl3 = bl2 = n3 == list.size() - 1;
            if (x509Certificate2 == null) {
                throw new CertPathValidatorException("NULL certificate found", null, certPath, n3);
            }
            btD.a(certPath, bqQ2, n3, publicKey, bl2, x500Principal, x509Certificate, this.nCN);
            btD.a(certPath, n3, aYu2);
            bso2 = btD.a(certPath, n3, hashSet3, bso2, listArray, n5);
            bso2 = btD.a(certPath, n3, bso2);
            btD.a(certPath, n3, bso2, n4);
            if (n8 == n2) continue;
            if (x509Certificate2.getVersion() == 1) {
                throw new CertPathValidatorException("Version 1 certificates can't be used as CA ones.", null, certPath, n3);
            }
            btD.prepareNextCertA(certPath, n3);
            bso2 = btD.a(certPath, n3, listArray, bso2, n6);
            btD.b(certPath, n3, aYu2);
            n4 = btD.prepareNextCertH1(certPath, n3, n4);
            n6 = btD.prepareNextCertH2(certPath, n3, n6);
            n5 = btD.prepareNextCertH3(certPath, n3, n5);
            n4 = btD.prepareNextCertI1(certPath, n3, n4);
            n6 = btD.prepareNextCertI2(certPath, n3, n6);
            n5 = btD.prepareNextCertJ(certPath, n3, n5);
            btD.prepareNextCertK(certPath, n3);
            n7 = btD.prepareNextCertL(certPath, n3, n7);
            n7 = btD.prepareNextCertM(certPath, n3, n7);
            btD.prepareNextCertN(certPath, n3);
            hashSet = x509Certificate2.getCriticalExtensionOIDs();
            if (hashSet != null) {
                hashSet = new HashSet(hashSet);
                hashSet.removeAll(btD.ocE);
            } else {
                hashSet = new HashSet();
            }
            btD.prepareNextCertO(certPath, n3, hashSet, list2);
            x509Certificate = x509Certificate2;
            x500Principal = brE.getSubjectPrincipal(x509Certificate);
            try {
                publicKey = brE.getNextWorkingKey(certPath.getCertificates(), n3, this.nCN);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException("Next working key could not be retrieved.", (Throwable)certPathValidatorException, certPath, n3);
            }
            aXE2 = brE.g(publicKey);
            aPV2 = aXE2.bRW();
            aPJ2 = aXE2.bRX();
        }
        n4 = btD.wrapupCertA(n4, x509Certificate2);
        n4 = btD.wrapupCertB(certPath, n3 + 1, n4);
        Set<String> set2 = x509Certificate2.getCriticalExtensionOIDs();
        if (set2 != null) {
            set2 = new HashSet<String>(set2);
            set2.removeAll(btD.ocE);
            set2.remove(aYb.mik.getId());
        } else {
            set2 = new HashSet<String>();
        }
        btD.wrapupCertF(certPath, n3 + 1, list2, set2);
        hashSet = btD.a(certPath, bqQ2, set, n3 + 1, listArray, bso2, hashSet3);
        if (n4 > 0 || hashSet != null) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)((Object)hashSet), x509Certificate2.getPublicKey());
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, n3);
    }
}

