/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aPS;
import com.aspose.html.utils.aPU;
import com.aspose.html.utils.aPV;
import com.aspose.html.utils.aPW;
import com.aspose.html.utils.aQa;
import com.aspose.html.utils.aXN;
import com.aspose.html.utils.aXO;
import com.aspose.html.utils.aXS;
import com.aspose.html.utils.aXp;
import com.aspose.html.utils.aXu;
import com.aspose.html.utils.aYG;
import com.aspose.html.utils.aYH;
import com.aspose.html.utils.aYb;
import com.aspose.html.utils.aYc;
import com.aspose.html.utils.aYf;
import com.aspose.html.utils.aYl;
import com.aspose.html.utils.bCc;
import com.aspose.html.utils.bCl;
import com.aspose.html.utils.btD;
import com.aspose.html.utils.btI;
import com.aspose.html.utils.btM;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class btJ
extends X509CRL {
    private final Provider ocL;
    private final aXS ocM;
    private final String ocN;
    private final byte[] ocO;
    private final boolean ocP;
    private volatile boolean isHashCodeSet = false;
    private volatile int hashCodeValue;

    static boolean isIndirectCRL(X509CRL x509CRL) throws CRLException {
        try {
            byte[] byArray = x509CRL.getExtensionValue(aYb.mic.getId());
            return byArray != null && aYl.hW(aPW.cr(byArray).getOctets()).isIndirectCRL();
        }
        catch (Exception exception) {
            throw new CRLException("Exception reading IssuingDistributionPoint", exception);
        }
    }

    protected btJ(Provider provider, aXS aXS2) throws CRLException {
        this.ocL = provider;
        this.ocM = aXS2;
        try {
            this.ocN = btM.v(aXS2.bMN());
            this.ocO = (byte[])(aXS2.bMN().bRX() != null ? aXS2.bMN().bRX().bKv().getEncoded("DER") : null);
            this.ocP = btJ.isIndirectCRL(this);
        }
        catch (Exception exception) {
            throw new CRLException("CRL contents invalid: " + exception);
        }
    }

    public boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        if (set == null) {
            return false;
        }
        set.removeAll(btD.ocF);
        return !set.isEmpty();
    }

    private Set getExtensionOIDs(boolean bl2) {
        aYc aYc2;
        if (this.getVersion() == 2 && (aYc2 = this.ocM.bTg().bOt()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = aYc2.oids();
            while (enumeration.hasMoreElements()) {
                aPV aPV2 = (aPV)enumeration.nextElement();
                aYb aYb2 = aYc2.q(aPV2);
                if (bl2 != aYb2.isCritical()) continue;
                hashSet.add(aPV2.getId());
            }
            return hashSet;
        }
        return null;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public byte[] getExtensionValue(String string) {
        aYb aYb2;
        aYc aYc2 = this.ocM.bTg().bOt();
        if (aYc2 != null && (aYb2 = aYc2.q(new aPV(string))) != null) {
            try {
                return aYb2.bTu().getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public byte[] getEncoded() throws CRLException {
        try {
            return this.ocM.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        try {
            signature = Signature.getInstance(this.getSigAlgName(), this.ocL);
        }
        catch (Exception exception) {
            signature = Signature.getInstance(this.getSigAlgName());
        }
        this.doVerify(publicKey, signature);
    }

    public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = string != null ? Signature.getInstance(this.getSigAlgName(), string) : Signature.getInstance(this.getSigAlgName());
        this.doVerify(publicKey, signature);
    }

    public void verify(PublicKey publicKey, Provider provider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = provider != null ? Signature.getInstance(this.getSigAlgName(), provider) : Signature.getInstance(this.getSigAlgName());
        this.doVerify(publicKey, signature);
    }

    private void doVerify(PublicKey publicKey, Signature signature) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!this.ocM.bMN().equals(this.ocM.bTg().bSW())) {
            throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
        }
        if (this.ocO != null) {
            try {
                btM.a(signature, aQa.cl(this.ocO));
            }
            catch (IOException iOException) {
                throw new SignatureException("cannot decode signature parameters: " + iOException.getMessage());
            }
        }
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
    }

    public int getVersion() {
        return this.ocM.getVersionNumber();
    }

    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    public X500Principal getIssuerX500Principal() {
        try {
            return new X500Principal(this.ocM.bOn().getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    public Date getThisUpdate() {
        return this.ocM.bTi().getDate();
    }

    public Date getNextUpdate() {
        if (this.ocM.bTj() != null) {
            return this.ocM.bTj().getDate();
        }
        return null;
    }

    private Set loadCRLEntries() {
        HashSet<btI> hashSet = new HashSet<btI>();
        Enumeration enumeration = this.ocM.getRevokedCertificateEnumeration();
        aXu aXu2 = null;
        while (enumeration.hasMoreElements()) {
            aYb aYb2;
            aYG.a a2 = (aYG.a)enumeration.nextElement();
            btI btI2 = new btI(a2, this.ocP, aXu2);
            hashSet.add(btI2);
            if (!this.ocP || !a2.hasExtensions() || (aYb2 = a2.bOt().q(aYb.mid)) == null) continue;
            aXu2 = aXu.hp(aYf.hR(aYb2.bTv()).bTA()[0].bTr());
        }
        return hashSet;
    }

    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        Enumeration enumeration = this.ocM.getRevokedCertificateEnumeration();
        aXu aXu2 = null;
        while (enumeration.hasMoreElements()) {
            aYb aYb2;
            aYG.a a2 = (aYG.a)enumeration.nextElement();
            if (bigInteger.equals(a2.bUc().getValue())) {
                return new btI(a2, this.ocP, aXu2);
            }
            if (!this.ocP || !a2.hasExtensions() || (aYb2 = a2.bOt().q(aYb.mid)) == null) continue;
            aXu2 = aXu.hp(aYf.hR(aYb2.bTv()).bTA()[0].bTr());
        }
        return null;
    }

    public Set getRevokedCertificates() {
        Set set = this.loadCRLEntries();
        if (!set.isEmpty()) {
            return Collections.unmodifiableSet(set);
        }
        return null;
    }

    public byte[] getTBSCertList() throws CRLException {
        try {
            return this.ocM.bTg().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    public byte[] getSignature() {
        return this.ocM.bOM().getOctets();
    }

    public String getSigAlgName() {
        return this.ocN;
    }

    public String getSigAlgOID() {
        return this.ocM.bMN().bRW().getId();
    }

    public byte[] getSigAlgParams() {
        if (this.ocO != null) {
            byte[] byArray = new byte[this.ocO.length];
            System.arraycopy(this.ocO, 0, byArray, 0, byArray.length);
            return byArray;
        }
        return null;
    }

    public String toString() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = bCc.lineSeparator();
        stringBuffer.append("              Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("          This update: ").append(this.getThisUpdate()).append(string);
        stringBuffer.append("          Next update: ").append(this.getNextUpdate()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(bCc.fromByteArray(bCl.encode(byArray, 0, 20))).append(string);
        for (int i2 = 20; i2 < byArray.length; i2 += 20) {
            if (i2 < byArray.length - 20) {
                stringBuffer.append("                       ").append(bCc.fromByteArray(bCl.encode(byArray, i2, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(bCc.fromByteArray(bCl.encode(byArray, i2, byArray.length - i2))).append(string);
        }
        aYc aYc2 = this.ocM.bTg().bOt();
        if (aYc2 != null) {
            object2 = aYc2.oids();
            if (object2.hasMoreElements()) {
                stringBuffer.append("           Extensions: ").append(string);
            }
            while (object2.hasMoreElements()) {
                object = (aPV)object2.nextElement();
                aYb aYb2 = aYc2.q((aPV)object);
                if (aYb2.bTu() != null) {
                    byte[] byArray2 = aYb2.bTu().getOctets();
                    stringBuffer.append("                       critical(").append(aYb2.isCritical()).append(") ");
                    try {
                        aQa aQa2 = aQa.cl(byArray2);
                        if (((aQa)object).equals(aYb.mhX)) {
                            stringBuffer.append(new aXO(aPS.co(aQa2).getPositiveValue())).append(string);
                            continue;
                        }
                        if (((aQa)object).equals(aYb.mib)) {
                            stringBuffer.append("Base CRL: " + new aXO(aPS.co(aQa2).getPositiveValue())).append(string);
                            continue;
                        }
                        if (((aQa)object).equals(aYb.mic)) {
                            stringBuffer.append(aYl.hW(aQa2)).append(string);
                            continue;
                        }
                        if (((aQa)object).equals(aYb.mif)) {
                            stringBuffer.append(aXN.hA(aQa2)).append(string);
                            continue;
                        }
                        if (((aQa)object).equals(aYb.mil)) {
                            stringBuffer.append(aXN.hA(aQa2)).append(string);
                            continue;
                        }
                        stringBuffer.append(((aPV)object).getId());
                        stringBuffer.append(" value = ").append(aXp.dumpAsString(aQa2)).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(((aPV)object).getId());
                        stringBuffer.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        if ((object2 = this.getRevokedCertificates()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                stringBuffer.append(object.next());
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public boolean isRevoked(Certificate certificate) {
        if (!certificate.getType().equals("X.509")) {
            throw new IllegalArgumentException("X.509 CRL used with non X.509 Cert");
        }
        Enumeration enumeration = this.ocM.getRevokedCertificateEnumeration();
        aXu aXu2 = this.ocM.bOn();
        if (enumeration.hasMoreElements()) {
            BigInteger bigInteger = ((X509Certificate)certificate).getSerialNumber();
            while (enumeration.hasMoreElements()) {
                aPU aPU2;
                aYG.a a2 = aYG.a.in(enumeration.nextElement());
                if (this.ocP && a2.hasExtensions() && (aPU2 = a2.bOt().q(aYb.mid)) != null) {
                    aXu2 = aXu.hp(aYf.hR(aPU2.bTv()).bTA()[0].bTr());
                }
                if (!a2.bUc().getValue().equals(bigInteger)) continue;
                if (certificate instanceof X509Certificate) {
                    aPU2 = aXu.hp(((X509Certificate)certificate).getIssuerX500Principal().getEncoded());
                } else {
                    try {
                        aPU2 = aYH.io(certificate.getEncoded()).bOn();
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        throw new IllegalArgumentException("Cannot process certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
                    }
                }
                return aXu2.equals(aPU2);
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509CRL)) {
            return false;
        }
        if (object instanceof btJ) {
            boolean bl2;
            btJ btJ2 = (btJ)object;
            if (this.isHashCodeSet && (bl2 = btJ2.isHashCodeSet) && btJ2.hashCodeValue != this.hashCodeValue) {
                return false;
            }
            return this.ocM.equals(btJ2.ocM);
        }
        return super.equals(object);
    }

    public int hashCode() {
        if (!this.isHashCodeSet) {
            this.hashCodeValue = super.hashCode();
            this.isHashCodeSet = true;
        }
        return this.hashCodeValue;
    }
}

