/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils;

import com.aspose.html.utils.aPJ;
import com.aspose.html.utils.aPV;
import com.aspose.html.utils.aPY;
import com.aspose.html.utils.aQD;
import com.aspose.html.utils.aQL;
import com.aspose.html.utils.aQM;
import com.aspose.html.utils.aQO;
import com.aspose.html.utils.aQa;
import com.aspose.html.utils.aQb;
import com.aspose.html.utils.aQg;
import com.aspose.html.utils.aVK;
import com.aspose.html.utils.aVL;
import com.aspose.html.utils.aVM;
import com.aspose.html.utils.aVO;
import com.aspose.html.utils.aXB;
import com.aspose.html.utils.aXE;
import com.aspose.html.utils.aXM;
import com.aspose.html.utils.aXR;
import com.aspose.html.utils.aXp;
import com.aspose.html.utils.aXu;
import com.aspose.html.utils.aYb;
import com.aspose.html.utils.aYc;
import com.aspose.html.utils.aYe;
import com.aspose.html.utils.aYn;
import com.aspose.html.utils.bBR;
import com.aspose.html.utils.bCc;
import com.aspose.html.utils.bCl;
import com.aspose.html.utils.brD;
import com.aspose.html.utils.btD;
import com.aspose.html.utils.btM;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class btK
extends X509Certificate {
    private final brD ocQ;
    private final aXR ocR;
    private final aXM ocS;
    private final boolean[] ocT;
    private volatile PublicKey publicKeyValue;
    private volatile boolean hashValueSet;
    private volatile int hashValue;

    public btK(brD brD2, aXR aXR2) throws CertificateParsingException {
        byte[] byArray;
        this.ocQ = brD2;
        this.ocR = aXR2;
        try {
            byArray = this.getExtensionBytes("2.5.29.19");
            this.ocS = byArray != null ? aXM.hz(aQa.cl(byArray)) : null;
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct BasicConstraints: " + exception);
        }
        try {
            byArray = this.getExtensionBytes("2.5.29.15");
            if (byArray != null) {
                aQD aQD2 = aQD.cx(aQa.cl(byArray));
                int n2 = (byArray = aQD2.getBytes()).length * 8 - aQD2.getPadBits();
                this.ocT = new boolean[n2 < 9 ? 9 : n2];
                for (int i2 = 0; i2 != n2; ++i2) {
                    this.ocT[i2] = (byArray[i2 / 8] & 128 >>> i2 % 8) != 0;
                }
            } else {
                this.ocT = null;
            }
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct KeyUsage: " + exception);
        }
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.getTime() > this.getNotAfter().getTime()) {
            throw new CertificateExpiredException("certificate expired on " + this.ocR.bTf().getTime());
        }
        if (date.getTime() < this.getNotBefore().getTime()) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.ocR.bTe().getTime());
        }
    }

    public int getVersion() {
        return this.ocR.getVersionNumber();
    }

    public BigInteger getSerialNumber() {
        return this.ocR.bNb().getValue();
    }

    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    public X500Principal getIssuerX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            aPY aPY2 = new aPY(byteArrayOutputStream);
            aPY2.b(this.ocR.bOn());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN: " + iOException.getMessage(), iOException);
        }
    }

    public Principal getSubjectDN() {
        return this.getSubjectX500Principal();
    }

    public X500Principal getSubjectX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            aPY aPY2 = new aPY(byteArrayOutputStream);
            aPY2.b(this.ocR.bOp());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN: " + iOException.getMessage(), iOException);
        }
    }

    public Date getNotBefore() {
        return this.ocR.bTe().getDate();
    }

    public Date getNotAfter() {
        return this.ocR.bTf().getDate();
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            return this.ocR.bTd().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public byte[] getSignature() {
        return this.ocR.bOM().getOctets();
    }

    public String getSigAlgName() {
        Object object;
        brD brD2 = this.ocQ;
        if (brD2 != null && (object = brD2.getProperty("Alg.Alias.Signature." + this.getSigAlgOID())) != null) {
            return object;
        }
        object = Security.getProviders();
        for (int i2 = 0; i2 != ((Provider[])object).length; ++i2) {
            String string = object[i2].getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
            if (string == null) continue;
            return string;
        }
        return this.getSigAlgOID();
    }

    public String getSigAlgOID() {
        return this.ocR.bMN().bRW().getId();
    }

    public byte[] getSigAlgParams() {
        if (this.ocR.bMN().bRX() != null) {
            try {
                return this.ocR.bMN().bRX().bKv().getEncoded("DER");
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public boolean[] getIssuerUniqueID() {
        aQD aQD2 = this.ocR.bTd().bUe();
        if (aQD2 != null) {
            byte[] byArray = aQD2.getBytes();
            boolean[] blArray = new boolean[byArray.length * 8 - aQD2.getPadBits()];
            for (int i2 = 0; i2 != blArray.length; ++i2) {
                blArray[i2] = (byArray[i2 / 8] & 128 >>> i2 % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    public boolean[] getSubjectUniqueID() {
        aQD aQD2 = this.ocR.bTd().bUf();
        if (aQD2 != null) {
            byte[] byArray = aQD2.getBytes();
            boolean[] blArray = new boolean[byArray.length * 8 - aQD2.getPadBits()];
            for (int i2 = 0; i2 != blArray.length; ++i2) {
                blArray[i2] = (byArray[i2 / 8] & 128 >>> i2 % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    public boolean[] getKeyUsage() {
        return this.ocT;
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        byte[] byArray = this.getExtensionBytes("2.5.29.37");
        if (byArray != null) {
            try {
                aQb aQb2 = aQb.cs(byArray);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i2 = 0; i2 != aQb2.size(); ++i2) {
                    arrayList.add(((aPV)aQb2.vp(i2)).getId());
                }
                return Collections.unmodifiableList(arrayList);
            }
            catch (Exception exception) {
                throw new CertificateParsingException("error processing extended key usage extension");
            }
        }
        return null;
    }

    public int getBasicConstraints() {
        if (this.ocS != null) {
            if (this.ocS.isCA()) {
                if (this.ocS.getPathLenConstraint() == null) {
                    return Integer.MAX_VALUE;
                }
                return this.ocS.getPathLenConstraint().intValue();
            }
            return -1;
        }
        return -1;
    }

    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        return btK.getAlternativeNames(this.getExtensionBytes(aYb.mhU.getId()));
    }

    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        return btK.getAlternativeNames(this.getExtensionBytes(aYb.mhV.getId()));
    }

    public Set getCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            aYc aYc2 = this.ocR.bTd().bOt();
            if (aYc2 != null) {
                Enumeration enumeration = aYc2.oids();
                while (enumeration.hasMoreElements()) {
                    aPV aPV2 = (aPV)enumeration.nextElement();
                    aYb aYb2 = aYc2.q(aPV2);
                    if (!aYb2.isCritical()) continue;
                    hashSet.add(aPV2.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    private byte[] getExtensionBytes(String string) {
        aYb aYb2;
        aYc aYc2 = this.ocR.bTd().bOt();
        if (aYc2 != null && (aYb2 = aYc2.q(new aPV(string))) != null) {
            return aYb2.bTu().getOctets();
        }
        return null;
    }

    public byte[] getExtensionValue(String string) {
        aYb aYb2;
        aYc aYc2 = this.ocR.bTd().bOt();
        if (aYc2 != null && (aYb2 = aYc2.q(new aPV(string))) != null) {
            try {
                return aYb2.bTu().getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            aYc aYc2 = this.ocR.bTd().bOt();
            if (aYc2 != null) {
                Enumeration enumeration = aYc2.oids();
                while (enumeration.hasMoreElements()) {
                    aPV aPV2 = (aPV)enumeration.nextElement();
                    aYb aYb2 = aYc2.q(aPV2);
                    if (aYb2.isCritical()) continue;
                    hashSet.add(aPV2.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        aYc aYc2;
        if (this.getVersion() == 3 && (aYc2 = this.ocR.bTd().bOt()) != null) {
            Set set = this.getCriticalExtensionOIDs();
            set.removeAll(btD.ocE);
            return !set.isEmpty();
        }
        return false;
    }

    public PublicKey getPublicKey() {
        try {
            if (this.publicKeyValue == null) {
                this.publicKeyValue = this.ocQ.q(this.ocR.bRi());
            }
            return this.publicKeyValue;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.ocR.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof btK) {
            btK btK2 = (btK)object;
            if (this.hashValueSet && btK2.hashValueSet && this.hashValue != btK2.hashValue) {
                return false;
            }
            return this.ocR.equals(btK2.ocR);
        }
        return super.equals(object);
    }

    public int hashCode() {
        if (!this.hashValueSet) {
            this.hashValue = super.hashCode();
            this.hashValueSet = true;
        }
        return this.hashValue;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = bCc.lineSeparator();
        stringBuffer.append("  [0]         Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("         SerialNumber: ").append(this.getSerialNumber()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("           Start Date: ").append(this.getNotBefore()).append(string);
        stringBuffer.append("           Final Date: ").append(this.getNotAfter()).append(string);
        stringBuffer.append("            SubjectDN: ").append(this.getSubjectDN()).append(string);
        stringBuffer.append("           Public Key: ").append(this.getPublicKey()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(bCc.fromByteArray(bCl.encode(byArray, 0, 20))).append(string);
        for (int i2 = 20; i2 < byArray.length; i2 += 20) {
            if (i2 < byArray.length - 20) {
                stringBuffer.append("                       ").append(bCc.fromByteArray(bCl.encode(byArray, i2, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(bCc.fromByteArray(bCl.encode(byArray, i2, byArray.length - i2))).append(string);
        }
        aYc aYc2 = this.ocR.bTd().bOt();
        if (aYc2 != null) {
            Enumeration enumeration = aYc2.oids();
            if (enumeration.hasMoreElements()) {
                stringBuffer.append("       Extensions: \n");
            }
            while (enumeration.hasMoreElements()) {
                aPV aPV2 = (aPV)enumeration.nextElement();
                aYb aYb2 = aYc2.q(aPV2);
                if (aYb2.bTu() != null) {
                    byte[] byArray2 = aYb2.bTu().getOctets();
                    stringBuffer.append("                       critical(").append(aYb2.isCritical()).append(") ");
                    try {
                        aQa aQa2 = aQa.cl(byArray2);
                        if (aPV2.equals(aYb.mhW)) {
                            stringBuffer.append(aXM.hz(aQa2)).append(string);
                            continue;
                        }
                        if (aPV2.equals(aYb.mhS)) {
                            stringBuffer.append(aYn.hY(aQa2)).append(string);
                            continue;
                        }
                        if (aPV2.equals(aVK.lRB)) {
                            stringBuffer.append(new aVL((aQD)aQa2)).append(string);
                            continue;
                        }
                        if (aPV2.equals(aVK.lRD)) {
                            stringBuffer.append(new aVM((aQL)aQa2)).append(string);
                            continue;
                        }
                        if (aPV2.equals(aVK.lRK)) {
                            stringBuffer.append(new aVO((aQL)aQa2)).append(string);
                            continue;
                        }
                        stringBuffer.append(aPV2.getId());
                        stringBuffer.append(" value = ").append(aXp.dumpAsString(aQa2)).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(aPV2.getId());
                        stringBuffer.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public final void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string = btM.v(this.ocR.bMN());
        Signature signature = this.getSignatureFromProvider(this.ocQ, string);
        this.checkSignature(publicKey, signature);
    }

    public final void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string2 = btM.v(this.ocR.bMN());
        Signature signature = string != null ? Signature.getInstance(string2, string) : Signature.getInstance(string2);
        this.checkSignature(publicKey, signature);
    }

    public final void verify(PublicKey publicKey, Provider provider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        String string = btM.v(this.ocR.bMN());
        Signature signature = this.getSignatureFromProvider(provider, string);
        this.checkSignature(publicKey, signature);
    }

    private Signature getSignatureFromProvider(Provider provider, String string) throws NoSuchAlgorithmException {
        if (provider != null) {
            try {
                return Signature.getInstance(string, provider);
            }
            catch (Exception exception) {
                return Signature.getInstance(string);
            }
        }
        return Signature.getInstance(string);
    }

    private void checkSignature(PublicKey publicKey, Signature signature) throws CertificateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (!this.a(this.ocR.bMN(), this.ocR.bTd().bSW())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        aPJ aPJ2 = this.ocR.bMN().bRX();
        btM.a(signature, aPJ2);
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertificate());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("certificate does not verify with supplied key");
        }
    }

    private boolean a(aXE aXE2, aXE aXE3) {
        if (!aXE2.bRW().equals(aXE3.bRW())) {
            return false;
        }
        if (aXE2.bRX() == null) {
            return aXE3.bRX() == null || aXE3.bRX().equals(aQM.lxe);
        }
        if (aXE3.bRX() == null) {
            return aXE2.bRX() == null || aXE2.bRX().equals(aQM.lxe);
        }
        return aXE2.bRX().equals(aXE3.bRX());
    }

    private static Collection getAlternativeNames(byte[] byArray) throws CertificateParsingException {
        if (byArray == null) {
            return null;
        }
        try {
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = aQb.cs(byArray).getObjects();
            block11: while (enumeration.hasMoreElements()) {
                aYe aYe2 = aYe.hQ(enumeration.nextElement());
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                arrayList2.add(bBR.valueOf(aYe2.getTagNo()));
                switch (aYe2.getTagNo()) {
                    case 0: 
                    case 3: 
                    case 5: {
                        arrayList2.add(aYe2.getEncoded());
                        break;
                    }
                    case 4: {
                        arrayList2.add(aXu.a(aXB.mgN, aYe2.bTr()).toString());
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 6: {
                        arrayList2.add(((aQg)((Object)aYe2.bTr())).getString());
                        break;
                    }
                    case 8: {
                        arrayList2.add(aPV.cq(aYe2.bTr()).getId());
                        break;
                    }
                    case 7: {
                        String string;
                        byte[] byArray2 = aQO.cr(aYe2.bTr()).getOctets();
                        try {
                            string = InetAddress.getByAddress(byArray2).getHostAddress();
                        }
                        catch (UnknownHostException unknownHostException) {
                            continue block11;
                        }
                        arrayList2.add(string);
                        break;
                    }
                    default: {
                        throw new IOException("Bad tag number: " + aYe2.getTagNo());
                    }
                }
                arrayList.add(Collections.unmodifiableList(arrayList2));
            }
            if (arrayList.size() == 0) {
                return null;
            }
            return Collections.unmodifiableCollection(arrayList);
        }
        catch (Exception exception) {
            throw new CertificateParsingException(exception.getMessage());
        }
    }
}

