/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Drawing;

import com.aspose.html.utils.ms.System.Drawing.Point;
import com.aspose.html.utils.ms.System.Drawing.RectangleF;
import com.aspose.html.utils.ms.System.Drawing.Size;
import com.aspose.html.utils.ms.System.ObjectExtensions;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.msMath;
import com.aspose.html.utils.ms.lang.Struct;

public class Rectangle
extends Struct<Rectangle> {
    private java.awt.Rectangle b = new java.awt.Rectangle();
    public static Rectangle Empty = new Rectangle();

    public Rectangle() {
    }

    public Rectangle(java.awt.Rectangle rectangle) {
        this.b = rectangle;
    }

    public java.awt.Rectangle getNativeObject() {
        return this.b;
    }

    public static Rectangle ceiling(RectangleF rectangleF) {
        int n2 = (int)Math.ceil(rectangleF.getX());
        int n3 = (int)Math.ceil(rectangleF.getY());
        int n4 = (int)Math.ceil(rectangleF.getWidth());
        int n5 = (int)Math.ceil(rectangleF.getHeight());
        return new Rectangle(n2, n3, n4, n5);
    }

    public static Rectangle fromLTRB(int n2, int n3, int n4, int n5) {
        return new Rectangle(n2, n3, n4 - n2, n5 - n3);
    }

    public static Rectangle inflate(Rectangle rectangle, int n2, int n3) {
        Rectangle rectangle2 = new Rectangle(rectangle.getLocation().Clone(), rectangle.getSize().Clone());
        rectangle2.inflate(n2, n3);
        return rectangle2;
    }

    public void inflate(int n2, int n3) {
        this.inflate(new Size(n2, n3));
    }

    public void inflate(Size size) {
        this.b.x -= size.getWidth();
        this.b.y -= size.getHeight();
        this.setWidth(this.getWidth() + size.getWidth() * 2);
        this.setHeight(this.getHeight() + size.getHeight() * 2);
    }

    public static Rectangle intersect(Rectangle rectangle, Rectangle rectangle2) {
        if (!rectangle.a(rectangle2.Clone())) {
            return Empty;
        }
        return Rectangle.fromLTRB(Math.max(rectangle.getLeft(), rectangle2.getLeft()), Math.max(rectangle.getTop(), rectangle2.getTop()), Math.min(rectangle.getRight(), rectangle2.getRight()), Math.min(rectangle.getBottom(), rectangle2.getBottom()));
    }

    public void intersect(Rectangle rectangle) {
        Rectangle.intersect(this.Clone(), rectangle.Clone()).CloneTo(this);
    }

    public static Rectangle round(RectangleF rectangleF) {
        int n2 = (int)msMath.round(rectangleF.getX());
        int n3 = (int)msMath.round(rectangleF.getY());
        int n4 = (int)msMath.round(rectangleF.getWidth());
        int n5 = (int)msMath.round(rectangleF.getHeight());
        return new Rectangle(n2, n3, n4, n5);
    }

    public static Rectangle truncate(RectangleF rectangleF) {
        int n2 = (int)rectangleF.getX();
        int n3 = (int)rectangleF.getY();
        int n4 = (int)rectangleF.getWidth();
        int n5 = (int)rectangleF.getHeight();
        return new Rectangle(n2, n3, n4, n5);
    }

    public static Rectangle union(Rectangle rectangle, Rectangle rectangle2) {
        return Rectangle.fromLTRB(Math.min(rectangle.getLeft(), rectangle2.getLeft()), Math.min(rectangle.getTop(), rectangle2.getTop()), Math.max(rectangle.getRight(), rectangle2.getRight()), Math.max(rectangle.getBottom(), rectangle2.getBottom()));
    }

    public static boolean op_Equality(Rectangle rectangle, Rectangle rectangle2) {
        return Point.equals(rectangle.getLocation(), rectangle2.getLocation()) && Size.equals(rectangle.getSize(), rectangle2.getSize());
    }

    public static boolean op_Inequality(Rectangle rectangle, Rectangle rectangle2) {
        return !Point.equals(rectangle.getLocation(), rectangle2.getLocation()) || !Size.equals(rectangle.getSize(), rectangle2.getSize());
    }

    public Rectangle(Point point, Size size) {
        this.b = new java.awt.Rectangle(point.getX(), point.getY(), size.getWidth(), size.getHeight());
    }

    public Rectangle(int n2, int n3, int n4, int n5) {
        this.b = new java.awt.Rectangle(n2, n3, n4, n5);
    }

    public int getBottom() {
        return this.getY() + this.getHeight();
    }

    public int getHeight() {
        return this.b.height;
    }

    public void setHeight(int n2) {
        this.b.height = n2;
    }

    public boolean isEmpty() {
        return this.getX() == 0 && this.getY() == 0 && this.getWidth() == 0 && this.getHeight() == 0;
    }

    public int getLeft() {
        return this.getX();
    }

    public Point getLocation() {
        return new Point(this.getX(), this.getY());
    }

    public void setLocation(Point point) {
        this.b.x = point.getX();
        this.b.y = point.getY();
    }

    public int getRight() {
        return this.getX() + this.getWidth();
    }

    public Size getSize() {
        return new Size(this.getWidth(), this.getHeight());
    }

    public void setSize(Size size) {
        this.setWidth(size.getWidth());
        this.setHeight(size.getHeight());
    }

    public int getTop() {
        return this.getY();
    }

    public int getWidth() {
        return this.b.width;
    }

    public void setWidth(int n2) {
        this.b.width = n2;
    }

    public int getX() {
        return this.b.x;
    }

    public void setX(int n2) {
        this.b.x = n2;
    }

    public int getY() {
        return this.b.y;
    }

    public void setY(int n2) {
        this.b.y = n2;
    }

    public boolean contains(int n2, int n3) {
        return n2 >= this.getLeft() && n2 < this.getRight() && n3 >= this.getTop() && n3 < this.getBottom();
    }

    public boolean contains(Point point) {
        return this.contains(point.getX(), point.getY());
    }

    public boolean contains(Rectangle rectangle) {
        return Rectangle.equals(rectangle, Rectangle.intersect(this.Clone(), rectangle.Clone()));
    }

    public int hashCode() {
        return this.getHeight() + this.getWidth() ^ this.getX() + this.getY();
    }

    public boolean intersectsWith(Rectangle rectangle) {
        return this.getLeft() < rectangle.getRight() && this.getRight() > rectangle.getLeft() && this.getTop() < rectangle.getBottom() && this.getBottom() > rectangle.getTop();
    }

    private boolean a(Rectangle rectangle) {
        return this.getLeft() <= rectangle.getRight() && this.getRight() >= rectangle.getLeft() && this.getTop() <= rectangle.getBottom() && this.getBottom() >= rectangle.getTop();
    }

    public void offset(int n2, int n3) {
        this.b.x += n2;
        this.b.y += n3;
    }

    public void offset(Point point) {
        this.b.x += point.getX();
        this.b.y += point.getY();
    }

    public String toString() {
        return StringExtensions.format("{{X={0},Y={1},Width={2},Height={3}}}", this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    public void CloneTo(Rectangle rectangle) {
        rectangle.setX(this.getX());
        rectangle.setY(this.getY());
        rectangle.setWidth(this.getWidth());
        rectangle.setHeight(this.getHeight());
    }

    @Override
    public Rectangle Clone() {
        Rectangle rectangle = new Rectangle();
        this.CloneTo(rectangle);
        return rectangle;
    }

    public Object clone() {
        return this.Clone();
    }

    private boolean b(Rectangle rectangle) {
        return rectangle.getX() == this.getX() && rectangle.getY() == this.getY() && rectangle.getWidth() == this.getWidth() && rectangle.getHeight() == this.getHeight();
    }

    public boolean equals(Object object) {
        assert (object != null);
        if (ObjectExtensions.referenceEquals(null, object)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(this, object)) {
            return true;
        }
        if (!(object instanceof Rectangle)) {
            return false;
        }
        return this.b((Rectangle)object);
    }

    public static boolean equals(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle.equals(rectangle2);
    }

    public static Rectangle fromJava(java.awt.Rectangle rectangle) {
        if (rectangle == null) {
            return new Rectangle();
        }
        return new Rectangle(rectangle);
    }

    public static java.awt.Rectangle toJava(Rectangle rectangle) {
        if (rectangle == null) {
            return null;
        }
        return rectangle.b;
    }
}

