/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.ByteExtensions;
import com.aspose.html.utils.ms.System.Environment;
import com.aspose.html.utils.ms.System.NullReferenceException;
import com.aspose.html.utils.ms.System.Security.Cryptography.AsnEncodedData;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.utils.ms.System.Security.Cryptography.Oid;
import com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates.X509Extension;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.utils.ms.lang.Operators;

public final class X509KeyUsageExtension
extends X509Extension {
    public static final String oid = "2.5.29.15";
    public static final String friendlyName = "Key Usage";
    public static final int all = 33023;
    private int a;
    private int b;

    public X509KeyUsageExtension() {
        this._oid = new Oid(oid, friendlyName);
    }

    public X509KeyUsageExtension(AsnEncodedData asnEncodedData, boolean bl2) {
        if (asnEncodedData == null) {
            throw new NullReferenceException();
        }
        this._oid = new Oid(oid, friendlyName);
        this._raw = asnEncodedData.getRawData();
        super.setCritical(bl2);
        this.b = this.decode(this.getRawData());
    }

    public X509KeyUsageExtension(int n2, boolean bl2) {
        this._oid = new Oid(oid, friendlyName);
        super.setCritical(bl2);
        this.a = this.getValidFlags(n2);
        this.setRawData(this.encode());
    }

    public int getKeyUsages() {
        switch (this.b) {
            case 0: 
            case 4: {
                return this.a;
            }
        }
        throw new CryptographicException("Badly encoded extension.");
    }

    @Override
    public void copyFrom(AsnEncodedData asnEncodedData) {
        if (asnEncodedData == null) {
            throw new ArgumentNullException("encodedData");
        }
        X509Extension x509Extension = Operators.as(asnEncodedData, X509Extension.class);
        if (x509Extension == null) {
            throw new ArgumentException(StringExtensions.format("Wrong type.", new Object[0]), "encodedData");
        }
        this._oid = x509Extension._oid == null ? new Oid(oid, friendlyName) : new Oid(x509Extension._oid);
        this.setRawData(x509Extension.getRawData());
        super.setCritical(x509Extension.getCritical());
        this.b = this.decode(this.getRawData());
    }

    public int getValidFlags(int n2) {
        if ((n2 & 0x80FF) != n2) {
            return 0;
        }
        return n2;
    }

    public int decode(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return 1;
        }
        if (Operators.castToInt32(byArray[0], 6) != 3) {
            return 2;
        }
        if (byArray.length < 3) {
            return 3;
        }
        if (byArray.length < 4) {
            return 4;
        }
        try {
            ASN1 aSN1 = new ASN1(byArray);
            int n2 = 0;
            int n3 = 1;
            while (n3 < aSN1.getValue().length) {
                n2 = (n2 << 8) + Operators.castToInt32(aSN1.getValue()[n3++], 6);
            }
            this.a = this.getValidFlags(n2);
        }
        catch (RuntimeException runtimeException) {
            return 1;
        }
        return 0;
    }

    public byte[] encode() {
        ASN1 aSN1 = null;
        int n2 = this.a;
        byte by2 = 0;
        if (n2 == 0) {
            aSN1 = new ASN1(3, new byte[]{0});
        } else {
            int n3;
            int n4 = n3 = n2 < 255 ? n2 : n2 >> 8;
            while ((n3 & 1) == 0 && Operators.castToInt32(by2, 6) < 8) {
                by2 = (byte)(by2 + 1);
                n3 >>= 1;
            }
            aSN1 = n2 <= 255 ? new ASN1(3, new byte[]{by2, Operators.castToByte(n2, 9)}) : new ASN1(3, new byte[]{by2, Operators.castToByte(n2, 9), Operators.castToByte(n2 >> 8, 9)});
        }
        return aSN1.getBytes();
    }

    @Override
    public String toString(boolean bl2) {
        switch (this.b) {
            case 1: {
                return StringExtensions.Empty;
            }
            case 2: 
            case 3: {
                return this.formatUnkownData(this._raw);
            }
            case 4: {
                return "Information Not Available";
            }
        }
        if (!oid.equals(this._oid.getValue())) {
            return StringExtensions.format("Unknown Key Usage ({0})", this._oid.getValue());
        }
        if (this.a == 0) {
            return "Information Not Available";
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        if ((this.a & 0x80) != 0) {
            msStringBuilder2.append("Digital Signature");
        }
        if ((this.a & 0x40) != 0) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(", ");
            }
            msStringBuilder2.append("Non-Repudiation");
        }
        if ((this.a & 0x20) != 0) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(", ");
            }
            msStringBuilder2.append("Key Encipherment");
        }
        if ((this.a & 0x10) != 0) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(", ");
            }
            msStringBuilder2.append("Data Encipherment");
        }
        if ((this.a & 8) != 0) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(", ");
            }
            msStringBuilder2.append("Key Agreement");
        }
        if ((this.a & 4) != 0) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(", ");
            }
            msStringBuilder2.append("Certificate Signing");
        }
        if ((this.a & 2) != 0) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(", ");
            }
            msStringBuilder2.append("Off-line CRL Signing, CRL Signing");
        }
        if ((this.a & 1) != 0) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(", ");
            }
            msStringBuilder2.append("Encipher Only");
        }
        if ((this.a & 0x8000) != 0) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(", ");
            }
            msStringBuilder2.append("Decipher Only");
        }
        int n2 = this.a;
        msStringBuilder2.append(" (");
        msStringBuilder2.append(ByteExtensions.toString(Operators.castToByte(n2, 9), "x2"));
        if (n2 > 255) {
            msStringBuilder2.append(" ");
            msStringBuilder2.append(ByteExtensions.toString(Operators.castToByte(n2 >> 8, 9), "x2"));
        }
        msStringBuilder2.append(")");
        if (bl2) {
            msStringBuilder2.append(Environment.get_NewLine());
        }
        return msStringBuilder2.toString();
    }
}

