/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Text.RegularExpressions;

import com.aspose.html.utils.I;
import com.aspose.html.utils.collections.generic.List;
import com.aspose.html.utils.ms.System.Text.RegularExpressions.Group;
import com.aspose.html.utils.ms.System.Text.RegularExpressions.GroupCollection;
import com.aspose.html.utils.ms.System.Text.RegularExpressions.java.JavaRegExpMatcher;
import com.aspose.html.utils.ms.System.Text.RegularExpressions.java.RegExp;
import com.aspose.html.utils.ms.System.Text.RegularExpressions.java.RegExpMatcher;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;

public class Match
extends Group {
    private RegExpMatcher mMatcher;
    private int _textstart;
    private boolean mSuccess;
    private GroupCollection mGroups;

    Match(RegExp regExp, String string) {
        super(string, regExp.getSource(), false);
        this.mMatcher = regExp.match(string);
        this.mSuccess = this.find();
    }

    Match(RegExp regExp, String string, int n2) {
        this(regExp, string, n2, 0);
    }

    Match(RegExp regExp, String string, int n2, int n3) {
        super(string, regExp.getSource(), false);
        this.mMatcher = regExp.match(string);
        this._textstart = n3;
        this.mSuccess = this.find(n2);
    }

    private Match(RegExpMatcher regExpMatcher) {
        super(regExpMatcher.group(), false);
        this.mMatcher = regExpMatcher;
        this.mSuccess = this.find();
    }

    private boolean find() {
        if (I.a.Fl.ah() && this.mMatcher.find()) {
            boolean bl2 = this.mMatcher.group().equals(".");
            boolean bl3 = this.mMatcher.start() == 1;
            boolean bl4 = bl2 && bl3;
            return !bl4;
        }
        return this.mMatcher.find();
    }

    private boolean find(int n2) {
        return this.mMatcher.find(n2);
    }

    public GroupCollection getGroups() {
        if (this.mGroups == null) {
            List<String> list = this.createSubGroups();
            this.mGroups = new GroupCollection(this, list);
        }
        return this.mGroups;
    }

    private List<String> createSubGroups() {
        String string = this.groupRegexp;
        List<String> list = new List<String>();
        int n2 = 0;
        List<BracePair> list2 = new List<BracePair>();
        BracePair bracePair = new BracePair();
        int n3 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == '[' && !this.isTreatedAsOrdinaryChar(string, i2)) {
                ++n3;
                continue;
            }
            if (string.charAt(i2) == ']' && !this.isTreatedAsOrdinaryChar(string, i2)) {
                --n3;
                continue;
            }
            if (n3 > 0) continue;
            if (string.charAt(i2) == '(') {
                if (++n2 > 1 || i2 > 0 && string.charAt(i2 - 1) == '\\' || string.charAt(i2 + 1) == '?' || i2 > 0 && string.charAt(i2 - 1) == '\\' && i2 > 1 && string.charAt(i2 - 2) != '\\') continue;
                bracePair.openBrace = i2 + 1;
                continue;
            }
            if (string.charAt(i2) != ')' || --n2 > 0 || string.charAt(i2 - 1) == '\\' && string.charAt(i2 - 2) != '\\' || bracePair.openBrace < 0) continue;
            bracePair.closeBrace = i2;
            list2.add(bracePair);
            bracePair = new BracePair();
        }
        list.addItem(string);
        for (BracePair bracePair2 : list2) {
            list.add(string.substring(bracePair2.openBrace, bracePair2.closeBrace));
        }
        return list;
    }

    private boolean isTreatedAsOrdinaryChar(String string, int n2) {
        boolean bl2 = false;
        while (--n2 >= 0 && string.charAt(n2) == '\\') {
            bl2 = !bl2;
        }
        return bl2;
    }

    @Override
    public boolean getSuccess() {
        return this.mSuccess;
    }

    @Override
    public int getIndex() {
        return this.mMatcher.start() + this._textstart;
    }

    @Override
    public int getLength() {
        return this.mMatcher.end() - this.mMatcher.start();
    }

    @Override
    public String getValue() {
        return this.mMatcher.group();
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    public Match nextMatch() {
        return new Match(this.mMatcher);
    }

    public static Matcher toJava(Match match) {
        if (match == null) {
            return null;
        }
        if (match.mMatcher.getMatcher() instanceof Matcher) {
            return (Matcher)match.mMatcher.getMatcher();
        }
        throw new IllegalArgumentException("Can't extract java.util.regex.Matcher from this type of Match");
    }

    public static MatchResult toJava2(Match match) {
        return match.mMatcher;
    }

    public static Match fromJava(Matcher matcher) {
        if (matcher == null) {
            return null;
        }
        return new Match(new JavaRegExpMatcher(matcher));
    }

    class BracePair {
        private int openBrace;
        private int closeBrace;

        private BracePair() {
            this.openBrace = -1;
            this.closeBrace = -1;
        }

        private BracePair(int n2, int n3) {
            this.openBrace = n2;
            this.closeBrace = n3;
        }
    }
}

