/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Text.RegularExpressions.java;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.Diagnostics.Debug;

public class PatternUtils {
    private static final String identifier_chars = "\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]";
    public static final String identifier_charclass = "[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]]";
    public static final String not_identifier_charclass = "[^\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]]";
    private static final String boundary_after_not_word = "(?=[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])";
    private static final String not_boundary_after_word = "(?=[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])";
    public static final String precedes_word = "(?=[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])";
    private static final String boundary_after_word = "(?![\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])";
    private static final String not_boundary_after_not_word = "(?![\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])";
    public static final String not_precedes_word = "(?![\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])";
    private static final String boundary_before_not_word = "(?<=[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])";
    private static final String not_boundary_before_word = "(?<=[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])";
    public static final String follows_word = "(?<=[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])";
    private static final String boundary_before_word = "(?<![\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])";
    private static final String not_boundary_before_not_word = "(?<![\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])";
    public static final String not_follows_word = "(?<![\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])";
    public static final String boundary = "(?:(?<=[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])(?![\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])|(?<![\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])(?=[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]]))";
    public static final String not_boundary = "(?:(?<=[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])(?=[\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])|(?<![\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]])(?![\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]]))";
    private static final String whitespace_chars = "\\u000A\\u000B\\u000C\\u000D\\u0020\\u0085\\u00A0\\u1680\\u180E\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200A\\u2028\\u2029\\u202F\\u205F\\u3000";
    public static final String whitespace_charclass = "[\\u000A\\u000B\\u000C\\u000D\\u0020\\u0085\\u00A0\\u1680\\u180E\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200A\\u2028\\u2029\\u202F\\u205F\\u3000]";
    public static final String not_whitespace_charclass = "[^\\u000A\\u000B\\u000C\\u000D\\u0020\\u0085\\u00A0\\u1680\\u180E\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200A\\u2028\\u2029\\u202F\\u205F\\u3000]";
    public static final String space_edge_left = "(?:(?<=^)|(?<=[\\u000A\\u000B\\u000C\\u000D\\u0020\\u0085\\u00A0\\u1680\\u180E\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200A\\u2028\\u2029\\u202F\\u205F\\u3000]))";
    public static final String space_edge_right = "(?=$|[\\u000A\\u000B\\u000C\\u000D\\u0020\\u0085\\u00A0\\u1680\\u180E\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200A\\u2028\\u2029\\u202F\\u205F\\u3000])";
    private static final String alphabetic_chars = "\\pL\\pM\\p{Nl}";
    public static final String alphabetic_charclass = "[\\pL\\pM\\p{Nl}]";
    public static final String not_alphabetic_charclass = "[^\\pL\\pM\\p{Nl}]";
    public static final String digits_charclass = "\\p{Nd}";
    public static final String not_digits_charclass = "\\P{Nd}";
    private static final String hyphen_chars = "\\u002D\\u00AD\\u058A\\u1806\\u2010\\u2011\\u2E17\\u30FB\\uFE63\\uFF0D\\uFF65";
    public static final String hyphen_charclass = "[\\u002D\\u00AD\\u058A\\u1806\\u2010\\u2011\\u2E17\\u30FB\\uFE63\\uFF0D\\uFF65]";
    public static final String not_hyphen_charclass = "[^\\u002D\\u00AD\\u058A\\u1806\\u2010\\u2011\\u2E17\\u30FB\\uFE63\\uFF0D\\uFF65]";
    private static final String dash_chars = "\\u002D\\u058A\\u05BE\\u1400\\u1806\\u2010\\u2011\\u2012\\u2013\\u2014\\u2015\\u2053\\u207B\\u208B\\u2212\\u2E17\\u2E1A\\u301C\\u3030\\u30A0\\uFE31\\uFE32\\uFE58\\uFE63\\uFF0D";
    public static final String dash_charclass = "[\\u002D\\u058A\\u05BE\\u1400\\u1806\\u2010\\u2011\\u2012\\u2013\\u2014\\u2015\\u2053\\u207B\\u208B\\u2212\\u2E17\\u2E1A\\u301C\\u3030\\u30A0\\uFE31\\uFE32\\uFE58\\uFE63\\uFF0D]";
    public static final String not_dash_charclass = "[^\\u002D\\u058A\\u05BE\\u1400\\u1806\\u2010\\u2011\\u2012\\u2013\\u2014\\u2015\\u2053\\u207B\\u208B\\u2212\\u2E17\\u2E1A\\u301C\\u3030\\u30A0\\uFE31\\uFE32\\uFE58\\uFE63\\uFF0D]";
    private static final String quotation_mark_chars = "\\u0022\\u0027\\u00AB\\u00BB\\u2018\\u2019\\u201A\\u201B\\u201C\\u201D\\u201E\\u201F\\u2039\\u203A\\u300C\\u300D\\u300E\\u300F\\u301D\\u301E\\u301F\\uFE41\\uFE42\\uFE43\\uFE44\\uFF02\\uFF07\\uFF62\\uFF63";
    public static final String quotation_mark_charclass = "[\\u0022\\u0027\\u00AB\\u00BB\\u2018\\u2019\\u201A\\u201B\\u201C\\u201D\\u201E\\u201F\\u2039\\u203A\\u300C\\u300D\\u300E\\u300F\\u301D\\u301E\\u301F\\uFE41\\uFE42\\uFE43\\uFE44\\uFF02\\uFF07\\uFF62\\uFF63]";
    public static final String not_quotation_mark_charclass = "[^\\u0022\\u0027\\u00AB\\u00BB\\u2018\\u2019\\u201A\\u201B\\u201C\\u201D\\u201E\\u201F\\u2039\\u203A\\u300C\\u300D\\u300E\\u300F\\u301D\\u301E\\u301F\\uFE41\\uFE42\\uFE43\\uFE44\\uFF02\\uFF07\\uFF62\\uFF63]";
    private static final String apostrophic_chars = "\\u0027\\u02BC\\u2019";
    public static final String apostrophic_charclass = "[\\u0027\\u02BC\\u2019]";
    public static final String not_apostrophic_charclass = "[^\\u0027\\u02BC\\u2019]";
    private static final String natural_word_chars = "\\pL\\pM\\p{Nl}\\u0027\\u02BC\\u2019\\u002D\\u058A\\u05BE\\u1400\\u1806\\u2010\\u2011\\u2012\\u2013\\u2014\\u2015\\u2053\\u207B\\u208B\\u2212\\u2E17\\u2E1A\\u301C\\u3030\\u30A0\\uFE31\\uFE32\\uFE58\\uFE63\\uFF0D";
    public static final String natural_word_charclass = "[\\pL\\pM\\p{Nl}\\u0027\\u02BC\\u2019\\u002D\\u058A\\u05BE\\u1400\\u1806\\u2010\\u2011\\u2012\\u2013\\u2014\\u2015\\u2053\\u207B\\u208B\\u2212\\u2E17\\u2E1A\\u301C\\u3030\\u30A0\\uFE31\\uFE32\\uFE58\\uFE63\\uFF0D]";
    public static final String not_natural_word_charclass = "[^\\pL\\pM\\p{Nl}\\u0027\\u02BC\\u2019\\u002D\\u058A\\u05BE\\u1400\\u1806\\u2010\\u2011\\u2012\\u2013\\u2014\\u2015\\u2053\\u207B\\u208B\\u2212\\u2E17\\u2E1A\\u301C\\u3030\\u30A0\\uFE31\\uFE32\\uFE58\\uFE63\\uFF0D]";
    private static final String vertical_whitespace_chars = "\\u000A\\u000B\\u000C\\u000D\\u0085\\u2028\\u2029";
    public static final String vertical_whitespace_charclass = "[\\u000A\\u000B\\u000C\\u000D\\u0085\\u2028\\u2029]";
    public static final String not_vertical_whitespace_charclass = "[^\\u000A\\u000B\\u000C\\u000D\\u0085\\u2028\\u2029]";
    private static final String horizontal_whitespace_chars = "\\u0009\\u0020\\u00A0\\u1680\\u180E\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200A\\u202F\\u205F\\u3000";
    public static final String horizontal_whitespace_charclass = "[\\u0009\\u0020\\u00A0\\u1680\\u180E\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200A\\u202F\\u205F\\u3000]";
    public static final String not_horizontal_whitespace_charclass = "[^\\u0009\\u0020\\u00A0\\u1680\\u180E\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200A\\u202F\\u205F\\u3000]";
    public static final String linebreak = "(?:(?>\\u000D\\u000A)|[\\u000A\\u000B\\u000C\\u000D\\u0085\\u2028\\u2029])";
    public static final String legacy_grapheme_cluster = "(?>\\PM\\pM*)";
    private static final String GCB_CR = "\\u000D";
    private static final String GCB_LF = "\\u000A";
    private static final String GCB_CRLF = "\\u000D\\u000A";
    private static final String GCB_Control = "[\\p{Zl}\\p{Zp}\\p{Cc}\\p{Cf}&&[^\\u000D\\u000A\\u200C\\u200D]]";
    private static final String GCB_Extend = "[\\p{Mn}\\p{Me}\\u200C\\u200D\\u0488\\u0489\\u20DD\\u20DE\\u20DF\\u20E0\\u20E2\\u20E3\\u20E4\\uA670\\uA671\\uA672\\uFF9E\\uFF9F]";
    private static final String GCB_Prepend = "[\\u0E40\\u0E41\\u0E42\\u0E43\\u0E44\\u0EC0\\u0EC1\\u0EC2\\u0EC3\\u0EC4\\uAAB5\\uAAB6\\uAAB9\\uAABB\\uAABC]";
    private static final String GCB_Spacing_Mark = "[\\p{Mc}\\u0E30\\u0E32\\u0E33\\u0E45\\u0EB0\\u0EB2\\u0EB3]";
    private static final String GCB_L = "[\\u1100-\\u115F\\uA960-\\uA97C]";
    private static final String GCB_V = "[\\u1160-\\u11A2\\uD7B0-\\uD7C6]";
    private static final String GCB_T = "[\\u11A8-\\u11F9\\uD7CB-\\uD7FB]";
    private static final String GCB_LV = "[\\uAC00\\uAC1C\\uAC38]";
    private static final String GCB_LVT = "[\\uAC01\\uAC02\\uAC03\\uAC04]";
    public static final String extended_grapheme_cluster = "(?:(?:\\u000D\\u000A)|(?:[\\u0E40\\u0E41\\u0E42\\u0E43\\u0E44\\u0EC0\\u0EC1\\u0EC2\\u0EC3\\u0EC4\\uAAB5\\uAAB6\\uAAB9\\uAABB\\uAABC]*(?:[\\u1100-\\u115F\\uA960-\\uA97C]+|([\\u1100-\\u115F\\uA960-\\uA97C]*((?:[[\\u1160-\\u11A2\\uD7B0-\\uD7C6][\\uAC00\\uAC1C\\uAC38]][\\u1160-\\u11A2\\uD7B0-\\uD7C6]*|[\\uAC01\\uAC02\\uAC03\\uAC04])[\\u11A8-\\u11F9\\uD7CB-\\uD7FB]*))|[\\u11A8-\\u11F9\\uD7CB-\\uD7FB]+|[^[\\p{Zl}\\p{Zp}\\p{Cc}\\p{Cf}&&[^\\u000D\\u000A\\u200C\\u200D]]\\u000D\\u000A])[[\\p{Mn}\\p{Me}\\u200C\\u200D\\u0488\\u0489\\u20DD\\u20DE\\u20DF\\u20E0\\u20E2\\u20E3\\u20E4\\uA670\\uA671\\uA672\\uFF9E\\uFF9F][\\p{Mc}\\u0E30\\u0E32\\u0E33\\u0E45\\u0EB0\\u0EB2\\u0EB3]]*)|(?s:.))";

    public static final String unicode_charclass(String string) {
        int n2;
        int n3 = string.length();
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (string.charAt(n2) != '\\') continue;
            n3 += 100;
        }
        StringBuffer stringBuffer = new StringBuffer(n3);
        n3 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            int n4 = string.codePointAt(n2);
            if (string.codePointAt(n2) > 65535) {
                ++n2;
            }
            if (n3 == 0) {
                if (n4 == 92) {
                    n3 = 1;
                    continue;
                }
                stringBuffer.append(Character.toChars(n4));
                continue;
            }
            if (n4 == 92) {
                n3 = 0;
                stringBuffer.append("\\\\");
                continue;
            }
            switch (n4) {
                case 119: {
                    stringBuffer.append(identifier_charclass);
                    break;
                }
                default: {
                    stringBuffer.append('\\');
                    stringBuffer.append(Character.toChars(n4));
                }
            }
            n3 = 0;
        }
        if (n3 != 0) {
            stringBuffer.append('\\');
        }
        return stringBuffer.toString();
    }

    public static final String unescape_perl_string(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl2 = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n2 = string.codePointAt(i2);
            if (string.codePointAt(i2) > 65535) {
                ++i2;
            }
            if (!bl2) {
                if (n2 == 92) {
                    bl2 = true;
                    continue;
                }
                stringBuffer.append(Character.toChars(n2));
                continue;
            }
            if (n2 == 92) {
                bl2 = false;
                stringBuffer.append("\\\\");
                continue;
            }
            switch (n2) {
                case 114: {
                    stringBuffer.append('\r');
                    break;
                }
                case 110: {
                    stringBuffer.append('\n');
                    break;
                }
                case 102: {
                    stringBuffer.append('\f');
                    break;
                }
                case 98: {
                    stringBuffer.append('\b');
                    break;
                }
                case 116: {
                    stringBuffer.append('\t');
                    break;
                }
                case 97: {
                    stringBuffer.append('\u0007');
                    break;
                }
                case 101: {
                    stringBuffer.append('\u001b');
                    break;
                }
                case 99: {
                    if (++i2 == string.length()) {
                        PatternUtils.die("trailing \\c");
                    }
                    if ((n2 = string.codePointAt(i2)) > 127) {
                        PatternUtils.die("expected ASCII after \\c");
                    }
                    stringBuffer.append(Character.toChars(n2 ^ 0x40));
                    break;
                }
                case 56: 
                case 57: {
                    PatternUtils.die("illegal octal digit");
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    --i2;
                }
                case 48: {
                    int n3;
                    int n4;
                    if (i2 + 1 == string.length()) {
                        stringBuffer.append(Character.toChars(0));
                        break;
                    }
                    ++i2;
                    int n5 = 0;
                    for (n4 = 0; n4 <= 2 && i2 + n4 != string.length() && (n3 = string.charAt(i2 + n4)) >= 48 && n3 <= 55; ++n4) {
                        ++n5;
                    }
                    if (n5 == 0) {
                        --i2;
                        stringBuffer.append('\u0000');
                        break;
                    }
                    n3 = 0;
                    try {
                        n3 = Integer.parseInt(string.substring(i2, i2 + n5), 8);
                    }
                    catch (NumberFormatException numberFormatException) {
                        PatternUtils.die("invalid octal value for \\0 escape");
                    }
                    stringBuffer.append(Character.toChars(n3));
                    i2 += n5 - 1;
                    break;
                }
                case 120: {
                    int n4;
                    if (i2 + 2 > string.length()) {
                        PatternUtils.die("string too short for \\x escape");
                    }
                    int n5 = 0;
                    if (string.charAt(++i2) == '{') {
                        ++i2;
                        n5 = 1;
                    }
                    for (n4 = 0; n4 < 8 && (n5 != 0 || n4 != 2); ++n4) {
                        char c2 = string.charAt(i2 + n4);
                        if (c2 > '\u007f') {
                            PatternUtils.die("illegal non-ASCII hex digit in \\x escape");
                        }
                        if (n5 != 0 && c2 == '}') break;
                        if (c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F') continue;
                        PatternUtils.die(String.format("illegal hex digit #%d '%c' in \\x", c2, (int)c2));
                    }
                    if (n4 == 0) {
                        PatternUtils.die("empty braces in \\x{} escape");
                    }
                    int n6 = 0;
                    try {
                        n6 = Integer.parseInt(string.substring(i2, i2 + n4), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        PatternUtils.die("invalid hex value for \\x escape");
                    }
                    stringBuffer.append(Character.toChars(n6));
                    if (n5 != 0) {
                        ++n4;
                    }
                    i2 += n4 - 1;
                    break;
                }
                case 117: {
                    int n5;
                    if (i2 + 4 > string.length()) {
                        PatternUtils.die("string too short for \\u escape");
                    }
                    ++i2;
                    for (n5 = 0; n5 < 4; ++n5) {
                        if (string.charAt(i2 + n5) <= '\u007f') continue;
                        PatternUtils.die("illegal non-ASCII hex digit in \\u escape");
                    }
                    int n4 = 0;
                    try {
                        n4 = Integer.parseInt(string.substring(i2, i2 + n5), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        PatternUtils.die("invalid hex value for \\u escape");
                    }
                    stringBuffer.append(Character.toChars(n4));
                    i2 += n5 - 1;
                    break;
                }
                case 85: {
                    int n5;
                    if (i2 + 8 > string.length()) {
                        PatternUtils.die("string too short for \\U escape");
                    }
                    ++i2;
                    for (n5 = 0; n5 < 8; ++n5) {
                        if (string.charAt(i2 + n5) <= '\u007f') continue;
                        PatternUtils.die("illegal non-ASCII hex digit in \\U escape");
                    }
                    int n4 = 0;
                    try {
                        n4 = Integer.parseInt(string.substring(i2, i2 + n5), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        PatternUtils.die("invalid hex value for \\U escape");
                    }
                    stringBuffer.append(Character.toChars(n4));
                    i2 += n5 - 1;
                    break;
                }
                default: {
                    stringBuffer.append('\\');
                    stringBuffer.append(Character.toChars(n2));
                }
            }
            bl2 = false;
        }
        if (bl2) {
            stringBuffer.append('\\');
        }
        return stringBuffer.toString();
    }

    public static final String uniplus(String string) {
        if (string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(2 + 3 * string.length());
        stringBuffer.append("U+");
        for (int i2 = 0; i2 < string.length(); ++i2) {
            stringBuffer.append(String.format("%02X", string.codePointAt(i2)));
            if (string.codePointAt(i2) > 65535) {
                ++i2;
            }
            if (i2 + 1 >= string.length()) continue;
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    private static final void die(String string) {
        throw new ArgumentException(string);
    }

    private static final void say(String string) {
        Debug.print(string);
    }
}

