/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Xml;

import com.aspose.html.utils.ms.System.Exception;
import com.aspose.html.utils.ms.System.Guid;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Xml.ValidationEventHandler;
import com.aspose.html.utils.ms.System.Xml.XmlQualifiedName;
import com.aspose.html.utils.ms.System.Xml.XmlSchema;
import com.aspose.html.utils.ms.System.Xml.XmlSchemaAnnotated;
import com.aspose.html.utils.ms.System.Xml.XmlSchemaAnnotation;
import com.aspose.html.utils.ms.System.Xml.XmlSchemaComplexType;
import com.aspose.html.utils.ms.System.Xml.XmlSchemaDatatype;
import com.aspose.html.utils.ms.System.Xml.XmlSchemaObject;
import com.aspose.html.utils.ms.System.Xml.XmlSchemaReader;
import com.aspose.html.utils.ms.System.Xml.XmlSchemaSimpleType;
import com.aspose.html.utils.ms.System.Xml.XmlSchemaType;
import com.aspose.html.utils.ms.System.Xml.XmlSchemaUtil;

public class XmlSchemaAttribute
extends XmlSchemaAnnotated {
    private Object a;
    private XmlSchemaSimpleType b;
    private String c;
    private String d;
    private String e;
    private String f;
    private Object g;
    private int h = 0;
    private String i;
    private String j;
    private XmlQualifiedName k;
    private XmlQualifiedName l;
    private XmlSchemaSimpleType m;
    private XmlQualifiedName n = XmlQualifiedName.Empty;
    private int o = 0;
    private int p;
    private XmlSchemaAttribute q;
    private static final String r = "attribute";

    boolean getParentIsSchema() {
        return this.getParent() instanceof XmlSchema;
    }

    public XmlSchemaAttribute() {
        this.k = XmlQualifiedName.Empty;
        this.l = XmlQualifiedName.Empty;
    }

    public String getDefaultValue() {
        return this.c;
    }

    public void setDefaultValue(String string) {
        this.d = null;
        this.c = string;
    }

    public String getFixedValue() {
        return this.d;
    }

    public void setFixedValue(String string) {
        this.c = null;
        this.d = string;
    }

    public int getForm() {
        return this.h;
    }

    public void setForm(int n2) {
        this.h = n2;
    }

    public String getName() {
        return this.i;
    }

    public void setName(String string) {
        this.i = string;
    }

    public XmlQualifiedName getRefName() {
        return this.l;
    }

    public void setRefName(XmlQualifiedName xmlQualifiedName) {
        this.l = xmlQualifiedName;
    }

    public XmlQualifiedName getSchemaTypeName() {
        return this.n;
    }

    public void setSchemaTypeName(XmlQualifiedName xmlQualifiedName) {
        this.n = xmlQualifiedName;
    }

    public XmlSchemaSimpleType getSchemaType() {
        return this.m;
    }

    public void setSchemaType(XmlSchemaSimpleType xmlSchemaSimpleType) {
        this.m = xmlSchemaSimpleType;
    }

    public int getUse() {
        return this.o;
    }

    public void setUse(int n2) {
        this.o = n2;
    }

    public XmlQualifiedName getQualifiedName() {
        return this.k;
    }

    public Object getAttributeType() {
        if (this.q != null) {
            return this.q.getAttributeType();
        }
        return this.a;
    }

    public XmlSchemaSimpleType getAttributeSchemaType() {
        if (this.q != null) {
            return this.q.getAttributeSchemaType();
        }
        return this.b;
    }

    String getValidatedDefaultValue() {
        return this.e;
    }

    String getValidatedFixedValue() {
        return this.f;
    }

    Object getValidatedFixedTypedValue() {
        return this.g;
    }

    int getValidatedUse() {
        return this.p;
    }

    @Override
    void setParent(XmlSchemaObject xmlSchemaObject) {
        super.setParent(xmlSchemaObject);
        if (this.m != null) {
            this.m.setParent(this);
        }
    }

    @Override
    int compile(ValidationEventHandler validationEventHandler, XmlSchema xmlSchema) {
        if (Guid.op_Equality(this.getCompilationId(), xmlSchema.getCompilationId())) {
            return 0;
        }
        this.errorCount = 0;
        if (this.getParentIsSchema() || this.isRedefineChild) {
            if (this.getRefName() != null && !this.getRefName().isEmpty()) {
                this.error(validationEventHandler, "ref must be absent in the top level <attribute>");
            }
            if (this.getForm() != 0) {
                this.error(validationEventHandler, "form must be absent in the top level <attribute>");
            }
            if (this.getUse() != 0) {
                this.error(validationEventHandler, "use must be absent in the top level <attribute>");
            }
            this.j = this.getAncestorSchema().getTargetNamespace();
            this.a(validationEventHandler, xmlSchema, true);
        } else if (this.getRefName() == null || this.getRefName().isEmpty()) {
            this.j = this.h == 1 || this.h == 0 && xmlSchema.getAttributeFormDefault() == 1 ? this.getAncestorSchema().getTargetNamespace() : "";
            this.a(validationEventHandler, xmlSchema, true);
        } else {
            if (this.i != null) {
                this.error(validationEventHandler, "name must be absent if ref is present");
            }
            if (this.h != 0) {
                this.error(validationEventHandler, "form must be absent if ref is present");
            }
            if (this.m != null) {
                this.error(validationEventHandler, "simpletype must be absent if ref is present");
            }
            if (this.n != null && !this.n.isEmpty()) {
                this.error(validationEventHandler, "type must be absent if ref is present");
            }
            this.a(validationEventHandler, xmlSchema, false);
        }
        this.setCompilationId(xmlSchema.getCompilationId().Clone());
        return this.errorCount;
    }

    private void a(ValidationEventHandler validationEventHandler, XmlSchema xmlSchema, boolean bl2) {
        if (bl2) {
            if (this.getName() == null) {
                this.error(validationEventHandler, "Required attribute name must be present");
            } else if (!XmlSchemaUtil.checkNCName(this.getName())) {
                this.error(validationEventHandler, "attribute name must be NCName");
            } else if ("xmlns".equals(this.getName())) {
                this.error(validationEventHandler, "attribute name must not be xmlns");
            } else {
                this.k = new XmlQualifiedName(this.getName(), this.j);
            }
            if (this.getSchemaType() != null) {
                if (this.getSchemaTypeName() != null && !this.getSchemaTypeName().isEmpty()) {
                    this.error(validationEventHandler, "attribute can't have both a type and <simpleType> content");
                }
                this.errorCount += this.getSchemaType().compile(validationEventHandler, xmlSchema);
            }
            if (this.getSchemaTypeName() != null && !XmlSchemaUtil.checkQName(this.getSchemaTypeName())) {
                this.error(validationEventHandler, this.getSchemaTypeName() + " is not a valid QName");
            }
        } else {
            if (this.getRefName() == null || this.getRefName().isEmpty()) {
                throw new InvalidOperationException("Error: Should Never Happen. refname must be present");
            }
            this.k = this.getRefName();
        }
        if (!(!"http://www.w3.org/2001/XMLSchema-instance".equals(this.getAncestorSchema().getTargetNamespace()) || "nil".equals(this.getName()) || "type".equals(this.getName()) || "schemaLocation".equals(this.getName()) || "noNamespaceSchemaLocation".equals(this.getName()))) {
            this.error(validationEventHandler, StringExtensions.concat("targetNamespace can't be ", "http://www.w3.org/2001/XMLSchema-instance"));
        }
        if (this.getDefaultValue() != null && this.getFixedValue() != null) {
            this.error(validationEventHandler, "default and fixed must not both be present in an Attribute");
        }
        if (this.getDefaultValue() != null && this.getUse() != 0 && this.getUse() != 1) {
            this.error(validationEventHandler, "if default is present, use must be optional");
        }
        XmlSchemaUtil.compileID(this.getId(), this, xmlSchema.getIDCollection(), validationEventHandler);
    }

    @Override
    int validate(ValidationEventHandler validationEventHandler, XmlSchema xmlSchema) {
        Object object;
        if (this.isValidated(xmlSchema.ValidationId.Clone())) {
            return this.errorCount;
        }
        if (this.getSchemaType() != null) {
            this.getSchemaType().validate(validationEventHandler, xmlSchema);
            this.a = this.getSchemaType();
        } else if (this.getSchemaTypeName() != null && XmlQualifiedName.op_Inequality(this.getSchemaTypeName(), XmlQualifiedName.Empty)) {
            object = xmlSchema.findSchemaType(this.getSchemaTypeName());
            if (object instanceof XmlSchemaComplexType) {
                this.error(validationEventHandler, "An attribute can't have complexType Content");
            } else if (object != null) {
                this.errorCount += ((XmlSchemaObject)object).validate(validationEventHandler, xmlSchema);
                this.a = object;
            } else if (XmlQualifiedName.op_Equality(this.getSchemaTypeName(), XmlSchemaComplexType.AnyTypeName)) {
                this.a = XmlSchemaComplexType.getAnyType();
            } else if (XmlSchemaUtil.isBuiltInDatatypeName(this.getSchemaTypeName())) {
                this.a = XmlSchemaDatatype.fromName(this.getSchemaTypeName());
                if (this.a == null) {
                    this.error(validationEventHandler, "Invalid xml schema namespace datatype was specified.");
                }
            } else if (!xmlSchema.isNamespaceAbsent(this.getSchemaTypeName().getNamespace())) {
                this.error(validationEventHandler, StringExtensions.concat("Referenced schema type ", this.getSchemaTypeName(), " was not found in the corresponding schema."));
            }
        }
        if (this.getRefName() != null && XmlQualifiedName.op_Inequality(this.getRefName(), XmlQualifiedName.Empty)) {
            this.q = xmlSchema.findAttribute(this.getRefName());
            if (this.q != null) {
                this.errorCount += this.q.validate(validationEventHandler, xmlSchema);
            } else if (!xmlSchema.isNamespaceAbsent(this.getRefName().getNamespace())) {
                this.error(validationEventHandler, StringExtensions.concat("Referenced attribute ", this.getRefName(), " was not found in the corresponding schema."));
            }
        }
        if (this.a == null) {
            this.a = XmlSchemaSimpleType.getAnySimpleType();
        }
        if (this.c != null || this.d != null) {
            Object object2 = object = this.a instanceof XmlSchemaDatatype ? (XmlSchemaDatatype)this.a : null;
            if (object == null) {
                object = ((XmlSchemaSimpleType)this.a).getDatatype();
            }
            if (((XmlSchemaDatatype)object).getTokenizedType() == 10) {
                this.error(validationEventHandler, "By the defection of the W3C XML Schema specification, it is impossible to supply QName default or fixed values.");
            } else {
                try {
                    if (this.c != null) {
                        this.e = ((XmlSchemaDatatype)object).normalize(this.c);
                        ((XmlSchemaDatatype)object).parseValue(this.e, null, null);
                    }
                }
                catch (Exception exception) {
                    XmlSchemaAttribute.error(validationEventHandler, "The Attribute's default value is invalid with its type definition.", exception);
                }
                try {
                    if (this.d != null) {
                        this.f = ((XmlSchemaDatatype)object).normalize(this.d);
                        this.g = ((XmlSchemaDatatype)object).parseValue(this.f, null, null);
                    }
                }
                catch (Exception exception) {
                    XmlSchemaAttribute.error(validationEventHandler, "The Attribute's fixed value is invalid with its type definition.", exception);
                }
            }
        }
        this.p = this.getUse() == 0 ? 1 : this.getUse();
        if (this.a != null) {
            XmlSchemaSimpleType xmlSchemaSimpleType = this.b = this.a instanceof XmlSchemaSimpleType ? (XmlSchemaSimpleType)this.a : null;
            if (this.a == XmlSchemaSimpleType.getAnySimpleType()) {
                this.b = XmlSchemaSimpleType.XsAnySimpleType;
            }
            if (this.b == null) {
                this.b = XmlSchemaType.getBuiltInSimpleType(this.getSchemaTypeName());
            }
        }
        xmlSchema.ValidationId.CloneTo(this.ValidationId);
        return this.errorCount;
    }

    boolean attributeEquals(XmlSchemaAttribute xmlSchemaAttribute) {
        return StringExtensions.equals(this.getId(), xmlSchemaAttribute.getId()) && !XmlQualifiedName.op_Inequality(this.getQualifiedName(), xmlSchemaAttribute.getQualifiedName()) && this.getAttributeType() == xmlSchemaAttribute.getAttributeType() && this.getValidatedUse() == xmlSchemaAttribute.getValidatedUse() && StringExtensions.equals(this.getValidatedDefaultValue(), xmlSchemaAttribute.getValidatedDefaultValue()) && StringExtensions.equals(this.getValidatedFixedValue(), xmlSchemaAttribute.getValidatedFixedValue());
    }

    static XmlSchemaAttribute read(XmlSchemaReader xmlSchemaReader, ValidationEventHandler validationEventHandler) {
        Object object;
        XmlSchemaAttribute xmlSchemaAttribute = new XmlSchemaAttribute();
        xmlSchemaReader.moveToElement();
        if (!"http://www.w3.org/2001/XMLSchema".equals(xmlSchemaReader.getNamespaceURI()) || !r.equals(xmlSchemaReader.getLocalName())) {
            XmlSchemaAttribute.error(validationEventHandler, StringExtensions.concat("Should not happen :1: XmlSchemaAttribute.Read, name=", xmlSchemaReader.getName()), null);
            xmlSchemaReader.skipToEnd();
            return null;
        }
        xmlSchemaAttribute.setLineNumber(xmlSchemaReader.getLineNumber());
        xmlSchemaAttribute.setLinePosition(xmlSchemaReader.getLinePosition());
        xmlSchemaAttribute.setSourceUri(xmlSchemaReader.getBaseURI());
        while (xmlSchemaReader.moveToNextAttribute()) {
            Exception exception;
            if ("default".equals(xmlSchemaReader.getName())) {
                xmlSchemaAttribute.c = xmlSchemaReader.getValue();
                continue;
            }
            if ("fixed".equals(xmlSchemaReader.getName())) {
                xmlSchemaAttribute.d = xmlSchemaReader.getValue();
                continue;
            }
            if ("form".equals(xmlSchemaReader.getName())) {
                exception = null;
                object = new Exception[]{exception};
                xmlSchemaAttribute.h = XmlSchemaUtil.readFormAttribute(xmlSchemaReader, object);
                exception = object[0];
                if (exception == null) continue;
                XmlSchemaAttribute.error(validationEventHandler, StringExtensions.concat(xmlSchemaReader.getValue(), " is not a valid value for form attribute"), exception);
                continue;
            }
            if ("id".equals(xmlSchemaReader.getName())) {
                xmlSchemaAttribute.setId(xmlSchemaReader.getValue());
                continue;
            }
            if ("name".equals(xmlSchemaReader.getName())) {
                xmlSchemaAttribute.i = xmlSchemaReader.getValue();
                continue;
            }
            if ("ref".equals(xmlSchemaReader.getName())) {
                exception = null;
                object = new Exception[]{exception};
                xmlSchemaAttribute.l = XmlSchemaUtil.readQNameAttribute(xmlSchemaReader, object);
                exception = object[0];
                if (exception == null) continue;
                XmlSchemaAttribute.error(validationEventHandler, StringExtensions.concat(xmlSchemaReader.getValue(), " is not a valid value for ref attribute"), exception);
                continue;
            }
            if ("type".equals(xmlSchemaReader.getName())) {
                exception = null;
                object = new Exception[]{exception};
                xmlSchemaAttribute.n = XmlSchemaUtil.readQNameAttribute(xmlSchemaReader, object);
                exception = object[0];
                if (exception == null) continue;
                XmlSchemaAttribute.error(validationEventHandler, StringExtensions.concat(xmlSchemaReader.getValue(), " is not a valid value for type attribute"), exception);
                continue;
            }
            if ("use".equals(xmlSchemaReader.getName())) {
                exception = null;
                object = new Exception[]{exception};
                xmlSchemaAttribute.o = XmlSchemaUtil.readUseAttribute(xmlSchemaReader, object);
                exception = object[0];
                if (exception == null) continue;
                XmlSchemaAttribute.error(validationEventHandler, StringExtensions.concat(xmlSchemaReader.getValue(), " is not a valid value for use attribute"), exception);
                continue;
            }
            if ("".equals(xmlSchemaReader.getNamespaceURI()) && !"xmlns".equals(xmlSchemaReader.getName()) || "http://www.w3.org/2001/XMLSchema".equals(xmlSchemaReader.getNamespaceURI())) {
                XmlSchemaAttribute.error(validationEventHandler, StringExtensions.concat(xmlSchemaReader.getName(), " is not a valid attribute for attribute"), null);
                continue;
            }
            XmlSchemaUtil.readUnhandledAttribute(xmlSchemaReader, xmlSchemaAttribute);
        }
        xmlSchemaReader.moveToElement();
        if (xmlSchemaReader.isEmptyElement()) {
            return xmlSchemaAttribute;
        }
        int n2 = 1;
        while (xmlSchemaReader.readNextElement()) {
            if (xmlSchemaReader.getNodeType() == 15) {
                if (r.equals(xmlSchemaReader.getLocalName())) break;
                XmlSchemaAttribute.error(validationEventHandler, StringExtensions.concat("Should not happen :2: XmlSchemaAttribute.Read, name=", xmlSchemaReader.getName()), null);
                break;
            }
            if (n2 <= 1 && "annotation".equals(xmlSchemaReader.getLocalName())) {
                n2 = 2;
                object = XmlSchemaAnnotation.read(xmlSchemaReader, validationEventHandler);
                if (object == null) continue;
                xmlSchemaAttribute.setAnnotation((XmlSchemaAnnotation)object);
                continue;
            }
            if (n2 <= 2 && "simpleType".equals(xmlSchemaReader.getLocalName())) {
                n2 = 3;
                object = XmlSchemaSimpleType.read(xmlSchemaReader, validationEventHandler);
                if (object == null) continue;
                xmlSchemaAttribute.m = object;
                continue;
            }
            xmlSchemaReader.raiseInvalidElementError();
        }
        return xmlSchemaAttribute;
    }
}

