/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Xml;

import com.aspose.html.IDisposable;
import com.aspose.html.utils.Stream;
import com.aspose.html.utils.TimeSpan;
import com.aspose.html.utils.ayI;
import com.aspose.html.utils.ayY;
import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Collections.IEnumerable;
import com.aspose.html.utils.ms.System.Decimal;
import com.aspose.html.utils.ms.System.Enum;
import com.aspose.html.utils.ms.System.IO.StringWriter;
import com.aspose.html.utils.ms.System.IO.TextWriter;
import com.aspose.html.utils.ms.System.InvalidCastException;
import com.aspose.html.utils.ms.System.NotSupportedException;
import com.aspose.html.utils.ms.System.ObjectExtensions;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.Encoding;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.System.Uri;
import com.aspose.html.utils.ms.System.Xml.DefaultXmlWriter;
import com.aspose.html.utils.ms.System.Xml.XPathNavigator;
import com.aspose.html.utils.ms.System.Xml.XQueryConvert;
import com.aspose.html.utils.ms.System.Xml.XmlChar;
import com.aspose.html.utils.ms.System.Xml.XmlConvert;
import com.aspose.html.utils.ms.System.Xml.XmlException;
import com.aspose.html.utils.ms.System.Xml.XmlNodeType;
import com.aspose.html.utils.ms.System.Xml.XmlQualifiedName;
import com.aspose.html.utils.ms.System.Xml.XmlReader;
import com.aspose.html.utils.ms.System.Xml.XmlWellFormedWriter;
import com.aspose.html.utils.ms.System.Xml.XmlWriterSettings;
import com.aspose.html.utils.ms.System.msArray;
import com.aspose.html.utils.ms.lang.Operators;
import java.lang.reflect.Array;

public abstract class XmlWriter
implements IDisposable {
    private XmlWriterSettings a;

    protected XmlWriter() {
    }

    public XmlWriterSettings getSettings() {
        return this.a;
    }

    public abstract int getWriteState();

    public String getXmlLang() {
        return null;
    }

    public int getXmlSpace() {
        return 0;
    }

    public abstract void close();

    public static XmlWriter create(Stream stream) {
        return XmlWriter.create(stream, null);
    }

    public static XmlWriter create(String string) {
        return XmlWriter.create(string, null);
    }

    public static XmlWriter create(TextWriter textWriter) {
        return XmlWriter.create(textWriter, null);
    }

    public static XmlWriter create(XmlWriter xmlWriter) {
        return XmlWriter.create(xmlWriter, null);
    }

    public static XmlWriter create(msStringBuilder msStringBuilder2) {
        return XmlWriter.create(msStringBuilder2, null);
    }

    public static XmlWriter create(Stream stream, XmlWriterSettings xmlWriterSettings) {
        Encoding encoding = xmlWriterSettings != null ? xmlWriterSettings.getEncoding() : Encoding.getUTF8();
        return XmlWriter.create(new ayY(stream, encoding), xmlWriterSettings);
    }

    public static XmlWriter create(String string, XmlWriterSettings xmlWriterSettings) {
        Encoding encoding = xmlWriterSettings != null ? xmlWriterSettings.getEncoding() : Encoding.getUTF8();
        return XmlWriter.a(new ayY(string, false, encoding), xmlWriterSettings, true);
    }

    public static XmlWriter create(msStringBuilder msStringBuilder2, XmlWriterSettings xmlWriterSettings) {
        return XmlWriter.create(new StringWriter(msStringBuilder2), xmlWriterSettings);
    }

    public static XmlWriter create(TextWriter textWriter, XmlWriterSettings xmlWriterSettings) {
        if (xmlWriterSettings == null) {
            xmlWriterSettings = new XmlWriterSettings();
        }
        return XmlWriter.a(textWriter, xmlWriterSettings, xmlWriterSettings.getCloseOutput());
    }

    public static XmlWriter create(XmlWriter xmlWriter, XmlWriterSettings xmlWriterSettings) {
        xmlWriterSettings = xmlWriterSettings == null ? new XmlWriterSettings() : xmlWriterSettings.deepClone();
        XmlWriterSettings xmlWriterSettings2 = xmlWriter.getSettings();
        if (xmlWriterSettings2 == null) {
            xmlWriterSettings.setConformanceLevel(2);
            xmlWriter = new DefaultXmlWriter(xmlWriter);
            xmlWriter.a = xmlWriterSettings;
        } else {
            int n2 = xmlWriterSettings2.getConformanceLevel();
            switch (xmlWriterSettings2.getConformanceLevel()) {
                case 0: {
                    n2 = xmlWriterSettings.getConformanceLevel();
                    break;
                }
                case 1: 
                case 2: {
                    if (xmlWriterSettings.getConformanceLevel() == 0) break;
                    n2 = xmlWriterSettings.getConformanceLevel();
                }
            }
            xmlWriterSettings.mergeFrom(xmlWriterSettings2);
            if (xmlWriterSettings2.getConformanceLevel() != n2) {
                xmlWriter = new DefaultXmlWriter(xmlWriter, false);
                xmlWriter.a = xmlWriterSettings;
            }
        }
        return xmlWriter;
    }

    private static XmlWriter a(TextWriter textWriter, XmlWriterSettings xmlWriterSettings, boolean bl2) {
        if (xmlWriterSettings == null) {
            xmlWriterSettings = new XmlWriterSettings();
        }
        XmlWellFormedWriter xmlWellFormedWriter = new XmlWellFormedWriter(textWriter, xmlWriterSettings, bl2);
        return XmlWriter.create(xmlWellFormedWriter, xmlWriterSettings);
    }

    protected void dispose(boolean bl2) {
        this.close();
    }

    @Override
    public void dispose() {
        this.dispose(false);
    }

    public abstract void flush();

    public abstract String lookupPrefix(String var1);

    private void a(XmlReader xmlReader, boolean bl2) {
        if (!bl2 && xmlReader.isDefault()) {
            return;
        }
        this.writeStartAttribute(xmlReader.getPrefix(), xmlReader.getLocalName(), xmlReader.getNamespaceURI());
        while (xmlReader.readAttributeValue()) {
            switch (xmlReader.getNodeType()) {
                case 3: {
                    this.writeString(xmlReader.getValue());
                    break;
                }
                case 5: {
                    this.writeEntityRef(xmlReader.getName());
                }
            }
        }
        this.writeEndAttribute();
    }

    public void writeAttributes(XmlReader xmlReader, boolean bl2) {
        if (xmlReader == null) {
            throw new ArgumentException("null XmlReader specified.", "reader");
        }
        switch (xmlReader.getNodeType()) {
            case 17: {
                this.writeAttributeString("version", xmlReader.get_Item("version"));
                if (xmlReader.get_Item("encoding") != null) {
                    this.writeAttributeString("encoding", xmlReader.get_Item("encoding"));
                }
                if (xmlReader.get_Item("standalone") == null) break;
                this.writeAttributeString("standalone", xmlReader.get_Item("standalone"));
                break;
            }
            case 1: 
            case 2: {
                if (xmlReader.getNodeType() == 1 && !xmlReader.moveToFirstAttribute()) break;
                do {
                    this.a(xmlReader, bl2);
                } while (xmlReader.moveToNextAttribute());
                xmlReader.moveToElement();
                break;
            }
            default: {
                throw new XmlException("NodeType is not one of Element, Attribute, nor XmlDeclaration.");
            }
        }
    }

    public void writeAttributeString(String string, String string2) {
        this.writeAttributeString("", string, null, string2);
    }

    public void writeAttributeString(String string, String string2, String string3) {
        this.writeAttributeString("", string, string2, string3);
    }

    public void writeAttributeString(String string, String string2, String string3, String string4) {
        this.writeStartAttribute(string, string2, string3);
        if (string4 != null && string4.length() > 0) {
            this.writeString(string4);
        }
        this.writeEndAttribute();
    }

    public abstract void writeBase64(byte[] var1, int var2, int var3);

    public void writeBinHex(byte[] byArray, int n2, int n3) {
        StringWriter stringWriter = new StringWriter();
        XmlConvert.writeBinHex(byArray, n2, n3, stringWriter);
        this.writeString(stringWriter.toString());
    }

    public abstract void writeCData(String var1);

    public abstract void writeCharEntity(char var1);

    public abstract void writeChars(char[] var1, int var2, int var3);

    public abstract void writeComment(String var1);

    public abstract void writeDocType(String var1, String var2, String var3, String var4);

    public void writeElementString(String string, String string2) {
        this.writeStartElement(string);
        if (string2 != null && string2.length() > 0) {
            this.writeString(string2);
        }
        this.writeEndElement();
    }

    public void writeElementString(String string, String string2, String string3) {
        this.writeStartElement(string, string2);
        if (string3 != null && string3.length() > 0) {
            this.writeString(string3);
        }
        this.writeEndElement();
    }

    public void writeElementString(String string, String string2, String string3, String string4) {
        this.writeStartElement(string, string2, string3);
        if (string4 != null && string4.length() > 0) {
            this.writeString(string4);
        }
        this.writeEndElement();
    }

    public abstract void writeEndAttribute();

    public abstract void writeEndDocument();

    public abstract void writeEndElement();

    public abstract void writeEntityRef(String var1);

    public abstract void writeFullEndElement();

    public void writeName(String string) {
        this.writeNameInternal(string);
    }

    public void writeNmToken(String string) {
        this.writeNmTokenInternal(string);
    }

    public void writeQualifiedName(String string, String string2) {
        this.writeQualifiedNameInternal(string, string2);
    }

    void writeNameInternal(String string) {
        switch (this.getSettings().getConformanceLevel()) {
            case 1: 
            case 2: {
                XmlConvert.verifyName(string);
            }
        }
        this.writeString(string);
    }

    void writeNmTokenInternal(String string) {
        boolean bl2 = true;
        switch (this.getSettings().getConformanceLevel()) {
            case 1: 
            case 2: {
                bl2 = XmlChar.isNmToken(string);
            }
        }
        if (!bl2) {
            throw new ArgumentException("Argument name is not a valid NMTOKEN.");
        }
        this.writeString(string);
    }

    void writeQualifiedNameInternal(String string, String string2) {
        String string3;
        if (string == null || StringExtensions.equals(string, StringExtensions.Empty)) {
            throw new ArgumentException();
        }
        if (string2 == null) {
            string2 = StringExtensions.Empty;
        }
        if (this.getSettings() != null) {
            switch (this.getSettings().getConformanceLevel()) {
                case 1: 
                case 2: {
                    XmlConvert.verifyNCName(string);
                }
            }
        } else {
            XmlConvert.verifyNCName(string);
        }
        String string4 = string3 = string2.length() > 0 ? this.lookupPrefix(string2) : StringExtensions.Empty;
        if (string3 == null) {
            throw new ArgumentException(StringExtensions.format("Namespace '{0}' is not declared.", string2));
        }
        if (!StringExtensions.equals(string3, StringExtensions.Empty)) {
            this.writeString(string3);
            this.writeString(":");
            this.writeString(string);
        } else {
            this.writeString(string);
        }
    }

    public void writeNode(XPathNavigator xPathNavigator, boolean bl2) {
        if (xPathNavigator == null) {
            throw new ArgumentNullException("navigator");
        }
        switch (xPathNavigator.getNodeType()) {
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.writeString(xPathNavigator.getValue());
                break;
            }
            case 5: {
                this.writeWhitespace(xPathNavigator.getValue());
                break;
            }
            case 6: {
                this.writeWhitespace(xPathNavigator.getValue());
                break;
            }
            case 8: {
                this.writeComment(xPathNavigator.getValue());
                break;
            }
            case 7: {
                this.writeProcessingInstruction(xPathNavigator.getName(), xPathNavigator.getValue());
                break;
            }
            case 0: {
                if (!xPathNavigator.moveToFirstChild()) break;
                do {
                    this.writeNode(xPathNavigator, bl2);
                } while (xPathNavigator.moveToNext());
                xPathNavigator.moveToParent();
                break;
            }
            case 1: {
                this.writeStartElement(xPathNavigator.getPrefix(), xPathNavigator.getLocalName(), xPathNavigator.getNamespaceURI());
                if (xPathNavigator.moveToFirstNamespace(2)) {
                    do {
                        if (!bl2 && xPathNavigator.getSchemaInfo() != null && !xPathNavigator.getSchemaInfo().isDefault()) continue;
                        this.writeAttributeString(xPathNavigator.getPrefix(), StringExtensions.equals(xPathNavigator.getLocalName(), StringExtensions.Empty) ? "xmlns" : xPathNavigator.getLocalName(), "http://www.w3.org/2000/xmlns/", xPathNavigator.getValue());
                    } while (xPathNavigator.moveToNextNamespace(2));
                    xPathNavigator.moveToParent();
                }
                if (xPathNavigator.moveToFirstAttribute()) {
                    do {
                        if (!bl2 && xPathNavigator.getSchemaInfo() != null && !xPathNavigator.getSchemaInfo().isDefault()) continue;
                        this.writeAttributeString(xPathNavigator.getPrefix(), xPathNavigator.getLocalName(), xPathNavigator.getNamespaceURI(), xPathNavigator.getValue());
                    } while (xPathNavigator.moveToNextAttribute());
                    xPathNavigator.moveToParent();
                }
                if (xPathNavigator.moveToFirstChild()) {
                    do {
                        this.writeNode(xPathNavigator, bl2);
                    } while (xPathNavigator.moveToNext());
                    xPathNavigator.moveToParent();
                }
                if (xPathNavigator.isEmptyElement()) {
                    this.writeEndElement();
                    break;
                }
                this.writeFullEndElement();
                break;
            }
            default: {
                throw new NotSupportedException();
            }
        }
    }

    public void writeNode(XmlReader xmlReader, boolean bl2) {
        if (xmlReader == null) {
            throw new ArgumentException();
        }
        if (xmlReader.getReadState() == 0) {
            xmlReader.read();
            do {
                this.writeNode(xmlReader, bl2);
            } while (!xmlReader.getEOF());
            return;
        }
        switch (xmlReader.getNodeType()) {
            case 1: {
                int n2;
                this.writeStartElement(xmlReader.getPrefix(), xmlReader.getLocalName(), xmlReader.getNamespaceURI());
                if (xmlReader.hasAttributes()) {
                    for (n2 = 0; n2 < xmlReader.getAttributeCount(); ++n2) {
                        xmlReader.moveToAttribute(n2);
                        this.a(xmlReader, bl2);
                    }
                    xmlReader.moveToElement();
                }
                if (xmlReader.isEmptyElement()) {
                    this.writeEndElement();
                    break;
                }
                n2 = xmlReader.getDepth();
                xmlReader.read();
                if (xmlReader.getNodeType() != 15) {
                    do {
                        this.writeNode(xmlReader, bl2);
                    } while (n2 < xmlReader.getDepth());
                }
                this.writeFullEndElement();
                break;
            }
            case 2: {
                return;
            }
            case 3: {
                this.writeString(xmlReader.getValue());
                break;
            }
            case 4: {
                this.writeCData(xmlReader.getValue());
                break;
            }
            case 5: {
                this.writeEntityRef(xmlReader.getName());
                break;
            }
            case 7: 
            case 17: {
                this.writeProcessingInstruction(xmlReader.getName(), xmlReader.getValue());
                break;
            }
            case 8: {
                this.writeComment(xmlReader.getValue());
                break;
            }
            case 10: {
                this.writeDocType(xmlReader.getName(), xmlReader.get_Item("PUBLIC"), xmlReader.get_Item("SYSTEM"), xmlReader.getValue());
                break;
            }
            case 13: 
            case 14: {
                this.writeWhitespace(xmlReader.getValue());
                break;
            }
            case 15: {
                this.writeFullEndElement();
                break;
            }
            case 16: {
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new XmlException(StringExtensions.concat("Unexpected node ", xmlReader.getName(), " of type ", Enum.getName(XmlNodeType.class, xmlReader.getNodeType())));
            }
        }
        xmlReader.read();
    }

    public abstract void writeProcessingInstruction(String var1, String var2);

    public abstract void writeRaw(String var1);

    public abstract void writeRaw(char[] var1, int var2, int var3);

    public void writeStartAttribute(String string) {
        this.writeStartAttribute(null, string, null);
    }

    public void writeStartAttribute(String string, String string2) {
        this.writeStartAttribute(null, string, string2);
    }

    public abstract void writeStartAttribute(String var1, String var2, String var3);

    public abstract void writeStartDocument();

    public abstract void writeStartDocument(boolean var1);

    public void writeStartElement(String string) {
        this.writeStartElement(null, string, null);
    }

    public void writeStartElement(String string, String string2) {
        this.writeStartElement(null, string, string2);
    }

    public abstract void writeStartElement(String var1, String var2, String var3);

    public abstract void writeString(String var1);

    public abstract void writeSurrogateCharEntity(char var1, char var2);

    public abstract void writeWhitespace(String var1);

    public void writeValue(boolean bl2) {
        this.writeString(XQueryConvert.booleanToString(bl2));
    }

    public void writeValue(ayI ayI2) {
        this.writeString(XmlConvert.toString_DateTime(ayI2.bfo()));
    }

    public void writeValue(Decimal decimal) {
        this.writeString(XQueryConvert.decimalToString(decimal.Clone()));
    }

    public void writeValue(double d2) {
        this.writeString(XQueryConvert.doubleToString(d2));
    }

    public void writeValue(int n2) {
        this.writeString(XQueryConvert.intToString(n2));
    }

    public void writeValue(long l2) {
        this.writeString(XQueryConvert.integerToString(l2));
    }

    public void writeValue(Object object) {
        if (object == null) {
            throw new ArgumentNullException("value");
        }
        if (Operators.is(object, String.class)) {
            this.writeString((String)object);
        } else if (Operators.is(object, Boolean.class)) {
            this.writeValue(Operators.unboxing(object, Boolean.TYPE));
        } else if (Operators.is(object, Byte.class)) {
            this.writeValue(Operators.unboxing(object, Byte.TYPE).byteValue());
        } else if (Operators.is(object, byte[].class)) {
            this.writeBase64(Operators.cast(object, byte[].class), 0, Operators.cast(object, byte[].class).length);
        } else if (Operators.is(object, char[].class)) {
            this.writeChars(Operators.cast(object, char[].class), 0, Operators.cast(object, char[].class).length);
        } else if (Operators.is(object, ayI.class)) {
            this.writeValue(Operators.unboxing(object, ayI.class).bfo());
        } else if (Operators.is(object, Decimal.class)) {
            this.writeValue(Operators.unboxing(object, Decimal.class).Clone());
        } else if (Operators.is(object, Double.class)) {
            this.writeValue(Operators.unboxing(object, Double.TYPE));
        } else if (Operators.is(object, Short.class)) {
            this.writeValue(Operators.unboxing(object, Short.TYPE).shortValue());
        } else if (Operators.is(object, Integer.class)) {
            this.writeValue(Operators.unboxing(object, Integer.TYPE));
        } else if (Operators.is(object, Long.class)) {
            this.writeValue(Operators.unboxing(object, Long.TYPE));
        } else if (Operators.is(object, Float.class)) {
            this.writeValue(Operators.unboxing(object, Float.TYPE).floatValue());
        } else if (Operators.is(object, TimeSpan.class)) {
            this.writeString(XmlConvert.toString_TimeSpan(Operators.unboxing(object, TimeSpan.class).Clone()));
        } else if (Operators.is(object, Uri.class)) {
            this.writeString(((Uri)object).toString());
        } else if (Operators.is(object, XmlQualifiedName.class)) {
            XmlQualifiedName xmlQualifiedName = (XmlQualifiedName)object;
            if (!xmlQualifiedName.equals(XmlQualifiedName.Empty)) {
                if (xmlQualifiedName.getNamespace().length() > 0 && this.lookupPrefix(xmlQualifiedName.getNamespace()) == null) {
                    throw new InvalidCastException(StringExtensions.format("The QName '{0}' cannot be written. No corresponding prefix is declared", xmlQualifiedName));
                }
                this.writeQualifiedName(xmlQualifiedName.getName(), xmlQualifiedName.getNamespace());
            } else {
                this.writeString(StringExtensions.Empty);
            }
        } else if (object instanceof XmlQualifiedName[]) {
            XmlQualifiedName[] xmlQualifiedNameArray;
            for (XmlQualifiedName xmlQualifiedName : xmlQualifiedNameArray = (XmlQualifiedName[])object) {
                if (!xmlQualifiedName.equals(XmlQualifiedName.Empty)) {
                    if (xmlQualifiedName.getNamespace().length() > 0 && this.lookupPrefix(xmlQualifiedName.getNamespace()) == null) {
                        throw new InvalidCastException(StringExtensions.format("The QName '{0}' cannot be written. No corresponding prefix is declared", xmlQualifiedName));
                    }
                    this.writeQualifiedName(xmlQualifiedName.getName(), xmlQualifiedName.getNamespace());
                    continue;
                }
                this.writeString(StringExtensions.Empty);
            }
        } else if (object instanceof IEnumerable) {
            boolean bl2 = false;
            for (Object e2 : (IEnumerable)object) {
                if (bl2) {
                    this.writeString(" ");
                } else {
                    bl2 = true;
                }
                this.writeValue(e2);
            }
        } else if (object.getClass().isArray()) {
            int n2;
            int n3 = msArray.getUpperBound(object, 0);
            Object[] objectArray = new Object[n3 + 1];
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                Array.set(objectArray, n2, Array.get(object, n2));
            }
            n2 = 0;
            for (Object object2 : objectArray) {
                if (n2 != 0) {
                    this.writeString(" ");
                } else {
                    n2 = 1;
                }
                this.writeValue(object2);
            }
        } else {
            throw new InvalidCastException(StringExtensions.format("Type '{0}' cannot be cast to string", ObjectExtensions.getType(object)));
        }
    }

    public void writeValue(float f2) {
        this.writeString(XQueryConvert.floatToString(f2));
    }

    public void writeValue(String string) {
        this.writeString(string);
    }
}

