/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System;

import com.aspose.html.NotImplementedException;
import com.aspose.html.utils.ms.core.JavaLangSystem;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Random;

public final class ByteArrayUtil {
    private static final String[] a = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000", "0000000000", "0000 0000000", "000000000000", "0000000000000", "00000000000000", "00000000000000", "0000000000000000"};

    public static byte getByte(byte[] byArray, int n2) {
        return (byte)ByteArrayUtil.a(byArray, n2, 1, true);
    }

    public static short getShort(byte[] byArray, int n2, boolean bl2) {
        return (short)ByteArrayUtil.a(byArray, n2, 2, bl2);
    }

    public static int getInt(byte[] byArray, int n2, boolean bl2) {
        return (int)ByteArrayUtil.a(byArray, n2, 4, bl2);
    }

    public static float getFloat(byte[] byArray, int n2, boolean bl2) {
        return Float.intBitsToFloat(ByteArrayUtil.getInt(byArray, n2, bl2));
    }

    public static long getLong(byte[] byArray, int n2, boolean bl2) {
        return ByteArrayUtil.a(byArray, n2, 8, bl2);
    }

    public static double getDouble(byte[] byArray, int n2, boolean bl2) {
        return Double.longBitsToDouble(ByteArrayUtil.getLong(byArray, n2, bl2));
    }

    public static int setByte(byte by2, byte[] byArray, int n2) {
        return ByteArrayUtil.a(by2, byArray, n2, 1, true);
    }

    public static int setShort(short s2, byte[] byArray, int n2, boolean bl2) {
        return ByteArrayUtil.a(s2, byArray, n2, 2, bl2);
    }

    public static int setInt(int n2, byte[] byArray, int n3, boolean bl2) {
        return ByteArrayUtil.a(n2, byArray, n3, 4, bl2);
    }

    public static int setFloat(float f2, byte[] byArray, int n2, boolean bl2) {
        return ByteArrayUtil.a(Float.floatToIntBits(f2), byArray, n2, 4, bl2);
    }

    public static int setLong(long l2, byte[] byArray, int n2, boolean bl2) {
        return ByteArrayUtil.a(l2, byArray, n2, 8, bl2);
    }

    public static int setDouble(double d2, byte[] byArray, int n2, boolean bl2) {
        return ByteArrayUtil.a(Double.doubleToLongBits(d2), byArray, n2, 8, bl2);
    }

    public static byte[] toArray(byte by2) {
        byte[] byArray = new byte[1];
        ByteArrayUtil.setByte(by2, byArray, 0);
        return byArray;
    }

    public static byte[] toArray(short s2, boolean bl2) {
        byte[] byArray = new byte[2];
        ByteArrayUtil.setShort(s2, byArray, 0, bl2);
        return byArray;
    }

    public static byte[] toArray(int n2, boolean bl2) {
        byte[] byArray = new byte[4];
        ByteArrayUtil.setInt(n2, byArray, 0, bl2);
        return byArray;
    }

    public static byte[] toArray(float f2, boolean bl2) {
        byte[] byArray = new byte[4];
        ByteArrayUtil.setFloat(f2, byArray, 0, bl2);
        return byArray;
    }

    public static byte[] toArray(long l2, boolean bl2) {
        byte[] byArray = new byte[8];
        ByteArrayUtil.setLong(l2, byArray, 0, bl2);
        return byArray;
    }

    public static byte[] toArray(double d2, boolean bl2) {
        byte[] byArray = new byte[8];
        ByteArrayUtil.setDouble(d2, byArray, 0, bl2);
        return byArray;
    }

    private static long a(byte[] byArray, int n2, int n3, boolean bl2) {
        long l2 = 0L;
        if (bl2) {
            if (n2 % 8 == 0) {
                int n4 = n2 / 8;
                for (int i2 = n3 - 1; i2 >= 0; --i2) {
                    l2 <<= 8;
                    l2 |= (long)(byArray[n4 + i2] & 0xFF);
                }
                return l2;
            }
            throw new NotImplementedException();
        }
        if (n2 % 8 == 0) {
            int n5 = n2 / 8;
            for (int i3 = 0; i3 < n3; ++i3) {
                l2 <<= 8;
                l2 |= (long)(byArray[n5 + i3] & 0xFF);
            }
            return l2;
        }
        int n6 = n2 % 8;
        int n7 = 8 - n6;
        int n8 = n2 / 8;
        for (int i4 = 0; i4 < n3; ++i4) {
            l2 <<= 8;
            byte by2 = byArray[n8 + i4];
            byte by3 = byArray[n8 + i4 + 1];
            by2 = (byte)(by2 << n6);
            by3 = (byte)((by3 & 0xFF) >> n7);
            l2 |= (long)(by2 & 0xFF);
            l2 |= (long)(by3 & 0xFF);
        }
        return l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int a(long l2, byte[] byArray, int n2, int n3, boolean bl2) {
        int n4 = n2 / 8;
        if (bl2) {
            if (n2 % 8 != 0) throw new NotImplementedException();
            for (int i2 = 0; i2 < n3; ++i2) {
                byArray[n4 + i2] = (byte)(l2 & 0xFFL);
                l2 >>>= 8;
            }
            return n3;
        } else if (n2 % 8 == 0) {
            for (int i3 = n3 - 1; i3 >= 0; --i3) {
                byArray[n4 + i3] = (byte)(l2 & 0xFFL);
                l2 >>>= 8;
            }
            return n3;
        } else {
            int n5 = n2 % 8;
            int n6 = 8 - n5;
            byte by2 = (byte)(255 << n6);
            byte by3 = (byte)(255 >>> n5);
            for (int i4 = n3 - 1; i4 >= 0; --i4) {
                byte by4 = byArray[n4 + i4 + 1];
                byte by5 = byArray[n4 + i4];
                byte by6 = (byte)(l2 & 0xFFL);
                by4 = (byte)(by4 & by3);
                by5 = (byte)(by5 & by2);
                by4 = (byte)(by4 | by6 << n6);
                by5 = (byte)(by5 | (by6 & 0xFF) >> n5);
                byArray[n4 + i4 + 1] = by4;
                byArray[n4 + i4] = by5;
                l2 >>>= 8;
            }
        }
        return n3;
    }

    public static void randomBytes(byte[] byArray) {
        Random random = new Random();
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = random.nextInt();
            int n4 = Math.min(byArray.length - n2, 4);
            while (n4-- > 0) {
                byArray[n2++] = (byte)n3;
                n3 >>= 8;
            }
        }
    }

    public static byte[] randomBytes(int n2) {
        byte[] byArray = new byte[n2];
        ByteArrayUtil.randomBytes(byArray);
        return byArray;
    }

    public static void setRandom(byte[] byArray, int n2, int n3) {
        if (n3 <= 0) {
            return;
        }
        int n4 = n2 / 8;
        int n5 = (n2 + n3) / 8;
        int n6 = n2 % 8;
        int n7 = (n2 + n3) % 8;
        if (n6 == 0 && n7 == 0) {
            ByteArrayUtil.a(byArray, n4, n5);
        } else {
            int n8;
            if (n6 != 0) {
                ++n4;
            }
            if (n7 != 0) {
                --n5;
            }
            if ((n8 = n5 - n4) >= 0) {
                ByteArrayUtil.a(byArray, n4, n7 == 0 ? n5 : n5 + 1);
            }
            if (n8 == -2) {
                byte by2 = byArray[n4 - 1];
                ByteArrayUtil.a(by2, n2, n3);
                byArray[n4 - 1] = by2;
            } else if (n8 == -1 || n8 == 0) {
                byte by3;
                if (n6 != 0) {
                    by3 = byArray[n4 - 1];
                    ByteArrayUtil.a(by3, n2, n3);
                    byArray[n4 - 1] = by3;
                }
                if (n7 != 0) {
                    by3 = byArray[n5 + 1];
                    ByteArrayUtil.a(by3, n2, n3);
                    byArray[n5 + 1] = by3;
                }
            }
        }
    }

    private static byte a(byte by2, int n2, int n3) {
        byte by3 = ByteArrayUtil.a();
        int n4 = 1;
        int n5 = 0;
        int n6 = n3 - 1;
        while (n5 < 8 - n2 - 1) {
            n4 = (byte)(n4 << 1 | (n6 > 0 ? 1 : 0));
            ++n5;
            --n6;
        }
        n5 = (byte)(0xFF ^ n4);
        return (byte)(by2 & n5 | by3 & n4);
    }

    private static byte a() {
        int n2 = new Random().nextInt();
        return (byte)(n2 >>= 8);
    }

    private static void a(byte[] byArray, int n2, int n3) {
        int n4 = n3 - n2;
        byte[] byArray2 = new byte[n4];
        ByteArrayUtil.randomBytes(byArray2);
        System.arraycopy(byArray2, 0, byArray, n2, n4);
    }

    public static String toString(byte[] byArray, Format format, Separator separator, boolean bl2, Declaration declaration) {
        String string;
        if (byArray == null) {
            return "<NULL>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl3 = bl2 = bl2 || declaration == Declaration.JAVA || declaration == Declaration.NET;
        if (bl2) {
            stringBuffer.append("{ ");
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            String string2;
            byte by2 = byArray[i2];
            if (i2 != 0) {
                stringBuffer.append(separator.getSymbol());
            }
            if (Format.HEX == format) {
                string2 = Integer.toHexString(by2 & 0xFF);
                if (string2.length() < 2) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string2.toUpperCase());
                continue;
            }
            if (Format.HEX_0x == format) {
                stringBuffer.append("0x");
                string2 = Integer.toHexString(by2 & 0xFF);
                if (string2.length() < 2) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string2.toUpperCase());
                continue;
            }
            if (Format.CAST_HEX_0x == format) {
                stringBuffer.append("(byte)0x");
                string2 = Integer.toHexString(by2 & 0xFF);
                if (string2.length() < 2) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string2.toUpperCase());
                continue;
            }
            if (Format.DEC != format) continue;
            stringBuffer.append(Long.toString(by2));
        }
        if (bl2) {
            stringBuffer.append(" }");
        }
        if ((string = declaration.getTemplate()) != null && !"".equals(string)) {
            string = string.replace("${0}", "" + byArray.length);
            string = string.replace("${1}", "" + 8 * byArray.length);
            string = string.replace("${2}", stringBuffer.toString());
            return string;
        }
        return stringBuffer.toString();
    }

    public static void printByteArray(byte[] byArray, int n2) {
        JavaLangSystem.out.print("(byte)");
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            JavaLangSystem.out.print(ByteArrayUtil.getByteInHexa(byArray[i2]));
            if (i2 % n2 == n2 - 1 && i2 != byArray.length - 1) {
                JavaLangSystem.out.print(",\n(byte)");
                continue;
            }
            if (i2 == byArray.length - 1) continue;
            JavaLangSystem.out.print(", (byte)");
        }
        JavaLangSystem.out.println("");
    }

    public static String getByteInHexa(byte n2) {
        String string = "0x";
        int n3 = n2;
        if (n3 >= 0) {
            int n4 = n3 / 16;
            int n5 = n3 - 16 * n4;
            string = string + String.valueOf(n4);
            char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
            string = string + String.valueOf(cArray[n5]);
        } else {
            int n6 = (n3 += 128) / 16;
            int n7 = n3 - 16 * n6;
            char[] cArray = new char[]{'8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
            string = string + String.valueOf(cArray[n6]);
            char[] cArray2 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
            string = string + String.valueOf(cArray2[n7]);
        }
        return string;
    }

    public static String toString(byte[] byArray) {
        if (byArray == null) {
            return "<null>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(ByteArrayUtil.getByteInHexa(byArray[i2]));
            if (i2 >= n2 - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            return false;
        }
        int n2 = byArray.length;
        int n3 = byArray2.length;
        if (n2 != n3) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static String getAsHexString(short s2) {
        String string = Integer.toHexString(s2 & 0xFFFF).toUpperCase();
        return a[4 - string.length()] + string;
    }

    public static String getAsHexString(int n2) {
        String string = Integer.toHexString(n2).toUpperCase();
        return a[8 - string.length()] + string;
    }

    public static String getAsHexString(long l2) {
        String string = Long.toHexString(l2).toUpperCase();
        return a[16 - string.length()] + string;
    }

    public static String getAsHexString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            String string = Integer.toHexString(byArray[i2] & 0xFF).toUpperCase();
            stringBuffer.append(a[2 - string.length()]).append(string);
        }
        return stringBuffer.toString().toUpperCase();
    }

    public static void reverse(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        int n2 = 0;
        for (int i2 = byArray.length - 1; i2 > n2; --i2, ++n2) {
            byte by2 = byArray[i2];
            byArray[i2] = byArray[n2];
            byArray[n2] = by2;
        }
    }

    public static BigDecimal getDecimal(byte[] byArray, int n2, boolean bl2) {
        if (bl2) {
            ByteArrayUtil.reverse(byArray);
        }
        int n3 = ByteArrayUtil.getInt(byArray, 0, false);
        byte[] byArray2 = new byte[byArray.length - 4];
        System.arraycopy(byArray, 4, byArray2, 0, byArray2.length);
        BigInteger bigInteger = new BigInteger(byArray2);
        return new BigDecimal(bigInteger, n3);
    }

    public static byte[] toByteArray(BigDecimal bigDecimal, boolean bl2) {
        int n2 = bigDecimal.scale();
        BigInteger bigInteger = bigDecimal.unscaledValue();
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = new byte[16];
        byArray2[0] = (byte)(n2 >>> 24);
        byArray2[1] = (byte)(n2 >>> 16);
        byArray2[2] = (byte)(n2 >>> 8);
        byArray2[3] = (byte)(n2 >>> 0);
        System.arraycopy(byArray, 0, byArray2, 16 - byArray.length, byArray.length);
        if (bl2) {
            ByteArrayUtil.reverse(byArray2);
        }
        return byArray2;
    }

    public static byte[] toPrimitiveByteArray(List<Byte> list) {
        return ByteArrayUtil.toPrimitiveByteByte(list.toArray(new Byte[list.size()]));
    }

    public static byte[] toPrimitiveByteByte(Byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        if (byteArray.length == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[byteArray.length];
        for (int i2 = 0; i2 < byteArray.length; ++i2) {
            byArray[i2] = byteArray[i2];
        }
        return byArray;
    }

    public static int[] toPrimitiveIntArray(List<Integer> list) {
        return ByteArrayUtil.toPrimitiveIntArray(list.toArray(new Integer[list.size()]));
    }

    public static int[] toPrimitiveIntArray(Integer[] integerArray) {
        if (integerArray == null) {
            return null;
        }
        if (integerArray.length == 0) {
            return new int[0];
        }
        int[] nArray = new int[integerArray.length];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            nArray[i2] = integerArray[i2];
        }
        return nArray;
    }

    public static char[] toPrimitiveCharArray(List<Character> list) {
        return ByteArrayUtil.toPrimitiveCharArray(list.toArray(new Character[list.size()]));
    }

    public static char[] toPrimitiveCharArray(Character[] characterArray) {
        if (characterArray == null) {
            return null;
        }
        if (characterArray.length == 0) {
            return new char[0];
        }
        char[] cArray = new char[characterArray.length];
        for (int i2 = 0; i2 < characterArray.length; ++i2) {
            cArray[i2] = characterArray[i2].charValue();
        }
        return cArray;
    }

    public static float[] toPrimitiveFloatArray(Float[] floatArray) {
        if (floatArray == null) {
            return null;
        }
        if (floatArray.length == 0) {
            return new float[0];
        }
        float[] fArray = new float[floatArray.length];
        for (int i2 = 0; i2 < floatArray.length; ++i2) {
            fArray[i2] = floatArray[i2].floatValue();
        }
        return fArray;
    }

    public static final class Declaration {
        public static final Declaration NONE = new Declaration(null);
        public static final Declaration JAVA = new Declaration("/**\n * ${0} bytes (${1} bits)\n */\nprivate static final byte[] byteArray = ${2};");
        public static final Declaration NET = new Declaration("//<summary>\n// ${0} bytes (${1} bits)\n//</summary>\nprivate static readonly byte[] byteArray = new byte[${0}] ${2};");
        private String a;

        private Declaration(String string) {
            this.a = string;
        }

        public String getTemplate() {
            return this.a;
        }
    }

    public static enum Separator {
        NONE(""),
        SPACE(" "),
        DOT("."),
        COMMA(","),
        HYPHEN("-");

        private String a;

        private Separator(String string2) {
            this.a = string2;
        }

        public String getSymbol() {
            return this.a;
        }
    }

    public static final class Format {
        public static final Format HEX = new Format();
        public static final Format HEX_0x = new Format();
        public static final Format CAST_HEX_0x = new Format();
        public static final Format DEC = new Format();

        private Format() {
        }
    }
}

