/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.msMath;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.PointF;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Size;
import com.aspose.html.utils.ms.lang.Struct;

public class Point
extends Struct<Point> {
    static final String PointFormat = "{{X={0}, Y={1}}}";
    private static final Point a = new Point();
    private int b;
    private int c;

    public Point() {
    }

    public Point(int n2, int n3) {
        this.b = n2;
        this.c = n3;
    }

    public Point(Size size) {
        this.b = size.getWidth();
        this.c = size.getHeight();
    }

    public Point(int n2) {
        this.b = (short)Point.a(n2);
        this.c = (short)Point.b(n2);
    }

    public static Point getEmpty() {
        return a;
    }

    public boolean isEmpty() {
        return this.b == 0 && this.c == 0;
    }

    public int getX() {
        return this.b;
    }

    public void setX(int n2) {
        this.b = n2;
    }

    public int getY() {
        return this.c;
    }

    public void setY(int n2) {
        this.c = n2;
    }

    public static Point add(Point point, Size size) {
        return new Point(point.getX() + size.getWidth(), point.getY() + size.getHeight());
    }

    public static Point subtract(Point point, Size size) {
        return new Point(point.getX() - size.getWidth(), point.getY() - size.getHeight());
    }

    public static Point ceiling(PointF pointF) {
        return new Point((int)msMath.ceiling(pointF.getX()), (int)msMath.ceiling(pointF.getY()));
    }

    public static Point round(PointF pointF) {
        return new Point((int)msMath.round(pointF.getX()), (int)msMath.round(pointF.getY()));
    }

    public static Point truncate(PointF pointF) {
        return new Point((int)pointF.getX(), (int)pointF.getY());
    }

    public static Point op_Addition(Point point, Size size) {
        return Point.add(point.Clone(), size.Clone());
    }

    public static Point op_Subtraction(Point point, Size size) {
        return Point.subtract(point.Clone(), size.Clone());
    }

    public static boolean op_Equality(Point point, Point point2) {
        return point.b == point2.b && point.c == point2.c;
    }

    public static boolean op_Inequality(Point point, Point point2) {
        return !Point.op_Equality(point, point2);
    }

    public static Size to_Size(Point point) {
        return new Size(point.getX(), point.getY());
    }

    public static PointF to_PointF(Point point) {
        return new PointF(point.getX(), point.getY());
    }

    public void offset(Point point) {
        this.offset(point.getX(), point.getY());
    }

    public void offset(int n2, int n3) {
        this.setX(this.getX() + n2);
        this.setY(this.getY() + n3);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Point)) {
            return false;
        }
        Point point = ((Point)object).Clone();
        return point.getX() == this.getX() && point.getY() == this.getY();
    }

    public int hashCode() {
        return this.b ^ this.c;
    }

    public String toString() {
        return StringExtensions.format(CultureInfo.getCurrentCulture(), PointFormat, this.b, this.c);
    }

    private static int a(int n2) {
        return n2 & 0xFFFF;
    }

    private static int b(int n2) {
        return n2 >> 16 & 0xFFFF;
    }

    @Override
    public void CloneTo(Point point) {
        point.b = this.b;
        point.c = this.c;
    }

    @Override
    public Point Clone() {
        Point point = new Point();
        this.CloneTo(point);
        return point;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(Point point, Point point2) {
        return point.equals(point2);
    }
}

