/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg;

import com.aspose.html.NotImplementedException;
import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.IccProfileHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.LoadOptions;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.datawriters.CMYKWriter;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.datawriters.GrayscaleWriter;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.datawriters.RgbWriter;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.datawriters.YCCKWriter;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.datawriters.YCbCrWriter;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.imageoptions.JpegOptions;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialRawDataLoader;

public abstract class JpegDataWriter
implements IPartialArgb32PixelLoader,
IPartialRawDataLoader {
    protected IPartialRawDataLoader dataLoader;
    protected PixelDataFormat targetPixelSettings;

    public static JpegDataWriter getWriter(IPartialRawDataLoader iPartialRawDataLoader, JpegOptions jpegOptions) {
        JpegDataWriter jpegDataWriter;
        switch (jpegOptions.getColorType()) {
            case 4: {
                jpegDataWriter = new RgbWriter(iPartialRawDataLoader);
                break;
            }
            case 0: {
                jpegDataWriter = new GrayscaleWriter(iPartialRawDataLoader);
                break;
            }
            case 1: {
                jpegDataWriter = new YCbCrWriter(iPartialRawDataLoader);
                break;
            }
            case 2: {
                jpegDataWriter = new CMYKWriter(iPartialRawDataLoader);
                break;
            }
            case 3: {
                if (jpegOptions.getRGBColorProfile() == null) {
                    jpegOptions.setRGBColorProfile(IccProfileHelper.getDefaultRGBProfile());
                } else {
                    jpegOptions.getRGBColorProfile().getStream().seek(0L, 0);
                }
                if (jpegOptions.getCMYKColorProfile() == null) {
                    jpegOptions.setCMYKColorProfile(IccProfileHelper.getDefaultCmykProfile());
                } else {
                    jpegOptions.getCMYKColorProfile().getStream().seek(0L, 0);
                }
                jpegDataWriter = new YCCKWriter(iPartialRawDataLoader, jpegOptions.getRGBColorProfile().getStream(), jpegOptions.getCMYKColorProfile().getStream());
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException();
            }
        }
        return jpegDataWriter;
    }

    @Override
    public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
        byte[] byArray = new byte[rectangle.getWidth() * rectangle.getHeight() * this.targetPixelSettings.getChannelsCount()];
        this.convert(nArray, byArray);
        this.dataLoader.process(rectangle.Clone(), byArray, point.Clone(), point2.Clone());
    }

    @Override
    public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2) {
        this.dataLoader.process(rectangle.Clone(), byArray, point.Clone(), point2.Clone());
    }

    @Override
    public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2, LoadOptions loadOptions) {
        throw new NotImplementedException();
    }

    protected abstract void convert(int[] var1, byte[] var2);
}

