/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.writers;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.BitConverter;
import com.aspose.html.utils.ms.System.Buffer;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.msMath;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.BufferHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ByteConverter;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ColorPalette;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ColorPaletteHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffCodecDataWriter;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.imageoptions.TiffOptions;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IAdvancedBufferProcessor;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.utils.ms.lang.Operators;
import java.awt.Color;

public abstract class TiffByteConverterWriter
extends TiffCodecDataWriter {
    protected TiffByteConverterWriter(TiffOptions tiffOptions, int n2, int n3) {
        super(tiffOptions, n2, n3);
    }

    protected static ColorConverter getColorConverter(TiffOptions tiffOptions, int n2, int n3, int n4) {
        int n5 = tiffOptions.getPredictor();
        ColorConverter colorConverter = null;
        int[] nArray = tiffOptions.getBitsPerSample();
        int n6 = tiffOptions.getBitsPerPixel();
        if (nArray == null) {
            throw new ArgumentException("TiffImageException: The bits per sample are not specified");
        }
        int n7 = tiffOptions.getPhotometric();
        if (nArray.length == 1) {
            IColorPalette iColorPalette = tiffOptions.getPalette();
            if (n7 == 3 && iColorPalette == null) {
                throw new ArgumentException("TiffImageException: The palette is not defined for palettized tiff image.");
            }
            if (n7 != 3) {
                switch (nArray[0]) {
                    case 1: {
                        if (n7 != 1) {
                            iColorPalette = new ColorPalette(new int[]{Color.WHITE.getRGB(), Color.BLACK.getRGB()});
                            break;
                        }
                        iColorPalette = new ColorPalette(new int[]{Color.BLACK.getRGB(), Color.WHITE.getRGB()});
                        break;
                    }
                    case 4: {
                        iColorPalette = ColorPaletteHelper.create4BitGrayscale(n7 == 0);
                        break;
                    }
                    case 8: 
                    case 16: {
                        iColorPalette = ColorPaletteHelper.create8BitGrayscale(n7 == 0);
                    }
                }
            }
            if (n5 == 2) {
                if ((nArray[0] & 0xFFFF) == 8) {
                    colorConverter = new Bitmap8BitPredictorConverter(n2, n3, iColorPalette);
                }
            } else {
                switch (nArray[0]) {
                    case 1: {
                        colorConverter = new Bitmap1BitConverter(n2, n3, n4, iColorPalette);
                        break;
                    }
                    case 4: {
                        colorConverter = new Bitmap4BitConverter(n2, n3, n4, iColorPalette);
                        break;
                    }
                    case 8: {
                        colorConverter = new Bitmap8BitConverter(n2, n3, n4, iColorPalette);
                        break;
                    }
                    case 16: {
                        colorConverter = n7 == 3 ? new Bitmap16BitPaletteConverter(n2, n3, n4, iColorPalette) : new Bitmap16BitGrayscaleConverter(n2, n3, n4, iColorPalette);
                    }
                }
            }
        } else if (nArray.length == 3) {
            if ((nArray[0] & 0xFFFF) == 8 && (nArray[1] & 0xFFFF) == 8 && (nArray[2] & 0xFFFF) == 8) {
                colorConverter = n5 == 2 ? new HorizontalPredictorRgb888(n2, n3) : new Rgb888Converter(n2, n3, n4);
            }
        } else if (nArray.length >= 4) {
            boolean bl2 = true;
            for (int n8 : nArray) {
                if ((n8 & 0xFFFF) == 8) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                colorConverter = n5 == 2 ? new HorizontalPredictorRgb8888(n2, n3, n6, nArray.length) : new Rgb8888Converter(n2, n3, n4, nArray.length, n6);
            }
        }
        if (colorConverter == null) {
            String string = "TiffImageException: Unsupported bits per sample ";
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                string = StringExtensions.plusEqOperator(string, Operators.boxing(nArray[i2]));
                if (i2 >= nArray.length - 1) continue;
                string = StringExtensions.plusEqOperator(string, ", ");
            }
            string = StringExtensions.plusEqOperator(string, " count.");
            throw new InvalidOperationException(string);
        }
        return colorConverter;
    }

    static class Bitmap16BitPaletteConverter
    extends ColorConverter {
        private final IColorPalette a;

        public Bitmap16BitPaletteConverter(int n2, int n3, int n4, IColorPalette iColorPalette) {
            super(n2, n3, n4, 16);
            if (iColorPalette == null) {
                throw new ArgumentNullException("palette");
            }
            this.a = iColorPalette;
        }

        @Override
        protected void convert(int[] nArray, int n2, int n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = this.a.getNearestColorIndex(nArray[n2++]) & 0xFFFF;
                byte[] byArray = BitConverter.getBytesUInt16(n4);
                Buffer.blockCopy(Array.boxing(byArray), 0, Array.boxing(this.buffer), this.bufferIndex, 2);
                this.bufferIndex += 2;
            }
        }
    }

    static class Bitmap16BitGrayscaleConverter
    extends ColorConverter {
        private final IColorPalette a;

        public Bitmap16BitGrayscaleConverter(int n2, int n3, int n4, IColorPalette iColorPalette) {
            super(n2, n3, n4, 16);
            if (iColorPalette == null) {
                throw new ArgumentNullException("palette");
            }
            this.a = iColorPalette;
        }

        @Override
        protected void convert(int[] nArray, int n2, int n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = this.a.getNearestColorIndex(nArray[n2++]) & 0xFFFF;
                ByteConverter.writeBigEndianBytesUInt16(n4, this.buffer, this.bufferIndex);
                this.bufferIndex += 2;
            }
        }
    }

    static class Bitmap8BitPredictorConverter
    extends ColorConverter {
        private final IColorPalette a;
        private byte b;

        public Bitmap8BitPredictorConverter(int n2, int n3, IColorPalette iColorPalette) {
            super(n2, n3, 1, 8);
            if (iColorPalette == null) {
                throw new ArgumentNullException("palette");
            }
            this.a = iColorPalette;
        }

        @Override
        protected void convert(int[] nArray, int n2, int n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                byte by2 = (byte)this.a.getNearestColorIndex(nArray[n2++]);
                this.buffer[this.bufferIndex++] = (byte)((by2 & 0xFF) - (this.b & 0xFF));
                this.b = by2;
            }
            if (this.rowLeft - n3 == 0) {
                this.b = 0;
            }
        }
    }

    static class Bitmap8BitConverter
    extends ColorConverter {
        private final IColorPalette a;

        public Bitmap8BitConverter(int n2, int n3, int n4, IColorPalette iColorPalette) {
            super(n2, n3, n4, 8);
            if (iColorPalette == null) {
                throw new ArgumentNullException("palette");
            }
            this.a = iColorPalette;
        }

        @Override
        protected void convert(int[] nArray, int n2, int n3) {
            Integer n4 = null;
            Byte by2 = null;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n5 = nArray[n2++];
                byte by3 = n4 != null && n4 == n5 ? by2 : (byte)this.a.getNearestColorIndex(n5);
                this.buffer[this.bufferIndex++] = by3;
                n4 = n5;
                by2 = by3;
            }
        }
    }

    static class Bitmap4BitConverter
    extends ColorConverter {
        private final IColorPalette a;

        public Bitmap4BitConverter(int n2, int n3, int n4, IColorPalette iColorPalette) {
            super(n2, n3, n4, 4);
            if (iColorPalette == null) {
                throw new ArgumentNullException("palette");
            }
            this.a = iColorPalette;
        }

        @Override
        protected void convert(int[] nArray, int n2, int n3) {
            while (n3 > 0) {
                int n4 = msMath.min((this.bitIndex + 1) / 4, n3);
                byte by2 = this.buffer[this.bufferIndex];
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n5 = this.a.getNearestColorIndex(nArray[n2++]);
                    int n6 = this.bitIndex - 3;
                    by2 = (byte)(by2 & 0xFF & ((byte)(~(15 << n6)) & 0xFF));
                    by2 = (byte)(by2 & 0xFF | (byte)(n5 << n6) & 0xFF);
                    this.bitIndex -= 4;
                }
                this.buffer[this.bufferIndex] = by2;
                n3 -= n4;
                if (this.bitIndex >= 0) continue;
                this.bitIndex = 7;
                ++this.bufferIndex;
            }
        }
    }

    static class Bitmap1BitConverter
    extends ColorConverter {
        private final IColorPalette a;

        public Bitmap1BitConverter(int n2, int n3, int n4, IColorPalette iColorPalette) {
            super(n2, n3, n4, 1);
            if (iColorPalette == null) {
                throw new ArgumentNullException("palette");
            }
            this.a = iColorPalette;
        }

        @Override
        protected void convert(int[] nArray, int n2, int n3) {
            while (n3 > 0) {
                int n4 = msMath.min(this.bitIndex + 1, n3);
                byte by2 = this.buffer[this.bufferIndex];
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n5 = this.a.getNearestColorIndex(nArray[n2++]);
                    byte by3 = (byte)(1 << this.bitIndex);
                    by2 = n5 == 1 ? (byte)(by2 & 0xFF | by3 & 0xFF) : (byte)(by2 & 0xFF & ((byte)(~(by3 & 0xFF)) & 0xFF));
                    --this.bitIndex;
                }
                this.buffer[this.bufferIndex] = by2;
                n3 -= n4;
                if (this.bitIndex >= 0) continue;
                this.bitIndex = 7;
                ++this.bufferIndex;
            }
        }
    }

    static class HorizontalPredictorRgb8888
    extends HorizontalRgbPredictor {
        private final int a;

        public HorizontalPredictorRgb8888(int n2, int n3, int n4, int n5) {
            super(n2, n3, n4);
            this.a = n5;
        }

        @Override
        protected void convert(int[] nArray, int n2, int n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = nArray[n2++];
                byte by2 = (byte)(n4 >> 24);
                byte by3 = (byte)(n4 >> 16 & 0xFF);
                byte by4 = (byte)(n4 >> 8 & 0xFF);
                byte by5 = (byte)(n4 & 0xFF);
                this.buffer[this.bufferIndex] = (byte)((by3 & 0xFF) - (this.oldR & 0xFF));
                this.buffer[this.bufferIndex + 1] = (byte)((by4 & 0xFF) - (this.oldG & 0xFF));
                this.buffer[this.bufferIndex + 2] = (byte)((by5 & 0xFF) - (this.oldB & 0xFF));
                this.buffer[this.bufferIndex + 3] = (byte)((by2 & 0xFF) - (this.oldA & 0xFF));
                this.bufferIndex += this.a;
                this.oldA = by2;
                this.oldR = by3;
                this.oldG = by4;
                this.oldB = by5;
            }
            this.zeroPredictors(n3);
        }
    }

    static class HorizontalPredictorRgb888
    extends HorizontalRgbPredictor {
        public HorizontalPredictorRgb888(int n2, int n3) {
            super(n2, n3, 24);
        }

        @Override
        protected void convert(int[] nArray, int n2, int n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = nArray[n2++];
                byte by2 = (byte)(n4 >> 16 & 0xFF);
                byte by3 = (byte)(n4 >> 8 & 0xFF);
                byte by4 = (byte)(n4 & 0xFF);
                this.buffer[this.bufferIndex] = (byte)((by2 & 0xFF) - (this.oldR & 0xFF));
                this.buffer[this.bufferIndex + 1] = (byte)((by3 & 0xFF) - (this.oldG & 0xFF));
                this.buffer[this.bufferIndex + 2] = (byte)((by4 & 0xFF) - (this.oldB & 0xFF));
                this.bufferIndex += 3;
                this.oldR = by2;
                this.oldG = by3;
                this.oldB = by4;
            }
            this.zeroPredictors(n3);
        }
    }

    static abstract class HorizontalRgbPredictor
    extends ColorConverter {
        protected byte oldR;
        protected byte oldG;
        protected byte oldB;
        protected byte oldA;

        protected HorizontalRgbPredictor(int n2, int n3, int n4) {
            super(n2, n3, 1, n4);
            this.rowLeft = n2;
        }

        protected void zeroPredictors(int n2) {
            if (this.rowLeft - n2 == 0) {
                this.oldA = 0;
                this.oldR = 0;
                this.oldG = 0;
                this.oldB = 0;
            }
        }
    }

    static class Rgb8888Converter
    extends ColorConverter {
        private final int a;

        public Rgb8888Converter(int n2, int n3, int n4, int n5, int n6) {
            super(n2, n3, n4, n6);
            this.a = n5;
        }

        @Override
        protected void convert(int[] nArray, int n2, int n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = nArray[n2++];
                byte by2 = (byte)(n4 >> 24);
                byte by3 = (byte)(n4 >> 16 & 0xFF);
                byte by4 = (byte)(n4 >> 8 & 0xFF);
                byte by5 = (byte)(n4 & 0xFF);
                this.buffer[this.bufferIndex] = by3;
                this.buffer[this.bufferIndex + 1] = by4;
                this.buffer[this.bufferIndex + 2] = by5;
                this.buffer[this.bufferIndex + 3] = by2;
                this.bufferIndex += this.a;
            }
        }
    }

    static class Rgb888Converter
    extends ColorConverter {
        public Rgb888Converter(int n2, int n3, int n4) {
            super(n2, n3, n4, 24);
        }

        @Override
        protected void convert(int[] nArray, int n2, int n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = nArray[n2++];
                byte by2 = (byte)(n4 >> 16 & 0xFF);
                byte by3 = (byte)(n4 >> 8 & 0xFF);
                byte by4 = (byte)(n4 & 0xFF);
                this.buffer[this.bufferIndex++] = by2;
                this.buffer[this.bufferIndex++] = by3;
                this.buffer[this.bufferIndex++] = by4;
            }
        }
    }

    protected static abstract class ColorConverter {
        protected final int width;
        private int a;
        private final int b;
        protected int rowLeft;
        private int c;
        protected final byte[] buffer;
        protected int bufferIndex;
        protected int bitIndex = 7;

        protected ColorConverter(int n2, int n3, int n4, int n5) {
            boolean bl2;
            this.b = n5;
            this.width = n2;
            this.c = n4;
            this.a = n3;
            boolean bl3 = bl2 = n2 * n5 % 8 != 0;
            if (bl2) {
                this.c = 1;
            }
            this.rowLeft = this.c * n2;
            this.buffer = BufferHelper.allocate((n2 * n5 + 7) / 8 * this.c);
            if (this.buffer.length * 8 / n5 == 0) {
                throw new InvalidOperationException("TiffImageException: The buffer allocated is too small. Cannot continue execution.");
            }
        }

        public void convert(int[] nArray, IAdvancedBufferProcessor iAdvancedBufferProcessor) {
            int n2 = 0;
            int n3 = nArray.length;
            int n4 = this.buffer.length;
            int n5 = this.a(n3 - n2);
            while (n5 > 0) {
                this.convert(nArray, n2, n5);
                n2 += n5;
                this.rowLeft -= n5;
                int n6 = ((n4 - this.bufferIndex) * 8 - (7 - this.bitIndex)) / this.b;
                if (this.rowLeft == 0 || n6 == 0) {
                    if (this.rowLeft == 0 && this.bitIndex != 7) {
                        ++this.bufferIndex;
                    }
                    iAdvancedBufferProcessor.processBuffer(this.buffer, this.bufferIndex);
                    if (this.rowLeft == 0) {
                        int n7 = msMath.min(this.a, this.c);
                        iAdvancedBufferProcessor.finishRows(n7);
                        this.a -= n7;
                        this.rowLeft = this.width * msMath.min(this.a, this.c);
                        this.bitIndex = 7;
                    } else if (this.bufferIndex > 0 && this.bufferIndex < n4 && this.bitIndex < 7) {
                        this.buffer[0] = this.buffer[this.bufferIndex];
                    }
                    this.bufferIndex = 0;
                }
                n5 = this.a(n3 - n2);
            }
        }

        protected abstract void convert(int[] var1, int var2, int var3);

        private int a(int n2) {
            int n3 = this.buffer.length;
            int n4 = ((n3 - this.bufferIndex) * 8 - (7 - this.bitIndex)) / this.b;
            int n5 = msMath.min(n2, n4);
            n5 = msMath.min(n5, this.rowLeft);
            return n5;
        }
    }
}

