/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.ico;

import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.ico.BmpEncoder;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.ico.BmpInfoHeader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.ico.IconEntry;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class IcoEncoder {
    static final int ICON_TYPE = 1;
    static final int CURSOR_TYPE = 2;

    private IcoEncoder() {
    }

    public static void write(BufferedImage bufferedImage, ImageOutputStream imageOutputStream) throws IOException {
        IcoEncoder.write(bufferedImage, -1, imageOutputStream);
    }

    public static void write(List<BufferedImage> list, ImageOutputStream imageOutputStream) throws IOException {
        IcoEncoder.write(list, null, null, imageOutputStream);
    }

    public static void write(BufferedImage bufferedImage, int n2, ImageOutputStream imageOutputStream) throws IOException {
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>(1);
        arrayList.add(bufferedImage);
        IcoEncoder.write(arrayList, new int[]{n2}, new boolean[]{false}, imageOutputStream);
    }

    public static void write(List<BufferedImage> list, int[] nArray, ImageOutputStream imageOutputStream) throws IOException {
        IcoEncoder.write(list, nArray, null, imageOutputStream);
    }

    public static void write(List<BufferedImage> list, int[] nArray, boolean[] blArray, ImageOutputStream imageOutputStream) throws IOException {
        Object object;
        Object object2;
        BufferedImage bufferedImage;
        int n2;
        int n3 = list.size();
        IcoEncoder.writeFileHeader(n3, 1, imageOutputStream);
        int n4 = 6 + n3 * 16;
        ArrayList<Object> arrayList = new ArrayList<Object>(n3);
        ArrayList<BufferedImage> arrayList2 = new ArrayList<BufferedImage>(n3);
        ArrayList<byte[]> arrayList3 = null;
        if (blArray != null) {
            arrayList3 = new ArrayList<byte[]>(n3);
        }
        ImageWriter imageWriter = null;
        for (n2 = 0; n2 < n3; ++n2) {
            bufferedImage = list.get(n2);
            int n5 = nArray == null ? -1 : nArray[n2];
            object2 = n5 == -1 ? bufferedImage : IcoEncoder.convert(bufferedImage, n5);
            arrayList2.add((BufferedImage)object2);
            object = BmpEncoder.createHeader((BufferedImage)object2, 0, 0);
            IconEntry iconEntry = IcoEncoder.createIconEntry((BmpInfoHeader)object);
            if (blArray != null) {
                if (blArray[n2]) {
                    if (imageWriter == null) {
                        imageWriter = IcoEncoder.a();
                    }
                    byte[] byArray = IcoEncoder.a(imageWriter, (BufferedImage)object2);
                    arrayList3.add(byArray);
                    iconEntry.sizeInBytes = byArray.length;
                } else {
                    arrayList3.add(null);
                }
            }
            ((BmpInfoHeader)object).height *= 2;
            iconEntry.fileOffset = n4;
            n4 += iconEntry.sizeInBytes;
            iconEntry.write(imageOutputStream);
            arrayList.add(object);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            bufferedImage = list.get(n2);
            BufferedImage bufferedImage2 = (BufferedImage)arrayList2.get(n2);
            if (blArray == null || !blArray[n2]) {
                object2 = (BmpInfoHeader)arrayList.get(n2);
                ((BmpInfoHeader)object2).write(imageOutputStream);
                if (((BmpInfoHeader)object2).bitCount <= 8) {
                    object = (IndexColorModel)bufferedImage2.getColorModel();
                    BmpEncoder.writeColorMap((IndexColorModel)object, imageOutputStream);
                }
                IcoEncoder.a(bufferedImage2, (BmpInfoHeader)object2, imageOutputStream);
                IcoEncoder.writeAndBitmap(bufferedImage, nArray == null ? ((BmpInfoHeader)object2).bitCount : nArray[n2], imageOutputStream);
                continue;
            }
            object2 = (byte[])arrayList3.get(n2);
            imageOutputStream.write((byte[])object2);
        }
        imageOutputStream.flush();
    }

    public static void writeFileHeader(int n2, int n3, ImageOutputStream imageOutputStream) throws IOException {
        imageOutputStream.writeShort(0);
        imageOutputStream.writeShort((short)n3);
        imageOutputStream.writeShort((short)n2);
    }

    public static IconEntry createIconEntry(BmpInfoHeader bmpInfoHeader) {
        int n2;
        IconEntry iconEntry = new IconEntry();
        iconEntry.width = bmpInfoHeader.width == 256 ? 0 : bmpInfoHeader.width;
        iconEntry.height = bmpInfoHeader.height == 256 ? 0 : bmpInfoHeader.height;
        iconEntry.colorCount = bmpInfoHeader.numColors >= 256 ? 0 : bmpInfoHeader.numColors;
        iconEntry.reserved = 0;
        iconEntry.planes = 1;
        iconEntry.bitCount = bmpInfoHeader.bitCount;
        int n3 = bmpInfoHeader.bitCount <= 8 ? (1 << bmpInfoHeader.bitCount) * 4 : 0;
        int n4 = BmpEncoder.getBitmapSize(bmpInfoHeader.width, bmpInfoHeader.height, bmpInfoHeader.bitCount);
        int n5 = BmpEncoder.getBitmapSize(bmpInfoHeader.width, bmpInfoHeader.height, 1);
        iconEntry.sizeInBytes = n2 = bmpInfoHeader.size + n3 + n4 + n5;
        iconEntry.fileOffset = 0;
        return iconEntry;
    }

    public static void writeAndBitmap(BufferedImage bufferedImage, int n2, ImageOutputStream imageOutputStream) throws IOException {
        WritableRaster writableRaster = bufferedImage.getAlphaRaster();
        if (bufferedImage.getColorModel() instanceof IndexColorModel && bufferedImage.getColorModel().hasAlpha()) {
            int n3 = bufferedImage.getWidth();
            int n4 = bufferedImage.getHeight();
            int n5 = BmpEncoder.calcStride(n3, n2);
            byte[] byArray = new byte[n5];
            IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
            WritableRaster writableRaster2 = bufferedImage.getRaster();
            for (int i2 = n4 - 1; i2 >= 0; --i2) {
                for (int i3 = 0; i3 < n3; ++i3) {
                    int n6 = i3 / 8;
                    int n7 = i3 % 8;
                    int n8 = writableRaster2.getSample(i3, i2, 0);
                    int n9 = indexColorModel.getAlpha(n8);
                    int n10 = ~n9 & 1;
                    byArray[n6] = IcoEncoder.a(byArray[n6], n7, n10);
                }
                imageOutputStream.write(byArray);
            }
        } else if (writableRaster == null) {
            int n11;
            int n12 = bufferedImage.getHeight();
            int n13 = bufferedImage.getWidth();
            int n14 = BmpEncoder.calcStride(n13, n2);
            byte[] byArray = new byte[n14];
            for (n11 = 0; n11 < n14; ++n11) {
                byArray[n11] = 0;
            }
            for (n11 = n12 - 1; n11 >= 0; --n11) {
                imageOutputStream.write(byArray);
            }
        } else {
            int n15 = bufferedImage.getWidth();
            int n16 = bufferedImage.getHeight();
            int n17 = BmpEncoder.calcStride(n15, 1);
            byte[] byArray = new byte[n17];
            for (int i4 = n16 - 1; i4 >= 0; --i4) {
                for (int i5 = 0; i5 < n15; ++i5) {
                    int n18 = i5 / 8;
                    int n19 = i5 % 8;
                    int n20 = writableRaster.getSample(i5, i4, 0);
                    int n21 = ~n20 & 1;
                    byArray[n18] = IcoEncoder.a(byArray[n18], n19, n21);
                }
                imageOutputStream.write(byArray);
            }
        }
        imageOutputStream.flush();
    }

    private static byte a(byte by2, int n2, int n3) {
        int n4 = 1 << 7 - n2;
        by2 = (byte)(by2 & ~n4);
        by2 = (byte)(by2 | n3 << 7 - n2);
        return by2;
    }

    private static void a(BufferedImage bufferedImage, BmpInfoHeader bmpInfoHeader, ImageOutputStream imageOutputStream) throws IOException {
        WritableRaster writableRaster = bufferedImage.getRaster();
        switch (bmpInfoHeader.bitCount) {
            case 1: {
                BmpEncoder.write1bpp(writableRaster, imageOutputStream);
                break;
            }
            case 4: {
                BmpEncoder.write4bpp(writableRaster, imageOutputStream);
                break;
            }
            case 8: {
                BmpEncoder.write8bpp(writableRaster, imageOutputStream);
                break;
            }
            case 24: {
                BmpEncoder.write24bpp(writableRaster, imageOutputStream);
                break;
            }
            case 32: {
                WritableRaster writableRaster2 = bufferedImage.getAlphaRaster();
                BmpEncoder.write32bpp(writableRaster, writableRaster2, imageOutputStream);
            }
        }
    }

    public static BufferedImage convert(BufferedImage bufferedImage, int n2) {
        BufferedImage bufferedImage2 = null;
        switch (n2) {
            case 1: {
                bufferedImage2 = ColorDepthConverter.convert1(bufferedImage);
                break;
            }
            case 4: {
                bufferedImage2 = ColorDepthConverter.convert4(bufferedImage);
                break;
            }
            case 8: {
                bufferedImage2 = ColorDepthConverter.convert8(bufferedImage);
                break;
            }
            case 24: {
                int n3 = bufferedImage.getColorModel().getPixelSize();
                if (n3 == 24 || n3 == 32) {
                    bufferedImage2 = bufferedImage;
                    break;
                }
                bufferedImage2 = ColorDepthConverter.convert24(bufferedImage);
                break;
            }
            case 32: {
                int n4 = bufferedImage.getColorModel().getPixelSize();
                bufferedImage2 = n4 == 24 || n4 == 32 ? bufferedImage : ColorDepthConverter.convert32(bufferedImage);
            }
        }
        return bufferedImage2;
    }

    private static ImageWriter a() {
        ImageWriter imageWriter = null;
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("png");
        if (iterator.hasNext()) {
            imageWriter = iterator.next();
        }
        return imageWriter;
    }

    private static byte[] a(ImageWriter imageWriter, BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(bufferedImage);
        byteArrayOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    static class ColorDepthConverter {
        ColorDepthConverter() {
        }

        public static BufferedImage convert1(BufferedImage bufferedImage) {
            IndexColorModel indexColorModel = new IndexColorModel(1, 2, new byte[]{0, -1}, new byte[]{0, -1}, new byte[]{0, -1});
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 12, indexColorModel);
            ColorConvertOp colorConvertOp = new ColorConvertOp(bufferedImage.getColorModel().getColorSpace(), bufferedImage2.getColorModel().getColorSpace(), null);
            colorConvertOp.filter(bufferedImage, bufferedImage2);
            return bufferedImage2;
        }

        public static BufferedImage convert4(BufferedImage bufferedImage) {
            int[] nArray = new int[]{0, 0x800000, 32768, 0x808000, 128, 0x800080, 32896, 0x808080, 0xC0C0C0, 0xFF0000, 65280, 0xFFFF00, 255, 0xFF00FF, 65535, 0xFFFFFF};
            return ColorDepthConverter.convert4(bufferedImage, nArray);
        }

        public static BufferedImage convert4(BufferedImage bufferedImage, int[] nArray) {
            IndexColorModel indexColorModel = new IndexColorModel(4, nArray.length, nArray, 0, false, 1, 0);
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 12, indexColorModel);
            ColorConvertOp colorConvertOp = new ColorConvertOp(bufferedImage.getColorModel().getColorSpace(), bufferedImage2.getColorModel().getColorSpace(), null);
            colorConvertOp.filter(bufferedImage, bufferedImage2);
            return bufferedImage2;
        }

        public static BufferedImage convert8(BufferedImage bufferedImage) {
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 13);
            ColorConvertOp colorConvertOp = new ColorConvertOp(bufferedImage.getColorModel().getColorSpace(), bufferedImage2.getColorModel().getColorSpace(), null);
            colorConvertOp.filter(bufferedImage, bufferedImage2);
            return bufferedImage2;
        }

        public static BufferedImage convert24(BufferedImage bufferedImage) {
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
            ColorConvertOp colorConvertOp = new ColorConvertOp(bufferedImage.getColorModel().getColorSpace(), bufferedImage2.getColorModel().getColorSpace(), null);
            colorConvertOp.filter(bufferedImage, bufferedImage2);
            return bufferedImage2;
        }

        public static BufferedImage convert32(BufferedImage bufferedImage) {
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
            ColorConvertOp colorConvertOp = new ColorConvertOp(bufferedImage.getColorModel().getColorSpace(), bufferedImage2.getColorModel().getColorSpace(), null);
            colorConvertOp.filter(bufferedImage, bufferedImage2);
            return bufferedImage2;
        }
    }
}

