/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks;

import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.PngHelperInternal;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.PngjBadCrcException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.PngjOutputException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.zip.CRC32;
import javax.imageio.stream.ImageOutputStream;

public class ChunkRaw {
    public final int len;
    public final byte[] idbytes = new byte[4];
    public byte[] data = null;
    private int a = 0;

    public ChunkRaw(int n2, byte[] byArray, boolean bl2) {
        this.len = n2;
        System.arraycopy(byArray, 0, this.idbytes, 0, 4);
        if (bl2) {
            this.a();
        }
    }

    private void a() {
        if (this.data == null || this.data.length < this.len) {
            this.data = new byte[this.len];
        }
    }

    private int b() {
        CRC32 cRC32 = PngHelperInternal.getCRC();
        cRC32.reset();
        cRC32.update(this.idbytes, 0, 4);
        if (this.len > 0) {
            cRC32.update(this.data, 0, this.len);
        }
        return (int)cRC32.getValue();
    }

    public void writeChunk(ImageOutputStream imageOutputStream) {
        if (this.idbytes.length != 4) {
            throw new PngjOutputException("bad chunkid [" + ChunkHelper.toString(this.idbytes) + "]");
        }
        this.a = this.b();
        PngHelperInternal.writeInt4(imageOutputStream, this.len);
        PngHelperInternal.writeBytes(imageOutputStream, this.idbytes);
        if (this.len > 0) {
            PngHelperInternal.writeBytes(imageOutputStream, this.data, 0, this.len);
        }
        PngHelperInternal.writeInt4(imageOutputStream, this.a);
    }

    public int readChunkData(InputStream inputStream, boolean bl2) {
        int n2;
        PngHelperInternal.readBytes(inputStream, this.data, 0, this.len);
        this.a = PngHelperInternal.readInt4(inputStream);
        if (bl2 && (n2 = this.b()) != this.a) {
            throw new PngjBadCrcException("chunk: " + this + " crc calc=" + n2 + " read=" + this.a);
        }
        return this.len + 4;
    }

    ByteArrayInputStream getAsByteStream() {
        return new ByteArrayInputStream(this.data);
    }

    public String toString() {
        return "chunkid=" + ChunkHelper.toString(this.idbytes) + " len=" + this.len;
    }
}

