/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.extensions;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.Collections.ArrayList;
import com.aspose.html.utils.ms.System.Environment;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.ASN1Convert;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.X509Extension;
import com.aspose.html.utils.ms.lang.Operators;
import com.aspose.html.utils.ms.lang.StringSwitchMap;

public class ExtendedKeyUsageExtension
extends X509Extension {
    private ArrayList a;
    private static final StringSwitchMap b = new StringSwitchMap("1.3.6.1.5.5.7.3.1", "1.3.6.1.5.5.7.3.2", "1.3.6.1.5.5.7.3.3", "1.3.6.1.5.5.7.3.4", "1.3.6.1.5.5.7.3.8", "1.3.6.1.5.5.7.3.9");

    public ExtendedKeyUsageExtension() {
        this.extnOid = "2.5.29.37";
        this.a = new ArrayList();
    }

    public ExtendedKeyUsageExtension(ASN1 aSN1) {
        super(aSN1);
    }

    public ExtendedKeyUsageExtension(X509Extension x509Extension) {
        super(x509Extension);
    }

    @Override
    public void decode() {
        this.a = new ArrayList();
        ASN1 aSN1 = new ASN1(this.extnValue.getValue());
        if (Operators.castToInt32(aSN1.getTag(), 6) != 48) {
            throw new ArgumentException("Invalid ExtendedKeyUsage extension");
        }
        for (int i2 = 0; i2 < aSN1.getCount(); ++i2) {
            this.a.addItem(ASN1Convert.toOid(aSN1.get_Item(i2)));
        }
    }

    @Override
    public void encode() {
        ASN1 aSN1 = new ASN1(48);
        for (String string : this.a) {
            aSN1.add(ASN1Convert.fromOid(string));
        }
        this.extnValue = new ASN1(4);
        this.extnValue.add(aSN1);
    }

    public ArrayList getKeyPurpose() {
        return this.a;
    }

    @Override
    public String getName() {
        return "Extended Key Usage";
    }

    @Override
    public String toString() {
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        for (String string : this.a) {
            switch (b.of(string)) {
                case 0: {
                    msStringBuilder2.append("Server Authentication");
                    break;
                }
                case 1: {
                    msStringBuilder2.append("Client Authentication");
                    break;
                }
                case 2: {
                    msStringBuilder2.append("Code Signing");
                    break;
                }
                case 3: {
                    msStringBuilder2.append("Email Protection");
                    break;
                }
                case 4: {
                    msStringBuilder2.append("Time Stamping");
                    break;
                }
                case 5: {
                    msStringBuilder2.append("OCSP Signing");
                    break;
                }
                default: {
                    msStringBuilder2.append("unknown");
                }
            }
            msStringBuilder2.appendFormat(" ({0}){1}", string, Environment.get_NewLine());
        }
        return msStringBuilder2.toString();
    }
}

