/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.asymmetric;

import com.aspose.html.utils.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.utils.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.oiw.ElGamalParameter;
import com.aspose.html.utils.ms.core.bc.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.pkcs.DHParameter;
import com.aspose.html.utils.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.x9.DomainParameters;
import com.aspose.html.utils.ms.core.bc.asn1.x9.X9ObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.crypto.Algorithm;
import com.aspose.html.utils.ms.core.bc.crypto.AsymmetricKey;
import com.aspose.html.utils.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.DHDomainParameters;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.DHValidationParameters;
import com.aspose.html.utils.ms.core.bc.crypto.asymmetric.KeyUtils;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsUnapprovedOperationError;

public abstract class AsymmetricDHKey
implements AsymmetricKey {
    protected final boolean approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
    protected Algorithm algorithm;
    protected DHDomainParameters domainParameters;

    AsymmetricDHKey(Algorithm algorithm, DHDomainParameters dHDomainParameters) {
        this.algorithm = algorithm;
        this.domainParameters = dHDomainParameters;
    }

    AsymmetricDHKey(Algorithm algorithm, AlgorithmIdentifier algorithmIdentifier) {
        this.algorithm = algorithm;
        this.domainParameters = AsymmetricDHKey.decodeDomainParameters(algorithmIdentifier);
    }

    private static DHDomainParameters decodeDomainParameters(AlgorithmIdentifier algorithmIdentifier) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
        if (aSN1Encodable == null) {
            throw new NullPointerException("AlgorithmIdentifier parameters cannot be empty");
        }
        if (aSN1ObjectIdentifier.equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter elGamalParameter = ElGamalParameter.getInstance(aSN1Encodable);
            return new DHDomainParameters(elGamalParameter.getP(), elGamalParameter.getG());
        }
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.dhKeyAgreement) || KeyUtils.isDHPKCSParam(aSN1Encodable)) {
            DHParameter dHParameter = DHParameter.getInstance(aSN1Encodable);
            if (dHParameter.getL() != null) {
                return new DHDomainParameters(dHParameter.getP(), null, dHParameter.getG(), dHParameter.getL().intValue());
            }
            return new DHDomainParameters(dHParameter.getP(), dHParameter.getG());
        }
        if (aSN1ObjectIdentifier.equals(X9ObjectIdentifiers.dhpublicnumber)) {
            DomainParameters domainParameters = DomainParameters.getInstance(aSN1Encodable);
            if (domainParameters.getValidationParams() != null) {
                return new DHDomainParameters(domainParameters.getP(), domainParameters.getQ(), domainParameters.getG(), domainParameters.getJ(), new DHValidationParameters(domainParameters.getValidationParams().getSeed(), domainParameters.getValidationParams().getPgenCounter().intValue()));
            }
            return new DHDomainParameters(domainParameters.getP(), domainParameters.getQ(), domainParameters.getG(), domainParameters.getJ(), null);
        }
        throw new IllegalArgumentException("Unknown algorithm type: " + aSN1ObjectIdentifier);
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public DHDomainParameters getDomainParameters() {
        return this.domainParameters;
    }

    protected final void checkApprovedOnlyModeStatus() {
        if (this.approvedModeOnly != CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("No access to key in current thread.");
        }
    }

    protected void zeroize() {
        this.algorithm = null;
        this.domainParameters = null;
    }
}

