/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.fips;

import com.aspose.html.utils.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.utils.ms.core.bc.crypto.EntropySource;
import com.aspose.html.utils.ms.core.bc.crypto.fips.DRBGUtils;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsAlgorithm;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsStatus;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsUnapprovedOperationError;
import com.aspose.html.utils.ms.core.bc.crypto.fips.SP80090DRBG;
import com.aspose.html.utils.ms.core.bc.crypto.fips.VariantInternalKatTest;
import com.aspose.html.utils.ms.core.bc.crypto.internal.BlockCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.KeyParameter;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.KeyParameterImpl;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import com.aspose.html.utils.ms.core.bc.util.Properties;
import com.aspose.html.utils.ms.core.bc.util.encoders.Hex;
import java.util.HashMap;
import java.util.Map;

class CTRSP800DRBG
implements SP80090DRBG {
    private static final long TDEA_RESEED_MAX = 0x80000000L;
    private static final long AES_RESEED_MAX = 0x800000000000L;
    private static final int TDEA_MAX_BITS_REQUEST = 4096;
    private static final int AES_MAX_BITS_REQUEST = 262144;
    private static final Map<String, byte[][]> kats = new HashMap<String, byte[][]>();
    private static final Map<String, byte[][]> reseedKats = new HashMap<String, byte[][]>();
    private static final Map<String, byte[][]> reseedValues = new HashMap<String, byte[][]>();
    private EntropySource _entropySource;
    private BlockCipher _engine;
    private int _keySizeInBits;
    private int _seedLength;
    private boolean _isTDEA = false;
    private int _securityStrength;
    private byte[] _Key;
    private byte[] _V;
    private long _reseedCounter = 0L;
    private static final byte[] K_BITS;

    public CTRSP800DRBG(BlockCipher blockCipher, int n2, int n3, EntropySource entropySource, byte[] byArray, byte[] byArray2) {
        this._engine = blockCipher;
        this._keySizeInBits = n2;
        this._seedLength = n2 + blockCipher.getBlockSize() * 8;
        this._isTDEA = this.isTDEA(blockCipher);
        if (!FipsStatus.isBooting() && this._isTDEA && CryptoServicesRegistrar.isInApprovedOnlyMode() && !Properties.isOverrideSet("com.aspose.html.utils.ms.core.bc.tripledes.allow_drbg")) {
            throw new FipsUnapprovedOperationError("Triple-DES CTRDRBG disallowed");
        }
        this.init(n3, entropySource, byArray, byArray2);
    }

    private void init(int n2, EntropySource entropySource, byte[] byArray, byte[] byArray2) {
        if (n2 > 256) {
            throw new IllegalArgumentException("Requested security strength is not supported by the derivation function");
        }
        if (this.getMaxSecurityStrength(this._engine, this._keySizeInBits) < n2) {
            throw new IllegalArgumentException("Requested security strength is not supported by the derivation function");
        }
        if (entropySource.entropySize() < n2) {
            throw new IllegalArgumentException("Not enough entropy for security strength required");
        }
        this._entropySource = entropySource;
        this._securityStrength = n2;
        this.CTR_DRBG_Instantiate_algorithm(byArray, byArray2);
    }

    private void CTR_DRBG_Instantiate_algorithm(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = this.getEntropy();
        byte[] byArray4 = Arrays.concatenate(byArray3, byArray2, byArray);
        Arrays.fill(byArray3, (byte)0);
        byte[] byArray5 = this.Block_Cipher_df(byArray4, this._seedLength);
        Arrays.fill(byArray4, (byte)0);
        int n2 = this._engine.getBlockSize();
        this._Key = new byte[this.getExpandedKeySizeInBytes()];
        this._V = new byte[n2];
        this.expandKey(this._Key);
        this.CTR_DRBG_Update(byArray5);
        Arrays.fill(byArray5, (byte)0);
        this._reseedCounter = 1L;
    }

    private void CTR_DRBG_Update(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        byte[] byArray3 = new byte[this._engine.getBlockSize()];
        int n2 = 0;
        int n3 = this._engine.getBlockSize();
        this._engine.init(true, new KeyParameterImpl(this._Key));
        while (n2 * n3 < byArray.length) {
            this.addOneTo(this._V);
            this._engine.processBlock(this._V, 0, byArray3, 0);
            int n4 = byArray2.length - n2 * n3 > n3 ? n3 : byArray2.length - n2 * n3;
            System.arraycopy(byArray3, 0, byArray2, n2 * n3, n4);
            ++n2;
        }
        Arrays.fill(byArray3, (byte)0);
        this.XOR(byArray2, byArray, byArray2, 0);
        System.arraycopy(byArray2, 0, this._Key, 0, this.getKeySizeInBytes());
        System.arraycopy(byArray2, this.getKeySizeInBytes(), this._V, 0, this._V.length);
        Arrays.fill(byArray2, (byte)0);
        this.expandKey(this._Key);
    }

    private void CTR_DRBG_Reseed_algorithm(byte[] byArray) {
        byte[] byArray2 = this.getEntropy();
        byte[] byArray3 = Arrays.concatenate(byArray2, byArray);
        Arrays.fill(byArray2, (byte)0);
        byte[] byArray4 = this.Block_Cipher_df(byArray3, this._seedLength);
        Arrays.fill(byArray3, (byte)0);
        this.CTR_DRBG_Update(byArray4);
        Arrays.fill(byArray4, (byte)0);
        this._reseedCounter = 1L;
    }

    private void XOR(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)(byArray2[i2] ^ byArray3[i2 + n2]);
        }
    }

    private void addOneTo(byte[] byArray) {
        int n2 = 1;
        for (int i2 = 1; i2 <= byArray.length; ++i2) {
            int n3 = (byArray[byArray.length - i2] & 0xFF) + n2;
            n2 = n3 > 255 ? 1 : 0;
            byArray[byArray.length - i2] = (byte)n3;
        }
    }

    private byte[] Block_Cipher_df(byte[] byArray, int n2) {
        int n3 = this._engine.getBlockSize();
        int n4 = byArray.length;
        int n5 = n2 / 8;
        int n6 = 8 + n4 + 1;
        int n7 = (n6 + n3 - 1) / n3 * n3;
        byte[] byArray2 = new byte[n7];
        this.copyIntToByteArray(byArray2, n4, 0);
        this.copyIntToByteArray(byArray2, n5, 4);
        System.arraycopy(byArray, 0, byArray2, 8, n4);
        byArray2[8 + n4] = -128;
        byte[] byArray3 = new byte[this.getKeySizeInBytes() + n3];
        byte[] byArray4 = new byte[n3];
        byte[] byArray5 = new byte[n3];
        int n8 = 0;
        byte[] byArray6 = new byte[this.getExpandedKeySizeInBytes()];
        System.arraycopy(K_BITS, 0, byArray6, 0, this.getKeySizeInBytes());
        this.expandKey(byArray6);
        KeyParameterImpl keyParameterImpl = new KeyParameterImpl(byArray6);
        while (n8 * n3 * 8 < this._keySizeInBits + n3 * 8) {
            this.copyIntToByteArray(byArray5, n8, 0);
            this.BCC(byArray4, keyParameterImpl, byArray5, byArray2);
            int n9 = byArray3.length - n8 * n3 > n3 ? n3 : byArray3.length - n8 * n3;
            System.arraycopy(byArray4, 0, byArray3, n8 * n3, n9);
            ++n8;
        }
        Arrays.fill(byArray2, (byte)0);
        Arrays.fill(byArray4, (byte)0);
        Arrays.fill(byArray5, (byte)0);
        byte[] byArray7 = new byte[n3];
        System.arraycopy(byArray3, 0, byArray6, 0, this.getKeySizeInBytes());
        System.arraycopy(byArray3, this.getKeySizeInBytes(), byArray7, 0, byArray7.length);
        Arrays.fill(byArray3, (byte)0);
        this.expandKey(byArray6);
        byArray3 = new byte[n2 / 2];
        n8 = 0;
        this._engine.init(true, new KeyParameterImpl(byArray6));
        while (n8 * n3 < byArray3.length) {
            this._engine.processBlock(byArray7, 0, byArray7, 0);
            int n10 = byArray3.length - n8 * n3 > n3 ? n3 : byArray3.length - n8 * n3;
            System.arraycopy(byArray7, 0, byArray3, n8 * n3, n10);
            ++n8;
        }
        Arrays.fill(byArray7, (byte)0);
        Arrays.fill(byArray6, (byte)0);
        return byArray3;
    }

    private void BCC(byte[] byArray, KeyParameter keyParameter, byte[] byArray2, byte[] byArray3) {
        int n2 = this._engine.getBlockSize();
        byte[] byArray4 = new byte[n2];
        int n3 = byArray3.length / n2;
        byte[] byArray5 = new byte[n2];
        this._engine.init(true, keyParameter);
        this._engine.processBlock(byArray2, 0, byArray4, 0);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.XOR(byArray5, byArray4, byArray3, i2 * n2);
            this._engine.processBlock(byArray5, 0, byArray4, 0);
        }
        System.arraycopy(byArray4, 0, byArray, 0, byArray.length);
    }

    private void copyIntToByteArray(byte[] byArray, int n2, int n3) {
        byArray[n3 + 0] = (byte)(n2 >> 24);
        byArray[n3 + 1] = (byte)(n2 >> 16);
        byArray[n3 + 2] = (byte)(n2 >> 8);
        byArray[n3 + 3] = (byte)n2;
    }

    public int getBlockSize() {
        return this._V.length * 8;
    }

    public int getSecurityStrength() {
        return this._securityStrength;
    }

    public int generate(byte[] byArray, byte[] byArray2, boolean bl2) {
        byte[] byArray3;
        if (bl2) {
            this.CTR_DRBG_Reseed_algorithm(byArray2);
            byArray2 = null;
        }
        if (this._isTDEA) {
            if (this._reseedCounter > 0x80000000L) {
                return -1;
            }
            if (DRBGUtils.isTooLarge(byArray, 512)) {
                throw new IllegalArgumentException("Number of bits per request limited to 4096");
            }
        } else {
            if (this._reseedCounter > 0x800000000000L) {
                return -1;
            }
            if (DRBGUtils.isTooLarge(byArray, 32768)) {
                throw new IllegalArgumentException("Number of bits per request limited to 262144");
            }
        }
        if (byArray2 != null) {
            byArray3 = this.Block_Cipher_df(byArray2, this._seedLength);
            this.CTR_DRBG_Update(byArray3);
        } else {
            byArray3 = new byte[this._seedLength];
        }
        byte[] byArray4 = new byte[this._V.length];
        this._engine.init(true, new KeyParameterImpl(this._Key));
        for (int i2 = 0; i2 <= byArray.length / byArray4.length; ++i2) {
            int n2;
            int n3 = n2 = byArray.length - i2 * byArray4.length > byArray4.length ? byArray4.length : byArray.length - i2 * this._V.length;
            if (n2 == 0) continue;
            this.addOneTo(this._V);
            this._engine.processBlock(this._V, 0, byArray4, 0);
            System.arraycopy(byArray4, 0, byArray, i2 * byArray4.length, n2);
        }
        this.CTR_DRBG_Update(byArray3);
        Arrays.fill(byArray3, (byte)0);
        ++this._reseedCounter;
        return byArray.length * 8;
    }

    public void reseed(byte[] byArray) {
        this.CTR_DRBG_Reseed_algorithm(byArray);
    }

    private byte[] getEntropy() {
        byte[] byArray = this._entropySource.getEntropy();
        if (byArray == null || byArray.length < (this._securityStrength + 7) / 8) {
            throw new IllegalStateException("Insufficient entropy provided by entropy source");
        }
        return byArray;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Arrays.fill(this._Key, (byte)0);
        Arrays.fill(this._V, (byte)0);
    }

    public VariantInternalKatTest createSelfTest(FipsAlgorithm fipsAlgorithm) {
        return new VariantInternalKatTest(fipsAlgorithm){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void evaluate() throws Exception {
                byte[] byArray = CTRSP800DRBG.this._Key;
                byte[] byArray2 = CTRSP800DRBG.this._V;
                long l2 = CTRSP800DRBG.this._reseedCounter;
                EntropySource entropySource = CTRSP800DRBG.this._entropySource;
                try {
                    int n2;
                    byte[] byArray3;
                    byte[] byArray4;
                    block16: {
                        block15: {
                            block14: {
                                byArray4 = Hex.decode("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F70717273747576");
                                byArray3 = Hex.decode("2021222324");
                                n2 = CTRSP800DRBG.this.getMaxSecurityStrength(CTRSP800DRBG.this._engine, CTRSP800DRBG.this._keySizeInBits);
                                byte[][] byArray5 = (byte[][])kats.get(this.algorithm.getName());
                                CTRSP800DRBG.this.init(CTRSP800DRBG.this._securityStrength, new DRBGUtils.KATEntropyProvider().get(n2), byArray4, byArray3);
                                byte[] byArray6 = new byte[byArray5[0].length];
                                CTRSP800DRBG.this.generate(byArray6, null, true);
                                if (!Arrays.areEqual(byArray5[0], byArray6)) {
                                    this.fail("DRBG Block 1 KAT failure");
                                }
                                byArray6 = new byte[byArray5[1].length];
                                CTRSP800DRBG.this.generate(byArray6, null, true);
                                if (!Arrays.areEqual(byArray5[1], byArray6)) {
                                    this.fail("DRBG Block 2 KAT failure");
                                }
                                try {
                                    CTRSP800DRBG.this.init(CTRSP800DRBG.this._securityStrength, new DRBGUtils.LyingEntropySource(n2), byArray4, byArray3);
                                    this.fail("DRBG LyingEntropySource not detected in init");
                                }
                                catch (IllegalStateException illegalStateException) {
                                    if (illegalStateException.getMessage().equals("Insufficient entropy provided by entropy source")) break block14;
                                    this.fail("DRBG self test failed init entropy check");
                                }
                            }
                            try {
                                CTRSP800DRBG.this.init(CTRSP800DRBG.this._securityStrength, new DRBGUtils.LyingEntropySource(20), byArray4, byArray3);
                                this.fail("DRBG insufficient EntropySource not detected");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                if (illegalArgumentException.getMessage().equals("Not enough entropy for security strength required")) break block15;
                                this.fail("DRBG self test failed init entropy check");
                            }
                        }
                        try {
                            CTRSP800DRBG.this._entropySource = new DRBGUtils.LyingEntropySource(n2);
                            CTRSP800DRBG.this.reseed(null);
                            this.fail("DRBG LyingEntropySource not detected in reseed");
                        }
                        catch (IllegalStateException illegalStateException) {
                            if (illegalStateException.getMessage().equals("Insufficient entropy provided by entropy source")) break block16;
                            this.fail("DRBG self test failed reseed entropy check");
                        }
                    }
                    try {
                        CTRSP800DRBG.this.init(n2 + 1, new DRBGUtils.KATEntropyProvider().get(n2), byArray4, byArray3);
                        this.fail("DRBG successful initialise with too high security strength");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (!illegalArgumentException.getMessage().equals("Requested security strength is not supported by the derivation function")) {
                            this.fail("DRBG self test failed init security strength check");
                        }
                    }
                }
                finally {
                    CTRSP800DRBG.access$002(CTRSP800DRBG.this, byArray);
                    CTRSP800DRBG.access$102(CTRSP800DRBG.this, byArray2);
                    CTRSP800DRBG.this._reseedCounter = l2;
                    CTRSP800DRBG.this._entropySource = entropySource;
                }
            }
        };
    }

    public VariantInternalKatTest createReseedSelfTest(FipsAlgorithm fipsAlgorithm) {
        return new VariantInternalKatTest(fipsAlgorithm){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void evaluate() throws Exception {
                byte[] byArray = CTRSP800DRBG.this._Key;
                byte[] byArray2 = CTRSP800DRBG.this._V;
                long l2 = CTRSP800DRBG.this._reseedCounter;
                EntropySource entropySource = CTRSP800DRBG.this._entropySource;
                try {
                    byte[] byArray3 = Hex.decode("404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F70717273747576");
                    int n2 = CTRSP800DRBG.this.getMaxSecurityStrength(CTRSP800DRBG.this._engine, CTRSP800DRBG.this._keySizeInBits);
                    byte[][] byArray4 = (byte[][])reseedKats.get(this.algorithm.getName());
                    byte[][] byArray5 = (byte[][])reseedValues.get(this.algorithm.getName());
                    byte[] byArray6 = byArray5[0];
                    CTRSP800DRBG.access$002(CTRSP800DRBG.this, new byte[CTRSP800DRBG.this.getExpandedKeySizeInBytes()]);
                    System.arraycopy(byArray6, 0, CTRSP800DRBG.this._Key, 0, byArray6.length);
                    CTRSP800DRBG.this.expandKey(CTRSP800DRBG.this._Key);
                    CTRSP800DRBG.access$102(CTRSP800DRBG.this, Arrays.clone(byArray5[1]));
                    CTRSP800DRBG.this._entropySource = new DRBGUtils.KATEntropyProvider().get(n2);
                    CTRSP800DRBG.this.reseed(byArray3);
                    if (CTRSP800DRBG.this._reseedCounter != 1L) {
                        this.fail("DRBG reseedCounter failed to reset");
                    }
                    byArray6 = new byte[byArray4[0].length];
                    CTRSP800DRBG.this.generate(byArray6, null, false);
                    if (!Arrays.areEqual(byArray4[0], byArray6)) {
                        this.fail("DRBG Block 1 reseed KAT failure");
                    }
                    byArray6 = new byte[byArray4[1].length];
                    CTRSP800DRBG.this.generate(byArray6, null, false);
                    if (!Arrays.areEqual(byArray4[1], byArray6)) {
                        this.fail("DRBG Block 2 reseed KAT failure");
                    }
                    try {
                        CTRSP800DRBG.this._entropySource = new DRBGUtils.LyingEntropySource(n2);
                        CTRSP800DRBG.this.reseed(null);
                        this.fail("DRBG LyingEntropySource not detected");
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (!illegalStateException.getMessage().equals("Insufficient entropy provided by entropy source")) {
                            this.fail("DRBG self test failed reseed entropy check");
                        }
                    }
                }
                finally {
                    CTRSP800DRBG.access$002(CTRSP800DRBG.this, byArray);
                    CTRSP800DRBG.access$102(CTRSP800DRBG.this, byArray2);
                    CTRSP800DRBG.this._reseedCounter = l2;
                    CTRSP800DRBG.this._entropySource = entropySource;
                }
            }
        };
    }

    private boolean isTDEA(BlockCipher blockCipher) {
        return blockCipher.getAlgorithmName().equals("DESede") || blockCipher.getAlgorithmName().equals("TDEA");
    }

    private int getMaxSecurityStrength(BlockCipher blockCipher, int n2) {
        if (this.isTDEA(blockCipher) && n2 == 168) {
            return 112;
        }
        if (blockCipher.getAlgorithmName().equals("AES")) {
            return n2;
        }
        return -1;
    }

    private void expandKey(byte[] byArray) {
        if (this._isTDEA) {
            byte[] byArray2 = new byte[24];
            this.padKey(byArray, 0, byArray2, 0);
            this.padKey(byArray, 7, byArray2, 8);
            this.padKey(byArray, 14, byArray2, 16);
            System.arraycopy(byArray2, 0, byArray, 0, 24);
            Arrays.fill(byArray2, (byte)0);
        }
    }

    private int getExpandedKeySizeInBytes() {
        return this._isTDEA ? 24 : this.getKeySizeInBytes();
    }

    private int getKeySizeInBytes() {
        return (this._keySizeInBits + 7) / 8;
    }

    private void padKey(byte[] byArray, int n2, byte[] byArray2, int n3) {
        byArray2[n3 + 0] = (byte)(byArray[n2 + 0] & 0xFE);
        byArray2[n3 + 1] = (byte)(byArray[n2 + 0] << 7 | (byArray[n2 + 1] & 0xFC) >>> 1);
        byArray2[n3 + 2] = (byte)(byArray[n2 + 1] << 6 | (byArray[n2 + 2] & 0xF8) >>> 2);
        byArray2[n3 + 3] = (byte)(byArray[n2 + 2] << 5 | (byArray[n2 + 3] & 0xF0) >>> 3);
        byArray2[n3 + 4] = (byte)(byArray[n2 + 3] << 4 | (byArray[n2 + 4] & 0xE0) >>> 4);
        byArray2[n3 + 5] = (byte)(byArray[n2 + 4] << 3 | (byArray[n2 + 5] & 0xC0) >>> 5);
        byArray2[n3 + 6] = (byte)(byArray[n2 + 5] << 2 | (byArray[n2 + 6] & 0x80) >>> 6);
        byArray2[n3 + 7] = (byte)(byArray[n2 + 6] << 1);
        for (int i2 = n3; i2 <= n3 + 7; ++i2) {
            byte by2 = byArray2[i2];
            byArray2[i2] = (byte)(by2 & 0xFE | (by2 >> 1 ^ by2 >> 2 ^ by2 >> 3 ^ by2 >> 4 ^ by2 >> 5 ^ by2 >> 6 ^ by2 >> 7 ^ 1) & 1);
        }
    }

    static /* synthetic */ byte[] access$002(CTRSP800DRBG cTRSP800DRBG, byte[] byArray) {
        cTRSP800DRBG._Key = byArray;
        return byArray;
    }

    static /* synthetic */ byte[] access$102(CTRSP800DRBG cTRSP800DRBG, byte[] byArray) {
        cTRSP800DRBG._V = byArray;
        return byArray;
    }

    static {
        kats.put("TRIPLEDES", new byte[][]{Hex.decode("09b2711937c5fc9fdf6f7e070625b41f74916ddb93b9f7a7c90091f86cdf2003a052e8d17bc37d86"), Hex.decode("b5c3c811e17247830be34f9461bf991401edbe99bc0dd6668b5d3f2501d2659bf99da71e38979e75")});
        kats.put("AES-128", new byte[][]{Hex.decode("314069e227a6e4c59c402ac0f9189f921ef19673d16b3fd401ded2f3b8b1d19a1c3b11f948ba8e2a"), Hex.decode("36ccfd81909865e88091079bbd408e9943dd3bedf8e7521e43cd639fed11f482bb17a794ed0265f1")});
        kats.put("AES-192", new byte[][]{Hex.decode("7ee353634fb8bd87bd4a2b292db7a049615bb8ae6a887efb8e81af7124453dac21949cfb51dd065f"), Hex.decode("8861d7165d9983a987e4ac39b9013ae41377f2134e5c7b57d6f8a3653e0ee616f0ddc9e11d85a8fd")});
        kats.put("AES-256", new byte[][]{Hex.decode("f5771b72bb3c3ceeea5d4327159f7bcf5d3aed67adaa039528b3d5f846961700734ac1aa5d401709"), Hex.decode("a6b09617644ea00b797ce09060d23682b89a09c293fb5fac71ba77943421a7559557bd957bce64c9")});
        reseedValues.put("TRIPLEDES", new byte[][]{Hex.decode("0102030405060708090a0b0c0d0e0f101112131415"), Hex.decode("0807060504030201")});
        reseedValues.put("AES-128", new byte[][]{Hex.decode("0102030405060708090a0b0c0d0e0f10"), Hex.decode("100f0e0d0c0b0a090807060504030201")});
        reseedValues.put("AES-192", new byte[][]{Hex.decode("0102030405060708090a0b0c0d0e0f101112131415161718"), Hex.decode("100f0e0d0c0b0a090807060504030201")});
        reseedValues.put("AES-256", new byte[][]{Hex.decode("0102030405060708090a0b0c0d0e0f100102030405060708090a0b0c0d0e0f10"), Hex.decode("100f0e0d0c0b0a090807060504030201")});
        reseedKats.put("TRIPLEDES", new byte[][]{Hex.decode("48ce7cefb4ec0f4a5a3b50c09a309675a9827404e01e0adff50a6d8d895d0308f6fffaf5e8159a8a"), Hex.decode("19d8a900cf51f131070cbbf22a7028edb42d79c836feb0a270e6703bf7d64ffa7bab66922bc7597b")});
        reseedKats.put("AES-128", new byte[][]{Hex.decode("af649344a18257a1448aca5e7014c784cf01618ac354a4dd9b63b83f10fd4d31eff645b737619fd7"), Hex.decode("c63ff00c3f966108d53270633a945b87fd11d8344946589f1533617323895593229d060c0b25f53e")});
        reseedKats.put("AES-192", new byte[][]{Hex.decode("544c683bd1538f349b62135813dc752ee329244ec83e037039dc35beb12a28ea505cdb81ec4bd61e"), Hex.decode("58dda13ba129e5ea009c8d0dac7cc5c998b84d52f759acfffa9bdd08d7cdbedc185114e270679e99")});
        reseedKats.put("AES-256", new byte[][]{Hex.decode("e20e7e3e5fc4876ac58b412c20b0cd173e0c934762f32d558f84c7a533efcee1b1571253afe18551"), Hex.decode("bae2554712e8143be922d97125c7b88fd768dd7c359fc1fe413f6ba5cb83892fe4a407c8aec04762")});
        K_BITS = Hex.decode("000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F");
    }
}

