/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.fips;

import com.aspose.html.utils.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.utils.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.utils.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.utils.ms.core.bc.crypto.InvalidSignatureException;
import com.aspose.html.utils.ms.core.bc.crypto.Parameters;
import com.aspose.html.utils.ms.core.bc.crypto.UpdateOutputStream;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsOutputVerifier;
import com.aspose.html.utils.ms.core.bc.crypto.internal.DSA;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Digest;
import com.aspose.html.utils.ms.core.bc.crypto.internal.io.DigestOutputStream;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import java.io.IOException;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DSAOutputVerifier<T extends Parameters>
extends FipsOutputVerifier<T> {
    private final DSA dsa;
    private final Digest digest;
    private final T parameter;

    DSAOutputVerifier(DSA dSA, Digest digest, T t2) {
        this.dsa = dSA;
        this.digest = digest;
        this.parameter = t2;
    }

    @Override
    public T getParameters() {
        return this.parameter;
    }

    @Override
    public UpdateOutputStream getVerifyingStream() {
        return new DigestOutputStream(this.digest);
    }

    @Override
    public boolean isVerified(byte[] byArray) throws InvalidSignatureException {
        try {
            BigInteger[] bigIntegerArray = this.decode(byArray);
            byte[] byArray2 = new byte[this.digest.getDigestSize()];
            this.digest.doFinal(byArray2, 0);
            return this.dsa.verifySignature(byArray2, bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (Exception exception) {
            throw new InvalidSignatureException("Unable to process signature: " + exception.getMessage(), exception);
        }
    }

    public BigInteger[] decode(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
        if (aSN1Sequence.size() != 2) {
            throw new IOException("malformed signature");
        }
        if (!Arrays.areEqual(byArray, aSN1Sequence.getEncoded("DER"))) {
            throw new IOException("malformed signature");
        }
        BigInteger[] bigIntegerArray = new BigInteger[]{ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).getValue(), ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1)).getValue()};
        return bigIntegerArray;
    }
}

