/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.general;

import com.aspose.html.utils.ms.core.bc.crypto.Algorithm;
import com.aspose.html.utils.ms.core.bc.crypto.AuthenticationParametersWithIV;
import com.aspose.html.utils.ms.core.bc.crypto.IllegalKeyException;
import com.aspose.html.utils.ms.core.bc.crypto.ParametersWithIV;
import com.aspose.html.utils.ms.core.bc.crypto.SymmetricKey;
import com.aspose.html.utils.ms.core.bc.crypto.SymmetricSecretKey;
import com.aspose.html.utils.ms.core.bc.crypto.general.BlowfishEngine;
import com.aspose.html.utils.ms.core.bc.crypto.general.CipherKeyGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.general.CipherUtils;
import com.aspose.html.utils.ms.core.bc.crypto.general.GeneralAlgorithm;
import com.aspose.html.utils.ms.core.bc.crypto.general.GeneralAuthParameters;
import com.aspose.html.utils.ms.core.bc.crypto.general.GeneralParameters;
import com.aspose.html.utils.ms.core.bc.crypto.general.GeneralParametersWithIV;
import com.aspose.html.utils.ms.core.bc.crypto.general.GuardedAEADOperatorFactory;
import com.aspose.html.utils.ms.core.bc.crypto.general.GuardedMACOperatorFactory;
import com.aspose.html.utils.ms.core.bc.crypto.general.GuardedSymmetricKeyGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.general.GuardedSymmetricOperatorFactory;
import com.aspose.html.utils.ms.core.bc.crypto.general.Mode;
import com.aspose.html.utils.ms.core.bc.crypto.general.Padding;
import com.aspose.html.utils.ms.core.bc.crypto.general.PrivilegedUtils;
import com.aspose.html.utils.ms.core.bc.crypto.general.SelfTestExecutor;
import com.aspose.html.utils.ms.core.bc.crypto.general.Utils;
import com.aspose.html.utils.ms.core.bc.crypto.general.VariantKatTest;
import com.aspose.html.utils.ms.core.bc.crypto.internal.BlockCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.BufferedBlockCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.KeyGenerationParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Mac;
import com.aspose.html.utils.ms.core.bc.crypto.internal.ValidatedSymmetricKey;
import com.aspose.html.utils.ms.core.bc.crypto.internal.modes.AEADBlockCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.KeyParameterImpl;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import com.aspose.html.utils.ms.core.bc.util.encoders.Hex;
import java.security.SecureRandom;

public final class Blowfish {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("Blowfish");
    private static final EngineProvider ENGINE_PROVIDER;
    public static final Parameters ECB;
    public static final Parameters ECBwithPKCS7;
    public static final Parameters ECBwithISO10126_2;
    public static final Parameters ECBwithX923;
    public static final Parameters ECBwithISO7816_4;
    public static final Parameters ECBwithTBC;
    public static final Parameters CBC;
    public static final Parameters CBCwithPKCS7;
    public static final Parameters CBCwithISO10126_2;
    public static final Parameters CBCwithX923;
    public static final Parameters CBCwithISO7816_4;
    public static final Parameters CBCwithTBC;
    public static final Parameters CBCwithCS1;
    public static final Parameters CBCwithCS2;
    public static final Parameters CBCwithCS3;
    public static final Parameters CFB8;
    public static final Parameters CFB64;
    public static final Parameters OFB;
    public static final Parameters CTR;
    public static final AuthParameters EAX;
    public static final Parameters OpenPGPCFB;
    public static final AuthParameters CMAC;

    private Blowfish() {
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey symmetricKey, Algorithm algorithm) {
        ValidatedSymmetricKey validatedSymmetricKey = PrivilegedUtils.getValidatedKey(symmetricKey);
        int n2 = validatedSymmetricKey.getKeySizeInBits();
        if (Blowfish.invalidKeySize(n2)) {
            throw new IllegalKeyException("Blowfish key must be between 32 and 448 bits inclusive");
        }
        Utils.checkKeyAlgorithm(validatedSymmetricKey, ALGORITHM, algorithm);
        return validatedSymmetricKey;
    }

    private static boolean invalidKeySize(int n2) {
        return n2 < 32 || n2 > 448;
    }

    static {
        EngineProvider engineProvider = new EngineProvider();
        engineProvider.createEngine();
        ENGINE_PROVIDER = engineProvider;
        ECB = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB));
        ECBwithPKCS7 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.PKCS7));
        ECBwithISO10126_2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO10126_2));
        ECBwithX923 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.X923));
        ECBwithISO7816_4 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO7816_4));
        ECBwithTBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.TBC));
        CBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC));
        CBCwithPKCS7 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.PKCS7));
        CBCwithISO10126_2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO10126_2));
        CBCwithX923 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.X923));
        CBCwithISO7816_4 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO7816_4));
        CBCwithTBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.TBC));
        CBCwithCS1 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS1));
        CBCwithCS2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS2));
        CBCwithCS3 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS3));
        CFB8 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CFB8));
        CFB64 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CFB64));
        OFB = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.OFB64));
        CTR = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CTR));
        EAX = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.EAX));
        OpenPGPCFB = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.OpenPGPCFB));
        CMAC = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CMAC));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AEADOperatorFactory
    extends GuardedAEADOperatorFactory<AuthParameters> {
        @Override
        protected AEADBlockCipher createAEADCipher(boolean bl2, SymmetricKey symmetricKey, AuthParameters authParameters) {
            return CipherUtils.createStandardAEADCipher(bl2, Blowfish.validateKey(symmetricKey, authParameters.getAlgorithm()), (com.aspose.html.utils.ms.core.bc.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (AuthenticationParametersWithIV)authParameters);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AuthParameters
    extends GeneralAuthParameters<AuthParameters> {
        private AuthParameters(GeneralAlgorithm generalAlgorithm, byte[] byArray, int n2) {
            super(generalAlgorithm, 8, byArray, n2);
        }

        AuthParameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, null, Utils.getDefaultMacSize(generalAlgorithm, 64));
        }

        @Override
        protected AuthParameters create(GeneralAlgorithm generalAlgorithm, byte[] byArray, int n2) {
            return new AuthParameters(generalAlgorithm, byArray, n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class EngineProvider
    implements com.aspose.html.utils.ms.core.bc.crypto.internal.EngineProvider<BlockCipher> {
        private EngineProvider() {
        }

        @Override
        public BlockCipher createEngine() {
            return SelfTestExecutor.validate((Algorithm)ALGORITHM, new BlowfishEngine(), new VariantKatTest<BlowfishEngine>(){

                @Override
                public void evaluate(BlowfishEngine blowfishEngine) {
                    byte[] byArray = Hex.decode("00112233445566778899aabbccddeeff");
                    byte[] byArray2 = Hex.decode("1c6eba2c44705f4b5ade62b53554ae9a");
                    byte[] byArray3 = new byte[byArray.length];
                    KeyParameterImpl keyParameterImpl = new KeyParameterImpl(Hex.decode("101112131415161718191a1b1c1d1e1f"));
                    blowfishEngine.init(true, keyParameterImpl);
                    blowfishEngine.processBlock(byArray, 0, byArray3, 0);
                    blowfishEngine.processBlock(byArray, 8, byArray3, 8);
                    if (!Arrays.areEqual(byArray2, byArray3)) {
                        this.fail("Failed self test on encryption");
                    }
                    blowfishEngine.init(false, keyParameterImpl);
                    blowfishEngine.processBlock(byArray3, 0, byArray3, 0);
                    blowfishEngine.processBlock(byArray3, 8, byArray3, 8);
                    if (!Arrays.areEqual(byArray, byArray3)) {
                        this.fail("Failed self test on decryption");
                    }
                }
            });
        }
    }

    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator {
        private final GeneralAlgorithm algorithm;
        private final int keySizeInBits;
        private final SecureRandom random;

        public KeyGenerator(int n2, SecureRandom secureRandom) {
            this(ALGORITHM, n2, secureRandom);
        }

        public KeyGenerator(GeneralParameters generalParameters, int n2, SecureRandom secureRandom) {
            this((GeneralAlgorithm)generalParameters.getAlgorithm(), n2, secureRandom);
        }

        private KeyGenerator(GeneralAlgorithm generalAlgorithm, int n2, SecureRandom secureRandom) {
            this.algorithm = generalAlgorithm;
            if (Blowfish.invalidKeySize(n2)) {
                throw new IllegalArgumentException("Attempt to create key with invalid key size [" + n2 + "]: " + generalAlgorithm.getName());
            }
            this.keySizeInBits = n2;
            this.random = secureRandom;
        }

        public SymmetricKey doGenerateKey() {
            CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
            cipherKeyGenerator.init(new KeyGenerationParameters(this.random, this.keySizeInBits));
            return new SymmetricSecretKey(this.algorithm, cipherKeyGenerator.generateKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MACOperatorFactory
    extends GuardedMACOperatorFactory<AuthParameters> {
        @Override
        protected Mac createMAC(SymmetricKey symmetricKey, AuthParameters authParameters) {
            return CipherUtils.createStandardMac(Blowfish.validateKey(symmetricKey, authParameters.getAlgorithm()), (com.aspose.html.utils.ms.core.bc.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (GeneralAuthParameters)authParameters);
        }

        @Override
        protected int calculateMACSize(AuthParameters authParameters) {
            return Utils.bitsToBytes(authParameters.macLenInBits);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory
    extends GuardedSymmetricOperatorFactory<Parameters> {
        @Override
        protected BufferedBlockCipher createCipher(boolean bl2, SymmetricKey symmetricKey, Parameters parameters, SecureRandom secureRandom) {
            return CipherUtils.createStandardCipher(bl2, Blowfish.validateKey(symmetricKey, parameters.getAlgorithm()), (com.aspose.html.utils.ms.core.bc.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (ParametersWithIV)parameters, secureRandom);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Parameters
    extends GeneralParametersWithIV<Parameters> {
        private Parameters(GeneralAlgorithm generalAlgorithm, byte[] byArray) {
            super(generalAlgorithm, 8, generalAlgorithm.checkIv(byArray, 8));
        }

        Parameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, null);
        }

        @Override
        protected Parameters create(GeneralAlgorithm generalAlgorithm, byte[] byArray) {
            return new Parameters(generalAlgorithm, byArray);
        }
    }
}

