/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.general;

import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.utils.ms.core.bc.crypto.general.Ed25519PublicKeyParameters;
import com.aspose.html.utils.ms.core.bc.crypto.general.Register;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Digest;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.AsymmetricKeyParameter;
import com.aspose.html.utils.ms.core.bc.math.ec.rfc8032.Ed25519;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import com.aspose.html.utils.ms.core.bc.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;

final class Ed25519PrivateKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 32;
    public static final int SIGNATURE_SIZE = 64;
    private final Ed25519 ed25519 = new Ed25519(){

        public Digest createDigest() {
            return Register.createDigest(FipsSHS.Algorithm.SHA512);
        }
    };
    private final byte[] data = new byte[32];

    public Ed25519PrivateKeyParameters(SecureRandom secureRandom) {
        super(true);
        this.ed25519.generatePrivateKey(secureRandom, this.data);
    }

    public Ed25519PrivateKeyParameters(byte[] byArray, int n2) {
        super(true);
        System.arraycopy(byArray, n2, this.data, 0, 32);
    }

    public Ed25519PrivateKeyParameters(InputStream inputStream) throws IOException {
        super(true);
        if (32 != Streams.readFully(inputStream, this.data)) {
            throw new EOFException("EOF encountered in middle of Ed25519 private key");
        }
    }

    public void encode(byte[] byArray, int n2) {
        System.arraycopy(this.data, 0, byArray, n2, 32);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }

    public Ed25519PublicKeyParameters generatePublicKey() {
        byte[] byArray = new byte[32];
        this.ed25519.generatePublicKey(this.data, 0, byArray, 0);
        return new Ed25519PublicKeyParameters(byArray, 0);
    }

    public void sign(int n2, Ed25519PublicKeyParameters ed25519PublicKeyParameters, byte[] byArray, byte[] byArray2, int n3, int n4, byte[] byArray3, int n5) {
        byte[] byArray4 = new byte[32];
        if (null == ed25519PublicKeyParameters) {
            this.ed25519.generatePublicKey(this.data, 0, byArray4, 0);
        } else {
            ed25519PublicKeyParameters.encode(byArray4, 0);
        }
        switch (n2) {
            case 0: {
                if (null != byArray) {
                    throw new IllegalArgumentException("ctx");
                }
                this.ed25519.sign(this.data, 0, byArray4, 0, byArray2, n3, n4, byArray3, n5);
                break;
            }
            case 1: {
                this.ed25519.sign(this.data, 0, byArray4, 0, byArray, byArray2, n3, n4, byArray3, n5);
                break;
            }
            case 2: {
                if (64 != n4) {
                    throw new IllegalArgumentException("msgLen");
                }
                this.ed25519.signPrehash(this.data, 0, byArray4, 0, byArray, byArray2, n3, byArray3, n5);
                break;
            }
            default: {
                throw new IllegalArgumentException("algorithm");
            }
        }
    }
}

