/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.general;

import com.aspose.html.utils.ms.core.bc.crypto.general.X448PublicKeyParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.params.AsymmetricKeyParameter;
import com.aspose.html.utils.ms.core.bc.math.ec.rfc7748.X448;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import com.aspose.html.utils.ms.core.bc.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;

final class X448PrivateKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 56;
    public static final int SECRET_SIZE = 56;
    private final byte[] data = new byte[56];

    public X448PrivateKeyParameters(SecureRandom secureRandom) {
        super(true);
        X448.generatePrivateKey(secureRandom, this.data);
    }

    public X448PrivateKeyParameters(byte[] byArray, int n2) {
        super(true);
        System.arraycopy(byArray, n2, this.data, 0, 56);
    }

    public X448PrivateKeyParameters(InputStream inputStream) throws IOException {
        super(true);
        if (56 != Streams.readFully(inputStream, this.data)) {
            throw new EOFException("EOF encountered in middle of X448 private key");
        }
    }

    public void encode(byte[] byArray, int n2) {
        System.arraycopy(this.data, 0, byArray, n2, 56);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }

    public X448PublicKeyParameters generatePublicKey() {
        byte[] byArray = new byte[56];
        X448.scalarMultBase(this.data, 0, byArray, 0);
        return new X448PublicKeyParameters(byArray, 0);
    }

    public void generateSecret(X448PublicKeyParameters x448PublicKeyParameters, byte[] byArray, int n2) {
        byte[] byArray2 = new byte[56];
        x448PublicKeyParameters.encode(byArray2, 0);
        if (!X448.calculateAgreement(this.data, 0, byArray2, 0, byArray, n2)) {
            throw new IllegalStateException("X448 agreement failed");
        }
    }
}

