/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.internal.digests;

import com.aspose.html.utils.ms.core.bc.crypto.internal.ExtendedDigest;
import com.aspose.html.utils.ms.core.bc.util.Memoable;

public abstract class GeneralDigest
implements ExtendedDigest,
Memoable {
    private static final int BYTE_LENGTH = 64;
    private byte[] xBuf;
    private int xBufOff;
    private long byteCount;

    public GeneralDigest() {
        this.xBuf = new byte[4];
        this.xBufOff = 0;
    }

    public GeneralDigest(GeneralDigest generalDigest) {
        this.xBuf = new byte[generalDigest.xBuf.length];
        this.copyIn(generalDigest);
    }

    public void copyIn(GeneralDigest generalDigest) {
        System.arraycopy(generalDigest.xBuf, 0, this.xBuf, 0, generalDigest.xBuf.length);
        this.xBufOff = generalDigest.xBufOff;
        this.byteCount = generalDigest.byteCount;
    }

    public void update(byte by2) {
        this.xBuf[this.xBufOff++] = by2;
        if (this.xBufOff == this.xBuf.length) {
            this.processWord(this.xBuf, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount;
    }

    public void update(byte[] byArray, int n2, int n3) {
        n3 = Math.max(0, n3);
        int n4 = 0;
        if (this.xBufOff != 0) {
            while (n4 < n3) {
                this.xBuf[this.xBufOff++] = byArray[n2 + n4++];
                if (this.xBufOff != 4) continue;
                this.processWord(this.xBuf, 0);
                this.xBufOff = 0;
                break;
            }
        }
        int n5 = (n3 - n4 & 0xFFFFFFFC) + n4;
        while (n4 < n5) {
            this.processWord(byArray, n2 + n4);
            n4 += 4;
        }
        while (n4 < n3) {
            this.xBuf[this.xBufOff++] = byArray[n2 + n4++];
        }
        this.byteCount += (long)n3;
    }

    public void finish() {
        long l2 = this.byteCount << 3;
        this.update((byte)-128);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        this.processLength(l2);
        this.processBlock();
    }

    public void reset() {
        this.byteCount = 0L;
        this.xBufOff = 0;
        for (int i2 = 0; i2 < this.xBuf.length; ++i2) {
            this.xBuf[i2] = 0;
        }
    }

    public int getByteLength() {
        return 64;
    }

    protected abstract void processWord(byte[] var1, int var2);

    protected abstract void processLength(long var1);

    protected abstract void processBlock();
}

