/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.internal.io;

import com.aspose.html.utils.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.utils.ms.core.bc.crypto.InvalidSignatureException;
import com.aspose.html.utils.ms.core.bc.crypto.UpdateOutputStream;
import com.aspose.html.utils.ms.core.bc.crypto.internal.CryptoException;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Signer;
import com.aspose.html.utils.ms.core.bc.crypto.internal.io.Utils;
import java.io.IOException;

public class SignerOutputStream
extends UpdateOutputStream {
    private final String algorithmName;
    private final boolean isApprovedMode;
    private Signer sig;

    public SignerOutputStream(String string, Signer signer) {
        this.algorithmName = string;
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.sig = signer;
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.sig.update(byArray, n2, n3);
    }

    public void write(byte[] byArray) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.sig.update(byArray, 0, byArray.length);
    }

    public void write(int n2) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.sig.update((byte)n2);
    }

    byte[] getSignature() throws CryptoException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        return this.sig.generateSignature();
    }

    boolean verify(byte[] byArray) throws InvalidSignatureException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        return this.sig.verifySignature(byArray);
    }
}

