/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.jcajce.provider;

import com.aspose.html.utils.ms.core.bc.crypto.AuthenticationParameters;
import com.aspose.html.utils.ms.core.bc.crypto.MACOperatorFactory;
import com.aspose.html.utils.ms.core.bc.crypto.SymmetricKeyGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.general.SipHash;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.AlgorithmProvider;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.BaseKeyGenerator;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.BaseMac;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.BaseSecretKeyFactory;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.EngineCreator;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.GuardedEngineCreator;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.KeyGeneratorCreator;
import com.aspose.html.utils.ms.core.bc.jcajce.provider.MacParametersCreator;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;

final class ProvSipHash
extends AlgorithmProvider {
    private static final String PREFIX = ProvSipHash.class.getName();

    ProvSipHash() {
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.SIPHASH-2-4", PREFIX + "$Mac24", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(SipHash.SIPHASH_2_4, (MACOperatorFactory)new SipHash.MACOperatorFactory(), new MacParametersCreator(){

                    public AuthenticationParameters getBaseParameters() {
                        return new SipHash.AuthParameters(SipHash.SIPHASH_2_4);
                    }

                    public AuthenticationParameters createParameters(boolean bl2, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                        return new SipHash.AuthParameters(SipHash.SIPHASH_2_4);
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Mac.SIPHASH", "SIPHASH-2-4");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.SIPHASH-4-8", PREFIX + "$Mac48", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(SipHash.SIPHASH_4_8, (MACOperatorFactory)new SipHash.MACOperatorFactory(), new MacParametersCreator(){

                    public AuthenticationParameters getBaseParameters() {
                        return new SipHash.AuthParameters(SipHash.SIPHASH_4_8);
                    }

                    public AuthenticationParameters createParameters(boolean bl2, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                        return new SipHash.AuthParameters(SipHash.SIPHASH_4_8);
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.SIPHASH", PREFIX + "$SIPHASHKFACT", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSecretKeyFactory("SipHash", SipHash.ALGORITHM, new BaseSecretKeyFactory.Validator(){

                    public byte[] validated(byte[] byArray) throws InvalidKeySpecException {
                        int n2 = byArray.length * 8;
                        if (n2 != 128) {
                            throw new InvalidKeySpecException("SipHash key must be of length 128 bits");
                        }
                        return byArray;
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("SecretKeyFactory", "SIPHASH", "SIPHASH-2-4", "SIPHASH-4-8");
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.SIPHASH", PREFIX + "$KeyGen", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "SipHash", 128, true, new KeyGeneratorCreator(){

                    public SymmetricKeyGenerator createInstance(int n2, SecureRandom secureRandom) {
                        return new SipHash.KeyGenerator(SipHash.ALGORITHM, secureRandom);
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("KeyGenerator", "SIPHASH", "SIPHASH-2-4", "SIPHASH-4-8");
    }
}

