/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.Color;
import com.aspose.imaging.DataStreamSupporter;
import com.aspose.imaging.DisposableObject;
import com.aspose.imaging.FileStreamContainer;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IHasMetadata;
import com.aspose.imaging.IImageCreator;
import com.aspose.imaging.IImageExporter;
import com.aspose.imaging.IMetadataContainer;
import com.aspose.imaging.IMultipageImage;
import com.aspose.imaging.IObjectWithBounds;
import com.aspose.imaging.ImageCreatorsRegistry;
import com.aspose.imaging.ImageExportersRegistry;
import com.aspose.imaging.ImageLoadersRegistry;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.LoadOptions;
import com.aspose.imaging.Point;
import com.aspose.imaging.ProgressEventHandler;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.Size;
import com.aspose.imaging.Source;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.coreexceptions.ImageCreateException;
import com.aspose.imaging.coreexceptions.ImageException;
import com.aspose.imaging.coreexceptions.ImageLoadException;
import com.aspose.imaging.coreexceptions.ImageSaveException;
import com.aspose.imaging.coreexceptions.OperationInterruptedException;
import com.aspose.imaging.exif.ExifData;
import com.aspose.imaging.h;
import com.aspose.imaging.i;
import com.aspose.imaging.imageoptions.MultipageCreateOptions;
import com.aspose.imaging.imageoptions.VectorRasterizationOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.IO.FileNotFoundException;
import com.aspose.imaging.internal.Exceptions.IO.IOException;
import com.aspose.imaging.internal.Exceptions.InvalidOperationException;
import com.aspose.imaging.internal.Exceptions.NotImplementedException;
import com.aspose.imaging.internal.br.Y;
import com.aspose.imaging.internal.br.aL;
import com.aspose.imaging.internal.br.aO;
import com.aspose.imaging.internal.br.aW;
import com.aspose.imaging.internal.br.aX;
import com.aspose.imaging.internal.br.aa;
import com.aspose.imaging.internal.br.bg;
import com.aspose.imaging.internal.br.cs;
import com.aspose.imaging.internal.br.ct;
import com.aspose.imaging.internal.br.e;
import com.aspose.imaging.internal.gF.f;
import com.aspose.imaging.internal.kx.o;
import com.aspose.imaging.internal.lV.b;
import com.aspose.imaging.internal.lr.a;
import com.aspose.imaging.internal.mF.D;
import com.aspose.imaging.internal.mF.z;
import com.aspose.imaging.internal.mR.u;
import com.aspose.imaging.internal.mR.w;
import com.aspose.imaging.internal.ms.I;
import com.aspose.imaging.internal.ms.x;
import com.aspose.imaging.internal.ms.y;
import com.aspose.imaging.internal.ne.g;
import com.aspose.imaging.internal.ns.aD;
import com.aspose.imaging.internal.ns.aV;
import com.aspose.imaging.internal.ns.am;
import com.aspose.imaging.internal.ns.bE;
import com.aspose.imaging.internal.su.c;
import com.aspose.imaging.internal.sv.d;
import com.aspose.imaging.j;
import com.aspose.imaging.k;
import com.aspose.imaging.l;
import com.aspose.imaging.m;
import com.aspose.imaging.metadata.IImageMetadataFormat;
import com.aspose.imaging.metadata.ImageMetadata;
import com.aspose.imaging.multithreading.IInterruptMonitor;
import com.aspose.imaging.multithreading.InterruptMonitor;
import com.aspose.imaging.n;
import com.aspose.imaging.progressmanagement.EventType;
import com.aspose.imaging.progressmanagement.ProgressEventHandlerInfo;
import com.aspose.imaging.sources.StreamSource;
import com.aspose.imaging.system.Enum;
import com.aspose.imaging.system.IDisposable;
import com.aspose.imaging.system.io.File;
import com.aspose.imaging.system.io.FileStream;
import com.aspose.imaging.system.io.Stream;
import com.aspose.imaging.xmp.XmpPacketWrapper;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public abstract class Image
extends DataStreamSupporter
implements IMetadataContainer,
IObjectWithBounds,
com.aspose.imaging.internal.lh.b,
com.aspose.imaging.internal.lh.c {
    public static final g<com.aspose.imaging.internal.br.g> e = new g();
    public static final g<e> f = new g();
    public static final g<com.aspose.imaging.internal.br.a> g = new g();
    private static final String j = "Cannot open an image. The image file format may be not supported at the moment.";
    private final AtomicReference<com.aspose.imaging.internal.kS.i> k = new AtomicReference<Object>(null);
    private final Color l = Color.getWhite();
    public o h;
    protected StreamContainer i;
    private int m = 0;
    private ImageMetadata n;
    private WeakReference<Image> o = new WeakReference<Object>(null);
    private IColorPalette p;
    private Object q;
    private boolean r = false;
    private boolean s;
    private InterruptMonitor t;
    private ProgressEventHandlerInfo u;
    private u v;
    private boolean w = false;
    private com.aspose.imaging.internal.mD.l x;
    private boolean y;

    protected Image() {
    }

    protected Image(IColorPalette iColorPalette) {
        this.p = iColorPalette;
    }

    public static boolean canLoad(String string) {
        return Image.canLoad(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canLoad(String string, LoadOptions loadOptions) {
        Y.a(string, "filePath");
        Object object = SyncOperation;
        synchronized (object) {
            boolean bl2;
            FileStream fileStream = File.open(string, 3, 3, 3);
            try {
                bl2 = Image.a((Stream)fileStream, loadOptions);
            }
            catch (Throwable throwable) {
                fileStream.dispose();
                throw throwable;
            }
            fileStream.dispose();
            return bl2;
        }
    }

    public static boolean canLoad(InputStream inputStream) {
        Y.a(inputStream, "stream");
        Stream stream = Stream.fromJava(inputStream);
        return Image.a(stream, null);
    }

    public static boolean c(Stream stream) {
        return Image.a(stream, null);
    }

    public static boolean canLoad(InputStream inputStream, LoadOptions loadOptions) {
        Y.a(inputStream, "stream");
        return Image.a(Stream.fromJava(inputStream), loadOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean a(Stream stream, LoadOptions loadOptions) {
        boolean bl2;
        cs cs2 = ct.a().a(stream);
        try {
            Stream stream2 = cs2.b();
            synchronized (stream2) {
                bl2 = ImageLoadersRegistry.a(cs2, loadOptions) != null;
            }
        }
        finally {
            ct.a().a(cs2);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image create(ImageOptionsBase imageOptionsBase, int n2, int n3) {
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("imageOptions");
        }
        if (n2 <= 0) {
            throw new ArgumentOutOfRangeException("width", "Expected positive width value.");
        }
        if (n3 <= 0) {
            throw new ArgumentOutOfRangeException("height", "Expected positive height value.");
        }
        Source source = imageOptionsBase.getSource();
        if (source == null) {
            imageOptionsBase.setSource(new StreamSource());
        }
        try {
            boolean[] blArray = new boolean[]{false};
            Image image = com.aspose.imaging.internal.cg.h.a(Image.a(imageOptionsBase, n2, n3, Image.a(com.aspose.imaging.internal.kx.m.a(Image.class.getSimpleName()), null, blArray)), blArray[0]);
            return image;
        }
        finally {
            if (source == null) {
                imageOptionsBase.setSource(null);
            }
        }
    }

    public static Image create(ImageOptionsBase imageOptionsBase, int n2, int n3, int[] nArray) {
        Object object = "Image instance creation with pre-existing pixels is permitted only in licensed mode.";
        if (aW.c() == aX.a) {
            throw new ImageCreateException((String)object);
        }
        int[] nArray2 = nArray;
        object = imageOptionsBase;
        int n4 = n2;
        int n5 = n3;
        Image image = Image.create((ImageOptionsBase)object, n4, n5);
        if (!com.aspose.imaging.internal.sv.d.b((Object)image, RasterImage.class)) {
            throw new ImageCreateException("Pixels can be processed into a RasterImage only.");
        }
        if (nArray2.length != image.getWidth() * image.getHeight()) {
            throw new ImageCreateException("Pixels length must be equal to the width and height of the image.");
        }
        f f2 = new f(n4, n5, image.k.get(), nArray2);
        ((RasterImage)image).a(f2);
        return image;
    }

    public static Image create(Image[] imageArray) {
        Y.a(imageArray, "images");
        boolean[] blArray = new boolean[]{false};
        return com.aspose.imaging.internal.cg.h.a(new bg(imageArray, false, Image.a(com.aspose.imaging.internal.kx.m.a(bg.class.getSimpleName()), null, blArray)), blArray[0]);
    }

    public static Image create(MultipageCreateOptions multipageCreateOptions) {
        return new bg(multipageCreateOptions);
    }

    public static Image create(String[] stringArray, boolean bl2) {
        return new bg(stringArray, bl2);
    }

    public static Image create(String[] stringArray) {
        return new bg(stringArray, false);
    }

    public static Image create(Image[] imageArray, boolean bl2) {
        boolean[] blArray = new boolean[]{false};
        return com.aspose.imaging.internal.cg.h.a(new bg(imageArray, bl2, Image.a(com.aspose.imaging.internal.kx.m.a(Image.class.getSimpleName()), null, blArray)), blArray[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileFormat(String string) {
        Y.a(string, "filePath");
        FileStream fileStream = File.open(string, 3, 1, 1);
        cs cs2 = ct.a().a(fileStream, false, true);
        try {
            long l2 = Image.f(cs2);
            return l2;
        }
        finally {
            ct.a().a(cs2);
            if (cs2.a() <= 0) {
                cs2.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image load(String string, LoadOptions loadOptions) {
        StreamContainer streamContainer = Image.c(string);
        boolean bl2 = true;
        try {
            boolean[] blArray = new boolean[]{false};
            Image image = com.aspose.imaging.internal.cg.h.a(Image.a(streamContainer, loadOptions, Image.a(com.aspose.imaging.internal.kx.m.a(Image.class.getSimpleName()), loadOptions, blArray)), blArray[0]);
            bl2 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl2) {
                streamContainer.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image load(String string) {
        StreamContainer streamContainer = Image.c(string);
        boolean bl2 = true;
        try {
            boolean[] blArray = new boolean[]{false};
            Image image = com.aspose.imaging.internal.cg.h.a(Image.a(streamContainer, null, Image.a(com.aspose.imaging.internal.kx.m.a(Image.class.getSimpleName()), null, blArray)), blArray[0]);
            bl2 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl2) {
                streamContainer.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image load(RandomAccessFile randomAccessFile, LoadOptions loadOptions) {
        Y.a(randomAccessFile, "file");
        a a2 = new a(randomAccessFile);
        boolean bl2 = true;
        try {
            Image image = Image.b(a2, loadOptions);
            bl2 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl2) {
                a2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image load(RandomAccessFile randomAccessFile) {
        Y.a(randomAccessFile, "file");
        a a2 = new a(randomAccessFile);
        boolean bl2 = true;
        try {
            Image image = Image.b(a2, null);
            bl2 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl2) {
                a2.close();
            }
        }
    }

    public static Image load(InputStream inputStream, LoadOptions loadOptions) {
        Y.a(inputStream, "stream");
        return Image.b(Stream.fromJava(inputStream), loadOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image b(Stream stream, LoadOptions loadOptions) {
        boolean bl2 = loadOptions != null && loadOptions.e();
        StreamContainer streamContainer = new StreamContainer(stream, 0L, bl2);
        boolean bl3 = true;
        try {
            boolean[] blArray = new boolean[]{false};
            Image image = com.aspose.imaging.internal.cg.h.a(Image.a(streamContainer, loadOptions, Image.a(com.aspose.imaging.internal.kx.m.a(Image.class.getSimpleName()), null, blArray)), blArray[0]);
            bl3 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl3) {
                streamContainer.dispose();
            }
        }
    }

    public static Image load(InputStream inputStream) {
        Y.a(inputStream, "stream");
        return Image.d(Stream.fromJava(inputStream));
    }

    public static Image d(Stream stream) {
        boolean[] blArray = new boolean[]{false};
        return com.aspose.imaging.internal.cg.h.a(Image.a(stream, null, Image.a(com.aspose.imaging.internal.kx.m.a(Image.class.getSimpleName()), null, blArray)), blArray[0]);
    }

    public static Image c(Stream stream, LoadOptions loadOptions) {
        boolean[] blArray = new boolean[]{false};
        return com.aspose.imaging.internal.cg.h.a(Image.a(stream, loadOptions, Image.a(com.aspose.imaging.internal.kx.m.a(Image.class.getSimpleName()), null, blArray)), blArray[0]);
    }

    public static Image a(Stream stream, LoadOptions loadOptions, o o2) {
        boolean bl2 = loadOptions != null && loadOptions.e();
        StreamContainer streamContainer = new StreamContainer(stream, 0L, bl2);
        return Image.a(streamContainer, loadOptions, o2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image a(Stream stream, long l2, LoadOptions loadOptions, o o2) {
        boolean bl2 = loadOptions != null && loadOptions.e();
        StreamContainer streamContainer = new StreamContainer(stream, 0L, bl2);
        streamContainer.setPosition(l2);
        boolean bl3 = true;
        try {
            Image image = Image.a(streamContainer, loadOptions, o2);
            bl3 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl3) {
                streamContainer.close();
            }
        }
    }

    public static Image a(Stream stream, long l2) {
        return Image.a(stream, l2, null, null);
    }

    public static Image e(Stream stream) {
        return Image.a(stream, 0L, null, null);
    }

    public static long getFileFormat(InputStream inputStream) {
        Y.a(inputStream, "stream");
        return Image.f(Stream.fromJava(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long f(Stream stream) {
        cs cs2 = ct.a().a(stream);
        Object object = cs2.getSyncRoot();
        synchronized (object) {
            long l2;
            try {
                l2 = Image.a((Stream)cs2, false);
                ct.a().a(cs2);
            }
            catch (Throwable throwable) {
                ct.a().a(cs2);
                throw throwable;
            }
            return l2;
        }
    }

    /*
     * Exception decompiling
     */
    private static long a(Stream var0, boolean var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Rectangle getFittingRectangle(Rectangle rectangle, int n2, int n3) {
        Rectangle rectangle2 = Rectangle.intersect(rectangle, new Rectangle(new Point(), new Size(bE.a(n2), bE.a(n3))));
        if (rectangle2.getWidth() <= 0 || rectangle2.getHeight() <= 0) {
            throw new ArgumentException("The rectangle has no common processing area. Cannot proceed.");
        }
        return rectangle2;
    }

    public static Rectangle getFittingRectangle(Rectangle rectangle, int[] nArray, int n2, int n3) {
        if (nArray == null) {
            throw new ArgumentNullException("pixels");
        }
        Rectangle rectangle2 = Image.getFittingRectangle(rectangle, n2, n3);
        if (nArray.length < rectangle2.getWidth() * rectangle2.getHeight()) {
            String string = aV.a("The passed rectangle does not correspond to pixels array size. Expected: {0} pixels, passed: {1} pixels.", new Object[]{rectangle2.getWidth() * rectangle2.getHeight(), nArray.length});
            throw new ImageException(string);
        }
        return rectangle2;
    }

    public static int getProportionalWidth(int n2, int n3, int n4) {
        double d2 = (double)n4 / (double)n3;
        return com.aspose.imaging.internal.sv.d.e(d2 * (double)n2 + 0.5);
    }

    public static int getProportionalHeight(int n2, int n3, int n4) {
        double d2 = (double)n4 / (double)n2;
        return com.aspose.imaging.internal.sv.d.e(d2 * (double)n3 + 0.5);
    }

    protected static void a(long[] lArray, Stream stream) {
        for (com.aspose.imaging.internal.br.g g2 : e.a()) {
            g2.a(lArray, stream);
        }
    }

    private static void a(long[] lArray, long l2) {
        for (e e2 : f.a()) {
            e2.a(lArray, l2);
        }
    }

    public static o a(String string, LoadOptions loadOptions, boolean[] blArray) {
        List<com.aspose.imaging.internal.br.a> list;
        blArray[0] = false;
        if (com.aspose.imaging.internal.kx.l.d()) {
            com.aspose.imaging.internal.kx.l.a(new com.aspose.imaging.g(), new h());
        }
        if ((list = g.a()) != null) {
            o o2 = null;
            if (loadOptions == null || !loadOptions.d()) {
                o2 = new o();
            }
            for (com.aspose.imaging.internal.br.a a2 : list) {
                blArray[0] = a2.a(string, o2, null);
            }
            return o2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static StreamContainer c(String string) {
        if (aV.b(string)) {
            throw new ArgumentNullException("filePath/uriString");
        }
        if (File.exists(string)) {
            return FileStreamContainer.a(string, true);
        }
        String string2 = aV.a(new String[]{"Incorrect image location: ", string});
        try {
            URL uRL = new URL(string);
            try (InputStream inputStream = uRL.openStream();){
                String string3;
                IInterruptMonitor iInterruptMonitor = InterruptMonitor.getThreadLocalInstance();
                if (iInterruptMonitor != null && iInterruptMonitor.isInterrupted()) {
                    throw new OperationInterruptedException(aV.a("Interrupted the loading file {0}", new Object[]{string}));
                }
                I i2 = new I(com.aspose.imaging.internal.ms.y.a, false);
                try {
                    string3 = i2.a();
                    com.aspose.imaging.internal.ms.x.a(inputStream, (Stream)i2);
                    i2.dispose();
                }
                finally {
                    i2.dispose();
                }
                FileStreamContainer fileStreamContainer = FileStreamContainer.a(string3, true);
                return fileStreamContainer;
            }
        }
        catch (MalformedURLException malformedURLException) {
            String string4 = malformedURLException.toString();
            throw new FileNotFoundException(aV.a(new String[]{string2, "\n", string4}));
        }
        catch (java.io.IOException iOException) {
            String string5 = iOException.toString();
            throw new IOException(aV.a(new String[]{string2, "\n", string5}));
        }
    }

    private static void a(ProgressEventHandlerInfo progressEventHandlerInfo, EventType eventType) {
        if (progressEventHandlerInfo != null) {
            progressEventHandlerInfo.a(eventType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static Image a(ImageOptionsBase imageOptionsBase, int n2, int n3, o o2) {
        Object object;
        StreamSource streamSource = (StreamSource)((Object)com.aspose.imaging.internal.sv.d.a(imageOptionsBase.getSource(), StreamSource.class));
        Stream stream = streamSource != null ? streamSource.getStream() : null;
        Object object2 = object = cs.a(stream, stream == null ? new Object() : stream);
        synchronized (object2) {
            ProgressEventHandlerInfo progressEventHandlerInfo = null;
            if (imageOptionsBase.getProgressEventHandler() != null) {
                progressEventHandlerInfo = ProgressEventHandlerInfo.a(4);
                progressEventHandlerInfo.a(imageOptionsBase.getProgressEventHandler());
            }
            Image.a(progressEventHandlerInfo, EventType.Initialization);
            StreamContainer streamContainer = imageOptionsBase.getSource().getStreamContainer();
            boolean bl2 = true;
            try {
                Image image;
                block19: {
                    IImageCreator iImageCreator = ImageCreatorsRegistry.createFirstSupportedCreator(imageOptionsBase);
                    if (iImageCreator == null) {
                        throw new ImageLoadException("Cannot create a new image. The image file format may be not supported at the moment.");
                    }
                    Image.a(progressEventHandlerInfo, EventType.PreProcessing);
                    Image image2 = iImageCreator.create(streamContainer, imageOptionsBase, n2, n3);
                    try {
                        com.aspose.imaging.internal.kS.i i2;
                        image2.u = progressEventHandlerInfo;
                        Image.a(progressEventHandlerInfo, EventType.Processing);
                        image2.a(streamContainer);
                        if (imageOptionsBase.b() != null) {
                            i2 = imageOptionsBase.b().f();
                        } else {
                            ImageOptionsBase imageOptionsBase2 = imageOptionsBase;
                            com.aspose.imaging.internal.kS.i i3 = com.aspose.imaging.internal.kS.i.a.f();
                            if (imageOptionsBase2 != null) {
                                i3.c(imageOptionsBase2.getBufferSizeHint());
                            }
                            i2 = i3;
                        }
                        com.aspose.imaging.internal.kS.i i4 = i2;
                        image2.a(i4, true);
                        image2.a(o2);
                        Image.a(progressEventHandlerInfo, EventType.Finalization);
                        if (!imageOptionsBase.a()) {
                            Image.a(image2.d, (long)image2.getWidth() * (long)image2.getHeight());
                        }
                        bl2 = false;
                        image = image2;
                        if (!bl2) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (bl2) {
                                image2.close();
                            }
                            throw throwable;
                        }
                        catch (Error | RuntimeException throwable2) {
                            throw new ImageCreateException("Image creation failed.", throwable2);
                        }
                    }
                    image2.close();
                }
                return image;
            }
            finally {
                if (bl2) {
                    streamContainer.close();
                }
            }
        }
    }

    private static Image a(ImageOptionsBase imageOptionsBase, int n2, int n3, int[] nArray) {
        Image image = Image.create(imageOptionsBase, n2, n3);
        if (!com.aspose.imaging.internal.sv.d.b((Object)image, RasterImage.class)) {
            throw new ImageCreateException("Pixels can be processed into a RasterImage only.");
        }
        if (nArray.length != image.getWidth() * image.getHeight()) {
            throw new ImageCreateException("Pixels length must be equal to the width and height of the image.");
        }
        f f2 = new f(n2, n3, image.k.get(), nArray);
        ((RasterImage)image).a(f2);
        return image;
    }

    /*
     * Exception decompiling
     */
    private static Image a(StreamContainer var0, LoadOptions var1_1, o var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void removeMetadata() {
        this.setXmpData(null);
        this.setExifData(null);
    }

    @Override
    public boolean trySetMetadata(IImageMetadataFormat iImageMetadataFormat) {
        return com.aspose.imaging.internal.kX.a.a(this, iImageMetadataFormat, this.getFileFormat());
    }

    public final boolean b(String string) {
        try {
            return this.a(string, null);
        }
        catch (RuntimeException runtimeException) {
            throw new FrameworkException("DoAPICallHook", runtimeException);
        }
    }

    public final boolean a(String string, com.aspose.imaging.internal.kx.c c2) {
        if (com.aspose.imaging.internal.kx.l.d()) {
            com.aspose.imaging.internal.kx.l.a(new i(this), new j(this));
        }
        if (this.h == null) {
            this.h = new o();
        }
        for (com.aspose.imaging.internal.br.a a2 : g.a()) {
            if (!a2.a(string, this.h, c2)) continue;
            this.a(this.h);
        }
        return true;
    }

    public final <T> boolean a(Class<T> clazz, String string) {
        try {
            return this.a(clazz, string, null);
        }
        catch (RuntimeException runtimeException) {
            throw new FrameworkException("DoAPICallHook<T>", runtimeException);
        }
    }

    public final <T> boolean a(Class<T> clazz, String string, com.aspose.imaging.internal.kx.c c2) {
        List<com.aspose.imaging.internal.br.a> list;
        if (com.aspose.imaging.internal.kx.l.d()) {
            com.aspose.imaging.internal.kx.l.a(new k(this), new l(this));
        }
        if ((list = g.a()) == null) {
            return false;
        }
        if (this.h == null) {
            this.h = new o();
        }
        return true;
    }

    public abstract int getBitsPerPixel();

    @Override
    public Rectangle getBounds() {
        this.verifyNotDisposed();
        return new Rectangle(Point.getEmpty(), this.getSize());
    }

    public Image getContainer() {
        return (Image)this.o.get();
    }

    @Override
    public abstract int getHeight();

    public IColorPalette getPalette() {
        return this.p;
    }

    public void setPalette(IColorPalette iColorPalette) {
        if (this.p != iColorPalette) {
            IColorPalette iColorPalette2 = this.p;
            this.onPaletteChanging(iColorPalette2, iColorPalette);
            this.p = iColorPalette;
            this.onPaletteChanged(iColorPalette2, iColorPalette);
        }
    }

    public boolean isUsePalette() {
        return false;
    }

    @Override
    public Size getSize() {
        this.verifyNotDisposed();
        return new Size(this.getWidth(), this.getHeight());
    }

    @Override
    public abstract int getWidth();

    public InterruptMonitor getInterruptMonitor() {
        return this.t;
    }

    public void setInterruptMonitor(InterruptMonitor interruptMonitor) {
        this.t = interruptMonitor;
    }

    public final int getBufferSizeHint() {
        return this.h().b();
    }

    public final void setBufferSizeHint(int n2) {
        com.aspose.imaging.internal.kS.i i2 = this.h();
        if (!aD.a(i2, com.aspose.imaging.internal.kS.i.a)) {
            i2.c(n2);
        }
    }

    public boolean isAutoAdjustPalette() {
        return this.s;
    }

    public void setAutoAdjustPalette(boolean bl2) {
        this.s = bl2;
    }

    public boolean hasBackgroundColor() {
        return this.w;
    }

    public long getFileFormat() {
        return 0L;
    }

    public Color getBackgroundColor() {
        return this.l;
    }

    public void setBackgroundColor(boolean bl2) {
        this.w = bl2;
    }

    public void setBackgroundColor(Color color) {
        color.CloneTo(this.l);
    }

    public boolean I_() {
        return this.r;
    }

    public void d(boolean bl2) {
        this.r = bl2;
    }

    public final synchronized com.aspose.imaging.internal.mD.l g() {
        if (this.x == null) {
            this.x = new com.aspose.imaging.internal.mD.l();
        }
        return this.x;
    }

    public com.aspose.imaging.internal.kS.i h() {
        com.aspose.imaging.internal.kS.i i2 = this.k.get();
        return i2 != null ? i2 : com.aspose.imaging.internal.kS.i.a;
    }

    @Override
    public boolean J_() {
        return this.h().c();
    }

    public int i() {
        if (this.h == null && this.getContainer() != null) {
            this.h = this.getContainer().h;
        }
        if (this.h == null) {
            return 0;
        }
        return this.h.a();
    }

    public ImageMetadata getMetadata() {
        this.b(com.aspose.imaging.internal.kx.m.c());
        ImageMetadata imageMetadata = this.n;
        if (imageMetadata == null) {
            IHasMetadata iHasMetadata = this.j();
            if (iHasMetadata == null) {
                throw new InvalidOperationException("Metadata container is not set.");
            }
            if (iHasMetadata == this) {
                iHasMetadata = null;
            }
            this.n = imageMetadata = ImageMetadata.a((Long)this.getFileFormat(), iHasMetadata);
        }
        return imageMetadata;
    }

    @Override
    public ExifData getExifData() {
        return this.getMetadata().getExifData();
    }

    @Override
    public void setExifData(ExifData exifData) {
        this.getMetadata().setExifData(exifData);
    }

    @Override
    public final XmpPacketWrapper getXmpData() {
        return this.getMetadata().getXmpData();
    }

    @Override
    public final void setXmpData(XmpPacketWrapper xmpPacketWrapper) {
        this.getMetadata().setXmpData(xmpPacketWrapper);
    }

    @Override
    @com.aspose.imaging.internal.sv.g
    public final ProgressEventHandler getIProgressEventHandler() {
        if (this.u == null) {
            return null;
        }
        return this.u.a();
    }

    @Override
    @com.aspose.imaging.internal.sv.g
    public final ProgressEventHandlerInfo getProgressEventHandlerInfo() {
        return this.u;
    }

    public IHasMetadata j() {
        return this;
    }

    public boolean canSave(ImageOptionsBase imageOptionsBase) {
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("options");
        }
        this.verifyNotDisposed();
        return ImageExportersRegistry.getFirstSupportedDescriptor(this, imageOptionsBase) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int n2, int n3) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.b(true);
                this.resize(n2, n3, 7);
            }
            finally {
                this.c(true);
            }
            this.b(com.aspose.imaging.internal.kx.m.c());
        }
    }

    public void resize(int n2, int n3, int n4) {
        throw new NotImplementedException();
    }

    public abstract void resize(int var1, int var2, ImageResizeSettings var3);

    public ImageOptionsBase getDefaultOptions(Object[] objectArray) {
        return null;
    }

    public ImageOptionsBase getOriginalOptions() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeWidthProportionally(int n2) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.c(2);
            try {
                this.b(bl2);
                this.resizeWidthProportionally(n2, 7);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeHeightProportionally(int n2) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.c(3);
            try {
                this.b(bl2);
                this.resizeHeightProportionally(n2, 7);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    public void resizeWidthProportionally(int n2, int n3) {
        int n4 = Image.getProportionalHeight(this.getWidth(), this.getHeight(), n2);
        this.resize(n2, n4, n3);
    }

    public void resizeHeightProportionally(int n2, int n3) {
        int n4 = Image.getProportionalWidth(this.getWidth(), this.getHeight(), n2);
        this.resize(n4, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeWidthProportionally(int n2, ImageResizeSettings imageResizeSettings) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.b(true);
                int n3 = Image.getProportionalHeight(this.getWidth(), this.getHeight(), n2);
                this.resize(n2, n3, imageResizeSettings);
            }
            finally {
                this.c(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeHeightProportionally(int n2, ImageResizeSettings imageResizeSettings) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.b(true);
                int n3 = Image.getProportionalWidth(this.getWidth(), this.getHeight(), n2);
                this.resize(n3, n2, imageResizeSettings);
            }
            finally {
                this.c(true);
            }
        }
    }

    public abstract void rotateFlip(int var1);

    public void rotate(float f2) {
        throw new NotImplementedException();
    }

    public void crop(Rectangle rectangle) {
        throw new NotImplementedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void crop(int n2, int n3, int n4, int n5) {
        Object object = this.c;
        synchronized (object) {
            this.crop(new Rectangle(n2, n4, this.getWidth() - n2 - n3, this.getHeight() - n4 - n5));
        }
    }

    @Override
    public final void save() {
        if (this.o.get() != null) {
            throw new FrameworkException("The result of this method is unpredictable since the current image has Container defined. Use the parent Container's Save() method instead.");
        }
        this.a(Image.class, com.aspose.imaging.internal.kx.m.c());
        super.save();
        if (this.i != null) {
            this.i.setPosition(0L);
            Stream stream = this.getDataStreamContainer().a();
            stream.setPosition(0L);
            com.aspose.imaging.internal.lV.b.a(stream, this.i.a());
        }
    }

    @Override
    public void save(String string) {
        ImageOptionsBase imageOptionsBase;
        if (string == null) {
            throw new ArgumentNullException("filePath");
        }
        if (string.isEmpty()) {
            throw new ArgumentException("filePath is empty!");
        }
        this.a(Image.class, com.aspose.imaging.internal.kx.m.c());
        if (!this.a(string) && (imageOptionsBase = aa.a(string, this)) != null) {
            this.save(string, imageOptionsBase);
            imageOptionsBase.close();
            return;
        }
        super.save(string);
    }

    public void save(String string, ImageOptionsBase imageOptionsBase) {
        this.save(string, imageOptionsBase, Rectangle.getEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String string, ImageOptionsBase imageOptionsBase, Rectangle rectangle) {
        this.verifyNotDisposed();
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("options");
        }
        aa.a(string, imageOptionsBase);
        try {
            FileStream fileStream = File.create(string);
            try {
                this.a(fileStream, imageOptionsBase, rectangle);
                fileStream.flush();
            }
            finally {
                fileStream.dispose();
            }
        }
        catch (ImageSaveException | OperationInterruptedException exception) {
            throw exception;
        }
        catch (Error error) {
            throw new ImageLoadException("Image saving failed.", error);
        }
        catch (RuntimeException runtimeException) {
            throw new ImageSaveException("Image saving failed.", runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(RandomAccessFile randomAccessFile, ImageOptionsBase imageOptionsBase) {
        a a2 = new a(randomAccessFile);
        try {
            this.a(a2, imageOptionsBase, Rectangle.getEmpty());
        }
        finally {
            a2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(RandomAccessFile randomAccessFile, ImageOptionsBase imageOptionsBase, Rectangle rectangle) {
        a a2 = new a(randomAccessFile);
        try {
            this.a(a2, imageOptionsBase, rectangle);
        }
        finally {
            a2.dispose();
        }
    }

    public void save(OutputStream outputStream, ImageOptionsBase imageOptionsBase) {
        if (outputStream instanceof com.aspose.imaging.internal.rJ.d) {
            this.a(((com.aspose.imaging.internal.rJ.d)outputStream).a(), imageOptionsBase, Rectangle.getEmpty());
        } else {
            com.aspose.imaging.internal.su.c.a(new m(this, outputStream, imageOptionsBase));
        }
    }

    public void save(OutputStream outputStream, ImageOptionsBase imageOptionsBase, Rectangle rectangle) {
        if (outputStream instanceof com.aspose.imaging.internal.rJ.d) {
            this.a(((com.aspose.imaging.internal.rJ.d)outputStream).a(), imageOptionsBase, rectangle);
        } else {
            com.aspose.imaging.internal.su.c.a(new n(this, outputStream, imageOptionsBase, rectangle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(Stream stream, ImageOptionsBase imageOptionsBase, Rectangle rectangle) {
        this.verifyNotDisposed();
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("optionsBase");
        }
        if (!(rectangle.isEmpty() || rectangle.getWidth() > 0 && rectangle.getHeight() > 0)) {
            throw new ArgumentOutOfRangeException("boundsRectangle", "Rectangle should have positive width and height");
        }
        boolean bl2 = false;
        try {
            Object object;
            Object object2 = this.c;
            synchronized (object2) {
                this.isRecursiveCall = bl2 = this.isSameSourceStream_internalized(stream);
                this.MutuallyExclusiveOperationIsNotRunningEvent_internalized.waitOne();
                if (imageOptionsBase.getProgressEventHandler() != null) {
                    this.u = ProgressEventHandlerInfo.a(4);
                    this.u.a(imageOptionsBase.getProgressEventHandler());
                } else if (this.u != null) {
                    this.u.b(this.u.getMaxValue() + 4);
                    imageOptionsBase.setProgressEventHandler(this.u.a());
                }
                object = this.SyncNonExclusiveOperation_internalized;
                synchronized (object) {
                    if (this.NonExclusiveRunningOperationsCount_internalized.incrementAndGet() > 0) {
                        this.NonMutuallyExclusiveOperationIsNotRunningEvent_internalized.reset();
                    }
                }
            }
            this.a(Image.class, com.aspose.imaging.internal.kx.m.c(), new com.aspose.imaging.internal.kx.g(imageOptionsBase));
            Image.a(this.u, EventType.Initialization);
            object2 = ImageExportersRegistry.createFirstSupportedExporter(this, imageOptionsBase);
            if (object2 == null) {
                object = this.getCanNotSaveMessage(imageOptionsBase);
                throw new ArgumentException((String)object, "optionsBase");
            }
            object = this.a(imageOptionsBase, rectangle, (IImageExporter)object2);
            Image image = ((aL)object).c();
            cs cs2 = null;
            try {
                Image.a(this.u, EventType.PreProcessing);
                image.a(image.h);
                cs2 = ct.a().a(stream);
                Object object3 = cs2.getSyncRoot();
                synchronized (object3) {
                    cs2.setPosition(0L);
                    image.tryCacheImage(cs2);
                    Image.a(this.u, EventType.Processing);
                    object2.export(image, cs2.toOutputStream(), imageOptionsBase, rectangle);
                    Image.a(this.u, EventType.Finalization);
                    this.b(cs2);
                }
                ct.a().a(cs2);
                ((aL)object).a();
            }
            catch (Throwable throwable) {
                ct.a().a(cs2);
                ((aL)object).a();
                throw throwable;
            }
        }
        catch (OperationInterruptedException operationInterruptedException) {
            throw operationInterruptedException;
        }
        catch (RuntimeException runtimeException) {
            throw new ImageSaveException("Image export failed.", runtimeException);
        }
        finally {
            Object object = this.SyncNonExclusiveOperation_internalized;
            synchronized (object) {
                if (bl2) {
                    this.isRecursiveCall = false;
                }
                if (this.NonExclusiveRunningOperationsCount_internalized.decrementAndGet() <= 0) {
                    this.NonMutuallyExclusiveOperationIsNotRunningEvent_internalized.set();
                }
            }
        }
    }

    public abstract void setPalette(IColorPalette var1, boolean var2);

    public final D a(VectorRasterizationOptions vectorRasterizationOptions, int n2, Rectangle rectangle) {
        aO aO2 = new aO(this);
        aO2.setVectorRasterizationOptions(vectorRasterizationOptions);
        return this.a((ImageOptionsBase)aO2, n2, rectangle.Clone());
    }

    public D a(ImageOptionsBase imageOptionsBase, int n2, Rectangle rectangle) {
        if (this.m > 0) {
            throw new NotImplementedException();
        }
        ++this.m;
        int[] nArray = new int[]{0};
        Stream stream = this.a(imageOptionsBase, rectangle, nArray);
        com.aspose.imaging.internal.mT.g g2 = new com.aspose.imaging.internal.mT.g();
        com.aspose.imaging.internal.mF.m m2 = (com.aspose.imaging.internal.mF.m)g2.a(stream);
        this.m = 0;
        if (m2 instanceof D) {
            return (D)m2;
        }
        return (D)m2.a(nArray[0]);
    }

    public InputStream getSerializedStream(ImageOptionsBase imageOptionsBase, Rectangle rectangle, int[] nArray) {
        Stream stream = this.a(imageOptionsBase, rectangle, nArray);
        stream.setPosition(0L);
        return Stream.toJava(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream a(ImageOptionsBase imageOptionsBase, Rectangle rectangle, int[] nArray) {
        com.aspose.imaging.internal.mT.g g2 = new com.aspose.imaging.internal.mT.g();
        boolean bl2 = true;
        I i2 = new I();
        try {
            g2.a(i2, (z)this.a(imageOptionsBase, 2, rectangle));
            bl2 = false;
        }
        finally {
            if (bl2) {
                i2.dispose();
            }
        }
        nArray[0] = 0;
        return i2;
    }

    public Object k() {
        if (this.q == null && this.getContainer() instanceof IMultipageImage) {
            return this.getContainer().k();
        }
        return this.q;
    }

    public void a(Object object) {
        this.q = object;
    }

    public boolean a(o o2) {
        if (o2 == null) {
            return false;
        }
        if (com.aspose.imaging.internal.kx.l.d()) {
            throw new FrameworkException("Plugin license is not ready");
        }
        if (this.h == null || this.h != o2) {
            this.h = o2;
        }
        return true;
    }

    public void a(Image image) {
        this.o = new WeakReference<Image>(image);
        this.l();
    }

    public final void a(EventType eventType) {
        if (this.u != null) {
            this.u.c(this.u.getValue() + 1);
            this.u.a(eventType, this.u.getValue());
        }
    }

    public final void b(int n2) {
        if (this.u != null) {
            this.u.b(this.u.getMaxValue() + n2);
        }
    }

    public void l() {
        Image image = this.getContainer();
        if (image == null) {
            return;
        }
        this.a(image.h);
        if (this.q == null) {
            this.a(image.k());
        }
    }

    public void a(com.aspose.imaging.internal.kS.i i2, boolean bl2) {
        if (this.y) {
            com.aspose.imaging.internal.kS.i i3 = this.k.getAndSet(aD.a(i2, com.aspose.imaging.internal.kS.i.a) ? null : i2);
            if (i3 != null && !aD.a(i3, i2)) {
                i3.dispose();
            }
        } else {
            this.k.set(aD.a(i2, com.aspose.imaging.internal.kS.i.a) ? null : i2);
        }
        this.y = bl2;
    }

    protected final void updateContainer(Image image) {
        this.a(image);
    }

    protected boolean c(int n2) {
        return false;
    }

    public am m() {
        throw new NotImplementedException();
    }

    public void a(am am2) {
        throw new NotImplementedException();
    }

    protected String getCanNotSaveMessage(ImageOptionsBase imageOptionsBase) {
        String string = "Unknown";
        if (imageOptionsBase != null) {
            string = imageOptionsBase.getClass().getSimpleName();
            string = string.substring(0, string.indexOf("Options"));
        }
        return "Cannot save to the specified format " + string + " as it is not supported at the moment";
    }

    public Image a(ImageOptionsBase imageOptionsBase) {
        return this;
    }

    public boolean n() {
        Image image = (Image)this.o.get();
        return this.s || image != null && image.n();
    }

    public final boolean o() {
        return this.v != null;
    }

    protected Rectangle getFitRectangle(Rectangle rectangle) {
        return Image.getFittingRectangle(rectangle, this.getWidth(), this.getHeight());
    }

    protected Image getImage2Export(ImageOptionsBase imageOptionsBase, Rectangle rectangle, IImageExporter iImageExporter) {
        return this;
    }

    public aL a(ImageOptionsBase imageOptionsBase, Rectangle rectangle, IImageExporter iImageExporter) {
        return new aL(this.getImage2Export(imageOptionsBase, rectangle, iImageExporter), false);
    }

    protected Rectangle getFitRectangle(Rectangle rectangle, int[] nArray) {
        return Image.getFittingRectangle(rectangle, nArray, this.getWidth(), this.getHeight());
    }

    protected void onPaletteChanged(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
    }

    protected void onPaletteChanging(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        this.b(com.aspose.imaging.internal.kx.m.c());
    }

    protected final void releaseResources() {
        this.p = null;
        com.aspose.imaging.internal.kS.i i2 = this.k.getAndSet(null);
        if (i2 != null && this.y) {
            i2.dispose();
        }
        if (this.x != null) {
            this.x.dispose();
            this.x = null;
        }
        if (this.v != null) {
            com.aspose.imaging.internal.mR.w.b().b(this.v);
        }
    }

    protected void releaseReferences() {
        this.releaseResources();
    }

    @Override
    protected void releaseManagedResources() {
        this.releaseResources();
        if (this.i != null) {
            try {
                IDisposable iDisposable;
                StreamContainer streamContainer = this.i;
                Stream stream = streamContainer.a();
                if (stream instanceof cs) {
                    iDisposable = (cs)stream;
                    ((cs)iDisposable).e();
                    if (((cs)iDisposable).a() <= 0) {
                        ((cs)iDisposable).dispose();
                        streamContainer.dispose();
                    }
                } else {
                    stream.dispose();
                    streamContainer.dispose();
                }
                iDisposable = this.getDataStreamContainer();
                Stream stream2 = ((StreamContainer)iDisposable).a();
                if (com.aspose.imaging.internal.sv.d.b((Object)stream2, cs.class)) {
                    cs cs2 = (cs)stream2;
                    Stream stream3 = cs2.b();
                    String string = stream3 instanceof FileStream ? ((FileStream)stream3).getName() : null;
                    stream2.dispose();
                    ((DisposableObject)iDisposable).dispose();
                    if (File.exists(string)) {
                        File.delete(string);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.releaseManagedResources();
    }

    private static void d(String string) {
        if (aW.c() == aX.a) {
            throw new ImageCreateException(string);
        }
    }

    static {
        new com.aspose.imaging.internal.lW.b().run();
    }

    protected static final class ImageOperation
    extends Enum {
        public static final int Blend = 0;
        public static final int Resize = 1;
        public static final int ResizeWidthProportionally = 2;
        public static final int ResizeHeightProportionally = 3;
        public static final int Filter = 4;
        public static final int LoadPixels = 5;
        public static final int SavePixels = 6;
        public static final int Crop = 7;
        public static final int BinarizeFixed = 8;
        public static final int BinarizeOtsu = 9;
        public static final int BinarizeBradley = 10;
        public static final int Grayscale = 11;
        public static final int HistogramNormalization = 12;
        public static final int AdjustBrightness = 13;
        public static final int AdjustContrast = 14;
        public static final int AdjustGamma = 15;
        public static final int Rotate = 16;
        public static final int RotateFlip = 17;

        private ImageOperation() {
        }

        static {
            Enum.register(new a());
        }

        private static final class a
        extends Enum.SimpleEnum {
            a() {
                super(ImageOperation.class, Integer.class);
                this.addConstant("Blend", 0L);
                this.addConstant("Resize", 1L);
                this.addConstant("ResizeWidthProportionally", 2L);
                this.addConstant("ResizeHeightProportionally", 3L);
                this.addConstant("Filter", 4L);
                this.addConstant("LoadPixels", 5L);
                this.addConstant("SavePixels", 6L);
                this.addConstant("Crop", 7L);
                this.addConstant("BinarizeFixed", 8L);
                this.addConstant("BinarizeOtsu", 9L);
                this.addConstant("BinarizeBradley", 10L);
                this.addConstant("Grayscale", 11L);
                this.addConstant("HistogramNormalization", 12L);
                this.addConstant("AdjustBrightness", 13L);
                this.addConstant("AdjustContrast", 14L);
                this.addConstant("AdjustGamma", 15L);
                this.addConstant("Rotate", 16L);
                this.addConstant("RotateFlip", 17L);
            }
        }
    }
}

