/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.IImageCreator;
import com.aspose.imaging.IImageCreatorDescriptor;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.extensions.FileFormatExtensions;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.bC.A;
import com.aspose.imaging.internal.bC.C;
import com.aspose.imaging.internal.bC.E;
import com.aspose.imaging.internal.bC.b;
import com.aspose.imaging.internal.bC.d;
import com.aspose.imaging.internal.bC.f;
import com.aspose.imaging.internal.bC.h;
import com.aspose.imaging.internal.bC.j;
import com.aspose.imaging.internal.bC.l;
import com.aspose.imaging.internal.bC.n;
import com.aspose.imaging.internal.bC.p;
import com.aspose.imaging.internal.bC.r;
import com.aspose.imaging.internal.bC.t;
import com.aspose.imaging.internal.bC.v;
import com.aspose.imaging.internal.bC.y;
import java.util.ArrayList;
import java.util.List;

public final class ImageCreatorsRegistry {
    private static volatile List<IImageCreatorDescriptor> a = new ArrayList<IImageCreatorDescriptor>();

    private ImageCreatorsRegistry() {
    }

    public static long getRegisteredFormats() {
        long l2 = 0L;
        for (IImageCreatorDescriptor iImageCreatorDescriptor : a) {
            l2 |= iImageCreatorDescriptor.getSupportedFormat();
        }
        return l2;
    }

    public static IImageCreatorDescriptor[] getRegisteredDescriptors() {
        return a.toArray(new IImageCreatorDescriptor[0]);
    }

    public static void register(IImageCreatorDescriptor iImageCreatorDescriptor) {
        if (iImageCreatorDescriptor == null) {
            throw new NullPointerException("creatorDescriptor");
        }
        List<IImageCreatorDescriptor> list = a;
        ArrayList<IImageCreatorDescriptor> arrayList = new ArrayList<IImageCreatorDescriptor>(list.size() + 1);
        arrayList.addAll(list);
        arrayList.add(iImageCreatorDescriptor);
        a = arrayList;
    }

    public static IImageCreatorDescriptor getFirstSupportedDescriptor(ImageOptionsBase imageOptionsBase) {
        if (imageOptionsBase == null) {
            throw new NullPointerException("imageOptions");
        }
        List<IImageCreatorDescriptor> list = a;
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            IImageCreatorDescriptor iImageCreatorDescriptor = list.get(i2);
            if (!iImageCreatorDescriptor.canCreate(imageOptionsBase)) continue;
            return iImageCreatorDescriptor;
        }
        return null;
    }

    public static IImageCreator createFirstSupportedCreator(ImageOptionsBase imageOptionsBase) {
        IImageCreator iImageCreator = null;
        IImageCreatorDescriptor iImageCreatorDescriptor = ImageCreatorsRegistry.getFirstSupportedDescriptor(imageOptionsBase);
        if (iImageCreatorDescriptor != null) {
            iImageCreator = iImageCreatorDescriptor.createInstance();
        }
        return iImageCreator;
    }

    public static void registerCreator(IImageCreatorDescriptor iImageCreatorDescriptor) {
        if (iImageCreatorDescriptor == null) {
            throw new NullPointerException("creatorDescriptor");
        }
        if (!FileFormatExtensions.isSingleFormatDefined(iImageCreatorDescriptor.getSupportedFormat())) {
            throw new ArgumentException("Creator should support only single file format.", "creatorDescriptor");
        }
        List<IImageCreatorDescriptor> list = a;
        ArrayList<IImageCreatorDescriptor> arrayList = new ArrayList<IImageCreatorDescriptor>(list.size() + 1);
        arrayList.addAll(list);
        arrayList.add(iImageCreatorDescriptor);
        a = arrayList;
    }

    public static void unregisterCreator(IImageCreatorDescriptor iImageCreatorDescriptor) {
        if (iImageCreatorDescriptor == null) {
            throw new NullPointerException("creatorDescriptor");
        }
        List<IImageCreatorDescriptor> list = a;
        ArrayList<IImageCreatorDescriptor> arrayList = new ArrayList<IImageCreatorDescriptor>(list.size() - 1);
        for (IImageCreatorDescriptor iImageCreatorDescriptor2 : list) {
            if (iImageCreatorDescriptor2 == iImageCreatorDescriptor) continue;
            arrayList.add(iImageCreatorDescriptor2);
        }
        if (arrayList.size() != list.size()) {
            a = arrayList;
        }
    }

    static {
        a.add(new n());
        a.add(new r());
        a.add(new t());
        a.add(new A());
        a.add(new b());
        a.add(new C());
        a.add(new d());
        a.add(new f());
        a.add(new v());
        a.add(new l());
        a.add(new p());
        a.add(new E());
        a.add(new j());
        a.add(new h());
        a.add(new y());
    }
}

