/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.IImageExporter;
import com.aspose.imaging.IImageExporterDescriptor;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.extensions.FileFormatExtensions;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.cc.A;
import com.aspose.imaging.internal.cc.C;
import com.aspose.imaging.internal.cc.F;
import com.aspose.imaging.internal.cc.H;
import com.aspose.imaging.internal.cc.J;
import com.aspose.imaging.internal.cc.O;
import com.aspose.imaging.internal.cc.Q;
import com.aspose.imaging.internal.cc.S;
import com.aspose.imaging.internal.cc.V;
import com.aspose.imaging.internal.cc.X;
import com.aspose.imaging.internal.cc.b;
import com.aspose.imaging.internal.cc.d;
import com.aspose.imaging.internal.cc.f;
import com.aspose.imaging.internal.cc.k;
import com.aspose.imaging.internal.cc.m;
import com.aspose.imaging.internal.cc.o;
import com.aspose.imaging.internal.cc.q;
import com.aspose.imaging.internal.cc.t;
import com.aspose.imaging.internal.cc.v;
import com.aspose.imaging.internal.cc.x;
import java.util.ArrayList;
import java.util.List;

public final class ImageExportersRegistry {
    private static volatile List<IImageExporterDescriptor> a = new ArrayList<IImageExporterDescriptor>();

    private ImageExportersRegistry() {
    }

    public static long getRegisteredFormats() {
        long l2 = 0L;
        for (IImageExporterDescriptor iImageExporterDescriptor : a) {
            l2 |= iImageExporterDescriptor.getSupportedFormat();
        }
        return l2;
    }

    public static IImageExporterDescriptor[] getRegisteredExporterDescriptors() {
        return a.toArray(new IImageExporterDescriptor[0]);
    }

    public static void register(IImageExporterDescriptor iImageExporterDescriptor) {
        if (iImageExporterDescriptor == null) {
            throw new NullPointerException("exporterDescriptor");
        }
        List<IImageExporterDescriptor> list = a;
        ArrayList<IImageExporterDescriptor> arrayList = new ArrayList<IImageExporterDescriptor>(list.size() + 1);
        arrayList.addAll(list);
        arrayList.add(iImageExporterDescriptor);
        a = arrayList;
    }

    public static IImageExporterDescriptor getFirstSupportedDescriptor(Image image, ImageOptionsBase imageOptionsBase) {
        List<IImageExporterDescriptor> list = a;
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            IImageExporterDescriptor iImageExporterDescriptor = list.get(i2);
            if (!iImageExporterDescriptor.canExport(image, imageOptionsBase)) continue;
            return iImageExporterDescriptor;
        }
        return null;
    }

    public static IImageExporter createFirstSupportedExporter(Image image, ImageOptionsBase imageOptionsBase) {
        IImageExporter iImageExporter = null;
        IImageExporterDescriptor iImageExporterDescriptor = ImageExportersRegistry.getFirstSupportedDescriptor(image, imageOptionsBase);
        if (iImageExporterDescriptor != null) {
            iImageExporter = iImageExporterDescriptor.createInstance();
        }
        return iImageExporter;
    }

    public static void registerExporter(IImageExporterDescriptor iImageExporterDescriptor) {
        if (iImageExporterDescriptor == null) {
            throw new NullPointerException("exporterDescriptor");
        }
        if (!FileFormatExtensions.isSingleFormatDefined(iImageExporterDescriptor.getSupportedFormat())) {
            throw new ArgumentException("Exporter should support only single file format.", "exporterDescriptor");
        }
        List<IImageExporterDescriptor> list = a;
        ArrayList<IImageExporterDescriptor> arrayList = new ArrayList<IImageExporterDescriptor>(list.size() + 1);
        arrayList.addAll(list);
        arrayList.add(iImageExporterDescriptor);
        a = arrayList;
    }

    public static void unregisterExporter(IImageExporterDescriptor iImageExporterDescriptor) {
        if (iImageExporterDescriptor == null) {
            throw new NullPointerException("exporterDescriptor");
        }
        List<IImageExporterDescriptor> list = a;
        ArrayList<IImageExporterDescriptor> arrayList = new ArrayList<IImageExporterDescriptor>(list.size() - 1);
        for (IImageExporterDescriptor iImageExporterDescriptor2 : list) {
            if (iImageExporterDescriptor2 == iImageExporterDescriptor) continue;
            arrayList.add(iImageExporterDescriptor2);
        }
        if (arrayList.size() != list.size()) {
            a = arrayList;
        }
    }

    public static boolean a() {
        return a.isEmpty();
    }

    static {
        a.add(new t());
        a.add(new S());
        a.add(new d());
        a.add(new C());
        a.add(new H());
        a.add(new Q());
        a.add(new b());
        a.add(new J());
        a.add(new f());
        a.add(new A());
        a.add(new q());
        a.add(new x());
        a.add(new F());
        a.add(new V());
        a.add(new k());
        a.add(new o());
        a.add(new X());
        a.add(new O());
        a.add(new v());
        a.add(new m());
    }
}

