/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.PointF;
import com.aspose.imaging.Size;
import com.aspose.imaging.internal.nG.i;
import com.aspose.imaging.internal.ni.a;
import com.aspose.imaging.internal.ns.aV;
import com.aspose.imaging.internal.ns.bE;
import com.aspose.imaging.system.SerializableAttribute;

@SerializableAttribute
public class Point
extends com.aspose.imaging.internal.sv.i<Point> {
    static final String PointFormat = "{{X={0}, Y={1}}}";
    private int a;
    private int b;

    public Point() {
    }

    public Point(int n2, int n3) {
        this.a = n2;
        this.b = n3;
    }

    public Point(Size size) {
        this.a = size.getWidth();
        this.b = size.getHeight();
    }

    public Point(int n2) {
        int n3 = n2;
        this.a = (short)(n3 & 0xFFFF);
        n3 = n2;
        this.b = (short)(n3 >> 16 & 0xFFFF);
    }

    public static Point getEmpty() {
        return new Point();
    }

    public static Point add(Point point, Size size) {
        return new Point(point.a + size.getWidth(), point.b + size.getHeight());
    }

    public static Point subtract(Point point, Size size) {
        return new Point(point.a - size.getWidth(), point.b - size.getHeight());
    }

    public static Point ceiling(PointF pointF) {
        return new Point((int)bE.b((double)pointF.getX()), (int)bE.b((double)pointF.getY()));
    }

    public static Point round(PointF pointF) {
        return new Point(com.aspose.imaging.internal.ni.a.b(pointF.getX()), com.aspose.imaging.internal.ni.a.b(pointF.getY()));
    }

    public static Point truncate(PointF pointF) {
        return new Point((int)pointF.getX(), (int)pointF.getY());
    }

    public static Point op_Addition(Point point, Size size) {
        return Point.add(point, size);
    }

    public static Point op_Subtraction(Point point, Size size) {
        return Point.subtract(point, size);
    }

    public static boolean op_Equality(Point point, Point point2) {
        return point.a == point2.a && point.b == point2.b;
    }

    public static boolean op_Inequality(Point point, Point point2) {
        return !Point.op_Equality(point, point2);
    }

    public static Size to_Size(Point point) {
        return new Size(point.a, point.b);
    }

    public static PointF to_PointF(Point point) {
        return new PointF(point.a, point.b);
    }

    public static void fromLong(long l2, int[] nArray, int[] nArray2) {
        nArray[0] = (int)(l2 >> 32);
        nArray2[0] = (int)(l2 & 0xFFFFFFFFL);
    }

    private static int a(int n2) {
        return n2 & 0xFFFF;
    }

    private static int b(int n2) {
        return n2 >> 16 & 0xFFFF;
    }

    public static boolean isEquals(Point point, Point point2) {
        if (point == point2) {
            return true;
        }
        if (point == null) {
            return false;
        }
        return point.equals(point2);
    }

    public boolean isEmpty() {
        return this.a == 0 && this.b == 0;
    }

    public int getX() {
        return this.a;
    }

    public void setX(int n2) {
        this.a = n2;
    }

    public int getY() {
        return this.b;
    }

    public void setY(int n2) {
        this.b = n2;
    }

    public void offset(Point point) {
        this.offset(point.a, point.b);
    }

    public void offset(int n2, int n3) {
        this.a += n2;
        this.b += n3;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Point)) {
            return false;
        }
        Point point = (Point)object;
        return point.a == this.a && point.b == this.b;
    }

    public int hashCode() {
        return this.a ^ this.b;
    }

    public final long toLong() {
        return (long)this.a << 32 | (long)this.b;
    }

    public String toString() {
        return aV.a(i.h(), PointFormat, this.a, this.b);
    }

    @Override
    public void CloneTo(Point point) {
        point.a = this.a;
        point.b = this.b;
    }

    @Override
    public Point Clone() {
        Point point = new Point();
        this.CloneTo(point);
        return point;
    }
}

