/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.Color;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IMultipageImage;
import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.PageExportingAction;
import com.aspose.imaging.Point;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.Size;
import com.aspose.imaging.coreexceptions.ImageException;
import com.aspose.imaging.imagefilters.filteroptions.FilterOptionsBase;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.NotImplementedException;
import com.aspose.imaging.internal.Exceptions.NullReferenceException;
import com.aspose.imaging.internal.kx.m;
import com.aspose.imaging.internal.kx.o;
import com.aspose.imaging.internal.mF.D;
import com.aspose.imaging.internal.mF.t;
import com.aspose.imaging.internal.mF.z;
import com.aspose.imaging.internal.mT.g;
import com.aspose.imaging.internal.ms.I;
import com.aspose.imaging.internal.ne.a;
import com.aspose.imaging.internal.ns.aV;
import com.aspose.imaging.internal.ns.au;
import com.aspose.imaging.internal.sv.d;
import com.aspose.imaging.metadata.ImageMetadata;
import com.aspose.imaging.palettehelper.AdjustPalette;
import com.aspose.imaging.system.io.Stream;

public abstract class RasterCachedMultipageImage
extends RasterCachedImage
implements IMultipageImage {
    private PageExportingAction j;

    protected RasterCachedMultipageImage(IColorPalette iColorPalette) {
        super(iColorPalette);
    }

    protected RasterCachedMultipageImage() {
    }

    @Override
    public int getHeight() {
        this.verifyNotDisposed();
        Image image = this.t();
        return image != null ? image.getHeight() : 0;
    }

    @Override
    public int getWidth() {
        this.verifyNotDisposed();
        Image image = this.t();
        return image != null ? image.getWidth() : 0;
    }

    @Override
    public int getBitsPerPixel() {
        this.verifyNotDisposed();
        int n2 = 0;
        Image image = this.t();
        if (image != null) {
            n2 = image.getBitsPerPixel();
        }
        return n2;
    }

    @Override
    public boolean isCached() {
        Image image;
        if (this.getPageCount() == 0) {
            return super.isCached();
        }
        boolean bl2 = true;
        Image[] imageArray = this.getPages();
        int n2 = imageArray.length;
        for (int i2 = 0; i2 < n2 && (bl2 = (image = imageArray[i2]).isCached()); ++i2) {
        }
        return bl2;
    }

    public Image t() {
        Image[] imageArray = this.getPages();
        if (imageArray == null || imageArray.length == 0) {
            throw new NotImplementedException();
        }
        return imageArray[0];
    }

    @Override
    public boolean hasAlpha() {
        RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(this.t(), RasterImage.class));
        if (rasterImage != null) {
            return rasterImage.hasAlpha();
        }
        return false;
    }

    @Override
    public boolean I_() {
        if (this.t() == this) {
            return super.I_();
        }
        Image[] imageArray = this.getPages();
        if (imageArray != null) {
            for (Image image : imageArray) {
                if (!image.I_()) continue;
                return true;
            }
        }
        return super.I_();
    }

    @Override
    public boolean hasTransparentColor() {
        RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(this.t(), RasterImage.class));
        if (rasterImage != null) {
            return rasterImage.hasTransparentColor();
        }
        return false;
    }

    @Override
    public float getImageOpacity() {
        Image image = this.t();
        if (image == this) {
            return super.getImageOpacity();
        }
        RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(image, RasterImage.class));
        if (rasterImage != null) {
            return rasterImage.getImageOpacity();
        }
        return super.getImageOpacity();
    }

    @Override
    public Color getBackgroundColor() {
        Image image = this.t();
        if (image == this) {
            return super.getBackgroundColor();
        }
        return image.getBackgroundColor();
    }

    @Override
    public void setBackgroundColor(Color color) {
        Image image = this.t();
        if (image == this) {
            super.setBackgroundColor(color);
            return;
        }
        image.setBackgroundColor(color);
    }

    @Override
    public ImageMetadata getMetadata() {
        ImageMetadata imageMetadata;
        Image image = this.t();
        if (image == this) {
            return super.getMetadata();
        }
        ImageMetadata imageMetadata2 = imageMetadata = image != null ? image.getMetadata() : null;
        if (imageMetadata == null) {
            imageMetadata = super.getMetadata();
        }
        return imageMetadata;
    }

    @Override
    public PageExportingAction getPageExportingAction() {
        return this.j;
    }

    @Override
    public void setPageExportingAction(PageExportingAction pageExportingAction) {
        this.j = pageExportingAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustBrightness(int n2) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.c(13);
            try {
                Image[] imageArray;
                this.b(bl2);
                this.verifyNotDisposed();
                if (this.t() == this && this.canDoAdjustments()) {
                    super.adjustBrightness(n2);
                }
                if ((imageArray = this.getPages()) != null && imageArray.length > 0) {
                    for (Image image : this.getPagesAsEnumerable()) {
                        RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(image, RasterImage.class));
                        if (rasterImage == null) continue;
                        rasterImage.adjustBrightness(n2);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException("Can't change brightness.", runtimeException);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustContrast(float f2) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.c(14);
            try {
                Image[] imageArray;
                this.b(bl2);
                this.verifyNotDisposed();
                if (this.t() == this && this.canDoAdjustments()) {
                    super.adjustContrast(f2);
                }
                if ((imageArray = this.getPages()) != null && imageArray.length > 0) {
                    for (Image image : this.getPagesAsEnumerable()) {
                        RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(image, RasterImage.class));
                        if (rasterImage == null) continue;
                        rasterImage.adjustContrast(f2);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException("Can't change contrast.", runtimeException);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustGamma(float f2, float f3, float f4) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.c(15);
            try {
                Image[] imageArray;
                this.b(bl2);
                this.verifyNotDisposed();
                if (this.t() == this && this.canDoAdjustments()) {
                    super.adjustGamma(f2, f3, f4);
                }
                if ((imageArray = this.getPages()) != null && imageArray.length > 0) {
                    for (Image image : this.getPagesAsEnumerable()) {
                        RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(image, RasterImage.class));
                        if (rasterImage == null) continue;
                        rasterImage.adjustGamma(f2, f3, f4);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException("Can't change gamma.", runtimeException);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    @Override
    public void adjustGamma(float f2) {
        this.adjustGamma(f2, f2, f2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blend(Point point, RasterImage rasterImage, Rectangle rectangle, byte by2) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.c(0);
            try {
                boolean bl3;
                this.b(bl2);
                this.verifyNotDisposed();
                Image image = this.t();
                boolean bl4 = bl3 = image == this && this.canDoAdjustments();
                if (bl3) {
                    super.blend(point, rasterImage, rectangle, by2);
                }
                for (Image image2 : this.getPagesAsEnumerable()) {
                    if (image2 == image && bl3 || !(image2 instanceof RasterImage)) continue;
                    RasterImage rasterImage2 = (RasterImage)image2;
                    rasterImage2.blend(point, rasterImage, rectangle, by2);
                }
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException("RasterCachedMultipageImage.Blend", runtimeException);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void embedDigitalSignature(String string) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.c(0);
            try {
                this.b(bl2);
                this.verifyNotDisposed();
                for (Image image : this.getPagesAsEnumerable()) {
                    ((RasterImage)image).embedDigitalSignature(string);
                }
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException("this.embedDigitalSignature", runtimeException);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int analyzePercentageDigitalSignature(String string) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.c(0);
            try {
                this.b(bl2);
                this.verifyNotDisposed();
                int n2 = 0;
                int n3 = 0;
                for (Image image : this.getPagesAsEnumerable()) {
                    int n4 = ((RasterImage)image).analyzePercentageDigitalSignature(string);
                    n2 += (n4 - n2) / ++n3;
                }
                int n5 = n2;
                return n5;
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException("this.analyzePercentageDigitalSignature", runtimeException);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDigitalSigned(String string, int n2) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.c(0);
            try {
                this.b(bl2);
                this.verifyNotDisposed();
                for (Image image : this.getPagesAsEnumerable()) {
                    if (((RasterImage)image).isDigitalSigned(string, n2)) continue;
                    boolean bl3 = false;
                    return bl3;
                }
                boolean bl4 = this.getPageCount() > 0;
                return bl4;
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException("this.analyzePercentageDigitalSignature", runtimeException);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binarizeFixed(byte by2) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.c(8);
            try {
                Image[] imageArray;
                this.b(bl2);
                this.verifyNotDisposed();
                if (this.t() == this && this.canDoAdjustments()) {
                    super.binarizeFixed(by2);
                }
                if ((imageArray = this.getPages()) != null && imageArray.length > 0) {
                    for (Image image : this.getPagesAsEnumerable()) {
                        RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(image, RasterImage.class));
                        if (rasterImage == null) continue;
                        rasterImage.binarizeFixed(by2);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException("Can't binarize image.", runtimeException);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binarizeBradley(double d2, int n2) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.c(10);
            try {
                Image[] imageArray;
                this.b(bl2);
                this.verifyNotDisposed();
                if (this.t() == this && this.canDoAdjustments()) {
                    super.binarizeBradley(d2, n2);
                }
                if ((imageArray = this.getPages()) != null && imageArray.length > 0) {
                    for (Image image : this.getPagesAsEnumerable()) {
                        RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(image, RasterImage.class));
                        if (rasterImage == null) continue;
                        rasterImage.binarizeBradley(d2, n2);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException("Can't binarize image.", runtimeException);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    @Override
    public void binarizeBradley(double d2) {
        this.binarizeBradley(d2, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binarizeOtsu() {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.c(9);
            try {
                Image[] imageArray;
                this.b(bl2);
                this.verifyNotDisposed();
                if (this.t() == this && this.canDoAdjustments()) {
                    super.binarizeOtsu();
                }
                if ((imageArray = this.getPages()) != null && imageArray.length > 0) {
                    for (Image image : this.getPagesAsEnumerable()) {
                        RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(image, RasterImage.class));
                        if (rasterImage == null) continue;
                        rasterImage.binarizeOtsu();
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException("Can't binarize image.", runtimeException);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void crop(Rectangle rectangle) {
        Object object = this.c;
        synchronized (object) {
            block15: {
                boolean bl2 = this.c(7);
                try {
                    Image[] imageArray;
                    this.b(bl2);
                    this.verifyNotDisposed();
                    if (rectangle.isEmpty() || rectangle.getX() < 0 || rectangle.getY() < 0 || rectangle.getWidth() < 0 || rectangle.getHeight() < 0) {
                        throw new ArgumentException("Rectangle incorrect.", "rectangle");
                    }
                    if (!this.getBounds().contains(rectangle)) {
                        throw new ArgumentException("Rectangle must be contained in the image bounds.", "rectangle");
                    }
                    int n2 = 0;
                    if (this.t() == this && this.canDoAdjustments()) {
                        super.crop(rectangle);
                    }
                    if ((imageArray = this.getPages()) == null || imageArray.length <= 0) break block15;
                    for (Image image : this.getPagesAsEnumerable()) {
                        RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(image, RasterImage.class));
                        if (rasterImage != null) {
                            try {
                                rasterImage.crop(rectangle);
                            }
                            catch (RuntimeException runtimeException) {
                                throw new ImageException(aV.a(new String[]{"Can't crop image. Frame index: ", au.b(n2)}), runtimeException);
                            }
                        }
                        ++n2;
                    }
                    this.updateDimensions(rectangle.getWidth(), rectangle.getHeight());
                }
                catch (RuntimeException runtimeException) {
                    throw new ImageException("Can't crop image.", runtimeException);
                }
                finally {
                    this.c(bl2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void crop(int n2, int n3, int n4, int n5) {
        if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 0) {
            return;
        }
        Object object = this.c;
        synchronized (object) {
            block14: {
                boolean bl2 = this.c(7);
                try {
                    Image[] imageArray;
                    this.b(bl2);
                    this.verifyNotDisposed();
                    int n6 = 0;
                    Image image = this.t();
                    if (image == this && this.canDoAdjustments()) {
                        super.crop(n2, n3, n4, n5);
                    }
                    if ((imageArray = this.getPages()) == null || imageArray.length <= 0) break block14;
                    for (Image image2 : this.getPagesAsEnumerable()) {
                        RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(image2, RasterImage.class));
                        if (rasterImage != null) {
                            try {
                                rasterImage.crop(n2, n3, n4, n5);
                            }
                            catch (RuntimeException runtimeException) {
                                throw new ImageException(aV.a(new String[]{"Can't crop image. Frame index: ", au.b(n6)}), runtimeException);
                            }
                        }
                        ++n6;
                    }
                    this.updateDimensions(image.getWidth(), image.getHeight());
                }
                catch (RuntimeException runtimeException) {
                    throw new ImageException("Can't crop image.", runtimeException);
                }
                finally {
                    this.c(bl2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dither(int n2, int n3, IColorPalette iColorPalette) {
        Object object = this.c;
        synchronized (object) {
            try {
                Image[] imageArray;
                this.b(true);
                this.verifyNotDisposed();
                if (this.t() == this && this.canDoAdjustments()) {
                    super.dither(n2, n3, iColorPalette);
                }
                if ((imageArray = this.getPages()) != null && imageArray.length > 0) {
                    for (Image image : this.getPagesAsEnumerable()) {
                        RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(image, RasterImage.class));
                        if (rasterImage == null) continue;
                        rasterImage.dither(n2, n3, iColorPalette);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException("Can't dither image.", runtimeException);
            }
            finally {
                this.c(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grayscale() {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.c(11);
            try {
                Image[] imageArray;
                this.b(bl2);
                this.verifyNotDisposed();
                if (this.t() == this && this.canDoAdjustments()) {
                    super.grayscale();
                }
                if ((imageArray = this.getPages()) != null && imageArray.length > 0) {
                    for (Image image : this.getPagesAsEnumerable()) {
                        RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(image, RasterImage.class));
                        if (rasterImage == null) continue;
                        rasterImage.grayscale();
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException("Can't grayscale image.", runtimeException);
            }
            finally {
                this.c(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void normalizeHistogram() {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.c(12);
            try {
                Image[] imageArray;
                this.b(bl2);
                this.verifyNotDisposed();
                if (this.t() == this && this.canDoAdjustments()) {
                    super.normalizeHistogram();
                }
                if ((imageArray = this.getPages()) != null && imageArray.length > 0) {
                    for (Image image : this.getPagesAsEnumerable()) {
                        RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(image, RasterImage.class));
                        if (rasterImage == null) continue;
                        rasterImage.normalizeHistogram();
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException("Can't normalize histogram of an image.", runtimeException);
            }
            finally {
                this.c(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rotate(float f2, boolean bl2, Color color) {
        Object object = this.c;
        synchronized (object) {
            boolean bl3 = this.c(16);
            try {
                Image[] imageArray;
                this.b(bl3);
                this.verifyNotDisposed();
                int n2 = this.getWidth();
                int n3 = this.getHeight();
                if (this.t() == this && this.canDoAdjustments()) {
                    super.rotate(f2, bl2, color);
                }
                if ((imageArray = this.getPages()) != null && imageArray.length > 0) {
                    for (Image image : this.getPagesAsEnumerable()) {
                        RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(image, RasterImage.class));
                        if (rasterImage == null) continue;
                        rasterImage.rotate(f2, bl2, color);
                        if (rasterImage.getWidth() > n2) {
                            n2 = rasterImage.getWidth();
                        }
                        if (rasterImage.getHeight() <= n3) continue;
                        n3 = rasterImage.getHeight();
                    }
                }
                this.updateDimensions(n2, n3);
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException("Can't rotate image.", runtimeException);
            }
            finally {
                this.c(bl3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rotateFlip(int n2) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.c(17);
            try {
                this.b(bl2);
                this.verifyNotDisposed();
                for (Image image : this.getPagesAsEnumerable()) {
                    RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(image, RasterImage.class));
                    if (rasterImage == null) continue;
                    rasterImage.rotateFlip(n2);
                }
                Size size = this.t().getSize();
                this.updateDimensions(size.getWidth(), size.getHeight());
            }
            finally {
                this.c(bl2);
            }
        }
    }

    @Deprecated
    public void rotateFlipAll(int n2) {
        this.rotateFlip(n2);
    }

    protected void resizeMain(int n2, int n3, int n4) {
        super.resize(n2, n3, n4);
    }

    protected void rotateFlipMain(int n2) {
        super.rotateFlip(n2);
    }

    protected void cropMain(int n2, int n3, int n4, int n5) {
        super.crop(n2, n3, n4, n5);
    }

    @Override
    public void resize(int n2, int n3, int n4) {
        this.resize(n2, n3, new ImageResizeSettings(n4));
    }

    @Override
    public void resize(int n2, int n3, ImageResizeSettings imageResizeSettings) {
        Image[] imageArray;
        this.verifyNotDisposed();
        if (this.t() == this && this.canDoAdjustments()) {
            super.resize(n2, n3, imageResizeSettings);
        }
        if ((imageArray = this.getPages()) != null && imageArray.length > 0) {
            for (Image image : this.getPagesAsEnumerable()) {
                if (!(image instanceof RasterImage)) continue;
                RasterImage rasterImage = (RasterImage)image;
                rasterImage.resize(n2, n3, imageResizeSettings);
            }
            this.updateDimensions(n2, n3);
        }
        this.b(m.c());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resizeWidthProportionally(int n2, int n3) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.c(2);
            try {
                this.b(bl2);
                this.verifyNotDisposed();
                int n4 = 0;
                for (Image image : this.getPagesAsEnumerable()) {
                    RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(image, RasterImage.class));
                    if (rasterImage == null) continue;
                    rasterImage.resizeWidthProportionally(n2, n3);
                    if (n4 >= rasterImage.getHeight()) continue;
                    n4 = rasterImage.getHeight();
                }
                this.updateDimensions(n2, n4);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resizeHeightProportionally(int n2, int n3) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.c(3);
            try {
                this.b(bl2);
                this.verifyNotDisposed();
                int n4 = 0;
                for (Image image : this.getPagesAsEnumerable()) {
                    RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(image, RasterImage.class));
                    if (rasterImage == null) continue;
                    rasterImage.resizeHeightProportionally(n2, n3);
                    if (n4 >= rasterImage.getWidth()) continue;
                    n4 = rasterImage.getWidth();
                }
                this.updateDimensions(n4, n2);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    @Override
    public void replaceColor(int n2, byte by2, int n3) {
        Image[] imageArray;
        this.verifyNotDisposed();
        if (this.t() == this && this.canDoAdjustments()) {
            super.replaceColor(n2, by2, n3);
        }
        if ((imageArray = this.getPages()) != null && imageArray.length > 0) {
            for (Image image : this.getPagesAsEnumerable()) {
                RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(image, RasterImage.class));
                if (rasterImage == null) continue;
                rasterImage.replaceColor(n2, by2, n3);
            }
        }
    }

    @Override
    public void replaceNonTransparentColors(int n2) {
        Image[] imageArray;
        this.verifyNotDisposed();
        if (this.t() == this && this.canDoAdjustments()) {
            super.replaceNonTransparentColors(n2);
        }
        if ((imageArray = this.getPages()) != null && imageArray.length > 0) {
            for (Image image : this.getPagesAsEnumerable()) {
                RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(image, RasterImage.class));
                if (rasterImage == null) continue;
                rasterImage.replaceNonTransparentColors(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filter(Rectangle rectangle, FilterOptionsBase filterOptionsBase) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.c(4);
            try {
                Image[] imageArray;
                this.b(bl2);
                this.verifyNotDisposed();
                if (this.t() == this && this.canDoAdjustments()) {
                    super.filter(rectangle, filterOptionsBase);
                }
                if ((imageArray = this.getPages()) != null && imageArray.length > 0) {
                    Object object2 = this.getPagesAsEnumerable().iterator();
                    while (object2.hasNext()) {
                        Image image = object2.next();
                        RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(image, RasterImage.class));
                        if (rasterImage == null) continue;
                        rasterImage.filter(rectangle, filterOptionsBase);
                    }
                    if (this.getPalette() != null && (object2 = AdjustPalette.a((RasterImage)this.t(), this.getPalette().getEntriesCount())) != null) {
                        this.setPalette((IColorPalette)object2);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException("Can't apply filter to image.", runtimeException);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void normalizeAngle(boolean bl2, Color color) {
        Object object = this.c;
        synchronized (object) {
            boolean bl3 = this.c(17);
            try {
                this.b(bl3);
                this.verifyNotDisposed();
                for (Image image : this.getPagesAsEnumerable()) {
                    RasterImage rasterImage = (RasterImage)((Object)com.aspose.imaging.internal.sv.d.a(image, RasterImage.class));
                    if (rasterImage == null) continue;
                    rasterImage.normalizeAngle(bl2, color);
                }
                Image image = this.t();
                this.updateDimensions(image.getWidth(), image.getHeight());
            }
            finally {
                this.c(bl3);
            }
        }
    }

    @Override
    protected void releaseReferences() {
        Image[] imageArray = this.getPages();
        if (imageArray != null) {
            for (Image image : imageArray) {
                if (!(image instanceof RasterImage)) continue;
                RasterImage rasterImage = (RasterImage)image;
                rasterImage.a((IRasterImageArgb32PixelLoader)null);
            }
        }
        super.releaseReferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void releaseManagedResources() {
        Object object = this.c;
        synchronized (object) {
            try {
                this.e();
                Image[] imageArray = this.getPages();
                if (imageArray != null) {
                    for (Image image : imageArray) {
                        if (image == null) continue;
                        image.dispose();
                    }
                }
            }
            finally {
                this.f();
            }
        }
        super.releaseManagedResources();
    }

    @Override
    protected void a(Rectangle rectangle, int[] nArray) {
        Image image = this.t();
        if (image == null) {
            throw new NullReferenceException("Cannot save pixels as no active page exists.");
        }
        if (image == this) {
            super.a(rectangle, nArray);
            return;
        }
        if (image instanceof RasterImage) {
            ((RasterImage)image).saveArgb32Pixels(rectangle, nArray);
        }
        this.b(m.c());
    }

    @Override
    public Stream a(ImageOptionsBase imageOptionsBase, Rectangle rectangle, int[] nArray) {
        t t2 = new t();
        for (Image image : this.getPages()) {
            D d2 = image.a(imageOptionsBase, 2, rectangle);
            t2.a(d2);
        }
        g g2 = new g();
        I i2 = new I();
        g2.a(i2, (z)t2);
        nArray[0] = -1;
        return i2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheData() {
        Object object = this.c;
        synchronized (object) {
            try {
                Image[] imageArray;
                this.e();
                if (this.t() == this && this.canDoAdjustments()) {
                    super.cacheData();
                    return;
                }
                for (Image image : imageArray = this.getPages()) {
                    if (image.getBounds().isEmpty()) continue;
                    image.cacheData();
                }
            }
            finally {
                this.f();
            }
        }
    }

    protected boolean canDoAdjustments() {
        return true;
    }

    protected Iterable<Image> getPagesAsEnumerable() {
        return () -> new a<Image>(this.getPages());
    }

    @Override
    public void a(Object object) {
        super.a(object);
        Image[] imageArray = this.getPages();
        if (imageArray != null) {
            for (Image image : imageArray) {
                if (image == null) continue;
                image.a(object);
            }
        }
    }

    @Override
    public boolean a(o o2) {
        if (!super.a(o2)) {
            return false;
        }
        Image[] imageArray = this.getPages();
        if (imageArray != null) {
            for (Image image : imageArray) {
                if (image == null) continue;
                image.a(o2);
            }
        }
        return true;
    }

    @Override
    public IColorPalette u() {
        Image image = this.t();
        if (image instanceof RasterImage) {
            return ((RasterImage)image).u();
        }
        return null;
    }
}

