/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.Point;
import com.aspose.imaging.RectangleF;
import com.aspose.imaging.Size;
import com.aspose.imaging.internal.nG.i;
import com.aspose.imaging.internal.ns.aV;
import com.aspose.imaging.internal.ns.bE;
import com.aspose.imaging.internal.sv.d;
import com.aspose.imaging.system.SerializableAttribute;

@SerializableAttribute
public class Rectangle
extends com.aspose.imaging.internal.sv.i<Rectangle> {
    static final String RectangleFormat = "{{X={0}, Y={1}, Width={2}, Height={3}}}";
    private int a;
    private int b;
    private int c;
    private int d;

    public Rectangle() {
    }

    public Rectangle(int n2, int n3, int n4, int n5) {
        this.c = n2;
        this.d = n3;
        this.b = n4;
        this.a = n5;
    }

    public Rectangle(Point point, Size size) {
        this.c = point.getX();
        this.d = point.getY();
        this.b = size.getWidth();
        this.a = size.getHeight();
    }

    public static Rectangle getEmpty() {
        return new Rectangle();
    }

    public static Rectangle fromPoints(Point point, Point point2) {
        int n2 = bE.d(point.getX(), point2.getX());
        int n3 = bE.b(point.getX(), point2.getX());
        int n4 = bE.d(point.getY(), point2.getY());
        int n5 = bE.b(point.getY(), point2.getY());
        return Rectangle.fromLeftTopRightBottom(n2, n4, n3, n5);
    }

    public static Rectangle ceiling(RectangleF rectangleF) {
        return new Rectangle(com.aspose.imaging.internal.sv.d.e(bE.b((double)rectangleF.getX())), com.aspose.imaging.internal.sv.d.e(bE.b((double)rectangleF.getY())), com.aspose.imaging.internal.sv.d.e(bE.b((double)rectangleF.getWidth())), com.aspose.imaging.internal.sv.d.e(bE.b((double)rectangleF.getHeight())));
    }

    public static Rectangle truncate(RectangleF rectangleF) {
        return new Rectangle(com.aspose.imaging.internal.sv.d.e(rectangleF.getX()), com.aspose.imaging.internal.sv.d.e(rectangleF.getY()), com.aspose.imaging.internal.sv.d.e(rectangleF.getWidth()), com.aspose.imaging.internal.sv.d.e(rectangleF.getHeight()));
    }

    public static Rectangle round(RectangleF rectangleF) {
        return new Rectangle(com.aspose.imaging.internal.sv.d.e(bE.d(rectangleF.getX())), com.aspose.imaging.internal.sv.d.e(bE.d(rectangleF.getY())), com.aspose.imaging.internal.sv.d.e(bE.d(rectangleF.getWidth())), com.aspose.imaging.internal.sv.d.e(bE.d(rectangleF.getHeight())));
    }

    public static Rectangle inflate(Rectangle rectangle, int n2, int n3) {
        Rectangle rectangle2 = rectangle.Clone();
        rectangle2.inflate(n2, n3);
        return rectangle2;
    }

    public static Rectangle intersect(Rectangle rectangle, Rectangle rectangle2) {
        int n2 = bE.b(rectangle.c, rectangle2.c);
        int n3 = bE.d(rectangle.c + rectangle.b, rectangle2.c + rectangle2.b);
        int n4 = bE.b(rectangle.d, rectangle2.d);
        int n5 = bE.d(rectangle.d + rectangle.a, rectangle2.d + rectangle2.a);
        if (n3 >= n2 && n5 >= n4) {
            return new Rectangle(n2, n4, n3 - n2, n5 - n4);
        }
        return new Rectangle();
    }

    public static Rectangle union(Rectangle rectangle, Rectangle rectangle2) {
        int n2 = bE.d(rectangle.c, rectangle2.c);
        int n3 = bE.b(rectangle.c + rectangle.b, rectangle2.c + rectangle2.b);
        int n4 = bE.d(rectangle.d, rectangle2.d);
        int n5 = bE.b(rectangle.d + rectangle.a, rectangle2.d + rectangle2.a);
        return new Rectangle(n2, n4, n3 - n2, n5 - n4);
    }

    public static boolean op_Equality(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle.c == rectangle2.c && rectangle.d == rectangle2.d && rectangle.b == rectangle2.b && rectangle.a == rectangle2.a;
    }

    public static boolean op_Inequality(Rectangle rectangle, Rectangle rectangle2) {
        return !Rectangle.op_Equality(rectangle, rectangle2);
    }

    public static Rectangle fromLeftTopRightBottom(int n2, int n3, int n4, int n5) {
        return new Rectangle(n2, n3, n4 - n2, n5 - n3);
    }

    public static boolean isEquals(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == rectangle2) {
            return true;
        }
        if (rectangle == null) {
            return false;
        }
        return rectangle.equals(rectangle2);
    }

    public Point getLocation() {
        return new Point(this.c, this.d);
    }

    public void setLocation(Point point) {
        this.c = point.getX();
        this.d = point.getY();
    }

    public Size getSize() {
        return new Size(this.b, this.a);
    }

    public void setSize(Size size) {
        this.b = size.getWidth();
        this.a = size.getHeight();
    }

    public int getX() {
        return this.c;
    }

    public void setX(int n2) {
        this.c = n2;
    }

    public int getY() {
        return this.d;
    }

    public void setY(int n2) {
        this.d = n2;
    }

    public int getWidth() {
        return this.b;
    }

    public void setWidth(int n2) {
        this.b = n2;
    }

    public int getHeight() {
        return this.a;
    }

    public void setHeight(int n2) {
        this.a = n2;
    }

    public int getLeft() {
        return this.c;
    }

    public void setLeft(int n2) {
        int n3 = n2 - this.c;
        this.c = n2;
        this.b -= n3;
    }

    public int getTop() {
        return this.d;
    }

    public void setTop(int n2) {
        int n3 = n2 - this.d;
        this.d = n2;
        this.a -= n3;
    }

    public int getRight() {
        return this.c + this.b;
    }

    public void setRight(int n2) {
        int n3 = n2 - this.getRight();
        this.b += n3;
    }

    public int getBottom() {
        return this.d + this.a;
    }

    public void setBottom(int n2) {
        int n3 = n2 - this.getBottom();
        this.a += n3;
    }

    public boolean isEmpty() {
        return this.a == 0 && this.b == 0 && this.c == 0 && this.d == 0;
    }

    public boolean a() {
        return this.a > 0 && this.b > 0 && (this.c + this.b > 0 || this.d + this.a > 0);
    }

    public final Point b() {
        return new Point(this.getRight(), this.getBottom());
    }

    public final boolean c() {
        return this.b * this.a == 0;
    }

    public boolean contains(int n2, int n3) {
        return this.c <= n2 && n2 < this.c + this.b && this.d <= n3 && n3 < this.d + this.a;
    }

    public boolean contains(Point point) {
        return this.contains(point.getX(), point.getY());
    }

    public boolean contains(Rectangle rectangle) {
        return this.c <= rectangle.c && rectangle.c + rectangle.b <= this.c + this.b && this.d <= rectangle.d && rectangle.d + rectangle.a <= this.d + this.a;
    }

    public void inflate(int n2, int n3) {
        this.c -= n2;
        this.d -= n3;
        this.b += 2 * n2;
        this.a += 2 * n3;
    }

    public void inflate(Size size) {
        this.inflate(size.getWidth(), size.getHeight());
    }

    public void intersect(Rectangle rectangle) {
        Rectangle rectangle2 = Rectangle.intersect(rectangle, this);
        this.c = rectangle2.c;
        this.d = rectangle2.d;
        this.b = rectangle2.b;
        this.a = rectangle2.a;
    }

    public boolean intersectsWith(Rectangle rectangle) {
        return rectangle.c < this.c + this.b && this.c < rectangle.c + rectangle.b && rectangle.d < this.d + this.a && this.d < rectangle.d + rectangle.a;
    }

    public void offset(Point point) {
        this.offset(point.getX(), point.getY());
    }

    public void offset(int n2, int n3) {
        this.c += n2;
        this.d += n3;
    }

    public void normalize() {
        if (this.b < 0) {
            this.c += this.b;
            this.b = -this.b;
        }
        if (this.a < 0) {
            this.d += this.a;
            this.a = -this.a;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Rectangle)) {
            return false;
        }
        Rectangle rectangle = (Rectangle)object;
        return rectangle.c == this.c && rectangle.d == this.d && rectangle.b == this.b && rectangle.a == this.a;
    }

    public int hashCode() {
        return this.c ^ (this.d << 13 | this.d >> 19) ^ (this.b << 26 | this.b >> 6) ^ (this.a << 7 | this.a >> 25);
    }

    public String toString() {
        return aV.a(i.h(), RectangleFormat, this.c, this.d, this.b, this.a);
    }

    @Override
    public void CloneTo(Rectangle rectangle) {
        rectangle.a = this.a;
        rectangle.b = this.b;
        rectangle.c = this.c;
        rectangle.d = this.d;
    }

    @Override
    public Rectangle Clone() {
        Rectangle rectangle = new Rectangle();
        this.CloneTo(rectangle);
        return rectangle;
    }
}

