/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.gif.blocks;

import com.aspose.imaging.Color;
import com.aspose.imaging.ColorPalette;
import com.aspose.imaging.IAnimationFrame;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IHasMetadata;
import com.aspose.imaging.IRasterImageArgb32PixelLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.Point;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.Size;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.coreexceptions.imageformats.GifImageException;
import com.aspose.imaging.fileformats.gif.GifImage;
import com.aspose.imaging.fileformats.gif.IGifBlock;
import com.aspose.imaging.fileformats.gif.blocks.GifGraphicsControlBlock;
import com.aspose.imaging.imageoptions.GifOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.NotSupportedException;
import com.aspose.imaging.internal.br.L;
import com.aspose.imaging.internal.br.aD;
import com.aspose.imaging.internal.br.bN;
import com.aspose.imaging.internal.br.bk;
import com.aspose.imaging.internal.br.bz;
import com.aspose.imaging.internal.br.m;
import com.aspose.imaging.internal.gF.o;
import com.aspose.imaging.internal.gm.a;
import com.aspose.imaging.internal.gm.c;
import com.aspose.imaging.internal.gm.d;
import com.aspose.imaging.internal.kS.i;
import com.aspose.imaging.internal.lh.b;
import com.aspose.imaging.internal.ns.aV;
import com.aspose.imaging.internal.ns.bE;
import com.aspose.imaging.internal.ns.w;
import com.aspose.imaging.system.io.Stream;
import java.io.InputStream;
import java.util.Arrays;

public final class GifFrameBlock
extends RasterCachedImage
implements IAnimationFrame,
IGifBlock,
com.aspose.imaging.internal.am.b {
    public static final int EXTENSION_LABEL = 44;
    public static final int IMAGE_DESCRIPTOR_SIZE = 10;
    private static final String j = "value";
    private byte k;
    private int l;
    private int m;
    private int n;
    private int o;
    private byte p;
    private GifGraphicsControlBlock q;
    private int r;
    private int s;
    private Rectangle t = null;
    private Rectangle u = null;

    public GifFrameBlock(int n2, int n3) {
        this(0, 0, n2, n3);
    }

    public GifFrameBlock(int n2, int n3, int n4, int n5) {
        this(null, n2, n3, n4, n5, null, false, false, 8);
    }

    public GifFrameBlock(int n2, int n3, int n4, int n5, IColorPalette iColorPalette, boolean bl2, boolean bl3, byte by2) {
        this(null, n2, n3, n4, n5, iColorPalette, bl2, bl3, by2);
    }

    public GifFrameBlock(RasterImage rasterImage) {
        this(rasterImage, 0, 0, false, false, 8);
    }

    public GifFrameBlock(RasterImage rasterImage, int n2, int n3) {
        this(rasterImage, n2, n3, false, false, 8);
    }

    public GifFrameBlock(RasterImage rasterImage, int n2, int n3, boolean bl2, boolean bl3, byte by2) {
        if (rasterImage == null) {
            throw new ArgumentNullException("image");
        }
        this.a(new bN(rasterImage), n2, n3, bl2, bl3, by2);
    }

    public GifFrameBlock(InputStream inputStream) {
        this(Stream.fromJava(inputStream));
    }

    public GifFrameBlock(Stream stream) {
        this(stream, 0, 0, false, false, 8);
    }

    public GifFrameBlock(InputStream inputStream, int n2, int n3) {
        this(Stream.fromJava(inputStream), n2, n3);
    }

    GifFrameBlock(Stream stream, int n2, int n3) {
        this(stream, n2, n3, false, false, 8);
    }

    public GifFrameBlock(InputStream inputStream, int n2, int n3, boolean bl2, boolean bl3, byte by2) {
        this(Stream.fromJava(inputStream), n2, n3, bl2, bl3, by2);
    }

    GifFrameBlock(Stream stream, int n2, int n3, boolean bl2, boolean bl3, byte by2) {
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        this.a(new bN(stream), n2, n3, bl2, bl3, by2);
    }

    public GifFrameBlock(String string) {
        this(string, 0, 0, false, false, 8);
    }

    public GifFrameBlock(String string, int n2, int n3) {
        this(string, n2, n3, false, false, 8);
    }

    public GifFrameBlock(String string, int n2, int n3, boolean bl2, boolean bl3, byte by2) {
        if (string == null) {
            throw new ArgumentNullException("path");
        }
        this.a(new bN(string), n2, n3, bl2, bl3, by2);
    }

    private GifFrameBlock(a a2, int n2, int n3, int n4, int n5, IColorPalette iColorPalette, boolean bl2, boolean bl3, byte by2) {
        super(iColorPalette);
        this.a(iColorPalette, n2, n3, n4 & 0xFFFF, n5 & 0xFFFF, bl2, bl3, by2);
        if (a2 != null) {
            this.setDataLoader(a2);
            a2.a(this);
        }
    }

    public static IColorPalette getColorPalette(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        IColorPalette iColorPalette3;
        IColorPalette iColorPalette4 = iColorPalette;
        if (iColorPalette4 == null) {
            iColorPalette4 = iColorPalette2;
        }
        if ((iColorPalette3 = iColorPalette4) != null) {
            return iColorPalette3;
        }
        throw new GifImageException("Cannot process GIF frame pixels since palette is not present neither in GIF image nor in GIF frame. Tip: setup color palette first.");
    }

    public static byte createFlags(IColorPalette iColorPalette, boolean bl2, boolean bl3) {
        int n2 = 0;
        if (iColorPalette != null) {
            if (iColorPalette.getEntriesCount() == 1) {
                throw new ArgumentOutOfRangeException("colorPalette", "The color palette must contain entries count equal to the power of 2. Minimal entries count are 2 and maximal 256.");
            }
            int n3 = 0;
            int n4 = iColorPalette.getEntriesCount();
            while (n4 > 2) {
                if ((n4 & 1) == 1) {
                    throw new ArgumentOutOfRangeException("colorPalette", "The color palette must contain entries count equal to the power of 2. Minimal entries count are 2 and maximal 256.");
                }
                n4 >>= 1;
                ++n3;
            }
            n2 |= n3;
            n2 |= 0x80;
        }
        if (bl2) {
            n2 |= 0x20;
        }
        if (bl3) {
            n2 |= 0x40;
        }
        return (byte)n2;
    }

    public static GifFrameBlock a(a a2, int n2, int n3, int n4, int n5, IColorPalette iColorPalette, boolean bl2, boolean bl3, byte by2) {
        return new GifFrameBlock(a2, n2, n3, n4, n5, iColorPalette, bl2, bl3, by2);
    }

    public static void a(StreamContainer streamContainer, Rectangle rectangle, byte by2) {
        streamContainer.writeByte((byte)44);
        com.aspose.imaging.internal.kh.b b2 = new com.aspose.imaging.internal.kh.b(streamContainer);
        b2.a(rectangle.getLeft());
        b2.a(rectangle.getTop());
        b2.a(rectangle.getWidth());
        b2.a(rectangle.getHeight());
        streamContainer.writeByte(by2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(RasterImage rasterImage, StreamContainer streamContainer, Rectangle rectangle, GifOptions gifOptions) {
        Rectangle rectangle2;
        if (gifOptions == null) {
            throw new ArgumentNullException("gifSaveOptions");
        }
        if (gifOptions.getPalette() == null) {
            throw new ArgumentNullException("palette");
        }
        if (gifOptions.getMaxDiff() < 0 || gifOptions.getMaxDiff() > 1000) {
            throw new ArgumentException("GifOptions.MaxDiff must be in range [0, 1000].");
        }
        streamContainer.writeByte((byte)gifOptions.g());
        GifOptions gifOptions2 = gifOptions;
        Rectangle rectangle3 = rectangle;
        StreamContainer streamContainer2 = streamContainer;
        RasterImage rasterImage2 = rasterImage;
        Rectangle rectangle4 = rectangle2 = rectangle3.Clone();
        RasterImage rasterImage3 = rasterImage2;
        Rectangle rectangle5 = rectangle4;
        Rectangle rectangle6 = com.aspose.imaging.internal.cg.a.b(rasterImage3);
        Rectangle rectangle7 = rectangle5.Clone();
        rectangle7.intersect(rectangle6);
        rectangle7.offset(-rectangle6.getX(), -rectangle6.getY());
        Rectangle rectangle8 = rectangle7;
        Rectangle rectangle9 = gifOptions2.h();
        if (rectangle9 != null && !rectangle8.c()) {
            rectangle8.CloneTo(rectangle2);
        }
        com.aspose.imaging.internal.go.a a2 = new com.aspose.imaging.internal.go.a(rasterImage2, streamContainer2, rectangle2, gifOptions2);
        try {
            if (rectangle8.getWidth() > 0 && rectangle8.getHeight() > 0) {
                a a3;
                boolean bl2 = gifOptions2.getInterlaced();
                GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.sv.d.a(rasterImage2, GifFrameBlock.class));
                a a4 = a3 = gifFrameBlock == null ? null : (a)((Object)com.aspose.imaging.internal.sv.d.a(gifFrameBlock.getDataLoader(), a.class));
                if (a3 != null) {
                    bl2 = !gifFrameBlock.getInterlaced() && gifOptions2.getInterlaced();
                    a3.a(!bl2);
                }
                if (bl2) {
                    bz.a(rectangle8, rasterImage2.getWidth(), rasterImage2.getHeight(), a2, rasterImage2);
                } else {
                    bz.a(rectangle8, a2, (b)rasterImage2);
                }
                if (a3 != null) {
                    a3.a(false);
                }
            }
            a2.a(true);
        }
        finally {
            a2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void b(RasterImage rasterImage, StreamContainer streamContainer, Rectangle rectangle, GifOptions gifOptions) {
        Rectangle rectangle2;
        Rectangle rectangle3 = rectangle2 = rectangle.Clone();
        RasterImage rasterImage2 = rasterImage;
        Rectangle rectangle4 = rectangle3;
        Rectangle rectangle5 = com.aspose.imaging.internal.cg.a.b(rasterImage2);
        Rectangle rectangle6 = rectangle4.Clone();
        rectangle6.intersect(rectangle5);
        rectangle6.offset(-rectangle5.getX(), -rectangle5.getY());
        Rectangle rectangle7 = rectangle6;
        Rectangle rectangle8 = gifOptions.h();
        if (rectangle8 != null && !rectangle7.c()) {
            rectangle7.CloneTo(rectangle2);
        }
        com.aspose.imaging.internal.go.a a2 = new com.aspose.imaging.internal.go.a(rasterImage, streamContainer, rectangle2, gifOptions);
        try {
            if (rectangle7.getWidth() > 0 && rectangle7.getHeight() > 0) {
                a a3;
                boolean bl2 = gifOptions.getInterlaced();
                GifFrameBlock gifFrameBlock = (GifFrameBlock)((Object)com.aspose.imaging.internal.sv.d.a(rasterImage, GifFrameBlock.class));
                a a4 = a3 = gifFrameBlock == null ? null : (a)((Object)com.aspose.imaging.internal.sv.d.a(gifFrameBlock.getDataLoader(), a.class));
                if (a3 != null) {
                    bl2 = !gifFrameBlock.getInterlaced() && gifOptions.getInterlaced();
                    a3.a(!bl2);
                }
                if (bl2) {
                    bz.a(rectangle7, rasterImage.getWidth(), rasterImage.getHeight(), a2, rasterImage);
                } else {
                    bz.a(rectangle7, a2, (b)rasterImage);
                }
                if (a3 != null) {
                    a3.a(false);
                }
            }
            a2.a(true);
        }
        finally {
            a2.dispose();
        }
    }

    @Override
    public void a(i i2, boolean bl2) {
        if (this.getContainer() != null) {
            throw new NotSupportedException("Setting a memory manager for an image-related frame is not allowed.");
        }
        super.a(i2, bl2);
    }

    @Override
    public long getFileFormat() {
        return 4L;
    }

    @Override
    public int getWidth() {
        return this.l;
    }

    @Override
    public int getHeight() {
        return this.m;
    }

    @Override
    public int getBitsPerPixel() {
        this.verifyNotDisposed();
        return this.k & 0xFF;
    }

    @Override
    public int getFrameTime() {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock == null) {
            return 10;
        }
        return (gifGraphicsControlBlock.getDelayTime() & 0xFFFF) * 10;
    }

    public void setFrameTime(int n2) {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock != null) {
            gifGraphicsControlBlock.setDelayTime(n2 / 10 & 0xFFFF);
        }
    }

    public boolean getInterlaced() {
        this.verifyNotDisposed();
        return (this.p & 0xFF & 0x40) != 0;
    }

    @Override
    public boolean isInterlaced() {
        return this.getInterlaced();
    }

    public void setInterlaced(boolean bl2) {
        this.verifyNotDisposed();
        byte by2 = this.p;
        by2 = bl2 ? (byte)(by2 & 0xFF | 0x40) : (byte)(by2 & 0xFF & 0xBF);
        this.p = by2;
    }

    public boolean isPaletteSorted() {
        this.verifyNotDisposed();
        return (this.p & 0xFF & 0x20) != 0;
    }

    public void setPaletteSorted(boolean bl2) {
        this.verifyNotDisposed();
        byte by2 = this.p;
        by2 = bl2 ? (byte)(by2 & 0xFF | 0x20) : (byte)(by2 & 0xFF & 0xDF);
        this.p = by2;
    }

    public byte getGifFrameBitsPerPixel() {
        this.verifyNotDisposed();
        return this.k;
    }

    public void setGifFrameBitsPerPixel(byte by2) {
        this.verifyNotDisposed();
        if ((by2 & 0xFF) < 2 || (by2 & 0xFF) > 8) {
            throw new ArgumentOutOfRangeException(j, aV.a(new String[]{"GifFrameBitsPerPixel is out of range [1, 4, 8] :", w.b(by2)}));
        }
        this.k = by2;
    }

    public int getLeft() {
        return this.n;
    }

    public void setLeft(int n2) {
        this.n = n2;
    }

    public int getTop() {
        return this.o;
    }

    public void setTop(int n2) {
        this.o = n2;
    }

    @Override
    public int getFrameTop() {
        return this.o & 0xFFFF;
    }

    @Override
    public int getFrameLeft() {
        return this.n & 0xFFFF;
    }

    public Rectangle t() {
        Rectangle rectangle = this.t;
        if (rectangle == null) {
            Image image = this.getContainer();
            Rectangle rectangle2 = rectangle = image != null ? com.aspose.imaging.internal.cg.a.a(image) : null;
        }
        if (rectangle == null) {
            rectangle = com.aspose.imaging.internal.cg.a.a(this);
        }
        return rectangle;
    }

    public void d(Rectangle rectangle) {
        this.t = rectangle != null ? rectangle.Clone() : null;
    }

    public Rectangle A() {
        return new Rectangle(this.n & 0xFFFF, this.o & 0xFFFF, this.l, this.m);
    }

    public void e(Rectangle rectangle) {
        this.n = rectangle.getLeft() & 0xFFFF;
        this.o = rectangle.getTop() & 0xFFFF;
        this.l = rectangle.getWidth() & 0xFFFF;
        this.m = rectangle.getHeight() & 0xFFFF;
    }

    @Override
    public int getDisposalMethod() {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock == null) {
            return 1;
        }
        switch (gifGraphicsControlBlock.getDisposalMethod()) {
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    public byte getFlags() {
        this.verifyNotDisposed();
        return this.p;
    }

    public void setFlags(byte by2) {
        this.verifyNotDisposed();
        if ((this.p & 0xFF) != (by2 & 0xFF)) {
            if ((by2 & 0x80) > 0 && this.getPalette() == null) {
                throw new ArgumentOutOfRangeException(j, "The flags are incorrect since palette is not present but flags indicate it is.");
            }
            if ((by2 & 0x80) == 0 && this.getPalette() != null) {
                throw new ArgumentOutOfRangeException(j, "The flags are incorrect since palette is present but flags indicate it is not.");
            }
            if (this.getPalette() != null && this.getPalette().getEntriesCount() != 2 << (by2 & 7)) {
                throw new ArgumentOutOfRangeException(j, "The flags are incorrect since palette entries count do not correspond to flags entries count.");
            }
            this.p = by2;
        }
    }

    @Override
    public boolean isUseAlphaBlending() {
        return this.hasAlpha() || this.hasTransparentColor();
    }

    public GifGraphicsControlBlock getControlBlock() {
        GifImage gifImage;
        int n2;
        GifGraphicsControlBlock gifGraphicsControlBlock = this.q;
        if (gifGraphicsControlBlock == null && com.aspose.imaging.internal.sv.d.b((Object)this.getContainer(), GifImage.class) && (n2 = (gifImage = (GifImage)this.getContainer()).a(this)) > 0) {
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                IGifBlock iGifBlock = gifImage.e(i2);
                if (!com.aspose.imaging.internal.sv.d.b((Object)iGifBlock, GifGraphicsControlBlock.class) && !com.aspose.imaging.internal.sv.d.b((Object)iGifBlock, GifFrameBlock.class)) continue;
                gifGraphicsControlBlock = (GifGraphicsControlBlock)((Object)com.aspose.imaging.internal.sv.d.a(iGifBlock, GifGraphicsControlBlock.class));
                break;
            }
        }
        return gifGraphicsControlBlock;
    }

    @Override
    public boolean hasTransparentColor() {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        return gifGraphicsControlBlock != null && gifGraphicsControlBlock.hasTransparentColor();
    }

    @Override
    public Color getTransparentColor() {
        IColorPalette iColorPalette;
        int n2;
        Color color = Color.getEmpty();
        Integer n3 = this.B();
        if (n3 != null && (n2 = n3.intValue()) < (iColorPalette = this.D()).getEntriesCount()) {
            iColorPalette.getColor(n2).CloneTo(color);
        }
        return color;
    }

    @Override
    public void setTransparentColor(boolean bl2) {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock != null) {
            gifGraphicsControlBlock.setTransparentColor(bl2);
        } else if (this.getContainer() instanceof GifImage) {
            GifImage gifImage = (GifImage)this.getContainer();
            int n2 = gifImage.a(this);
            if (n2 >= 0) {
                this.q = new GifGraphicsControlBlock();
                this.q.setTransparentColor(bl2);
                gifImage.a(n2, this.q);
            }
        } else {
            throw new FrameworkException("The block does not belong to any image so transparent color can not be set.");
        }
    }

    @Override
    public void setTransparentColor(Color color) {
        IColorPalette iColorPalette = this.D();
        int n2 = color.toArgb();
        this.a(n2, iColorPalette);
    }

    public Integer B() {
        Integer n2 = null;
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock != null && gifGraphicsControlBlock.hasTransparentColor()) {
            n2 = gifGraphicsControlBlock.getTransparentColorIndex() & 0xFF;
        }
        return n2;
    }

    public IColorPalette C() {
        Image image = this.getContainer();
        return image != null ? image.getPalette() : null;
    }

    @Override
    public i h() {
        Image image = this.getContainer();
        return image != null ? image.h() : super.h();
    }

    @Override
    public Color getBackgroundColor() {
        Color color;
        Image image = this.getContainer();
        Color color2 = color = image != null ? image.getBackgroundColor() : null;
        if (color == null) {
            color = Color.getEmpty();
        }
        return color;
    }

    @Override
    public void setBackgroundColor(Color color) {
        if (com.aspose.imaging.internal.sv.d.b((Object)this.getContainer(), GifImage.class)) {
            GifImage gifImage = (GifImage)this.getContainer();
            gifImage.setBackgroundColor(color);
        }
    }

    @Override
    public IHasMetadata j() {
        GifOptions gifOptions;
        Image image = this.getContainer();
        GifOptions gifOptions2 = gifOptions = image instanceof GifImage ? ((GifImage)image).C() : null;
        if (gifOptions == null) {
            gifOptions = (GifOptions)super.j();
        }
        return gifOptions;
    }

    @Override
    public ImageOptionsBase getOriginalOptions() {
        if (this.getContainer() != null) {
            GifImage gifImage = (GifImage)this.getContainer();
            return gifImage.C();
        }
        return null;
    }

    @Override
    public void adjustBrightness(int n2) {
        if (this.getPalette() != null) {
            int[] nArray = this.getPalette().getArgb32Entries();
            com.aspose.imaging.internal.gF.o.a(nArray, n2);
            this.setPalette(new ColorPalette(nArray));
        }
    }

    @Override
    public void replaceColor(int n2, byte by2, int n3) {
        Image image = this.getContainer();
        L l2 = new L(n2, by2, n3, this, !((GifImage)((Object)com.aspose.imaging.internal.sv.d.a(image, GifImage.class))).hasTransparentColor());
        bz.a(this.getBounds(), l2, (b)image);
    }

    @Override
    public void replaceNonTransparentColors(int n2) {
        bk bk2 = new bk(n2, this, !((GifImage)((Object)com.aspose.imaging.internal.sv.d.a(this.getContainer(), GifImage.class))).hasTransparentColor());
        bz.a(this.getBounds(), (aD)bk2);
    }

    @Override
    public RasterImage getFullFrame() {
        GifFrameBlock gifFrameBlock = this.f(true);
        gifFrameBlock.q = new GifGraphicsControlBlock();
        gifFrameBlock.q.setFlags(GifGraphicsControlBlock.createFlags(false, false, 0));
        gifFrameBlock.q.setTransparentColor(false);
        gifFrameBlock.setFrameTime(this.getFrameTime());
        return gifFrameBlock;
    }

    @Override
    public IColorPalette u() {
        Image image = this.getContainer();
        return image != null ? image.getPalette() : this.getPalette();
    }

    @Override
    public boolean a(IColorPalette iColorPalette) {
        boolean bl2;
        boolean bl3 = bl2 = this.getContainer() != null;
        if (bl2) {
            this.getContainer().setPalette(iColorPalette);
        }
        return bl2;
    }

    public void a(int n2, Size size) {
        int n3;
        int n4;
        switch (n2) {
            case 2: 
            case 12: {
                n4 = size.getWidth() - this.l - (this.n & 0xFFFF);
                n3 = size.getHeight() - this.m - (this.o & 0xFFFF);
                break;
            }
            case 6: 
            case 8: {
                n4 = this.n & 0xFFFF;
                n3 = size.getHeight() - this.m - (this.o & 0xFFFF);
                break;
            }
            case 4: 
            case 10: {
                n4 = size.getWidth() - this.l - (this.n & 0xFFFF);
                n3 = this.o & 0xFFFF;
                break;
            }
            case 3: 
            case 13: {
                n4 = this.o & 0xFFFF;
                n3 = size.getWidth() - this.l - (this.n & 0xFFFF);
                break;
            }
            case 7: 
            case 9: {
                n4 = size.getHeight() - this.m - (this.o & 0xFFFF);
                n3 = size.getWidth() - this.l - (this.n & 0xFFFF);
                break;
            }
            case 1: 
            case 15: {
                n4 = size.getHeight() - this.m - (this.o & 0xFFFF);
                n3 = this.n & 0xFFFF;
                break;
            }
            case 5: 
            case 11: {
                n4 = this.o & 0xFFFF;
                n3 = this.n & 0xFFFF;
                break;
            }
            default: {
                return;
            }
        }
        this.n = n4 & 0xFFFF;
        this.o = n3 & 0xFFFF;
    }

    public IColorPalette D() {
        return GifFrameBlock.getColorPalette(this.getPalette(), this.C());
    }

    @Override
    public void b(Stream stream) {
    }

    @Override
    protected void saveData(Stream stream) {
        this.verifyNotDisposed();
        try (StreamContainer streamContainer = new StreamContainer(stream);){
            Rectangle rectangle = this.A();
            GifFrameBlock gifFrameBlock = this;
            Rectangle rectangle2 = rectangle.Clone();
            Rectangle rectangle3 = gifFrameBlock.u;
            if (rectangle3 != null) {
                rectangle2.intersect(rectangle3);
            }
            Rectangle rectangle4 = rectangle2;
            GifFrameBlock.a(streamContainer, rectangle4, this.p);
            IColorPalette iColorPalette = this.getPalette();
            if (iColorPalette != null) {
                com.aspose.imaging.internal.gm.c.a(streamContainer, iColorPalette);
            }
            GifOptions gifOptions = new GifOptions();
            gifOptions.setInterlaced(this.getInterlaced());
            gifOptions.setMaxDiff(0);
            gifOptions.a(this.getBitsPerPixel());
            gifOptions.setPalette(this.D());
            gifOptions.a(this.t());
            GifFrameBlock.a(this, streamContainer, rectangle4, gifOptions);
        }
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
        this.l = n2;
        this.m = n3;
    }

    @Override
    protected void onPaletteChanging(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        if (this.hasTransparentColor()) {
            int n2 = this.getTransparentColor().toArgb();
            IColorPalette iColorPalette3 = iColorPalette2;
            if (iColorPalette3 == null) {
                iColorPalette3 = this.D();
            }
            this.a(n2, iColorPalette3);
        }
        super.onPaletteChanging(iColorPalette, iColorPalette2);
    }

    @Override
    protected void onPaletteChanged(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        this.p = GifFrameBlock.createFlags(iColorPalette2, (this.p & 0x20) > 0, (this.p & 0x40) > 0);
        if (this.n()) {
            IColorPalette iColorPalette3 = iColorPalette2;
            if (iColorPalette3 == null) {
                iColorPalette3 = this.D();
            }
            this.setGifFrameBitsPerPixel((byte)com.aspose.imaging.internal.lc.c.a(iColorPalette3));
        }
        super.onPaletteChanged(iColorPalette, iColorPalette2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a(int n2, IColorPalette iColorPalette) {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock == null) {
            if (!(this.getContainer() instanceof GifImage)) throw new FrameworkException("The block does not belong to any image so transparent color could not be set.");
            GifImage gifImage = (GifImage)this.getContainer();
            int n3 = gifImage.a(this);
            if (n3 < 0) return;
            GifGraphicsControlBlock gifGraphicsControlBlock2 = new GifGraphicsControlBlock();
            gifGraphicsControlBlock2.setTransparentColorIndex((byte)iColorPalette.getNearestColorIndex(n2));
            gifGraphicsControlBlock2.setTransparentColor(true);
            gifImage.a(n3, gifGraphicsControlBlock2);
            return;
        } else {
            gifGraphicsControlBlock.setTransparentColorIndex((byte)iColorPalette.getNearestColorIndex(n2));
            gifGraphicsControlBlock.setTransparentColor(true);
        }
    }

    private void a(IColorPalette iColorPalette, int n2, int n3, int n4, int n5, boolean bl2, boolean bl3, byte by2) {
        this.p = GifFrameBlock.createFlags(iColorPalette, bl2, bl3);
        this.n = n2;
        this.o = n3;
        this.k = (by2 & 0xFF) > 8 ? (byte)8 : ((by2 & 0xFF) < 2 ? (byte)2 : by2);
        this.l = n4;
        this.m = n5;
    }

    private void E() {
        Image image = this.getContainer();
        if (!(image instanceof GifImage)) {
            return;
        }
        GifImage gifImage = (GifImage)image;
        Image[] imageArray = gifImage.getPages();
        if (imageArray == null) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        for (Image image2 : imageArray) {
            GifGraphicsControlBlock gifGraphicsControlBlock;
            GifFrameBlock gifFrameBlock = (GifFrameBlock)image2;
            if (n3 > 0 && (gifGraphicsControlBlock = gifFrameBlock.getControlBlock()) != null) {
                switch (gifGraphicsControlBlock.getDisposalMethod()) {
                    case 0: 
                    case 2: {
                        n2 = n3;
                        break;
                    }
                    case 3: {
                        n2 = bE.d(0, n3 - 2);
                        break;
                    }
                }
            }
            gifFrameBlock.r = n2;
            gifFrameBlock.s = n3++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GifFrameBlock f(boolean bl2) {
        GifFrameBlock gifFrameBlock;
        GifImage gifImage;
        GifImage gifImage2;
        Image[] imageArray;
        GifFrameBlock gifFrameBlock2;
        Image image;
        if (bl2 && (image = (gifFrameBlock2 = this).getContainer()) instanceof GifImage && (imageArray = (gifImage2 = (GifImage)image).getPages()) != null) {
            int n2 = 0;
            int n3 = 0;
            for (Image image2 : imageArray) {
                GifGraphicsControlBlock gifGraphicsControlBlock;
                GifFrameBlock gifFrameBlock3 = (GifFrameBlock)image2;
                if (n3 > 0 && (gifGraphicsControlBlock = gifFrameBlock3.getControlBlock()) != null) {
                    switch (gifGraphicsControlBlock.getDisposalMethod()) {
                        case 0: 
                        case 2: {
                            n2 = n3;
                            break;
                        }
                        case 3: {
                            n2 = bE.d(0, n3 - 2);
                            break;
                        }
                    }
                }
                gifFrameBlock3.r = n2;
                gifFrameBlock3.s = n3++;
            }
        }
        if ((gifImage = (GifImage)this.getContainer()) == null || gifImage.getPageCount() < 2) {
            return this;
        }
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock != null && gifGraphicsControlBlock.getDisposalMethod() == 2) {
            gifFrameBlock = new GifFrameBlock(0, 0, gifImage.getWidth() & 0xFFFF, gifImage.getHeight() & 0xFFFF);
            boolean bl3 = true;
            try {
                int[] nArray = new int[gifFrameBlock.l];
                int n4 = this.getBackgroundColor().toArgb();
                if (n4 != 0) {
                    Arrays.fill(nArray, n4);
                    for (int i2 = 0; i2 < gifFrameBlock.m; ++i2) {
                        gifFrameBlock.saveArgb32Pixels(new Rectangle(0, i2, gifFrameBlock.l, 1), nArray);
                    }
                }
                bl3 = false;
            }
            finally {
                if (bl3) {
                    gifFrameBlock.close();
                }
            }
        } else {
            gifFrameBlock = this.r == this.s ? new GifFrameBlock(0, 0, gifImage.getWidth() & 0xFFFF, gifImage.getHeight() & 0xFFFF) : ((GifFrameBlock)gifImage.getPages()[this.s - 1]).f(false);
        }
        gifFrameBlock.a(this.k());
        gifFrameBlock.a(gifImage);
        gifFrameBlock.q = this.getControlBlock();
        Point point = new Point(this.n & 0xFFFF, this.o & 0xFFFF);
        gifFrameBlock.blend(point, this, this.getBounds(), (byte)-1);
        return gifFrameBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(bN bN2, int n2, int n3, boolean bl2, boolean bl3, byte by2) {
        boolean bl4 = true;
        try {
            RasterImage rasterImage = bN2.a();
            this.a(rasterImage.getPalette(), n2, n3, rasterImage.getWidth(), rasterImage.getHeight(), bl2, bl3, by2);
            this.setPalette(rasterImage.getPalette());
            this.setDataLoader(bN2);
            bl4 = false;
        }
        finally {
            if (bl4) {
                bN2.dispose();
            }
        }
    }

    @Override
    public void a(IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader, Size size) {
        this.u = null;
        super.a(iRasterImageArgb32PixelLoader, size);
    }

    @Override
    public void resize(int n2, int n3, ImageResizeSettings imageResizeSettings) {
        Rectangle rectangle = this.A();
        com.aspose.imaging.internal.gm.d.a(this);
        Rectangle rectangle2 = this.A();
        double d2 = (double)n2 / (double)rectangle2.getWidth();
        double d3 = (double)n3 / (double)rectangle2.getHeight();
        super.resize(n2, n3, imageResizeSettings);
        if (!com.aspose.imaging.internal.br.m.a(this)) {
            double d4 = d3;
            double d5 = d2;
            Rectangle rectangle3 = new Rectangle(0, 0, n2, n3);
            Rectangle rectangle4 = rectangle;
            Rectangle rectangle5 = rectangle4.Clone();
            rectangle5.inflate(com.aspose.imaging.internal.sv.d.e((double)rectangle5.getWidth() * 0.075), com.aspose.imaging.internal.sv.d.e((double)rectangle5.getHeight() * 0.075));
            int n4 = com.aspose.imaging.internal.sv.d.e((double)rectangle5.getX() * d5 + 0.5);
            int n5 = com.aspose.imaging.internal.sv.d.e((double)rectangle5.getY() * d4 + 0.5);
            int n6 = com.aspose.imaging.internal.sv.d.e((double)rectangle5.getWidth() * d5 + 0.5);
            int n7 = com.aspose.imaging.internal.sv.d.e((double)rectangle5.getHeight() * d4 + 0.5);
            Rectangle rectangle6 = new Rectangle(n4, n5, n6, n7);
            rectangle6.intersect(rectangle3);
            this.u = rectangle6;
        }
    }

    private Rectangle f(Rectangle rectangle) {
        Rectangle rectangle2 = rectangle.Clone();
        Rectangle rectangle3 = this.u;
        if (rectangle3 != null) {
            rectangle2.intersect(rectangle3);
        }
        return rectangle2;
    }
}

