/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.tiff.tifftagtypes;

import com.aspose.imaging.fileformats.tiff.TiffDataType;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamReader;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamWriter;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffCommonArrayType;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.aI.b;
import com.aspose.imaging.internal.ns.g;

public final class TiffFloatType
extends TiffCommonArrayType {
    private float[] a;

    public TiffFloatType(int n2) {
        super(n2);
    }

    public float[] getValues() {
        return this.a;
    }

    public void setValues(float[] fArray) {
        this.a = fArray;
    }

    @Override
    public byte getElementSize() {
        return 4;
    }

    @Override
    public g getValuesContainer() {
        return g.a((Object)this.a);
    }

    @Override
    public int getTagType() {
        return 11;
    }

    @Override
    public Object getValue() {
        return this.a;
    }

    @Override
    public void setValue(Object object) {
        if (object != null && !(object instanceof float[])) {
            throw new ArgumentException("Only float array is supported.");
        }
        this.a = (float[])object;
    }

    @Override
    public long writeAdditionalData(TiffStreamWriter tiffStreamWriter) {
        if (tiffStreamWriter == null) {
            throw new ArgumentNullException("dataStream");
        }
        byte by2 = new b(tiffStreamWriter).c();
        long l2 = this.getDataSize();
        float[] fArray = this.getValues();
        if (l2 > (long)(by2 & 0xFF)) {
            if (fArray == null || fArray.length < 1) {
                fArray = new float[]{0.0f};
            }
            tiffStreamWriter.writeFloatArray(fArray);
            return this.getDataSize();
        }
        return 0L;
    }

    @Override
    protected void readData(TiffStreamReader tiffStreamReader, long l2, long l3) {
        long l4 = l3;
        long l5 = this.getElementSize();
        long l6 = l4 * l5;
        if (l6 == (long)(new b(tiffStreamReader).c() & 0xFF)) {
            this.a = tiffStreamReader.readFloatArray(l2, l3);
        } else {
            long l7 = tiffStreamReader.a(l2);
            if (l7 + l6 <= tiffStreamReader.getLength()) {
                this.a = tiffStreamReader.readFloatArray(l7, l3);
            }
        }
    }

    @Override
    protected TiffDataType createInstance() {
        return new TiffFloatType(this.getTagId());
    }

    @Override
    protected void copyInstanceData(TiffDataType tiffDataType) {
        TiffFloatType tiffFloatType = (TiffFloatType)tiffDataType;
        float[] fArray = this.a;
        float[] fArray2 = null;
        if (fArray != null) {
            fArray2 = new float[fArray.length];
            System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        }
        tiffFloatType.a = fArray2;
        super.copyInstanceData(tiffDataType);
    }

    @Override
    protected void writeTagValue(TiffStreamWriter tiffStreamWriter) {
        tiffStreamWriter.writeFloatArray(this.a);
        TiffFloatType.a(tiffStreamWriter, this.getDataSize());
    }
}

