/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.imagefilters.complexutils;

import com.aspose.imaging.internal.Exceptions.DivideByZeroException;
import com.aspose.imaging.internal.Exceptions.FormatException;
import com.aspose.imaging.internal.ns.aV;
import com.aspose.imaging.internal.ns.aa;
import com.aspose.imaging.internal.ns.aq;
import com.aspose.imaging.internal.ns.bE;
import com.aspose.imaging.internal.sv.i;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Complex
extends i<Complex>
implements aq<Complex> {
    public static final int SIZE_OF_DOUBLE = 8;
    public static final int SIZE_OF_COMPLEX = 16;
    public static final Complex ZERO = new Complex(0.0, 0.0);
    public static final Complex ONE = new Complex(1.0, 0.0);
    public static final Complex I = new Complex(0.0, 1.0);
    private static final String a = "Can not divide by zero.";
    private double b;
    private double c;

    public Complex() {
    }

    public Complex(double d2, double d3) {
        this.b = d2;
        this.c = d3;
    }

    public Complex(Complex complex) {
        this.b = complex.b;
        this.c = complex.c;
    }

    public static Complex to_Complex(double d2) {
        return new Complex(d2, 0.0);
    }

    public static Complex to_Complex(float f2) {
        return new Complex(f2, 0.0);
    }

    public static boolean op_Equality(Complex complex, Complex complex2) {
        return complex.b == complex2.b && complex.c == complex2.c;
    }

    public static boolean op_Inequality(Complex complex, Complex complex2) {
        return !Complex.op_Equality(complex, complex2);
    }

    public static Complex op_UnaryNegation(Complex complex) {
        return Complex.negate(complex);
    }

    public static Complex op_Addition(Complex complex, Complex complex2) {
        return Complex.add(complex, complex2);
    }

    public static Complex op_Addition(Complex complex, double d2) {
        return Complex.add(complex, d2);
    }

    public static Complex op_Addition(double d2, Complex complex) {
        return Complex.add(complex, d2);
    }

    public static Complex op_Subtraction(Complex complex, Complex complex2) {
        return Complex.subtract(complex, complex2);
    }

    public static Complex op_Subtraction(Complex complex, double d2) {
        return Complex.subtract(complex, d2);
    }

    public static Complex op_Subtraction(double d2, Complex complex) {
        return Complex.subtract(d2, complex);
    }

    public static Complex op_Multiply(Complex complex, Complex complex2) {
        return Complex.multiply(complex, complex2);
    }

    public static Complex op_Multiply(double d2, Complex complex) {
        return Complex.multiply(complex, d2);
    }

    public static Complex op_Multiply(Complex complex, double d2) {
        return Complex.multiply(complex, d2);
    }

    public static Complex op_Division(Complex complex, Complex complex2) {
        return Complex.divide(complex, complex2);
    }

    public static Complex op_Division(Complex complex, double d2) {
        return Complex.divide(complex, d2);
    }

    public static Complex op_Division(double d2, Complex complex) {
        return Complex.divide(d2, complex);
    }

    public static Complex add(Complex complex, Complex complex2) {
        return new Complex(complex.b + complex2.b, complex.c + complex2.c);
    }

    public static Complex add(Complex complex, double d2) {
        return new Complex(complex.b + d2, complex.c);
    }

    public static void add(Complex complex, Complex complex2, Complex[] complexArray) {
        complexArray[0].b = complex.b + complex2.b;
        complexArray[0].c = complex.c + complex2.c;
    }

    public static void add(Complex complex, double d2, Complex[] complexArray) {
        complexArray[0].b = complex.b + d2;
        complexArray[0].c = complex.c;
    }

    public static Complex subtract(Complex complex, Complex complex2) {
        return new Complex(complex.b - complex2.b, complex.c - complex2.c);
    }

    public static Complex subtract(Complex complex, double d2) {
        return new Complex(complex.b - d2, complex.c);
    }

    public static Complex subtract(double d2, Complex complex) {
        return new Complex(d2 - complex.b, complex.c);
    }

    public static void subtract(Complex complex, Complex complex2, Complex[] complexArray) {
        complexArray[0].b = complex.b - complex2.b;
        complexArray[0].c = complex.c - complex2.c;
    }

    public static void subtract(Complex complex, double d2, Complex[] complexArray) {
        complexArray[0].b = complex.b - d2;
        complexArray[0].c = complex.c;
    }

    public static void subtract(double d2, Complex complex, Complex[] complexArray) {
        complexArray[0].b = d2 - complex.b;
        complexArray[0].c = complex.c;
    }

    public static Complex multiply(Complex complex, Complex complex2) {
        double d2 = complex.b;
        double d3 = complex.c;
        double d4 = complex2.b;
        double d5 = complex2.c;
        return new Complex(d2 * d4 - d3 * d5, d2 * d5 + d3 * d4);
    }

    public static Complex multiply(Complex complex, double d2) {
        return new Complex(complex.b * d2, complex.c * d2);
    }

    public static void multiply(Complex complex, Complex complex2, Complex[] complexArray) {
        double d2 = complex.b;
        double d3 = complex.c;
        double d4 = complex2.b;
        double d5 = complex2.c;
        complexArray[0].b = d2 * d4 - d3 * d5;
        complexArray[0].c = d2 * d5 + d3 * d4;
    }

    public static void multiply(Complex complex, double d2, Complex[] complexArray) {
        complexArray[0].b = complex.b * d2;
        complexArray[0].c = complex.c * d2;
    }

    public static Complex divide(Complex complex, Complex complex2) {
        double d2 = complex.b;
        double d3 = complex.c;
        double d4 = complex2.b;
        double d5 = complex2.c;
        double d6 = d4 * d4 + d5 * d5;
        if (d6 == 0.0) {
            throw new DivideByZeroException(a);
        }
        double d7 = 1.0 / d6;
        return new Complex((d2 * d4 + d3 * d5) * d7, (d3 * d4 - d2 * d5) * d7);
    }

    public static Complex divide(Complex complex, double d2) {
        if (d2 == 0.0) {
            throw new DivideByZeroException(a);
        }
        return new Complex(complex.b / d2, complex.c / d2);
    }

    public static Complex divide(double d2, Complex complex) {
        if (complex.b == 0.0 || complex.c == 0.0) {
            throw new DivideByZeroException(a);
        }
        return new Complex(d2 / complex.b, d2 / complex.c);
    }

    public static void divide(Complex complex, Complex complex2, Complex[] complexArray) {
        double d2 = complex.b;
        double d3 = complex.c;
        double d4 = complex2.b;
        double d5 = complex2.c;
        double d6 = d4 * d4 + d5 * d5;
        if (d6 == 0.0) {
            throw new DivideByZeroException(a);
        }
        double d7 = 1.0 / d6;
        complexArray[0].b = (d2 * d4 + d3 * d5) * d7;
        complexArray[0].c = (d3 * d4 - d2 * d5) * d7;
    }

    public static void divide(Complex complex, double d2, Complex[] complexArray) {
        if (d2 == 0.0) {
            throw new DivideByZeroException(a);
        }
        complexArray[0].b = complex.b / d2;
        complexArray[0].c = complex.c / d2;
    }

    public static void divide(double d2, Complex complex, Complex[] complexArray) {
        if (complex.b == 0.0 || complex.c == 0.0) {
            throw new DivideByZeroException(a);
        }
        complexArray[0].b = d2 / complex.b;
        complexArray[0].c = d2 / complex.c;
    }

    public static Complex negate(Complex complex) {
        return new Complex(-complex.b, -complex.c);
    }

    public static boolean approxEqual(Complex complex, Complex complex2) {
        return Complex.approxEqual(complex, complex2, 8.881784197001252E-16);
    }

    public static boolean approxEqual(Complex complex, Complex complex2, double d2) {
        return bE.a(complex.b - complex2.b) <= d2 && bE.a(complex.c - complex2.c) <= d2;
    }

    public static Complex parse(String string) {
        Matcher matcher = Pattern.compile("\\((?<real>.*),(?<imaginary>.*)\\)", 32).matcher(string);
        if (!matcher.find()) {
            throw new FormatException("String representation of the complex number is not correctly formatted.");
        }
        return new Complex(Double.parseDouble(matcher.replaceFirst("${real}")), Double.parseDouble(matcher.replaceFirst("${imaginary}")));
    }

    public static boolean tryParse(String string, Complex[] complexArray) {
        try {
            Complex complex;
            complexArray[0] = complex = Complex.parse(string);
            return true;
        }
        catch (FormatException formatException) {
            complexArray[0] = new Complex();
            return false;
        }
    }

    public static Complex sqrt(Complex complex) {
        Complex complex2 = ZERO.Clone();
        if (complex.b != 0.0 || complex.c != 0.0) {
            if (complex.c == 0.0) {
                double d2;
                if (complex.b > 0.0) {
                    double d3 = complex.b;
                    d2 = Math.sqrt(d3);
                } else {
                    double d4 = -complex.b;
                    d2 = Math.sqrt(d4);
                }
                complex2.b = d2;
                complex2.c = 0.0;
                return complex2;
            }
            double d5 = complex.getMagnitude();
            double d6 = 0.5 * (d5 + complex.b);
            complex2.b = Math.sqrt(d6);
            d6 = 0.5 * (d5 - complex.b);
            complex2.c = Math.sqrt(d6);
            if (complex.c < 0.0) {
                complex2.c = -complex2.c;
            }
        }
        return complex2;
    }

    public static Complex log(Complex complex) {
        Complex complex2 = ZERO.Clone();
        if (complex.b > 0.0 && complex.c == 0.0) {
            double d2 = complex.b;
            complex2.b = Math.log(d2);
            complex2.c = 0.0;
            return complex2;
        }
        if (complex.b == 0.0) {
            if (complex.c > 0.0) {
                double d3 = complex.c;
                complex2.b = Math.log(d3);
                complex2.c = 1.5707963267948966;
                return complex2;
            }
            double d4 = -complex.c;
            complex2.b = Math.log(d4);
            complex2.c = -1.5707963267948966;
            return complex2;
        }
        double d5 = complex.getMagnitude();
        complex2.b = Math.log(d5);
        double d6 = complex.b;
        d5 = complex.c;
        complex2.c = Math.atan2(d5, d6);
        return complex2;
    }

    public static Complex exp(Complex complex) {
        Complex complex2 = ZERO.Clone();
        double d2 = complex.b;
        double d3 = Math.exp(d2);
        d2 = complex.c;
        complex2.b = d3 * Math.cos(d2);
        d2 = complex.c;
        complex2.c = d3 * Math.sin(d2);
        return complex2;
    }

    public static Complex sin(Complex complex) {
        Complex complex2 = ZERO.Clone();
        if (complex.c == 0.0) {
            double d2 = complex.b;
            complex2.b = Math.sin(d2);
            complex2.c = 0.0;
            return complex2;
        }
        double d3 = complex.b;
        double d4 = Math.sin(d3);
        d3 = complex.c;
        complex2.b = d4 * Math.cosh(d3);
        d3 = complex.b;
        double d5 = Math.cos(d3);
        d3 = complex.c;
        complex2.c = d5 * Math.sinh(d3);
        return complex2;
    }

    public static Complex cos(Complex complex) {
        Complex complex2 = ZERO.Clone();
        if (complex.c == 0.0) {
            double d2 = complex.b;
            complex2.b = Math.cos(d2);
            complex2.c = 0.0;
            return complex2;
        }
        double d3 = complex.b;
        double d4 = Math.cos(d3);
        d3 = complex.c;
        complex2.b = d4 * Math.cosh(d3);
        d3 = complex.b;
        double d5 = -Math.sin(d3);
        d3 = complex.c;
        complex2.c = d5 * Math.sinh(d3);
        return complex2;
    }

    public static Complex tan(Complex complex) {
        Complex complex2 = ZERO.Clone();
        if (complex.c == 0.0) {
            double d2 = complex.b;
            complex2.b = Math.tan(d2);
            complex2.c = 0.0;
            return complex2;
        }
        double d3 = 2.0 * complex.b;
        double d4 = 2.0 * complex.c;
        double d5 = d3;
        double d6 = Math.cos(d5);
        d5 = d3;
        double d7 = d6 + Math.cosh(d5);
        d5 = d3;
        complex2.b = Math.sin(d5) / d7;
        d5 = d4;
        complex2.c = Math.sinh(d5) / d7;
        return complex2;
    }

    public static boolean isEquals(Complex complex, Complex complex2) {
        return complex.equals(complex2);
    }

    public Complex multiply_internalize(double d2) {
        this.b *= d2;
        this.c *= d2;
        return this;
    }

    public final double getRe() {
        return this.b;
    }

    public final void setRe(double d2) {
        this.b = d2;
    }

    public final double getIm() {
        return this.c;
    }

    public final void setIm(double d2) {
        this.c = d2;
    }

    public final Complex set(double d2, double d3) {
        this.b = d2;
        this.c = d3;
        return this;
    }

    public final double getMagnitude() {
        double d2 = this.b * this.b + this.c * this.c;
        return Math.sqrt(d2);
    }

    public final double getPhase() {
        double d2 = this.b;
        double d3 = this.c;
        return Math.atan2(d3, d2);
    }

    public final double getSquaredMagnitude() {
        return this.b * this.b + this.c * this.c;
    }

    public int hashCode() {
        return aa.a(this.b) ^ aa.a(this.c);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Complex)) {
            return false;
        }
        Complex complex = (Complex)object;
        return this.b == complex.b && this.c == complex.c;
    }

    public String toString() {
        return aV.a("({0}, {1})", this.b, this.c);
    }

    public final Complex deepClone() {
        return new Complex(this);
    }

    @Override
    public void CloneTo(Complex complex) {
        complex.b = this.b;
        complex.c = this.c;
    }

    @Override
    public Complex Clone() {
        Complex complex = new Complex();
        this.CloneTo(complex);
        return complex;
    }
}

