/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.imageoptions;

import com.aspose.imaging.ColorPaletteHelper;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IHasMetadata;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.PixelDataFormat;
import com.aspose.imaging.PixelFormat;
import com.aspose.imaging.RawDataSettings;
import com.aspose.imaging.ResolutionSetting;
import com.aspose.imaging.fileformats.png.PngColorType;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.kX.a;
import com.aspose.imaging.internal.ns.aV;
import java.util.Arrays;

public class PngOptions
extends ImageOptionsBase {
    public static final int DEFAULT_COMPRESSION_LEVEL = 10;
    private static final byte[] a = new byte[]{1, 2, 4, 8};
    private static final byte[] b = new byte[]{8};
    private static final byte[] c = new byte[]{8, 16};
    private int d = 10;
    private byte e = (byte)8;
    private int f = 2;
    private boolean g;
    private int h = 0;

    public PngOptions() {
    }

    public PngOptions(PngOptions pngOptions) {
        super(pngOptions);
        this.d = pngOptions.d;
        this.f = pngOptions.f;
        this.h = pngOptions.h;
        this.g = pngOptions.g;
        this.setPalette(pngOptions.getPalette());
        this.e = pngOptions.e;
        com.aspose.imaging.internal.kX.a.a((IHasMetadata)pngOptions, this);
    }

    PngOptions(com.aspose.imaging.internal.hA.a a2) {
        this.f = a2.c();
        this.e = a2.b();
        this.setXmpData(a2.getXmpData());
        this.setExifData(a2.getExifData());
        this.g = (a2.h() & 0xFF) == 1;
        this.d = a2.j();
        this.h = a2.p();
        if (a2.n()) {
            this.setResolutionSettings(new ResolutionSetting(a2.g(), a2.l()));
        }
        if (a2.c() == 3) {
            this.setPalette(a2.i());
        }
        com.aspose.imaging.internal.kX.a.a((IHasMetadata)a2, this);
    }

    public static PngOptions a(com.aspose.imaging.internal.hA.a a2) {
        return new PngOptions(a2);
    }

    private static byte a(byte by2, int n2) {
        byte[] byArray;
        switch (n2) {
            case 0: 
            case 3: {
                byArray = a;
                break;
            }
            case 4: {
                byArray = b;
                break;
            }
            case 2: 
            case 6: {
                byArray = c;
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException("colorType", aV.a("Unknown PNG color type '{0}'", new Object[]{PngColorType.toString(PngColorType.class, n2)}));
            }
        }
        if (Arrays.binarySearch(byArray, by2) >= 0) {
            return by2;
        }
        if (byArray.length == 1) {
            return byArray[0];
        }
        byte by3 = byArray[0];
        int n3 = Math.abs((by2 & 0xFF) - (by3 & 0xFF));
        for (byte by4 : byArray) {
            int n4 = Math.abs((by2 & 0xFF) - (by4 & 0xFF));
            if (n4 >= n3 && (n4 != n3 || (by4 & 0xFF) <= (by3 & 0xFF))) continue;
            n3 = n4;
            by3 = by4;
        }
        return by3;
    }

    public final int getColorType() {
        return this.f;
    }

    public final void setColorType(int n2) {
        this.f = n2;
    }

    public final boolean getProgressive() {
        return this.g;
    }

    public final void setProgressive(boolean bl2) {
        this.g = bl2;
    }

    public final int getFilterType() {
        return this.h;
    }

    public final void setFilterType(int n2) {
        this.h = n2;
    }

    @Deprecated
    public final int getCompressionLevel() {
        return this.d;
    }

    @Deprecated
    public final void setCompressionLevel(int n2) {
        this.d = Math.max(0, Math.min(n2, 10));
    }

    public final int getPngCompressionLevel() {
        return this.d;
    }

    public final void setPngCompressionLevel(int n2) {
        this.d = n2;
    }

    public final byte getBitDepth() {
        byte by2;
        byte[] byArray;
        int n2 = this.f;
        byte by3 = this.e;
        switch (n2) {
            case 0: 
            case 3: {
                byArray = a;
                break;
            }
            case 4: {
                byArray = b;
                break;
            }
            case 2: 
            case 6: {
                byArray = c;
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException("colorType", aV.a("Unknown PNG color type '{0}'", new Object[]{PngColorType.toString(PngColorType.class, n2)}));
            }
        }
        if (Arrays.binarySearch(byArray, by3) >= 0) {
            by2 = by3;
        } else if (byArray.length == 1) {
            by2 = byArray[0];
        } else {
            byte by4 = byArray[0];
            int n3 = Math.abs((by3 & 0xFF) - (by4 & 0xFF));
            for (byte by5 : byArray) {
                int n4 = Math.abs((by3 & 0xFF) - (by5 & 0xFF));
                if (n4 >= n3 && (n4 != n3 || (by5 & 0xFF) <= (by4 & 0xFF))) continue;
                n3 = n4;
                by4 = by5;
            }
            by2 = by4;
        }
        return by2;
    }

    public final void setBitDepth(byte by2) {
        this.e = by2;
    }

    @Override
    public IColorPalette e() {
        IColorPalette iColorPalette = super.e();
        if (this.f == 3) {
            if (iColorPalette == null) {
                return ColorPaletteHelper.createGrayscale(this.getBitDepth() & 0xFF);
            }
            return iColorPalette;
        }
        return iColorPalette;
    }

    @Override
    public RawDataSettings f() {
        RawDataSettings rawDataSettings = new RawDataSettings();
        switch (this.f) {
            case 0: {
                rawDataSettings.setPixelDataFormat(PixelDataFormat.Grayscale);
                rawDataSettings.setColorPalette(ColorPaletteHelper.createGrayscale(8));
                break;
            }
            case 2: {
                rawDataSettings.setPixelDataFormat(PixelDataFormat.getRgb24BppPng());
                break;
            }
            case 3: {
                int[] nArray = new int[]{this.getBitDepth() & 0xFF};
                rawDataSettings.setPixelDataFormat(PixelDataFormat.a(nArray, 2, PixelFormat.toString(PixelFormat.class, 2L), true));
                rawDataSettings.setColorPalette(this.getPalette());
                break;
            }
            case 4: {
                rawDataSettings.setPixelDataFormat(PixelDataFormat.getGrayscaleAlpha());
                rawDataSettings.setColorPalette(ColorPaletteHelper.createGrayscale(8));
                break;
            }
            case 6: {
                rawDataSettings.setPixelDataFormat(PixelDataFormat.getRgba32Bpp());
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException("this.ColorType");
            }
        }
        return rawDataSettings;
    }

    @Override
    protected Object memberwiseClone() {
        return new PngOptions(this);
    }
}

